/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;

public final class SimplifyMethodChain
extends Recipe {
    @Option(displayName="Method pattern chain", description="A list of method patterns that are called in sequence")
    private final List<String> methodPatternChain;
    @Option(displayName="New method name", description="The method name that will replace the existing name. The new method name target is assumed to have the same arguments as the last method in the chain.")
    private final String newMethodName;

    public String getDisplayName() {
        return "Simplify a call chain";
    }

    public String getDescription() {
        return "Simplify `a.b().c()` to `a.d()`.";
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new JavaVisitor<ExecutionContext>(){

            @Override
            public J visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
                for (String method : SimplifyMethodChain.this.methodPatternChain) {
                    this.doAfterVisit(new UsesMethod(method));
                }
                return cu;
            }
        };
    }

    public Validated validate() {
        return super.validate().and(Validated.test((String)"methodPatternChain", (String)"Requires more than one pattern", this.methodPatternChain, c -> c.size() > 1));
    }

    public JavaVisitor<ExecutionContext> getVisitor() {
        final List matchers = this.methodPatternChain.stream().map(MethodMatcher::new).collect(Collectors.toList());
        Collections.reverse(matchers);
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J m;
                J select = m = super.visitMethodInvocation(method, ctx);
                for (MethodMatcher matcher : matchers) {
                    if (!(select instanceof J.MethodInvocation) || !matcher.matches((J.MethodInvocation)select)) {
                        return m;
                    }
                    select = ((J.MethodInvocation)m).getSelect();
                }
                if (select instanceof J.MethodInvocation) {
                    assert (((J.MethodInvocation)m).getMethodType() != null);
                    return ((J.MethodInvocation)m).withSelect(((J.MethodInvocation)select).getSelect()).withName(((J.MethodInvocation)m).getName().withSimpleName(SimplifyMethodChain.this.newMethodName)).withMethodType(((J.MethodInvocation)m).getMethodType().withName(SimplifyMethodChain.this.newMethodName));
                }
                return m;
            }
        };
    }

    public SimplifyMethodChain(List<String> methodPatternChain, String newMethodName) {
        this.methodPatternChain = methodPatternChain;
        this.newMethodName = newMethodName;
    }

    public List<String> getMethodPatternChain() {
        return this.methodPatternChain;
    }

    public String getNewMethodName() {
        return this.newMethodName;
    }

    @NonNull
    public String toString() {
        return "SimplifyMethodChain(methodPatternChain=" + this.getMethodPatternChain() + ", newMethodName=" + this.getNewMethodName() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimplifyMethodChain)) {
            return false;
        }
        SimplifyMethodChain other = (SimplifyMethodChain)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<String> this$methodPatternChain = this.getMethodPatternChain();
        List<String> other$methodPatternChain = other.getMethodPatternChain();
        if (this$methodPatternChain == null ? other$methodPatternChain != null : !((Object)this$methodPatternChain).equals(other$methodPatternChain)) {
            return false;
        }
        String this$newMethodName = this.getNewMethodName();
        String other$newMethodName = other.getNewMethodName();
        return !(this$newMethodName == null ? other$newMethodName != null : !this$newMethodName.equals(other$newMethodName));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof SimplifyMethodChain;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<String> $methodPatternChain = this.getMethodPatternChain();
        result = result * 59 + ($methodPatternChain == null ? 43 : ((Object)$methodPatternChain).hashCode());
        String $newMethodName = this.getNewMethodName();
        result = result * 59 + ($newMethodName == null ? 43 : $newMethodName.hashCode());
        return result;
    }
}

