/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.marker;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ScanResult;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.internal.JavaTypeCache;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.marker.SourceSet;

public final class JavaSourceSet
implements SourceSet {
    private final UUID id;
    private final String name;
    private final List<JavaType.FullyQualified> classpath;

    public static JavaSourceSet build(String sourceSetName, Collection<Path> classpath, JavaTypeCache typeCache, boolean fullTypeInformation) {
        List<JavaType.FullyQualified> types;
        try (ScanResult scanResult = new ClassGraph().enableClassInfo().enableSystemJarsAndModules().acceptPackages(new String[]{"java"}).ignoreClassVisibility().scan();){
            Map<String, List<String>> packagesToTypes = JavaSourceSet.packagesToTypeDeclarations(scanResult);
            packagesToTypes.computeIfAbsent("java.lang", p -> new ArrayList()).add("java.lang.Object");
            types = JavaSourceSet.typesFrom(packagesToTypes, typeCache, Collections.emptyList(), fullTypeInformation);
        }
        if (classpath.iterator().hasNext()) {
            scanResult = new ClassGraph().overrideClasspath(classpath).enableMemoryMapping().enableClassInfo().ignoreClassVisibility().scan();
            try {
                types.addAll(JavaSourceSet.typesFrom(JavaSourceSet.packagesToTypeDeclarations(scanResult), typeCache, classpath, fullTypeInformation));
            }
            finally {
                if (scanResult != null) {
                    scanResult.close();
                }
            }
        }
        return new JavaSourceSet(Tree.randomId(), sourceSetName, types);
    }

    private static Map<String, List<String>> packagesToTypeDeclarations(ScanResult scanResult) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        for (ClassInfo classInfo : scanResult.getAllClasses()) {
            String typeDeclaration;
            if (classInfo.isAnonymousInnerClass() || classInfo.isPrivate() || classInfo.isSynthetic() || classInfo.getName().contains(".enum.") || classInfo.getPackageName().startsWith("kotlin.reflect.jvm.internal.impl.resolve.jvm") || (typeDeclaration = JavaSourceSet.declarableFullyQualifiedName(classInfo)) == null) continue;
            result.computeIfAbsent(classInfo.getPackageName(), p -> new ArrayList()).add(typeDeclaration);
        }
        return result;
    }

    private static List<JavaType.FullyQualified> typesFrom(Map<String, List<String>> packagesToTypes, JavaTypeCache typeCache, Collection<Path> classpath, boolean fullTypeInformation) {
        ArrayList<JavaType.FullyQualified> types = new ArrayList<JavaType.FullyQualified>();
        if (fullTypeInformation) {
            String[] typeStubs = JavaSourceSet.typeStubsFor(packagesToTypes);
            InMemoryExecutionContext noRecursiveJavaSourceSet = new InMemoryExecutionContext();
            noRecursiveJavaSourceSet.putMessage("org.openrewrite.java.skipSourceSetTypeGeneration", (Object)true);
            Parser jp = ((JavaParser.Builder)((Object)((JavaParser.Builder)((Object)JavaParser.fromJavaVersion().typeCache(typeCache))).classpath(classpath))).build();
            List<J.CompilationUnit> cus = jp.parse((ExecutionContext)noRecursiveJavaSourceSet, typeStubs);
            for (J.CompilationUnit cu : cus) {
                if (cu.getClasses().isEmpty()) continue;
                J.Block body = cu.getClasses().get(0).getBody();
                for (Statement s : body.getStatements()) {
                    JavaType type = ((J.MethodDeclaration)s).getType();
                    if (!(type instanceof JavaType.FullyQualified)) continue;
                    types.add((JavaType.FullyQualified)type);
                }
            }
        } else {
            for (Map.Entry<String, List<String>> packageToTypes : packagesToTypes.entrySet()) {
                for (String className : packageToTypes.getValue()) {
                    types.add(JavaType.ShallowClass.build(className));
                }
            }
        }
        return types;
    }

    private static String[] typeStubsFor(Map<String, List<String>> packagesToTypeNames) {
        String[] result = new String[packagesToTypeNames.size()];
        int i = 0;
        for (Map.Entry<String, List<String>> packageToTypes : packagesToTypeNames.entrySet()) {
            boolean isJreType = packageToTypes.getKey().startsWith("java.");
            StringBuilder sb = new StringBuilder("package ");
            if (isJreType) {
                sb.append("rewrite.");
            }
            sb.append(packageToTypes.getKey()).append(";\n").append("abstract class $RewriteTypeStub {\n");
            List<String> value = packageToTypes.getValue();
            for (int j = 0; j < value.size(); ++j) {
                String type = value.get(j);
                if (type == null) continue;
                sb.append("    abstract ").append(type).append(" t").append(j).append("();\n");
            }
            sb.append("}");
            result[i] = sb.toString();
            ++i;
        }
        return result;
    }

    @Nullable
    private static String declarableFullyQualifiedName(ClassInfo classInfo) {
        String name;
        if (classInfo.getName().startsWith("java.") && !classInfo.isPublic()) {
            return null;
        }
        if (classInfo.isInnerClass()) {
            StringBuilder sb = new StringBuilder();
            ClassInfoList outerClasses = classInfo.getOuterClasses();
            for (int i = outerClasses.size() - 1; i >= 0; --i) {
                ClassInfo outerClass = (ClassInfo)outerClasses.get(i);
                if (outerClass.isPrivate() || outerClass.isAnonymousInnerClass() || outerClass.isSynthetic() || outerClass.isExternalClass()) {
                    return null;
                }
                if (i == outerClasses.size() - 1) {
                    sb.append(outerClass.getName()).append(".");
                    continue;
                }
                if (!outerClass.getName().startsWith(sb.toString())) {
                    return classInfo.getName();
                }
                sb.append(outerClass.getName().substring(sb.length())).append(".");
            }
            if (!classInfo.getName().startsWith(sb.toString())) {
                return classInfo.getName();
            }
            String nameFragment = classInfo.getName().substring(sb.length());
            if (JavaSourceSet.isUndeclarable(nameFragment)) {
                return null;
            }
            sb.append(nameFragment);
            name = sb.toString();
        } else {
            name = classInfo.getName();
        }
        if (JavaSourceSet.isUndeclarable(name)) {
            return null;
        }
        return name;
    }

    private static boolean isUndeclarable(String className) {
        char firstChar = className.charAt(0);
        return !Character.isJavaIdentifierPart(firstChar) || Character.isDigit(firstChar);
    }

    public JavaSourceSet(UUID id, String name, List<JavaType.FullyQualified> classpath) {
        this.id = id;
        this.name = name;
        this.classpath = classpath;
    }

    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public List<JavaType.FullyQualified> getClasspath() {
        return this.classpath;
    }

    @NonNull
    public String toString() {
        return "JavaSourceSet(id=" + this.getId() + ", name=" + this.getName() + ", classpath=" + this.getClasspath() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JavaSourceSet)) {
            return false;
        }
        JavaSourceSet other = (JavaSourceSet)o;
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @NonNull
    public JavaSourceSet withId(UUID id) {
        return this.id == id ? this : new JavaSourceSet(id, this.name, this.classpath);
    }

    @NonNull
    public JavaSourceSet withName(String name) {
        return this.name == name ? this : new JavaSourceSet(this.id, name, this.classpath);
    }

    @NonNull
    public JavaSourceSet withClasspath(List<JavaType.FullyQualified> classpath) {
        return this.classpath == classpath ? this : new JavaSourceSet(this.id, this.name, classpath);
    }
}

