/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;

public class RemoveCallsToObjectFinalize
extends Recipe {
    private static final MethodMatcher OBJECT_FINALIZE = new MethodMatcher("java.lang.Object finalize()");

    public String getDisplayName() {
        return "Remove `Object.finalize()` invocations";
    }

    public String getDescription() {
        return "Removes calls to `Object.finalize()`. This method is called during garbage collection and calling it manually is misleading.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-1111");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(1L);
    }

    @Nullable
    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesMethod<ExecutionContext>(OBJECT_FINALIZE);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext context) {
                J invocation = super.visitMethodInvocation(method, context);
                if (((J.MethodInvocation)invocation).getMethodType() != null && "finalize".equals(((J.MethodInvocation)invocation).getMethodType().getName()) && ((J.MethodInvocation)invocation).getMethodType().getDeclaringType().getSupertype() != null && Object.class.getName().equals(((J.MethodInvocation)invocation).getMethodType().getDeclaringType().getSupertype().getFullyQualifiedName())) {
                    return null;
                }
                return invocation;
            }
        };
    }
}

