/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.util.Optional;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.format.SpacesVisitor;
import org.openrewrite.java.style.Checkstyle;
import org.openrewrite.java.style.IntelliJ;
import org.openrewrite.java.style.MethodParamPadStyle;
import org.openrewrite.java.style.SpacesStyle;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;

public class MethodParamPad
extends Recipe {
    public String getDisplayName() {
        return "Method parameter padding";
    }

    public String getDescription() {
        return "Fixes whitespace padding between the identifier of a method definition or method invocation and the left parenthesis of the parameter list. For example, when configured to remove spacing, `someMethodInvocation (x);` becomes `someMethodInvocation(x)`.";
    }

    public JavaIsoVisitor<ExecutionContext> getVisitor() {
        return new MethodParamPadVisitor();
    }

    private static class MethodParamPadVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        SpacesStyle spacesStyle;
        MethodParamPadStyle methodParamPadStyle;

        private MethodParamPadVisitor() {
        }

        @Override
        public JavaSourceFile visitJavaSourceFile(JavaSourceFile javaSourceFile, ExecutionContext ctx) {
            SourceFile cu = (SourceFile)javaSourceFile;
            this.spacesStyle = Optional.ofNullable((SpacesStyle)cu.getStyle(SpacesStyle.class)).orElse(IntelliJ.spaces());
            this.methodParamPadStyle = Optional.ofNullable((MethodParamPadStyle)cu.getStyle(MethodParamPadStyle.class)).orElse(Checkstyle.methodParamPadStyle());
            this.spacesStyle = this.spacesStyle.withBeforeParentheses(this.spacesStyle.getBeforeParentheses().withMethodDeclaration(this.methodParamPadStyle.getSpace()).withMethodCall(this.methodParamPadStyle.getSpace()));
            return super.visitJavaSourceFile((JavaSourceFile)cu, ctx);
        }

        @Override
        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
            J md = super.visitMethodDeclaration(method, ctx);
            if (!this.methodParamPadStyle.getAllowLineBreaks().booleanValue() && ((J.MethodDeclaration)md).getPadding().getParameters().getBefore().getWhitespace().contains("\n")) {
                md = ((J.MethodDeclaration)md).getPadding().withParameters(((J.MethodDeclaration)md).getPadding().getParameters().withBefore(((J.MethodDeclaration)md).getPadding().getParameters().getBefore().withWhitespace("")));
            }
            md = (J.MethodDeclaration)new SpacesVisitor(this.spacesStyle, null, null, ((J.MethodDeclaration)md).getParameters().get(0)).visitNonNull(md, ctx, this.getCursor().getParentTreeCursor().fork());
            return md;
        }

        @Override
        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J mi = super.visitMethodInvocation(method, ctx);
            if (!this.methodParamPadStyle.getAllowLineBreaks().booleanValue() && ((J.MethodInvocation)mi).getPadding().getArguments().getBefore().getWhitespace().contains("\n")) {
                mi = ((J.MethodInvocation)mi).getPadding().withArguments(((J.MethodInvocation)mi).getPadding().getArguments().withBefore(((J.MethodInvocation)mi).getPadding().getArguments().getBefore().withWhitespace("")));
            }
            mi = (J.MethodInvocation)new SpacesVisitor(this.spacesStyle, null, null, mi).visitNonNull(mi, ctx, this.getCursor().getParentTreeCursor().fork());
            return mi;
        }

        @Override
        public J.NewClass visitNewClass(J.NewClass newClass, ExecutionContext ctx) {
            J nc = super.visitNewClass(newClass, ctx);
            if (!this.methodParamPadStyle.getAllowLineBreaks().booleanValue() && ((J.NewClass)nc).getPadding().getArguments() != null && ((J.NewClass)nc).getPadding().getArguments().getBefore().getWhitespace().contains("\n")) {
                nc = ((J.NewClass)nc).getPadding().withArguments(((J.NewClass)nc).getPadding().getArguments().withBefore(((J.NewClass)nc).getPadding().getArguments().getBefore().withWhitespace("")));
            }
            nc = (J.NewClass)new SpacesVisitor(this.spacesStyle, null, null, nc).visitNonNull(nc, ctx, this.getCursor().getParentTreeCursor().fork());
            return nc;
        }
    }
}

