/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.dataflow.analysis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openrewrite.Cursor;
import org.openrewrite.Incubating;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.dataflow.LocalFlowSpec;
import org.openrewrite.java.dataflow.analysis.FlowGraph;
import org.openrewrite.java.dataflow.analysis.SinkFlow;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Statement;

@Incubating(since="7.24.0")
public class ForwardFlow
extends JavaVisitor<Integer> {
    public static void findSinks(SinkFlow<?, ?> root) {
        Iterator cursorPath = root.getCursor().getPathAsCursors();
        VariableNameToFlowGraph variableNameToFlowGraph = ForwardFlow.computeVariableAssignment(cursorPath, root, root.getSpec());
        if (variableNameToFlowGraph.nextVariableName != null) {
            Object next;
            Object taintStmt = null;
            Cursor taintStmtCursorParent = null;
            if (variableNameToFlowGraph.currentCursor != null && variableNameToFlowGraph.currentCursor.getValue() instanceof J) {
                taintStmt = variableNameToFlowGraph.currentCursor.getValue();
                taintStmtCursorParent = variableNameToFlowGraph.currentCursor.getParent();
            }
            while (cursorPath.hasNext() && !((next = (taintStmtCursorParent = (Cursor)cursorPath.next()).getValue()) instanceof J.Block)) {
                if (!(next instanceof J)) continue;
                taintStmt = next;
            }
            HashMap<String, FlowGraph> initialFlow = new HashMap<String, FlowGraph>();
            initialFlow.put(variableNameToFlowGraph.nextVariableName, variableNameToFlowGraph.nextFlowGraph);
            Analysis analysis = new Analysis(root.getSpec(), initialFlow);
            assert (taintStmtCursorParent != null) : "taintStmtCursorParent is null";
            if (taintStmt instanceof J.WhileLoop || taintStmt instanceof J.DoWhileLoop || taintStmt instanceof J.ForLoop) {
                Statement body = taintStmt instanceof J.WhileLoop ? ((J.WhileLoop)taintStmt).getBody() : (taintStmt instanceof J.DoWhileLoop ? ((J.DoWhileLoop)taintStmt).getBody() : ((J.ForLoop)taintStmt).getBody());
                analysis.visit(body, 0, taintStmtCursorParent);
            } else if (taintStmt instanceof J.Try) {
                J.Try _try = (J.Try)taintStmt;
                analysis.visit(_try.getBody(), 0, taintStmtCursorParent);
                analysis.visit(_try.getFinally(), 0, taintStmtCursorParent);
            } else {
                assert (taintStmt != null) : "taintStmt is null";
                ForwardFlow.visitBlocksRecursive(root.getCursor().dropParentUntil(J.Block.class::isInstance), taintStmt, analysis);
            }
        }
    }

    private static void visitBlocksRecursive(Cursor blockCursor, Object startStatement, Analysis analysis) {
        boolean seenRoot = false;
        J.Block block = (J.Block)blockCursor.getValue();
        ArrayList<String> declaredVariables = new ArrayList<String>();
        for (Statement statement : block.getStatements()) {
            if (statement instanceof J.VariableDeclarations) {
                J.VariableDeclarations variableDeclarations = (J.VariableDeclarations)statement;
                for (J.VariableDeclarations.NamedVariable variableDeclaration : variableDeclarations.getVariables()) {
                    declaredVariables.add(variableDeclaration.getSimpleName());
                }
            }
            if (seenRoot) {
                analysis.visit(statement, 0, blockCursor);
            }
            if (statement != startStatement) continue;
            seenRoot = true;
        }
        J.MethodDeclaration parentMethodDeclaration = (J.MethodDeclaration)blockCursor.firstEnclosing(J.MethodDeclaration.class);
        if (parentMethodDeclaration != null && parentMethodDeclaration.getBody() == block) {
            return;
        }
        J.Block parentBlock = (J.Block)blockCursor.getParentOrThrow().firstEnclosing(J.Block.class);
        if (parentBlock != null && parentBlock.getStatements().contains(block) && J.Block.isStaticOrInitBlock(blockCursor)) {
            return;
        }
        declaredVariables.forEach(analysis.flowsByIdentifier.peek()::remove);
        J nextStartStatement = (J)blockCursor.getParentOrThrow().firstEnclosing(J.class);
        if (nextStartStatement instanceof J.Block && ((J.Block)nextStartStatement).getStatements().contains(block)) {
            nextStartStatement = block;
        } else if (nextStartStatement == null || !ForwardFlow.getPossibleSubBlock(nextStartStatement).contains(block)) {
            return;
        }
        ForwardFlow.visitBlocksRecursive(blockCursor.dropParentUntil(J.Block.class::isInstance), nextStartStatement, analysis);
    }

    private static Set<Statement> getPossibleSubBlock(J j) {
        if (j instanceof J.If) {
            J.If _if = (J.If)j;
            if (_if.getElsePart() != null) {
                return Stream.of(_if.getThenPart(), _if.getElsePart().getBody()).collect(Collectors.toSet());
            }
            return Collections.singleton(_if.getThenPart());
        }
        if (j instanceof J.WhileLoop) {
            return Collections.singleton(((J.WhileLoop)j).getBody());
        }
        if (j instanceof J.DoWhileLoop) {
            return Collections.singleton(((J.DoWhileLoop)j).getBody());
        }
        if (j instanceof J.ForLoop) {
            return Collections.singleton(((J.ForLoop)j).getBody());
        }
        if (j instanceof J.ForEachLoop) {
            return Collections.singleton(((J.ForEachLoop)j).getBody());
        }
        if (j instanceof J.Try) {
            J.Try _try = (J.Try)j;
            return Stream.concat(Stream.of(_try.getBody(), _try.getFinally()), _try.getCatches().stream().map(J.Try.Catch::getBody)).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    private static VariableNameToFlowGraph computeVariableAssignment(Iterator<Cursor> cursorPath, FlowGraph currentFlow, LocalFlowSpec<?, ?> spec) {
        Cursor ancestorCursor = null;
        if (cursorPath.hasNext()) {
            ancestorCursor = cursorPath.next();
        }
        String nextVariableName = null;
        FlowGraph nextFlowGraph = currentFlow;
        while (cursorPath.hasNext()) {
            ancestorCursor = cursorPath.next();
            Object ancestor = ancestorCursor.getValue();
            if (ancestor instanceof Expression) {
                Cursor previousCursor = nextFlowGraph.getCursor();
                if (spec.isBarrier((Expression)ancestor, ancestorCursor)) break;
                if (spec.isFlowStep((Expression)previousCursor.getValue(), previousCursor, (Expression)ancestor, ancestorCursor)) {
                    nextFlowGraph = nextFlowGraph.addEdge(ancestorCursor);
                    continue;
                }
            }
            if (ancestor instanceof J.Binary || ancestor instanceof J.MethodInvocation) break;
            if (ancestor instanceof J.Ternary) {
                J.Ternary ternary = (J.Ternary)ancestor;
                Object previousCursorValue = nextFlowGraph.getCursor().getValue();
                if (ternary.getTruePart() != previousCursorValue && ternary.getFalsePart() != previousCursorValue) break;
                nextFlowGraph = nextFlowGraph.addEdge(ancestorCursor);
                continue;
            }
            if (ancestor instanceof J.TypeCast || ancestor instanceof J.Parentheses || ancestor instanceof J.ControlParentheses) {
                nextFlowGraph = nextFlowGraph.addEdge(ancestorCursor);
                continue;
            }
            if (ancestor instanceof J.NewClass) break;
            if (!(ancestor instanceof J.Assignment) && !(ancestor instanceof J.AssignmentOperation) && !(ancestor instanceof J.VariableDeclarations.NamedVariable)) continue;
            Expression variable = ancestor instanceof J.Assignment ? ((J.Assignment)ancestor).getVariable() : (ancestor instanceof J.AssignmentOperation ? ((J.AssignmentOperation)ancestor).getVariable() : ((J.VariableDeclarations.NamedVariable)ancestor).getName());
            if (!((variable = variable.unwrap()) instanceof J.Identifier)) continue;
            nextVariableName = ((J.Identifier)variable).getSimpleName();
            break;
        }
        return new VariableNameToFlowGraph(nextVariableName, nextFlowGraph, ancestorCursor);
    }

    private static final class VariableNameToFlowGraph {
        @Nullable
        String nextVariableName;
        FlowGraph nextFlowGraph;
        Cursor currentCursor;

        public VariableNameToFlowGraph(@Nullable String nextVariableName, FlowGraph nextFlowGraph, Cursor currentCursor) {
            this.nextVariableName = nextVariableName;
            this.nextFlowGraph = nextFlowGraph;
            this.currentCursor = currentCursor;
        }
    }

    private static class Analysis
    extends JavaVisitor<Integer> {
        final LocalFlowSpec<?, ?> localFlowSpec;
        Stack<Map<String, FlowGraph>> flowsByIdentifier = new Stack();

        Analysis(LocalFlowSpec<?, ?> localFlowSpec, Map<String, FlowGraph> initial) {
            this.localFlowSpec = localFlowSpec;
            this.flowsByIdentifier.push(initial);
        }

        @Override
        public J visitVariable(J.VariableDeclarations.NamedVariable variable, Integer p) {
            this.flowsByIdentifier.peek().remove(variable.getSimpleName());
            return super.visitVariable(variable, p);
        }

        @Override
        public J visitLambda(J.Lambda lambda, Integer p) {
            for (J parameter : lambda.getParameters().getParameters()) {
                new JavaIsoVisitor<Integer>(){

                    @Override
                    public J.Identifier visitIdentifier(J.Identifier identifier, Integer integer) {
                        flowsByIdentifier.peek().remove(identifier.getSimpleName());
                        return identifier;
                    }
                }.visit(parameter, 0);
            }
            return super.visitLambda(lambda, p);
        }

        @Override
        public J visitIdentifier(J.Identifier ident, Integer p) {
            J.Assignment parentAssignment = (J.Assignment)this.getCursor().firstEnclosing(J.Assignment.class);
            if (parentAssignment != null && parentAssignment.getVariable().unwrap() == ident) {
                return ident;
            }
            J.FieldAccess parentFieldAccess = (J.FieldAccess)this.getCursor().firstEnclosing(J.FieldAccess.class);
            if (parentFieldAccess != null && parentFieldAccess.getName() == ident) {
                return ident;
            }
            J.NewClass parentNewClass = (J.NewClass)this.getCursor().firstEnclosing(J.NewClass.class);
            if (parentNewClass != null && parentNewClass.getClazz() == ident) {
                return ident;
            }
            J.MethodInvocation parentMethodInvocation = (J.MethodInvocation)this.getCursor().firstEnclosing(J.MethodInvocation.class);
            if (parentMethodInvocation != null && parentMethodInvocation.getName() == ident) {
                return ident;
            }
            FlowGraph flowGraph = this.flowsByIdentifier.peek().get(ident.getSimpleName());
            if (flowGraph != null) {
                FlowGraph next = flowGraph.addEdge(this.getCursor());
                this.flowsByIdentifier.peek().put(ident.getSimpleName(), next);
                VariableNameToFlowGraph variableNameToFlowGraph = ForwardFlow.computeVariableAssignment(this.getCursor().getPathAsCursors(), next, this.localFlowSpec);
                if (variableNameToFlowGraph.nextVariableName != null) {
                    this.flowsByIdentifier.peek().put(variableNameToFlowGraph.nextVariableName, variableNameToFlowGraph.nextFlowGraph);
                }
            }
            return ident;
        }

        @Override
        public J visitBlock(J.Block block, Integer p) {
            this.flowsByIdentifier.push(new HashMap<String, FlowGraph>(this.flowsByIdentifier.peek()));
            J b = super.visitBlock(block, p);
            this.flowsByIdentifier.pop();
            return b;
        }

        @Override
        public J visitAssignment(J.Assignment assignment, Integer integer) {
            J.Assignment a = (J.Assignment)super.visitAssignment(assignment, integer);
            Expression left = a.getVariable().unwrap();
            if (left instanceof J.Identifier) {
                String variableName = ((J.Identifier)left).getSimpleName();
                FlowGraph variableNameFlowGraph = this.flowsByIdentifier.peek().get(variableName);
                if (variableNameFlowGraph != null && a.getAssignment() != variableNameFlowGraph.getCursor().getValue()) {
                    this.flowsByIdentifier.peek().remove(variableName);
                }
            }
            return a;
        }

        @Override
        public J visitNewClass(J.NewClass newClass, Integer integer) {
            return super.visitNewClass(newClass, integer);
        }
    }
}

