/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.ChangeType;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.dataflow.FindLocalFlowPaths;
import org.openrewrite.java.dataflow.LocalFlowSpec;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

public class ReplaceStackWithDeque
extends Recipe {
    public String getDisplayName() {
        return "Replace `java.util.Stack` with `java.util.Deque`.";
    }

    public String getDescription() {
        return "From the Javadoc of `Stack`:\n> A more complete and consistent set of LIFO stack operations is provided by the Deque interface and its implementations, which should be used in preference to this class.";
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesType<ExecutionContext>("java.util.Stack");
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.VariableDeclarations.NamedVariable visitVariable(final J.VariableDeclarations.NamedVariable variable, ExecutionContext ctx) {
                J v = super.visitVariable(variable, ctx);
                LocalFlowSpec<Expression, J> returned = new LocalFlowSpec<Expression, J>(){

                    @Override
                    public boolean isSource(Expression expression, Cursor cursor) {
                        return variable.getInitializer() == expression;
                    }

                    @Override
                    public boolean isSink(J j, Cursor cursor) {
                        return cursor.firstEnclosing(J.Return.class) != null;
                    }
                };
                if (((J.VariableDeclarations.NamedVariable)v).getInitializer() != null && FindLocalFlowPaths.noneMatch(this.getCursor(), returned)) {
                    v = (J.VariableDeclarations.NamedVariable)new ChangeType("java.util.Stack", "java.util.ArrayDeque", false).getVisitor().visitNonNull((Tree)v, (Object)ctx, this.getCursor().getParentOrThrow());
                    this.getCursor().putMessageOnFirstEnclosing(J.VariableDeclarations.class, "replace", (Object)true);
                }
                return v;
            }

            @Override
            public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext ctx) {
                J v = super.visitVariableDeclarations(multiVariable, ctx);
                if (((Boolean)this.getCursor().getMessage("replace", (Object)false)).booleanValue()) {
                    v = (J.VariableDeclarations)new ChangeType("java.util.Stack", "java.util.Deque", false).getVisitor().visitNonNull((Tree)v, (Object)ctx, this.getCursor().getParentOrThrow());
                    this.maybeAddImport("java.util.ArrayDeque");
                    this.maybeAddImport("java.util.Deque");
                }
                return v;
            }
        };
    }
}

