/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.style;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.WritableTypeId;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import java.io.IOException;
import org.openrewrite.java.style.ImportLayoutStyle;

class Serializer
extends JsonSerializer<ImportLayoutStyle> {
    Serializer() {
    }

    public void serializeWithType(ImportLayoutStyle value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        WritableTypeId typeId = typeSer.typeId((Object)value, JsonToken.START_OBJECT);
        typeSer.writeTypePrefix(gen, typeId);
        this.serializeFields(value, gen);
        typeSer.writeTypeSuffix(gen, typeId);
    }

    public void serialize(ImportLayoutStyle value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        this.serializeFields(value, gen);
        gen.writeEndObject();
    }

    private void serializeFields(ImportLayoutStyle value, JsonGenerator gen) throws IOException {
        gen.writeNumberField("classCountToUseStarImport", value.getClassCountToUseStarImport());
        gen.writeNumberField("nameCountToUseStarImport", value.getNameCountToUseStarImport());
        String[] blocks = (String[])value.getLayout().stream().map(block -> {
            if (block instanceof ImportLayoutStyle.Block.BlankLines) {
                return "<blank line>";
            }
            if (block instanceof ImportLayoutStyle.Block.AllOthers) {
                return "import " + (((ImportLayoutStyle.Block.AllOthers)block).isStatic() ? "static " : "") + "all other imports";
            }
            if (block instanceof ImportLayoutStyle.Block.ImportPackage) {
                ImportLayoutStyle.Block.ImportPackage importPackage = (ImportLayoutStyle.Block.ImportPackage)block;
                return (importPackage.isStatic() ? "static " : "") + "import " + importPackage.getPackageWildcard();
            }
            return new UnsupportedOperationException("Unknown block type " + block.getClass().getName());
        }).toArray(String[]::new);
        gen.writeArrayFieldStart("layout");
        gen.writeArray(blocks, 0, blocks.length);
        gen.writeEndArray();
    }
}

