/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.nio.file.Paths;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.ChangeType;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

public class ChangePackage
extends Recipe {
    @Option(displayName="Old fully-qualified package name", description="Fully-qualified package name of the old package.")
    private final String oldFullyQualifiedPackageName;
    @Option(displayName="New fully-qualified package name", description="Fully-qualified package name of the replacement package.")
    private final String newFullyQualifiedPackageName;
    @Option(displayName="Recursive", description="Recursively change subpackage names", required=false)
    @Nullable
    private Boolean recursive;

    public String getDisplayName() {
        return "Change package";
    }

    public String getDescription() {
        return "Change package names.";
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){
            final JavaTemplate newPackageExpr = this.template("package #{}").build();

            @Override
            public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext context) {
                J c = super.visitCompilationUnit(cu, context);
                String changingTo = (String)this.getCursor().getMessage("changingTo");
                if (changingTo != null) {
                    String path = ((J.CompilationUnit)c).getSourcePath().toString().replace('\\', '/');
                    String changingFrom = (String)this.getCursor().getMessage("changingFrom");
                    assert (changingFrom != null);
                    c = ((J.CompilationUnit)c).withSourcePath(Paths.get(path.replaceFirst(changingFrom.replace('.', '/'), changingTo.replace('.', '/')), new String[0]));
                }
                return c;
            }

            @Override
            public J.Package visitPackage(J.Package pkg, ExecutionContext context) {
                String original = pkg.getExpression().printTrimmed().replaceAll("\\s", "");
                this.getCursor().putMessageOnFirstEnclosing(J.CompilationUnit.class, "changingFrom", (Object)original);
                if (original.equals(ChangePackage.this.oldFullyQualifiedPackageName)) {
                    this.getCursor().putMessageOnFirstEnclosing(J.CompilationUnit.class, "changingTo", (Object)ChangePackage.this.newFullyQualifiedPackageName);
                    return (J.Package)pkg.withTemplate(this.newPackageExpr, pkg.getCoordinates().replace(), ChangePackage.this.newFullyQualifiedPackageName);
                }
                if ((ChangePackage.this.recursive == null || ChangePackage.this.recursive.booleanValue()) && original.startsWith(ChangePackage.this.oldFullyQualifiedPackageName) && !original.startsWith(ChangePackage.this.newFullyQualifiedPackageName)) {
                    String changingTo = ChangePackage.this.newFullyQualifiedPackageName + original.substring(ChangePackage.this.oldFullyQualifiedPackageName.length());
                    this.getCursor().putMessageOnFirstEnclosing(J.CompilationUnit.class, "changingTo", (Object)changingTo);
                    return (J.Package)pkg.withTemplate(this.newPackageExpr, pkg.getCoordinates().replace(), changingTo);
                }
                return pkg;
            }

            @Override
            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext context) {
                String changingTo = (String)this.getCursor().getNearestMessage("changingTo");
                JavaType.Class classType = classDecl.getType();
                if (changingTo != null && classType != null) {
                    String fqn = classType.getFullyQualifiedName();
                    ChangePackage.this.doNext(new ChangeType(fqn, changingTo + '.' + classType.getClassName()));
                }
                return super.visitClassDeclaration(classDecl, context);
            }
        };
    }

    public String getOldFullyQualifiedPackageName() {
        return this.oldFullyQualifiedPackageName;
    }

    public String getNewFullyQualifiedPackageName() {
        return this.newFullyQualifiedPackageName;
    }

    @Nullable
    public Boolean getRecursive() {
        return this.recursive;
    }

    public ChangePackage(String oldFullyQualifiedPackageName, String newFullyQualifiedPackageName) {
        this.oldFullyQualifiedPackageName = oldFullyQualifiedPackageName;
        this.newFullyQualifiedPackageName = newFullyQualifiedPackageName;
    }

    @JsonCreator
    public ChangePackage(String oldFullyQualifiedPackageName, String newFullyQualifiedPackageName, @Nullable Boolean recursive) {
        this.oldFullyQualifiedPackageName = oldFullyQualifiedPackageName;
        this.newFullyQualifiedPackageName = newFullyQualifiedPackageName;
        this.recursive = recursive;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangePackage)) {
            return false;
        }
        ChangePackage other = (ChangePackage)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$recursive = this.getRecursive();
        Boolean other$recursive = other.getRecursive();
        if (this$recursive == null ? other$recursive != null : !((Object)this$recursive).equals(other$recursive)) {
            return false;
        }
        String this$oldFullyQualifiedPackageName = this.getOldFullyQualifiedPackageName();
        String other$oldFullyQualifiedPackageName = other.getOldFullyQualifiedPackageName();
        if (this$oldFullyQualifiedPackageName == null ? other$oldFullyQualifiedPackageName != null : !this$oldFullyQualifiedPackageName.equals(other$oldFullyQualifiedPackageName)) {
            return false;
        }
        String this$newFullyQualifiedPackageName = this.getNewFullyQualifiedPackageName();
        String other$newFullyQualifiedPackageName = other.getNewFullyQualifiedPackageName();
        return !(this$newFullyQualifiedPackageName == null ? other$newFullyQualifiedPackageName != null : !this$newFullyQualifiedPackageName.equals(other$newFullyQualifiedPackageName));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChangePackage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $recursive = this.getRecursive();
        result = result * 59 + ($recursive == null ? 43 : ((Object)$recursive).hashCode());
        String $oldFullyQualifiedPackageName = this.getOldFullyQualifiedPackageName();
        result = result * 59 + ($oldFullyQualifiedPackageName == null ? 43 : $oldFullyQualifiedPackageName.hashCode());
        String $newFullyQualifiedPackageName = this.getNewFullyQualifiedPackageName();
        result = result * 59 + ($newFullyQualifiedPackageName == null ? 43 : $newFullyQualifiedPackageName.hashCode());
        return result;
    }

    @NonNull
    public ChangePackage withRecursive(@Nullable Boolean recursive) {
        return this.recursive == recursive ? this : new ChangePackage(this.oldFullyQualifiedPackageName, this.newFullyQualifiedPackageName, recursive);
    }
}

