/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.recipes;

import java.text.ParseException;
import java.text.RuleBasedCollator;
import java.time.Duration;
import java.util.Comparator;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeUtils;

public class SetDefaultEstimatedEffortPerOccurrence
extends Recipe {
    public String getDisplayName() {
        return "Set default estimated effort";
    }

    public String getDescription() {
        return "Retrofit recipes with a deafult estimated effort per occurrence.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(1L);
    }

    protected JavaVisitor<ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesType<ExecutionContext>("org.openrewrite.Recipe");
    }

    public JavaVisitor<ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){
            final JavaTemplate addMethod = JavaTemplate.builder(() -> (this).getCursor(), "@Override public Duration getEstimatedEffortPerOccurrence() {\nreturn Duration.ofMinutes(5);\n}").imports("java.time.Duration").build();

            @Override
            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext executionContext) {
                JavaType.FullyQualified type = TypeUtils.asFullyQualified(classDecl.getType());
                if (TypeUtils.isAssignableTo("org.openrewrite.Recipe", (JavaType)type)) {
                    assert (type != null);
                    for (Statement statement : classDecl.getBody().getStatements()) {
                        J.MethodDeclaration method;
                        if (!(statement instanceof J.MethodDeclaration) || !"getEstimatedEffortPerOccurrence".equals((method = (J.MethodDeclaration)statement).getSimpleName())) continue;
                        return classDecl;
                    }
                    this.maybeAddImport("java.time.Duration");
                    try {
                        return (J.ClassDeclaration)classDecl.withTemplate(this.addMethod, classDecl.getBody().getCoordinates().addMethodDeclaration(Comparator.comparing(J.MethodDeclaration::getSimpleName, new RuleBasedCollator("< getDisplayName < getDescription < getEstimatedEffortPerOccurrence < getVisitor"))), new Object[0]);
                    }
                    catch (ParseException e) {
                        throw new RuntimeException(e);
                    }
                }
                return super.visitClassDeclaration(classDecl, executionContext);
            }
        };
    }
}

