/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.time.Duration;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.NameCaseConvention;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.RenameVariable;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;

public class RenamePrivateFieldsToCamelCase
extends Recipe {
    public String getDisplayName() {
        return "Reformat private field names to camelCase";
    }

    public String getDescription() {
        return "Reformat private field names to camelCase to comply with Java naming convention. The recipe will not rename fields with default, protected or public access modifiers.The recipe will not rename private constants.The first character is set to lower case and existing capital letters are preserved. Special characters that are allowed in java field names `$` and `_` are removed. If a special character is removed the next valid alphanumeric will be capitalized. The recipe will not rename a field if the result already exists in the class, conflicts with a java reserved keyword, or the result is blank.";
    }

    public Set<String> getTags() {
        return new LinkedHashSet<String>(Arrays.asList("RSPEC-116", "RSPEC-3008"));
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(2L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new RenameNonCompliantNames();
    }

    private static class RenameNonCompliantNames
    extends JavaIsoVisitor<ExecutionContext> {
        private RenameNonCompliantNames() {
        }

        @Override
        public JavaSourceFile visitJavaSourceFile(JavaSourceFile cu, ExecutionContext ctx) {
            LinkedHashMap<J.VariableDeclarations.NamedVariable, String> renameVariablesMap = new LinkedHashMap<J.VariableDeclarations.NamedVariable, String>();
            HashSet hasNameSet = new HashSet();
            this.getCursor().putMessage("RENAME_VARIABLES_KEY", renameVariablesMap);
            this.getCursor().putMessage("HAS_NAME_KEY", hasNameSet);
            super.visitJavaSourceFile(cu, ctx);
            renameVariablesMap.forEach((key, value) -> {
                if (!hasNameSet.contains(value) && !hasNameSet.contains(key.getSimpleName())) {
                    this.doAfterVisit(new RenameVariable((J.VariableDeclarations.NamedVariable)key, (String)value));
                    hasNameSet.add(value);
                }
            });
            return cu;
        }

        @Override
        public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, ExecutionContext ctx) {
            Cursor parentScope = RenameNonCompliantNames.getCursorToParentScope(this.getCursor());
            if (parentScope.getParent() != null && parentScope.getParent().getValue() instanceof J.ClassDeclaration && variable.getVariableType().hasFlags(Flag.Private) && !variable.getVariableType().hasFlags(Flag.Static, Flag.Final) && !((J.ClassDeclaration)parentScope.getParent().getValue()).getType().getFullyQualifiedName().contains("$") && !NameCaseConvention.LOWER_CAMEL.matches(variable.getSimpleName())) {
                String toName = NameCaseConvention.LOWER_CAMEL.format(variable.getSimpleName());
                ((Map)this.getCursor().getNearestMessage("RENAME_VARIABLES_KEY")).put(variable, toName);
            } else {
                ((Set)this.getCursor().getNearestMessage("HAS_NAME_KEY")).add(variable.getSimpleName());
            }
            return variable;
        }

        @Override
        public J.Identifier visitIdentifier(J.Identifier identifier, ExecutionContext ctx) {
            Map renameVariablesMap = (Map)this.getCursor().getNearestMessage("RENAME_VARIABLES_KEY");
            for (J.VariableDeclarations.NamedVariable variableToRename : renameVariablesMap.keySet()) {
                if (!variableToRename.getSimpleName().equals(identifier.getSimpleName())) continue;
                return identifier;
            }
            return identifier;
        }

        private static Cursor getCursorToParentScope(Cursor cursor) {
            return cursor.dropParentUntil(is -> is instanceof J.Block);
        }
    }
}

