/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.util.function.BiPredicate;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.cleanup.RemoveMethodCallVisitor;
import org.openrewrite.java.internal.TypesInUse;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

public class RemoveUnneededAssertion
extends Recipe {
    private static final MethodMatcher JUNIT_JUPITER_ASSERT_TRUE_MATCHER = new MethodMatcher("org.junit.jupiter.api.Assertions assertTrue(..)");
    private static final MethodMatcher JUNIT_JUPITER_ASSERT_FALSE_MATCHER = new MethodMatcher("org.junit.jupiter.api.Assertions assertFalse(..)");
    private static final MethodMatcher JUNIT_ASSERT_TRUE_MATCHER = new MethodMatcher("org.junit.Assert assertTrue(boolean)");
    private static final MethodMatcher JUNIT_ASSERT_FALSE_MATCHER = new MethodMatcher("org.junit.Assert assertFalse(boolean)");
    private static final MethodMatcher JUNIT_ASSERT_MESSAGE_TRUE_MATCHER = new MethodMatcher("org.junit.Assert assertTrue(String, boolean)");
    private static final MethodMatcher JUNIT_ASSERT_MESSAGE_FALSE_MATCHER = new MethodMatcher("org.junit.Assert assertFalse(String, boolean)");

    public String getDisplayName() {
        return "Remove Unneeded Assertions";
    }

    public String getDescription() {
        return "Remove unneeded assertions like `assert true`, `assertTrue(true)`, or `assertFalse(false)`.";
    }

    @Nullable
    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext executionContext) {
                this.doAfterVisit(new UsesMethod(JUNIT_JUPITER_ASSERT_TRUE_MATCHER));
                this.doAfterVisit(new UsesMethod(JUNIT_JUPITER_ASSERT_FALSE_MATCHER));
                this.doAfterVisit(new UsesMethod(JUNIT_ASSERT_TRUE_MATCHER));
                this.doAfterVisit(new UsesMethod(JUNIT_ASSERT_FALSE_MATCHER));
                this.doAfterVisit(new UsesMethod(JUNIT_ASSERT_MESSAGE_TRUE_MATCHER));
                this.doAfterVisit(new UsesMethod(JUNIT_ASSERT_MESSAGE_FALSE_MATCHER));
                return super.visitCompilationUnit(cu, executionContext);
            }

            @Override
            public J.Assert visitAssert(J.Assert _assert, ExecutionContext executionContext) {
                if (J.Literal.isLiteralValue(_assert.getCondition(), true)) {
                    return _assert.withMarkers(_assert.getMarkers().searchResult());
                }
                return _assert;
            }
        };
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new RemoveUnneededAssertionVisitor<ExecutionContext>();
    }

    private static class RemoveUnneededAssertionVisitor<P>
    extends JavaIsoVisitor<P> {
        private RemoveUnneededAssertionVisitor() {
        }

        @Override
        public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, P p) {
            J compilationUnit = super.visitCompilationUnit(cu, (Object)p);
            TypesInUse typesInUse = ((J.CompilationUnit)compilationUnit).getTypesInUse();
            InvokeRemoveMethodCallVisitor invokeRemoveMethodCallVisitor = (inputCu, methodMatcher, argumentPredicate) -> {
                if (typesInUse.getUsedMethods().stream().anyMatch(methodMatcher::matches)) {
                    return (J.CompilationUnit)new RemoveMethodCallVisitor(methodMatcher, argumentPredicate).visitNonNull(cu, p, this.getCursor().getParentOrThrow());
                }
                return inputCu;
            };
            compilationUnit = invokeRemoveMethodCallVisitor.invoke((J.CompilationUnit)compilationUnit, JUNIT_JUPITER_ASSERT_TRUE_MATCHER, (arg, expr) -> !arg.equals(0) || J.Literal.isLiteralValue(expr, true));
            compilationUnit = invokeRemoveMethodCallVisitor.invoke((J.CompilationUnit)compilationUnit, JUNIT_JUPITER_ASSERT_FALSE_MATCHER, (arg, expr) -> !arg.equals(0) || J.Literal.isLiteralValue(expr, false));
            compilationUnit = invokeRemoveMethodCallVisitor.invoke((J.CompilationUnit)compilationUnit, JUNIT_ASSERT_TRUE_MATCHER, (arg, expr) -> arg.equals(0) && J.Literal.isLiteralValue(expr, true));
            compilationUnit = invokeRemoveMethodCallVisitor.invoke((J.CompilationUnit)compilationUnit, JUNIT_ASSERT_FALSE_MATCHER, (arg, expr) -> arg.equals(0) && J.Literal.isLiteralValue(expr, false));
            compilationUnit = invokeRemoveMethodCallVisitor.invoke((J.CompilationUnit)compilationUnit, JUNIT_ASSERT_MESSAGE_TRUE_MATCHER, (arg, expr) -> !arg.equals(1) || J.Literal.isLiteralValue(expr, true));
            compilationUnit = invokeRemoveMethodCallVisitor.invoke((J.CompilationUnit)compilationUnit, JUNIT_ASSERT_MESSAGE_FALSE_MATCHER, (arg, expr) -> !arg.equals(1) || J.Literal.isLiteralValue(expr, false));
            return compilationUnit;
        }

        @Override
        public J.Assert visitAssert(J.Assert _assert, P p) {
            if (_assert.getCondition() instanceof J.Literal && J.Literal.isLiteralValue(_assert.getCondition(), true)) {
                return null;
            }
            return super.visitAssert(_assert, (Object)p);
        }

        @FunctionalInterface
        private static interface InvokeRemoveMethodCallVisitor {
            public J.CompilationUnit invoke(J.CompilationUnit var1, MethodMatcher var2, BiPredicate<Integer, Expression> var3);
        }
    }
}

