/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;

public class UnnecessaryPrimitiveAnnotations
extends Recipe {
    private static final AnnotationMatcher CHECK_FOR_NULL_ANNOTATION_MATCHER = new AnnotationMatcher("@javax.annotation.CheckForNull");
    private static final AnnotationMatcher NULLABLE_ANNOTATION_MATCHER = new AnnotationMatcher("@javax.annotation.Nullable");

    public String getDisplayName() {
        return "Remove Nullable and CheckForNull annotations from primitives";
    }

    public String getDescription() {
        return "Remove `@Nullable` and `@CheckForNull` annotations from primitives since they can't be null.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-4682");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(1L);
    }

    protected JavaIsoVisitor<ExecutionContext> getSingleSourceApplicableTest() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public JavaSourceFile visitJavaSourceFile(JavaSourceFile cu, ExecutionContext executionContext) {
                this.doAfterVisit(new UsesType("javax.annotation.CheckForNull"));
                this.doAfterVisit(new UsesType("javax.annotation.Nullable"));
                return cu;
            }
        };
    }

    public JavaIsoVisitor<ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public JavaSourceFile visitJavaSourceFile(JavaSourceFile cu, ExecutionContext executionContext) {
                J c = super.visitJavaSourceFile(cu, executionContext);
                if (cu != c) {
                    this.maybeRemoveImport("javax.annotation.CheckForNull");
                    this.maybeRemoveImport("javax.annotation.Nullable");
                }
                return c;
            }

            @Override
            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext executionContext) {
                J md = super.visitMethodDeclaration(method, executionContext);
                if (((J.MethodDeclaration)md).getReturnTypeExpression() != null && !(((J.MethodDeclaration)md).getReturnTypeExpression() instanceof J.ArrayType) && ((J.MethodDeclaration)md).getReturnTypeExpression().getType() instanceof JavaType.Primitive) {
                    md = this.maybeAutoFormat(md, ((J.MethodDeclaration)md).withLeadingAnnotations(this.filterAnnotations(((J.MethodDeclaration)md).getLeadingAnnotations())), executionContext, this.getCursor().dropParentUntil(J.class::isInstance));
                }
                return md;
            }

            @Override
            public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext executionContext) {
                J varDecls = super.visitVariableDeclarations(multiVariable, executionContext);
                if (((J.VariableDeclarations)varDecls).getType() instanceof JavaType.Primitive && ((J.VariableDeclarations)varDecls).getVariables().stream().noneMatch(nv -> nv.getType() instanceof JavaType.Array)) {
                    varDecls = ((J.VariableDeclarations)varDecls).withLeadingAnnotations(this.filterAnnotations(((J.VariableDeclarations)varDecls).getLeadingAnnotations()));
                }
                return varDecls;
            }

            private List<J.Annotation> filterAnnotations(List<J.Annotation> annotations) {
                return ListUtils.map(annotations, anno -> {
                    if (NULLABLE_ANNOTATION_MATCHER.matches((J.Annotation)anno) || CHECK_FOR_NULL_ANNOTATION_MATCHER.matches((J.Annotation)anno)) {
                        return null;
                    }
                    return anno;
                });
            }
        };
    }
}

