/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.style.Checkstyle;
import org.openrewrite.java.style.NeedBracesStyle;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.marker.Markers;

public class NeedBraces
extends Recipe {
    public String getDisplayName() {
        return "Fix missing braces";
    }

    public String getDescription() {
        return "Adds missing braces around code such as single-line `if`, `for`, `while`, and `do-while` block bodies.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-121");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(2L);
    }

    public JavaIsoVisitor<ExecutionContext> getVisitor() {
        return new NeedBracesVisitor();
    }

    private static class NeedBracesVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        NeedBracesStyle needBracesStyle;

        private NeedBracesVisitor() {
        }

        private static <T extends Statement> J.Block buildBlock(T element) {
            return new J.Block(Tree.randomId(), Space.EMPTY, Markers.EMPTY, JRightPadded.build(false), element instanceof J.Empty ? Collections.emptyList() : Collections.singletonList(JRightPadded.build(element)), Space.EMPTY);
        }

        @Override
        public JavaSourceFile visitJavaSourceFile(JavaSourceFile javaSourceFile, ExecutionContext ctx) {
            SourceFile cu = (SourceFile)javaSourceFile;
            this.needBracesStyle = cu.getStyle(NeedBracesStyle.class) == null ? Checkstyle.needBracesStyle() : (NeedBracesStyle)cu.getStyle(NeedBracesStyle.class);
            return super.visitJavaSourceFile((JavaSourceFile)cu, ctx);
        }

        @Override
        public J.If visitIf(J.If iff, ExecutionContext ctx) {
            J elem = super.visitIf(iff, ctx);
            boolean hasAllowableBodyType = ((J.If)elem).getThenPart() instanceof J.Block;
            if (!this.needBracesStyle.getAllowSingleLineStatement().booleanValue() && !hasAllowableBodyType) {
                J.Block b = NeedBracesVisitor.buildBlock(((J.If)elem).getThenPart());
                elem = this.maybeAutoFormat(elem, ((J.If)elem).withThenPart(b), ctx, this.getCursor().dropParentUntil(J.class::isInstance));
            }
            return elem;
        }

        @Override
        public J.If.Else visitElse(J.If.Else elze, ExecutionContext ctx) {
            boolean hasAllowableBodyType;
            J elem = super.visitElse(elze, ctx);
            boolean bl = hasAllowableBodyType = ((J.If.Else)elem).getBody() instanceof J.Block || ((J.If.Else)elem).getBody() instanceof J.If;
            if (!this.needBracesStyle.getAllowSingleLineStatement().booleanValue() && !hasAllowableBodyType) {
                J.Block b = NeedBracesVisitor.buildBlock(((J.If.Else)elem).getBody());
                elem = this.maybeAutoFormat(elem, ((J.If.Else)elem).withBody(b), ctx, this.getCursor().dropParentUntil(J.class::isInstance));
            }
            return elem;
        }

        @Override
        public J.WhileLoop visitWhileLoop(J.WhileLoop whileLoop, ExecutionContext ctx) {
            boolean hasAllowableBodyType;
            J elem = super.visitWhileLoop(whileLoop, ctx);
            boolean bl = this.needBracesStyle.getAllowEmptyLoopBody().booleanValue() ? ((J.WhileLoop)elem).getBody() instanceof J.Block || ((J.WhileLoop)elem).getBody() instanceof J.Empty : (hasAllowableBodyType = ((J.WhileLoop)elem).getBody() instanceof J.Block);
            if (!this.needBracesStyle.getAllowEmptyLoopBody().booleanValue() && ((J.WhileLoop)elem).getBody() instanceof J.Empty) {
                J.Block b = NeedBracesVisitor.buildBlock(((J.WhileLoop)elem).getBody());
                elem = this.maybeAutoFormat(elem, ((J.WhileLoop)elem).withBody(b), ctx, this.getCursor().dropParentUntil(J.class::isInstance));
            } else if (!this.needBracesStyle.getAllowSingleLineStatement().booleanValue() && !hasAllowableBodyType) {
                J.Block b = NeedBracesVisitor.buildBlock(((J.WhileLoop)elem).getBody());
                elem = this.maybeAutoFormat(elem, ((J.WhileLoop)elem).withBody(b), ctx, this.getCursor().dropParentUntil(J.class::isInstance));
            }
            return elem;
        }

        @Override
        public J.DoWhileLoop visitDoWhileLoop(J.DoWhileLoop doWhileLoop, ExecutionContext ctx) {
            boolean hasAllowableBodyType;
            J elem = super.visitDoWhileLoop(doWhileLoop, ctx);
            boolean bl = this.needBracesStyle.getAllowEmptyLoopBody().booleanValue() ? ((J.DoWhileLoop)elem).getBody() instanceof J.Block || ((J.DoWhileLoop)elem).getBody() instanceof J.Empty : (hasAllowableBodyType = ((J.DoWhileLoop)elem).getBody() instanceof J.Block);
            if (!this.needBracesStyle.getAllowEmptyLoopBody().booleanValue() && ((J.DoWhileLoop)elem).getBody() instanceof J.Empty) {
                J.Block b = NeedBracesVisitor.buildBlock(((J.DoWhileLoop)elem).getBody());
                elem = this.maybeAutoFormat(elem, ((J.DoWhileLoop)elem).withBody(b), ctx, this.getCursor().dropParentUntil(J.class::isInstance));
            } else if (!this.needBracesStyle.getAllowSingleLineStatement().booleanValue() && !hasAllowableBodyType) {
                J.Block b = NeedBracesVisitor.buildBlock(((J.DoWhileLoop)elem).getBody());
                elem = this.maybeAutoFormat(elem, ((J.DoWhileLoop)elem).withBody(b), ctx, this.getCursor().dropParentUntil(J.class::isInstance));
            }
            return elem;
        }

        @Override
        public J.ForLoop visitForLoop(J.ForLoop forLoop, ExecutionContext ctx) {
            boolean hasAllowableBodyType;
            J elem = super.visitForLoop(forLoop, ctx);
            boolean bl = this.needBracesStyle.getAllowEmptyLoopBody().booleanValue() ? ((J.ForLoop)elem).getBody() instanceof J.Block || ((J.ForLoop)elem).getBody() instanceof J.Empty : (hasAllowableBodyType = ((J.ForLoop)elem).getBody() instanceof J.Block);
            if (!this.needBracesStyle.getAllowEmptyLoopBody().booleanValue() && ((J.ForLoop)elem).getBody() instanceof J.Empty) {
                J.Block b = NeedBracesVisitor.buildBlock(((J.ForLoop)elem).getBody());
                elem = this.maybeAutoFormat(elem, ((J.ForLoop)elem).withBody(b), ctx, this.getCursor().dropParentUntil(J.class::isInstance));
            } else if (!this.needBracesStyle.getAllowSingleLineStatement().booleanValue() && !hasAllowableBodyType) {
                J.Block b = NeedBracesVisitor.buildBlock(((J.ForLoop)elem).getBody());
                elem = this.maybeAutoFormat(elem, ((J.ForLoop)elem).withBody(b), ctx, this.getCursor().dropParentUntil(J.class::isInstance));
            }
            return elem;
        }
    }
}

