/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.marker.Markers;

public class IndexOfChecksShouldUseAStartPosition
extends Recipe {
    private static final MethodMatcher STRING_INDEX_MATCHER = new MethodMatcher("java.lang.String indexOf(String)");

    public String getDisplayName() {
        return "Use `indexOf(String, int)`";
    }

    public String getDescription() {
        return "Replaces `indexOf(String)` in binary operations if the compared value is an int and not less than 1.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-2912");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public JavaSourceFile visitJavaSourceFile(JavaSourceFile cu, ExecutionContext executionContext) {
                this.doAfterVisit(new UsesMethod(STRING_INDEX_MATCHER));
                return cu;
            }
        };
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            private boolean isValueNotCompliant(J.Literal literal) {
                return !(literal.getValue() instanceof Integer) || (Integer)literal.getValue() > 0;
            }

            @Override
            public J.Binary visitBinary(J.Binary binary, ExecutionContext ctx) {
                J b = super.visitBinary(binary, ctx);
                if (((J.Binary)b).getLeft() instanceof J.MethodInvocation && STRING_INDEX_MATCHER.matches(((J.Binary)b).getLeft()) && ((J.Binary)b).getOperator() == J.Binary.Type.GreaterThan && ((J.Binary)b).getRight() instanceof J.Literal && this.isValueNotCompliant((J.Literal)((J.Binary)b).getRight())) {
                    J.MethodInvocation m = (J.MethodInvocation)((J.Binary)b).getLeft();
                    b = ((J.Binary)b).withLeft((Expression)m.withTemplate(JavaTemplate.builder(() -> (this).getCursor(), "#{any(java.lang.String)}, #{any(int)}").build(), m.getCoordinates().replaceArguments(), m.getArguments().get(0), ((J.Binary)b).getRight()));
                    b = ((J.Binary)b).withRight(new J.Literal(Tree.randomId(), ((J.Binary)b).getRight().getPrefix(), Markers.EMPTY, -1, "-1", null, JavaType.Primitive.Int));
                }
                return b;
            }
        };
    }
}

