/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.Stack;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.AddImport;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.RemoveImport;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.java.tree.TypedTree;
import org.openrewrite.marker.Markers;

public final class ChangeType
extends Recipe {
    @Option(displayName="Old fully-qualified type name", description="Fully-qualified class name of the original type.", example="org.junit.Assume")
    private final String oldFullyQualifiedTypeName;
    @Option(displayName="New fully-qualified type name", description="Fully-qualified class name of the replacement type, or the name of a primitive such as \"int\". The `OuterClassName$NestedClassName` naming convention should be used for nested classes.", example="org.junit.jupiter.api.Assumptions")
    private final String newFullyQualifiedTypeName;
    @Option(displayName="Ignore type definition", description="When set to `true` the definition of the old type will be left untouched. This is useful when you're replacing usage of a class but don't want to rename it.", example="true", required=false)
    @Nullable
    private final Boolean ignoreDefinition;

    public String getDisplayName() {
        return "Change type";
    }

    public String getDescription() {
        return "Change a given type to another.";
    }

    public boolean causesAnotherCycle() {
        return true;
    }

    public JavaVisitor<ExecutionContext> getVisitor() {
        return new ChangeTypeVisitor(this.newFullyQualifiedTypeName);
    }

    protected JavaVisitor<ExecutionContext> getSingleSourceApplicableTest() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext executionContext) {
                for (J.ClassDeclaration it : cu.getClasses()) {
                    if (!TypeUtils.isOfClassType(it.getType(), ChangeType.this.oldFullyQualifiedTypeName)) continue;
                    if (Boolean.TRUE.equals(ChangeType.this.ignoreDefinition)) {
                        return cu;
                    }
                    return cu.withMarkers(cu.getMarkers().searchResult());
                }
                this.doAfterVisit(new UsesType(ChangeType.this.oldFullyQualifiedTypeName));
                return cu;
            }
        };
    }

    public ChangeType(String oldFullyQualifiedTypeName, String newFullyQualifiedTypeName, @Nullable Boolean ignoreDefinition) {
        this.oldFullyQualifiedTypeName = oldFullyQualifiedTypeName;
        this.newFullyQualifiedTypeName = newFullyQualifiedTypeName;
        this.ignoreDefinition = ignoreDefinition;
    }

    public String getOldFullyQualifiedTypeName() {
        return this.oldFullyQualifiedTypeName;
    }

    public String getNewFullyQualifiedTypeName() {
        return this.newFullyQualifiedTypeName;
    }

    @Nullable
    public Boolean getIgnoreDefinition() {
        return this.ignoreDefinition;
    }

    @NonNull
    public String toString() {
        return "ChangeType(oldFullyQualifiedTypeName=" + this.getOldFullyQualifiedTypeName() + ", newFullyQualifiedTypeName=" + this.getNewFullyQualifiedTypeName() + ", ignoreDefinition=" + this.getIgnoreDefinition() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeType)) {
            return false;
        }
        ChangeType other = (ChangeType)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$ignoreDefinition = this.getIgnoreDefinition();
        Boolean other$ignoreDefinition = other.getIgnoreDefinition();
        if (this$ignoreDefinition == null ? other$ignoreDefinition != null : !((Object)this$ignoreDefinition).equals(other$ignoreDefinition)) {
            return false;
        }
        String this$oldFullyQualifiedTypeName = this.getOldFullyQualifiedTypeName();
        String other$oldFullyQualifiedTypeName = other.getOldFullyQualifiedTypeName();
        if (this$oldFullyQualifiedTypeName == null ? other$oldFullyQualifiedTypeName != null : !this$oldFullyQualifiedTypeName.equals(other$oldFullyQualifiedTypeName)) {
            return false;
        }
        String this$newFullyQualifiedTypeName = this.getNewFullyQualifiedTypeName();
        String other$newFullyQualifiedTypeName = other.getNewFullyQualifiedTypeName();
        return !(this$newFullyQualifiedTypeName == null ? other$newFullyQualifiedTypeName != null : !this$newFullyQualifiedTypeName.equals(other$newFullyQualifiedTypeName));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChangeType;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $ignoreDefinition = this.getIgnoreDefinition();
        result = result * 59 + ($ignoreDefinition == null ? 43 : ((Object)$ignoreDefinition).hashCode());
        String $oldFullyQualifiedTypeName = this.getOldFullyQualifiedTypeName();
        result = result * 59 + ($oldFullyQualifiedTypeName == null ? 43 : $oldFullyQualifiedTypeName.hashCode());
        String $newFullyQualifiedTypeName = this.getNewFullyQualifiedTypeName();
        result = result * 59 + ($newFullyQualifiedTypeName == null ? 43 : $newFullyQualifiedTypeName.hashCode());
        return result;
    }

    private class ChangeTypeVisitor
    extends JavaVisitor<ExecutionContext> {
        private final JavaType targetType;
        private final JavaType.Class originalType;

        private ChangeTypeVisitor(String targetType) {
            this.originalType = JavaType.ShallowClass.build(ChangeType.this.oldFullyQualifiedTypeName);
            this.targetType = JavaType.buildType(targetType);
        }

        @Override
        public J visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
            JavaType.FullyQualified fullyQualifiedTarget;
            J.CompilationUnit c = (J.CompilationUnit)this.visitAndCast(cu, ctx, (x$0, x$1) -> super.visitCompilationUnit((J.CompilationUnit)x$0, x$1));
            c = (J.CompilationUnit)new RemoveImport(ChangeType.this.oldFullyQualifiedTypeName).visit(c, ctx);
            if (this.originalType.getOwningClass() != null) {
                c = (J.CompilationUnit)new RemoveImport(this.originalType.getOwningClass().getFullyQualifiedName()).visit(c, ctx);
            }
            if ((fullyQualifiedTarget = TypeUtils.asFullyQualified(this.targetType)) != null) {
                if (fullyQualifiedTarget.getOwningClass() != null && !"java.lang".equals(fullyQualifiedTarget.getPackageName())) {
                    c = (J.CompilationUnit)new AddImport(fullyQualifiedTarget.getOwningClass().getFullyQualifiedName(), null, true).visit(c, ctx);
                }
                if (!"java.lang".equals(fullyQualifiedTarget.getPackageName())) {
                    c = (J.CompilationUnit)new AddImport(fullyQualifiedTarget.getFullyQualifiedName(), null, true).visit(c, ctx);
                }
            }
            if (c != null) {
                c = c.withImports(ListUtils.map(c.getImports(), i -> (J.Import)this.visitAndCast((Tree)i, ctx, (x$0, x$1) -> super.visitImport((J.Import)x$0, x$1))));
            }
            return c;
        }

        @Override
        public J visitImport(J.Import impoort, ExecutionContext executionContext) {
            return impoort;
        }

        @Nullable
        public J postVisit(J tree, ExecutionContext executionContext) {
            TypedTree method;
            if (tree instanceof J.MethodDeclaration) {
                method = (J.MethodDeclaration)tree;
                tree = ((J.MethodDeclaration)method).withMethodType(this.updateType(((J.MethodDeclaration)method).getMethodType()));
            } else if (tree instanceof J.MethodInvocation) {
                method = (J.MethodInvocation)tree;
                tree = ((J.MethodInvocation)method).withMethodType(this.updateType(((J.MethodInvocation)method).getMethodType()));
            }
            if (tree instanceof TypedTree) {
                TypedTree m;
                if (tree instanceof J.MethodDeclaration) {
                    m = (J.MethodDeclaration)tree;
                    return ((J.MethodDeclaration)m).withMethodType(this.updateType(((J.MethodDeclaration)m).getMethodType()));
                }
                if (tree instanceof J.MethodInvocation) {
                    m = (J.MethodInvocation)tree;
                    return ((J.MethodInvocation)m).withMethodType(this.updateType(((J.MethodInvocation)m).getMethodType()));
                }
                if (tree instanceof J.NewClass) {
                    J.NewClass n = (J.NewClass)tree;
                    return n.withConstructorType(this.updateType(n.getConstructorType()));
                }
                return ((TypedTree)tree).withType(this.updateType(((TypedTree)tree).getType()));
            }
            return tree;
        }

        @Override
        public J visitFieldAccess(J.FieldAccess fieldAccess, ExecutionContext ctx) {
            if (fieldAccess.isFullyQualifiedClassReference(ChangeType.this.oldFullyQualifiedTypeName)) {
                if (this.targetType instanceof JavaType.FullyQualified) {
                    return this.updateOuterClassTypes((Expression)TypeTree.build(((JavaType.FullyQualified)this.targetType).getFullyQualifiedName()).withPrefix(fieldAccess.getPrefix()));
                }
                if (this.targetType instanceof JavaType.Primitive) {
                    return new J.Primitive(fieldAccess.getId(), fieldAccess.getPrefix(), Markers.EMPTY, (JavaType.Primitive)this.targetType);
                }
            } else {
                StringBuilder maybeClass = new StringBuilder();
                Expression target = fieldAccess;
                while (target != null) {
                    if (target instanceof J.FieldAccess) {
                        J.FieldAccess fa = target;
                        maybeClass.insert(0, fa.getSimpleName()).insert(0, '.');
                        target = fa.getTarget();
                        continue;
                    }
                    if (target instanceof J.Identifier) {
                        maybeClass.insert(0, ((J.Identifier)target).getSimpleName());
                        target = null;
                        continue;
                    }
                    maybeClass = new StringBuilder("__NOT_IT__");
                    break;
                }
                JavaType.ShallowClass oldType = JavaType.ShallowClass.build(ChangeType.this.oldFullyQualifiedTypeName);
                if (maybeClass.toString().equals(oldType.getClassName())) {
                    this.maybeRemoveImport(oldType.getOwningClass());
                    Expression e = this.updateOuterClassTypes((Expression)TypeTree.build(((JavaType.FullyQualified)this.targetType).getClassName()).withPrefix(fieldAccess.getPrefix()));
                    if (e instanceof J.Identifier && e.getType() == null) {
                        J.Identifier i = (J.Identifier)e;
                        e = i.withType(this.targetType);
                    }
                    return e;
                }
            }
            return super.visitFieldAccess(fieldAccess, ctx);
        }

        @Override
        public J visitIdentifier(J.Identifier ident, ExecutionContext ctx) {
            J.Identifier i = (J.Identifier)this.visitAndCast(ident, ctx, (x$0, x$1) -> super.visitIdentifier((J.Identifier)x$0, x$1));
            if (TypeUtils.isOfClassType(i.getType(), ChangeType.this.oldFullyQualifiedTypeName)) {
                String className = this.originalType.getClassName();
                JavaType.FullyQualified iType = TypeUtils.asFullyQualified(i.getType());
                if (iType != null && iType.getOwningClass() != null) {
                    className = this.originalType.getFullyQualifiedName().substring(iType.getOwningClass().getFullyQualifiedName().length() + 1);
                }
                if (i.getSimpleName().equals(className)) {
                    if (this.targetType instanceof JavaType.FullyQualified) {
                        if (((JavaType.FullyQualified)this.targetType).getOwningClass() != null) {
                            return this.updateOuterClassTypes((Expression)TypeTree.build(((JavaType.FullyQualified)this.targetType).getClassName()).withType(null).withPrefix(i.getPrefix()));
                        }
                        i = i.withSimpleName(((JavaType.FullyQualified)this.targetType).getClassName());
                    } else if (this.targetType instanceof JavaType.Primitive) {
                        i = i.withSimpleName(((JavaType.Primitive)this.targetType).getKeyword());
                    }
                }
            }
            return i.withType(this.updateType(i.getType()));
        }

        @Override
        public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            if (method.getMethodType() != null && method.getMethodType().hasFlags(Flag.Static) && method.getMethodType().getDeclaringType().isAssignableFrom(this.originalType)) {
                J.CompilationUnit cu = (J.CompilationUnit)this.getCursor().firstEnclosingOrThrow(J.CompilationUnit.class);
                for (J.Import anImport : cu.getImports()) {
                    JavaType.FullyQualified fqn;
                    if (!anImport.isStatic() || anImport.getQualid().getTarget().getType() == null || (fqn = TypeUtils.asFullyQualified(anImport.getQualid().getTarget().getType())) == null || !TypeUtils.isOfClassType(fqn, this.originalType.getFullyQualifiedName()) || !method.getSimpleName().equals(anImport.getQualid().getSimpleName())) continue;
                    this.maybeAddImport(((JavaType.FullyQualified)this.targetType).getFullyQualifiedName(), method.getName().getSimpleName());
                    break;
                }
            }
            return super.visitMethodInvocation(method, ctx);
        }

        private Expression updateOuterClassTypes(Expression typeTree) {
            if (typeTree instanceof J.FieldAccess) {
                JavaType.FullyQualified type = (JavaType.FullyQualified)this.targetType;
                if (type.getOwningClass() == null) {
                    typeTree.withType(this.updateType(this.targetType));
                }
                Stack<Expression> typeStack = new Stack<Expression>();
                typeStack.push(typeTree);
                Stack<JavaType.FullyQualified> attrStack = new Stack<JavaType.FullyQualified>();
                attrStack.push(type);
                Expression t = ((J.FieldAccess)typeTree).getTarget();
                while (true) {
                    typeStack.push(t);
                    if (t instanceof J.FieldAccess) {
                        if (Character.isUpperCase(((J.FieldAccess)t).getSimpleName().charAt(0)) && ((JavaType.FullyQualified)attrStack.peek()).getOwningClass() != null) {
                            attrStack.push(((JavaType.FullyQualified)attrStack.peek()).getOwningClass());
                        }
                        t = ((J.FieldAccess)t).getTarget();
                        continue;
                    }
                    if (t instanceof J.Identifier) break;
                }
                if (Character.isUpperCase(((J.Identifier)t).getSimpleName().charAt(0)) && ((JavaType.FullyQualified)attrStack.peek()).getOwningClass() != null) {
                    attrStack.push(((JavaType.FullyQualified)attrStack.peek()).getOwningClass());
                }
                Expression attributed = null;
                Expression e = (Expression)typeStack.pop();
                while (true) {
                    if (e instanceof J.Identifier) {
                        attributed = attrStack.size() == typeStack.size() + 1 ? ((J.Identifier)e).withType((JavaType)attrStack.pop()) : e;
                    } else if (e instanceof J.FieldAccess) {
                        attributed = attrStack.size() == typeStack.size() + 1 ? ((J.FieldAccess)e).withTarget(attributed).withType((JavaType)attrStack.pop()) : ((J.FieldAccess)e).withTarget(attributed);
                    }
                    if (typeStack.isEmpty()) break;
                    e = (Expression)typeStack.pop();
                }
                assert (attributed != null);
                return attributed;
            }
            return typeTree;
        }

        private JavaType updateType(@Nullable JavaType type) {
            JavaType.GenericTypeVariable gtv = TypeUtils.asGeneric(type);
            if (gtv != null) {
                return gtv.withBounds(ListUtils.map(gtv.getBounds(), bound -> {
                    JavaType.FullyQualified fq = TypeUtils.asFullyQualified(bound);
                    if (fq != null && fq.getFullyQualifiedName().equals(ChangeType.this.oldFullyQualifiedTypeName) && this.targetType instanceof JavaType.FullyQualified) {
                        return this.targetType;
                    }
                    return bound;
                }));
            }
            JavaType.FullyQualified fqt = TypeUtils.asFullyQualified(type);
            if (fqt != null && fqt.getFullyQualifiedName().equals(ChangeType.this.oldFullyQualifiedTypeName)) {
                return this.targetType;
            }
            return type;
        }

        @Nullable
        private JavaType.Method updateType(@Nullable JavaType.Method mt) {
            if (mt != null) {
                return mt.withDeclaringType((JavaType.FullyQualified)this.updateType(mt.getDeclaringType())).withReturnType(this.updateType(mt.getReturnType())).withParameterTypes(ListUtils.map(mt.getParameterTypes(), this::updateType));
            }
            return null;
        }
    }
}

