/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.marker.JavaSearchResult;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Marker;

@Incubating(since="7.2.0")
public final class HasTypes
extends Recipe {
    @Option(displayName="Fully-qualified type names", description="Find J.CompilationUnits having one of the supplied types. Types should be identified by fully qualified class name or a glob expression", example="com.google.guava.*")
    private final List<String> fullyQualifiedTypeNames;
    private final UUID id = Tree.randomId();

    public String getDisplayName() {
        return "Has types";
    }

    public String getDescription() {
        return "Find any type references by name.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){

            @Override
            public J visitCompilationUnit(J.CompilationUnit cu, ExecutionContext executionContext) {
                if (HasTypes.find(cu, HasTypes.this.fullyQualifiedTypeNames).booleanValue()) {
                    cu = cu.withMarkers(cu.getMarkers().addOrUpdate((Marker)new JavaSearchResult(HasTypes.this.id, HasTypes.this)));
                }
                return cu;
            }
        };
    }

    public static Boolean find(J j, final List<String> fullyQualifiedClassNames) {
        JavaIsoVisitor<AtomicBoolean> hasTypeVisitor = new JavaIsoVisitor<AtomicBoolean>(){

            @Override
            public <N extends NameTree> N visitTypeName(N name, AtomicBoolean typeExists) {
                if (typeExists.get()) {
                    return name;
                }
                N n = super.visitTypeName(name, typeExists);
                JavaType.Class asClass = TypeUtils.asClass(n.getType());
                for (String fullyQualifiedClassName : fullyQualifiedClassNames) {
                    if (asClass == null || !this.targetClassMatches(asClass, fullyQualifiedClassName) || this.getCursor().firstEnclosing(J.Import.class) != null) continue;
                    typeExists.set(true);
                    return n;
                }
                return n;
            }

            @Override
            public J.FieldAccess visitFieldAccess(J.FieldAccess fieldAccess, AtomicBoolean typeExists) {
                if (typeExists.get()) {
                    return fieldAccess;
                }
                J fa = super.visitFieldAccess(fieldAccess, typeExists);
                JavaType.Class targetClass = TypeUtils.asClass(((J.FieldAccess)fa).getTarget().getType());
                for (String fullyQualifiedTypeName : fullyQualifiedClassNames) {
                    if (targetClass == null || !this.targetClassMatches(targetClass, fullyQualifiedTypeName) || !((J.FieldAccess)fa).getName().getSimpleName().equals("class")) continue;
                    typeExists.set(true);
                    return fa;
                }
                return fa;
            }

            @Override
            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, AtomicBoolean typeExists) {
                if (typeExists.get()) {
                    return method;
                }
                J methodInvocation = super.visitMethodInvocation(method, typeExists);
                JavaType.Class targetClass = ((J.MethodInvocation)methodInvocation).getType() != null ? TypeUtils.asClass(((J.MethodInvocation)methodInvocation).getType().getDeclaringType()) : null;
                for (String fullyQualifiedTypeName : fullyQualifiedClassNames) {
                    if (targetClass == null || !this.targetClassMatches(targetClass, fullyQualifiedTypeName)) continue;
                    typeExists.set(true);
                    return methodInvocation;
                }
                return methodInvocation;
            }

            private boolean targetClassMatches(JavaType.Class targetClass, String fullyQualifiedTypeName) {
                if (fullyQualifiedTypeName.endsWith(".*")) {
                    fullyQualifiedTypeName = fullyQualifiedTypeName.replaceAll("\\.\\*", "");
                }
                return targetClass.getFullyQualifiedName().equals(fullyQualifiedTypeName) || targetClass.getFullyQualifiedName().startsWith(fullyQualifiedTypeName);
            }
        };
        AtomicBoolean typeExists = new AtomicBoolean(false);
        hasTypeVisitor.visit(j, typeExists);
        return typeExists.get();
    }

    public HasTypes(List<String> fullyQualifiedTypeNames) {
        this.fullyQualifiedTypeNames = fullyQualifiedTypeNames;
    }

    public List<String> getFullyQualifiedTypeNames() {
        return this.fullyQualifiedTypeNames;
    }

    public UUID getId() {
        return this.id;
    }

    @NonNull
    public String toString() {
        return "HasTypes(fullyQualifiedTypeNames=" + this.getFullyQualifiedTypeNames() + ", id=" + this.getId() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HasTypes)) {
            return false;
        }
        HasTypes other = (HasTypes)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<String> this$fullyQualifiedTypeNames = this.getFullyQualifiedTypeNames();
        List<String> other$fullyQualifiedTypeNames = other.getFullyQualifiedTypeNames();
        if (this$fullyQualifiedTypeNames == null ? other$fullyQualifiedTypeNames != null : !((Object)this$fullyQualifiedTypeNames).equals(other$fullyQualifiedTypeNames)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof HasTypes;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<String> $fullyQualifiedTypeNames = this.getFullyQualifiedTypeNames();
        result = result * 59 + ($fullyQualifiedTypeNames == null ? 43 : ((Object)$fullyQualifiedTypeNames).hashCode());
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

