/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.marker.JavaSearchResult;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Marker;

public final class FindTypes
extends Recipe {
    @Option(displayName="Fully-qualified type name", description="A fully-qualified type name, that is used to find matching type references.", example="java.util.List")
    private final String fullyQualifiedTypeName;
    private final UUID id = Tree.randomId();

    public String getDisplayName() {
        return "Find types";
    }

    public String getDescription() {
        return "Find type references by name.";
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){

            @Override
            public <N extends NameTree> N visitTypeName(N name, ExecutionContext ctx) {
                N n = super.visitTypeName(name, ctx);
                JavaType.Class asClass = TypeUtils.asClass(n.getType());
                if (asClass != null && asClass.getFullyQualifiedName().equals(FindTypes.this.fullyQualifiedTypeName) && this.getCursor().firstEnclosing(J.Import.class) == null) {
                    ctx.putMessageInSet("org.openrewrite.java.FoundType", (Object)asClass);
                    return (N)((NameTree)n.withMarkers(n.getMarkers().addOrUpdate((Marker)new JavaSearchResult(FindTypes.this.id, FindTypes.this))));
                }
                return n;
            }

            @Override
            public J visitFieldAccess(J.FieldAccess fieldAccess, ExecutionContext ctx) {
                J.FieldAccess fa = (J.FieldAccess)super.visitFieldAccess(fieldAccess, ctx);
                JavaType.Class asClass = TypeUtils.asClass(fa.getTarget().getType());
                if (asClass != null && asClass.getFullyQualifiedName().equals(FindTypes.this.fullyQualifiedTypeName) && fa.getName().getSimpleName().equals("class")) {
                    ctx.putMessageInSet("org.openrewrite.java.FoundType", (Object)asClass);
                    return fa.withMarkers(fa.getMarkers().addOrUpdate((Marker)new JavaSearchResult(FindTypes.this.id, FindTypes.this)));
                }
                return fa;
            }
        };
    }

    public static Set<NameTree> find(J j, final String fullyQualifiedClassName) {
        JavaIsoVisitor<Set<NameTree>> findVisitor = new JavaIsoVisitor<Set<NameTree>>(){

            @Override
            public <N extends NameTree> N visitTypeName(N name, Set<NameTree> ns) {
                N n = super.visitTypeName(name, ns);
                JavaType.Class asClass = TypeUtils.asClass(n.getType());
                if (asClass != null && asClass.getFullyQualifiedName().equals(fullyQualifiedClassName) && this.getCursor().firstEnclosing(J.Import.class) == null) {
                    ns.add(name);
                }
                return n;
            }

            @Override
            public J.FieldAccess visitFieldAccess(J.FieldAccess fieldAccess, Set<NameTree> ns) {
                J fa = super.visitFieldAccess(fieldAccess, ns);
                JavaType.Class targetClass = TypeUtils.asClass(((J.FieldAccess)fa).getTarget().getType());
                if (targetClass != null && targetClass.getFullyQualifiedName().equals(fullyQualifiedClassName) && ((J.FieldAccess)fa).getName().getSimpleName().equals("class")) {
                    ns.add(fieldAccess);
                }
                return fa;
            }
        };
        HashSet<NameTree> ts = new HashSet<NameTree>();
        findVisitor.visit(j, ts);
        return ts;
    }

    public FindTypes(String fullyQualifiedTypeName) {
        this.fullyQualifiedTypeName = fullyQualifiedTypeName;
    }

    public String getFullyQualifiedTypeName() {
        return this.fullyQualifiedTypeName;
    }

    public UUID getId() {
        return this.id;
    }

    @NonNull
    public String toString() {
        return "FindTypes(fullyQualifiedTypeName=" + this.getFullyQualifiedTypeName() + ", id=" + this.getId() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindTypes)) {
            return false;
        }
        FindTypes other = (FindTypes)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$fullyQualifiedTypeName = this.getFullyQualifiedTypeName();
        String other$fullyQualifiedTypeName = other.getFullyQualifiedTypeName();
        if (this$fullyQualifiedTypeName == null ? other$fullyQualifiedTypeName != null : !this$fullyQualifiedTypeName.equals(other$fullyQualifiedTypeName)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindTypes;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $fullyQualifiedTypeName = this.getFullyQualifiedTypeName();
        result = result * 59 + ($fullyQualifiedTypeName == null ? 43 : $fullyQualifiedTypeName.hashCode());
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

