/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.marker.JavaSearchResult;
import org.openrewrite.java.tree.J;
import org.openrewrite.marker.Marker;

public final class FindAnnotations
extends Recipe {
    @Option(displayName="Annotation pattern", description="An annotation pattern, expressed as a pointcut expression.", example="@java.lang.SuppressWarnings(\"deprecation\")")
    private final String annotationPattern;
    private final UUID id = Tree.randomId();

    public String getDisplayName() {
        return "Find annotations";
    }

    public String getDescription() {
        return "Find all annotations matching the annotation pattern.";
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        final AnnotationMatcher annotationMatcher = new AnnotationMatcher(this.annotationPattern);
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.Annotation visitAnnotation(J.Annotation annotation, ExecutionContext ctx) {
                J a = super.visitAnnotation(annotation, ctx);
                if (annotationMatcher.matches(annotation)) {
                    a = ((J.Annotation)a).withMarkers(((J.Annotation)a).getMarkers().addOrUpdate((Marker)new JavaSearchResult(FindAnnotations.this.id, FindAnnotations.this)));
                }
                return a;
            }
        };
    }

    public static Set<J.Annotation> find(J j, String annotationPattern) {
        final AnnotationMatcher annotationMatcher = new AnnotationMatcher(annotationPattern);
        JavaIsoVisitor<Set<J.Annotation>> findVisitor = new JavaIsoVisitor<Set<J.Annotation>>(){

            @Override
            public J.Annotation visitAnnotation(J.Annotation annotation, Set<J.Annotation> as) {
                if (annotationMatcher.matches(annotation)) {
                    as.add(annotation);
                }
                return super.visitAnnotation(annotation, as);
            }
        };
        HashSet<J.Annotation> as = new HashSet<J.Annotation>();
        findVisitor.visit(j, as);
        return as;
    }

    public FindAnnotations(String annotationPattern) {
        this.annotationPattern = annotationPattern;
    }

    public String getAnnotationPattern() {
        return this.annotationPattern;
    }

    public UUID getId() {
        return this.id;
    }

    @NonNull
    public String toString() {
        return "FindAnnotations(annotationPattern=" + this.getAnnotationPattern() + ", id=" + this.getId() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindAnnotations)) {
            return false;
        }
        FindAnnotations other = (FindAnnotations)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$annotationPattern = this.getAnnotationPattern();
        String other$annotationPattern = other.getAnnotationPattern();
        if (this$annotationPattern == null ? other$annotationPattern != null : !this$annotationPattern.equals(other$annotationPattern)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindAnnotations;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $annotationPattern = this.getAnnotationPattern();
        result = result * 59 + ($annotationPattern == null ? 43 : $annotationPattern.hashCode());
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

