/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import org.antlr.v4.runtime.tree.ParseTree;
import org.openrewrite.java.AspectjUtils;
import org.openrewrite.java.internal.grammar.RefactorMethodSignatureParser;
import org.openrewrite.java.internal.grammar.RefactorMethodSignatureParserBaseVisitor;

class TypeVisitor
extends RefactorMethodSignatureParserBaseVisitor<String> {
    TypeVisitor() {
    }

    @Override
    public String visitClassNameOrInterface(RefactorMethodSignatureParser.ClassNameOrInterfaceContext ctx) {
        StringBuilder classNameBuilder = new StringBuilder();
        for (ParseTree c : ctx.children) {
            classNameBuilder.append(AspectjUtils.aspectjNameToPattern(c.getText()));
        }
        String className = classNameBuilder.toString();
        if (!className.contains(".")) {
            try {
                int arrInit = className.lastIndexOf("\\[");
                Class.forName("java.lang." + (arrInit == -1 ? className : className.substring(0, arrInit)), false, TypeVisitor.class.getClassLoader());
                return "java.lang." + className;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return className;
    }

    @Override
    public String visitPrimitiveType(RefactorMethodSignatureParser.PrimitiveTypeContext ctx) {
        return ctx.getText();
    }
}

