/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;

public class ChangeFieldType<P>
extends JavaIsoVisitor<P> {
    private final String oldFullyQualifiedTypeName;
    private final JavaType.FullyQualified newFieldType;

    public ChangeFieldType(JavaType.FullyQualified oldFieldType, JavaType.FullyQualified newFieldType) {
        assert (oldFieldType != null);
        assert (newFieldType != null);
        this.oldFullyQualifiedTypeName = oldFieldType.getFullyQualifiedName();
        this.newFieldType = newFieldType;
    }

    @Override
    public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, P p) {
        JavaType.Class typeAsClass = multiVariable.getTypeAsClass();
        J mv = super.visitVariableDeclarations(multiVariable, (Object)p);
        if (typeAsClass != null && this.oldFullyQualifiedTypeName.equals(typeAsClass.getFullyQualifiedName())) {
            this.maybeAddImport(this.newFieldType);
            this.maybeRemoveImport(typeAsClass);
            mv = ((J.VariableDeclarations)mv).withTypeExpression(((J.VariableDeclarations)mv).getTypeExpression() == null ? null : J.Identifier.build(((J.VariableDeclarations)mv).getTypeExpression().getId(), ((J.VariableDeclarations)mv).getTypeExpression().getPrefix(), Markers.EMPTY, this.newFieldType.getClassName(), this.newFieldType));
            mv = ((J.VariableDeclarations)mv).withVariables(ListUtils.map(((J.VariableDeclarations)mv).getVariables(), var -> {
                JavaType.Class varType = TypeUtils.asClass(var.getType());
                if (varType != null && !varType.equals(this.newFieldType)) {
                    return var.withType(this.newFieldType).withName(var.getName().withType(this.newFieldType));
                }
                return var;
            }));
        }
        return mv;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeFieldType)) {
            return false;
        }
        ChangeFieldType other = (ChangeFieldType)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$oldFullyQualifiedTypeName = this.getOldFullyQualifiedTypeName();
        String other$oldFullyQualifiedTypeName = other.getOldFullyQualifiedTypeName();
        if (this$oldFullyQualifiedTypeName == null ? other$oldFullyQualifiedTypeName != null : !this$oldFullyQualifiedTypeName.equals(other$oldFullyQualifiedTypeName)) {
            return false;
        }
        JavaType.FullyQualified this$newFieldType = this.getNewFieldType();
        JavaType.FullyQualified other$newFieldType = other.getNewFieldType();
        return !(this$newFieldType == null ? other$newFieldType != null : !this$newFieldType.equals(other$newFieldType));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChangeFieldType;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $oldFullyQualifiedTypeName = this.getOldFullyQualifiedTypeName();
        result = result * 59 + ($oldFullyQualifiedTypeName == null ? 43 : $oldFullyQualifiedTypeName.hashCode());
        JavaType.FullyQualified $newFieldType = this.getNewFieldType();
        result = result * 59 + ($newFieldType == null ? 43 : $newFieldType.hashCode());
        return result;
    }

    public String getOldFullyQualifiedTypeName() {
        return this.oldFullyQualifiedTypeName;
    }

    public JavaType.FullyQualified getNewFieldType() {
        return this.newFieldType;
    }

    @NonNull
    public String toString() {
        return "ChangeFieldType(oldFullyQualifiedTypeName=" + this.getOldFullyQualifiedTypeName() + ", newFieldType=" + this.getNewFieldType() + ")";
    }
}

