/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.cleanup.EmptyForInitializerPadStyle;
import org.openrewrite.java.cleanup.EmptyForIteratorPadStyle;
import org.openrewrite.java.cleanup.TypecastParenPadStyle;
import org.openrewrite.java.format.SpacesVisitor;
import org.openrewrite.java.style.Checkstyle;
import org.openrewrite.java.style.IntelliJ;
import org.openrewrite.java.style.SpacesStyle;
import org.openrewrite.java.tree.J;

public class TypecastParenPad
extends Recipe {
    public String getDisplayName() {
        return "Typecast parenthesis padding";
    }

    public String getDescription() {
        return "Fixes whitespace padding between a typecast type identifier and the enclosing left and right parenthesis. For example, when configured to remove spacing, `( int ) 0L;` becomes `(int) 0L;`.";
    }

    protected JavaIsoVisitor<ExecutionContext> getVisitor() {
        return new TypecastParenPadVisitor();
    }

    private static class TypecastParenPadVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        SpacesStyle spacesStyle;
        TypecastParenPadStyle typecastParenPadStyle;
        @Nullable
        EmptyForInitializerPadStyle emptyForInitializerPadStyle;
        @Nullable
        EmptyForIteratorPadStyle emptyForIteratorPadStyle;

        private TypecastParenPadVisitor() {
        }

        @Override
        public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
            this.spacesStyle = cu.getStyle(SpacesStyle.class) == null ? IntelliJ.spaces() : (SpacesStyle)cu.getStyle(SpacesStyle.class);
            this.typecastParenPadStyle = cu.getStyle(TypecastParenPadStyle.class) == null ? Checkstyle.typecastParenPadStyle() : (TypecastParenPadStyle)cu.getStyle(TypecastParenPadStyle.class);
            this.emptyForInitializerPadStyle = (EmptyForInitializerPadStyle)cu.getStyle(EmptyForInitializerPadStyle.class);
            this.emptyForIteratorPadStyle = (EmptyForIteratorPadStyle)cu.getStyle(EmptyForIteratorPadStyle.class);
            this.spacesStyle = this.spacesStyle.withWithin(this.spacesStyle.getWithin().withTypeCastParentheses(this.typecastParenPadStyle.getSpace()));
            return super.visitCompilationUnit(cu, ctx);
        }

        @Override
        public J.TypeCast visitTypeCast(J.TypeCast typeCast, ExecutionContext ctx) {
            J tc = super.visitTypeCast(typeCast, ctx);
            this.doAfterVisit(new SpacesVisitor(this.spacesStyle, this.emptyForInitializerPadStyle, this.emptyForIteratorPadStyle, tc));
            return tc;
        }
    }
}

