/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Tree;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.cleanup.ModifierOrder;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.marker.Markers;

public class FinalClassVisitor
extends JavaIsoVisitor<ExecutionContext> {
    @Override
    public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDeclaration, ExecutionContext executionContext) {
        if (classDeclaration.getKind() == J.ClassDeclaration.Kind.Type.Interface) {
            return classDeclaration;
        }
        J cd = super.visitClassDeclaration(classDeclaration, executionContext);
        if (((J.ClassDeclaration)cd).hasModifier(J.Modifier.Type.Final) || ((J.ClassDeclaration)cd).getKind() != J.ClassDeclaration.Kind.Type.Class) {
            return cd;
        }
        boolean allPrivate = true;
        int constructorCount = 0;
        for (Statement s : ((J.ClassDeclaration)cd).getBody().getStatements()) {
            if (s instanceof J.MethodDeclaration && ((J.MethodDeclaration)s).isConstructor()) {
                J.MethodDeclaration constructor = (J.MethodDeclaration)s;
                ++constructorCount;
                if (!constructor.hasModifier(J.Modifier.Type.Private)) {
                    allPrivate = false;
                }
            }
            if (constructorCount <= 0 || allPrivate) continue;
            return cd;
        }
        if (constructorCount > 0) {
            List<J.Modifier> modifiers = new ArrayList<J.Modifier>(((J.ClassDeclaration)cd).getModifiers());
            modifiers.add(new J.Modifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, J.Modifier.Type.Final, Collections.emptyList()));
            modifiers = ModifierOrder.sortModifiers(modifiers);
            cd = ((J.ClassDeclaration)cd).withModifiers(modifiers);
            assert (this.getCursor().getParent() != null);
            cd = (J.ClassDeclaration)this.autoFormat(cd, ((J.ClassDeclaration)cd).getName(), executionContext, this.getCursor().getParent());
        }
        return cd;
    }
}

