/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.DeclaresMethod;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeTree;

public final class ChangeMethodName
extends Recipe {
    @Option(displayName="Method pattern", description="A method pattern, expressed as a pointcut expression, that is used to find matching method declarations/invocations.", example="org.mockito.Matchers anyVararg()")
    private final String methodPattern;
    @Option(displayName="New method name", description="The method name that will replace the existing name.", example="any")
    private final String newMethodName;

    public String getDisplayName() {
        return "Change method name";
    }

    public String getDescription() {
        return "Rename a method.";
    }

    protected JavaVisitor<ExecutionContext> getSingleSourceApplicableTest() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext executionContext) {
                this.doAfterVisit(new UsesMethod(ChangeMethodName.this.methodPattern));
                this.doAfterVisit(new DeclaresMethod(ChangeMethodName.this.methodPattern));
                return cu;
            }
        };
    }

    public boolean causesAnotherCycle() {
        return true;
    }

    public JavaVisitor<ExecutionContext> getVisitor() {
        return new ChangeMethodNameVisitor(new MethodMatcher(this.methodPattern));
    }

    public ChangeMethodName(String methodPattern, String newMethodName) {
        this.methodPattern = methodPattern;
        this.newMethodName = newMethodName;
    }

    public String getMethodPattern() {
        return this.methodPattern;
    }

    public String getNewMethodName() {
        return this.newMethodName;
    }

    @NonNull
    public String toString() {
        return "ChangeMethodName(methodPattern=" + this.getMethodPattern() + ", newMethodName=" + this.getNewMethodName() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeMethodName)) {
            return false;
        }
        ChangeMethodName other = (ChangeMethodName)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$methodPattern = this.getMethodPattern();
        String other$methodPattern = other.getMethodPattern();
        if (this$methodPattern == null ? other$methodPattern != null : !this$methodPattern.equals(other$methodPattern)) {
            return false;
        }
        String this$newMethodName = this.getNewMethodName();
        String other$newMethodName = other.getNewMethodName();
        return !(this$newMethodName == null ? other$newMethodName != null : !this$newMethodName.equals(other$newMethodName));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChangeMethodName;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $methodPattern = this.getMethodPattern();
        result = result * 59 + ($methodPattern == null ? 43 : $methodPattern.hashCode());
        String $newMethodName = this.getNewMethodName();
        result = result * 59 + ($newMethodName == null ? 43 : $newMethodName.hashCode());
        return result;
    }

    private class ChangeMethodNameVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private final MethodMatcher methodMatcher;

        private ChangeMethodNameVisitor(MethodMatcher methodMatcher) {
            this.methodMatcher = methodMatcher;
        }

        @Override
        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
            J m = super.visitMethodDeclaration(method, ctx);
            J.ClassDeclaration classDecl = (J.ClassDeclaration)this.getCursor().firstEnclosingOrThrow(J.ClassDeclaration.class);
            if (this.methodMatcher.matches(method, classDecl)) {
                JavaType.Method type = ((J.MethodDeclaration)m).getType();
                if (type != null) {
                    type = type.withName(ChangeMethodName.this.newMethodName);
                }
                m = ((J.MethodDeclaration)m).withName(((J.MethodDeclaration)m).getName().withName(ChangeMethodName.this.newMethodName)).withType(type);
            }
            return m;
        }

        @Override
        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J m = super.visitMethodInvocation(method, ctx);
            if (this.methodMatcher.matches(method) && !method.getSimpleName().equals(ChangeMethodName.this.newMethodName)) {
                JavaType.Method type = ((J.MethodInvocation)m).getType();
                if (type != null) {
                    type = type.withName(ChangeMethodName.this.newMethodName);
                }
                m = ((J.MethodInvocation)m).withName(((J.MethodInvocation)m).getName().withName(ChangeMethodName.this.newMethodName)).withType(type);
            }
            return m;
        }

        @Override
        public J.MemberReference visitMemberReference(J.MemberReference memberRef, ExecutionContext context) {
            J m = super.visitMemberReference(memberRef, context);
            if (this.methodMatcher.matches(((J.MemberReference)m).getReferenceType()) && !((J.MemberReference)m).getReference().getSimpleName().equals(ChangeMethodName.this.newMethodName)) {
                JavaType type = ((J.MemberReference)m).getReferenceType();
                if (type instanceof JavaType.Method) {
                    JavaType.Method mtype = (JavaType.Method)type;
                    type = mtype.withName(ChangeMethodName.this.newMethodName);
                }
                m = ((J.MemberReference)m).withReference(((J.MemberReference)m).getReference().withName(ChangeMethodName.this.newMethodName)).withReferenceType(type);
            }
            return m;
        }

        @Override
        public J.FieldAccess visitFieldAccess(J.FieldAccess fieldAccess, ExecutionContext ctx) {
            Expression target;
            J f = super.visitFieldAccess(fieldAccess, ctx);
            if (this.methodMatcher.isFullyQualifiedClassReference((J.FieldAccess)f) && (target = ((J.FieldAccess)f).getTarget()) instanceof J.FieldAccess) {
                String className = target.printTrimmed();
                String fullyQualified = className + "." + ChangeMethodName.this.newMethodName;
                return (J.FieldAccess)TypeTree.build(fullyQualified).withPrefix(((J.FieldAccess)f).getPrefix());
            }
            return f;
        }
    }
}

