/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.DeleteStatement;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Statement;

public class RemoveUnusedLocalVariables
extends Recipe {
    public String getDisplayName() {
        return "Remove unused local variables";
    }

    public String getDescription() {
        return "If a local variable is declared but not used, it is dead code and should be removed.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-1481");
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new RemoveUnusedLocalVariablesVisitor();
    }

    private static class FindAssignmentReferencesToVariable {
        private FindAssignmentReferencesToVariable() {
        }

        private static Set<Statement> find(J j, final J.VariableDeclarations.NamedVariable variable) {
            JavaIsoVisitor<Set<Statement>> visitor = new JavaIsoVisitor<Set<Statement>>(){

                @Override
                public J.Assignment visitAssignment(J.Assignment assignment, Set<Statement> ctx) {
                    J.Identifier i;
                    J a = super.visitAssignment(assignment, ctx);
                    if (((J.Assignment)a).getVariable() instanceof J.Identifier && (i = (J.Identifier)((J.Assignment)a).getVariable()).getSimpleName().equals(variable.getSimpleName())) {
                        ctx.add(assignment);
                    }
                    return a;
                }

                @Override
                public J.AssignmentOperation visitAssignmentOperation(J.AssignmentOperation assignOp, Set<Statement> ctx) {
                    J.Identifier i;
                    J a = super.visitAssignmentOperation(assignOp, ctx);
                    if (((J.AssignmentOperation)a).getVariable() instanceof J.Identifier && (i = (J.Identifier)((J.AssignmentOperation)a).getVariable()).getSimpleName().equals(variable.getSimpleName())) {
                        ctx.add(assignOp);
                    }
                    return a;
                }

                @Override
                public J.Unary visitUnary(J.Unary unary, Set<Statement> ctx) {
                    J.Identifier i;
                    J u = super.visitUnary(unary, ctx);
                    if (((J.Unary)u).getExpression() instanceof J.Identifier && (i = (J.Identifier)((J.Unary)u).getExpression()).getSimpleName().equals(variable.getSimpleName())) {
                        ctx.add(unary);
                    }
                    return u;
                }
            };
            HashSet<Statement> refs = new HashSet<Statement>();
            visitor.visit(j, refs);
            return refs;
        }
    }

    private static class FindReadReferencesToVariable {
        private FindReadReferencesToVariable() {
        }

        public static Set<NameTree> find(J j, final J.VariableDeclarations.NamedVariable variable) {
            HashSet<NameTree> refs = new HashSet<NameTree>();
            new JavaIsoVisitor<Set<NameTree>>(){

                @Override
                public J.Identifier visitIdentifier(J.Identifier identifier, Set<NameTree> ctx) {
                    J i = super.visitIdentifier(identifier, ctx);
                    if (((J.Identifier)i).getSimpleName().equals(variable.getSimpleName())) {
                        assert (this.getCursor().getParent() != null);
                        Object parent = this.getCursor().getParent().getValue();
                        if (parent instanceof J.Assignment) {
                            J.Assignment parentTree = (J.Assignment)parent;
                            if (!parentTree.getVariable().isScope(i)) {
                                ctx.add((NameTree)i);
                            }
                        } else if (parent instanceof J.AssignmentOperation) {
                            J.AssignmentOperation parentTree = (J.AssignmentOperation)parent;
                            if (parentTree.getVariable().isScope(i)) {
                                Object grandParent = this.getCursor().getParent().dropParentUntil(J.class::isInstance).getValue();
                                if (grandParent instanceof Expression || grandParent instanceof J.Return) {
                                    ctx.add((NameTree)i);
                                }
                            } else {
                                ctx.add((NameTree)i);
                            }
                        } else if (!(parent instanceof J.VariableDeclarations.NamedVariable)) {
                            ctx.add((NameTree)i);
                        }
                    }
                    return i;
                }
            }.visit(j, refs);
            return refs;
        }
    }

    private static class RemoveUnusedLocalVariablesVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private RemoveUnusedLocalVariablesVisitor() {
        }

        private static Cursor getCursorToParentScope(Cursor cursor) {
            return cursor.dropParentUntil(is -> is instanceof J.Block || is instanceof J.MethodDeclaration || is instanceof J.ForLoop || is instanceof J.ForEachLoop || is instanceof J.ForLoop.Control || is instanceof J.Case || is instanceof J.Try || is instanceof J.Try.Catch || is instanceof J.MultiCatch || is instanceof J.Lambda);
        }

        @Override
        public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, ExecutionContext ctx) {
            Set<NameTree> readReferences;
            Cursor parentScope = RemoveUnusedLocalVariablesVisitor.getCursorToParentScope(this.getCursor());
            if (!(this.getCursor().getParent(2).getValue() instanceof J.VariableDeclarations && !((J.VariableDeclarations)this.getCursor().getParent(2).getValue()).getAllAnnotations().isEmpty() || parentScope.getParent() != null && parentScope.getParent().getValue() instanceof J.ClassDeclaration || parentScope.getParent().getValue() instanceof J.NewClass || parentScope.getValue() instanceof J.MethodDeclaration || parentScope.getValue() instanceof J.ForEachLoop || parentScope.getValue() instanceof J.ForLoop.Control || parentScope.getValue() instanceof J.Try || parentScope.getValue() instanceof J.Try.Catch || parentScope.getValue() instanceof J.MultiCatch || parentScope.getValue() instanceof J.Lambda || !(readReferences = FindReadReferencesToVariable.find((J)parentScope.getValue(), variable)).isEmpty())) {
                Set assignmentReferences = FindAssignmentReferencesToVariable.find((J)parentScope.getValue(), variable);
                for (Statement ref : assignmentReferences) {
                    this.doAfterVisit(new DeleteStatement(ref));
                }
                return null;
            }
            return super.visitVariable(variable, ctx);
        }

        @Override
        public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext ctx) {
            J mv = super.visitVariableDeclarations(multiVariable, ctx);
            if (((J.VariableDeclarations)mv).getVariables().isEmpty()) {
                this.doAfterVisit(new DeleteStatement((Statement)mv));
            }
            return mv;
        }
    }
}

