/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.openrewrite.Cursor;
import org.openrewrite.Incubating;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.RenameVariable;
import org.openrewrite.java.cleanup.HiddenFieldStyle;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

@Incubating(since="7.6.0")
public final class HiddenFieldVisitor<P>
extends JavaIsoVisitor<P> {
    private static final Pattern NEXT_NAME_PATTERN = Pattern.compile("(.+)(\\d+)");
    private final HiddenFieldStyle style;

    private static Cursor getCursorToParentScope(Cursor cursor) {
        return cursor.dropParentUntil(is -> is instanceof J.Block || is instanceof J.MethodDeclaration || is instanceof J.ForLoop || is instanceof J.ForEachLoop || is instanceof J.Case || is instanceof J.Try || is instanceof J.Try.Catch || is instanceof J.MultiCatch || is instanceof J.Lambda);
    }

    @Override
    public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, P p) {
        List<J.VariableDeclarations.NamedVariable> classFields = classDecl.getBody().getStatements().stream().filter(J.VariableDeclarations.class::isInstance).map(J.VariableDeclarations.class::cast).flatMap(vd -> vd.getVariables().stream()).collect(Collectors.toList());
        classFields.forEach(cf -> FindNameShadows.find(classDecl, cf, classDecl, this.style).forEach(shadow -> this.doAfterVisit(new RenameShadowedName((J.VariableDeclarations.NamedVariable)shadow, this.style))));
        return super.visitClassDeclaration(classDecl, (Object)p);
    }

    public HiddenFieldVisitor(HiddenFieldStyle style) {
        this.style = style;
    }

    public HiddenFieldStyle getStyle() {
        return this.style;
    }

    @NonNull
    public String toString() {
        return "HiddenFieldVisitor(style=" + this.getStyle() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HiddenFieldVisitor)) {
            return false;
        }
        HiddenFieldVisitor other = (HiddenFieldVisitor)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HiddenFieldStyle this$style = this.getStyle();
        HiddenFieldStyle other$style = other.getStyle();
        return !(this$style == null ? other$style != null : !((Object)this$style).equals(other$style));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof HiddenFieldVisitor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        HiddenFieldStyle $style = this.getStyle();
        result = result * 59 + ($style == null ? 43 : ((Object)$style).hashCode());
        return result;
    }

    private static class FindNameShadows
    extends JavaIsoVisitor<Set<J.VariableDeclarations.NamedVariable>> {
        private final J.VariableDeclarations.NamedVariable targetVariable;
        private final J.ClassDeclaration targetVariableEnclosingClass;
        private final HiddenFieldStyle hiddenFieldStyle;

        public FindNameShadows(J.VariableDeclarations.NamedVariable targetVariable, J.ClassDeclaration targetVariableEnclosingClass, HiddenFieldStyle hiddenFieldStyle) {
            this.targetVariable = targetVariable;
            this.targetVariableEnclosingClass = targetVariableEnclosingClass;
            this.hiddenFieldStyle = hiddenFieldStyle;
        }

        public static Set<J.VariableDeclarations.NamedVariable> find(J j, J.VariableDeclarations.NamedVariable targetVariable, J.ClassDeclaration targetVariableEnclosingClass, HiddenFieldStyle hiddenFieldStyle) {
            HashSet<J.VariableDeclarations.NamedVariable> references = new HashSet<J.VariableDeclarations.NamedVariable>();
            new FindNameShadows(targetVariable, targetVariableEnclosingClass, hiddenFieldStyle).visit(j, references);
            return references;
        }

        @Override
        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, Set<J.VariableDeclarations.NamedVariable> ctx) {
            if (!classDecl.getKind().equals((Object)J.ClassDeclaration.Kind.Type.Class) || classDecl.hasModifier(J.Modifier.Type.Static)) {
                return classDecl;
            }
            return super.visitClassDeclaration(classDecl, ctx);
        }

        @Override
        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, Set<J.VariableDeclarations.NamedVariable> ctx) {
            if (method.hasModifier(J.Modifier.Type.Static)) {
                return method;
            }
            return super.visitMethodDeclaration(method, ctx);
        }

        @Override
        public J.Block visitBlock(J.Block block, Set<J.VariableDeclarations.NamedVariable> ctx) {
            if (block.isStatic()) {
                return block;
            }
            return super.visitBlock(block, ctx);
        }

        @Override
        public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, Set<J.VariableDeclarations.NamedVariable> ctx) {
            J v = super.visitVariable(variable, ctx);
            if (((J.VariableDeclarations.NamedVariable)v).getSimpleName().equals(this.targetVariable.getSimpleName()) && !v.isScope(this.targetVariable)) {
                boolean isIgnorableAbstractMethod;
                Tree maybeMethodDecl = (Tree)this.getCursor().dropParentUntil(J.class::isInstance).dropParentUntil(J.class::isInstance).getValue();
                boolean isIgnorableConstructorParam = this.hiddenFieldStyle.getIgnoreConstructorParameter();
                if (isIgnorableConstructorParam) {
                    isIgnorableConstructorParam = maybeMethodDecl instanceof J.MethodDeclaration && ((J.MethodDeclaration)maybeMethodDecl).isConstructor();
                }
                boolean isIgnorableSetter = this.hiddenFieldStyle.getIgnoreSetter();
                if (isIgnorableSetter &= maybeMethodDecl instanceof J.MethodDeclaration) {
                    J.MethodDeclaration methodDecl = (J.MethodDeclaration)maybeMethodDecl;
                    String methodName = methodDecl.getSimpleName();
                    boolean bl = methodName.startsWith("set") && methodDecl.getReturnTypeExpression() != null && (this.hiddenFieldStyle.getSetterCanReturnItsClass() != false ? this.targetVariableEnclosingClass.getType() != null && this.targetVariableEnclosingClass.getType().equals(methodDecl.getReturnTypeExpression().getType()) : JavaType.Primitive.Void.equals(methodDecl.getReturnTypeExpression().getType())) && methodName.length() > 3 && variable.getSimpleName().equalsIgnoreCase(methodName.substring(3)) ? true : (isIgnorableSetter = false);
                }
                if (isIgnorableAbstractMethod = this.hiddenFieldStyle.getIgnoreAbstractMethods().booleanValue()) {
                    boolean bl = isIgnorableAbstractMethod = maybeMethodDecl instanceof J.MethodDeclaration && ((J.MethodDeclaration)maybeMethodDecl).isAbstract();
                }
                if (!(isIgnorableSetter || isIgnorableConstructorParam || isIgnorableAbstractMethod)) {
                    ctx.add((J.VariableDeclarations.NamedVariable)v);
                }
            }
            return v;
        }
    }

    private static class RenameShadowedName<P>
    extends JavaIsoVisitor<P> {
        private final J.VariableDeclarations.NamedVariable targetVariable;
        private final HiddenFieldStyle hiddenFieldStyle;

        public RenameShadowedName(J.VariableDeclarations.NamedVariable targetVariable, HiddenFieldStyle hiddenFieldStyle) {
            this.targetVariable = targetVariable;
            this.hiddenFieldStyle = hiddenFieldStyle;
        }

        private static String nextName(String name) {
            Matcher nameMatcher = NEXT_NAME_PATTERN.matcher(name);
            return nameMatcher.matches() ? nameMatcher.group(1) + (Integer.parseInt(nameMatcher.group(2)) + 1) : name + "1";
        }

        @Override
        public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, P p) {
            J v = super.visitVariable(variable, (Object)p);
            if (v.isScope(this.targetVariable)) {
                String nextName = RenameShadowedName.nextName(((J.VariableDeclarations.NamedVariable)v).getSimpleName());
                J.CompilationUnit enclosingCU = (J.CompilationUnit)this.getCursor().firstEnclosingOrThrow(J.CompilationUnit.class);
                Cursor parentScope = HiddenFieldVisitor.getCursorToParentScope(this.getCursor());
                J.ClassDeclaration enclosingClass = (J.ClassDeclaration)this.getCursor().firstEnclosingOrThrow(J.ClassDeclaration.class);
                while (!FindNameShadows.find((J)parentScope.getValue(), ((J.VariableDeclarations.NamedVariable)v).withName(((J.VariableDeclarations.NamedVariable)v).getName().withName(nextName)), enclosingClass, this.hiddenFieldStyle).isEmpty() || !FindExistingVariableDeclarations.find(enclosingCU, this.getCursor(), nextName).isEmpty()) {
                    nextName = RenameShadowedName.nextName(nextName);
                }
                this.doAfterVisit(new RenameVariable((J.VariableDeclarations.NamedVariable)v, nextName));
            }
            return v;
        }
    }

    private static class FindExistingVariableDeclarations
    extends JavaIsoVisitor<Set<J.VariableDeclarations.NamedVariable>> {
        private final Cursor childTargetReference;
        private final String childTargetName;

        private FindExistingVariableDeclarations(Cursor childTargetReference, String childTargetName) {
            this.childTargetReference = childTargetReference;
            this.childTargetName = childTargetName;
        }

        public static Set<J.VariableDeclarations.NamedVariable> find(J j, Cursor childTargetReference, String childTargetName) {
            HashSet<J.VariableDeclarations.NamedVariable> references = new HashSet<J.VariableDeclarations.NamedVariable>();
            new FindExistingVariableDeclarations(childTargetReference, childTargetName).visit(j, references);
            return references;
        }

        @Override
        public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, Set<J.VariableDeclarations.NamedVariable> ctx) {
            if (variable.getSimpleName().equals(this.childTargetName) && this.isInSameNameScope(this.getCursor(), this.childTargetReference)) {
                ctx.add(variable);
            }
            return super.visitVariable(variable, ctx);
        }
    }
}

