/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.format;

import java.util.Iterator;
import java.util.List;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.style.BlankLinesStyle;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;

class BlankLinesVisitor<P>
extends JavaIsoVisitor<P> {
    private final BlankLinesStyle style;

    public BlankLinesVisitor(BlankLinesStyle style) {
        this.style = style;
    }

    @Override
    public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, P p) {
        J.CompilationUnit j = cu;
        if (j.getPackageDeclaration() != null) {
            j = !j.getPrefix().getComments().isEmpty() ? (J.CompilationUnit)j.withComments(ListUtils.mapLast(j.getComments(), c -> {
                String suffix = this.keepMaximumLines(c.getSuffix(), (int)this.style.getKeepMaximum().getBetweenHeaderAndPackage());
                suffix = this.minimumLines(suffix, (int)this.style.getMinimum().getBeforePackage());
                return c.withSuffix(suffix);
            })) : j.withPrefix(Space.EMPTY);
        }
        j = j.getPackageDeclaration() == null ? (j.getComments().isEmpty() ? j.withPrefix(Space.EMPTY) : (J.CompilationUnit)j.withComments(ListUtils.mapLast(j.getComments(), c -> c.withSuffix(this.minimumLines(c.getSuffix(), (int)this.style.getMinimum().getBeforeImports()))))) : j.getPadding().withImports(ListUtils.mapFirst(j.getPadding().getImports(), i -> this.minimumLines((J)((Object)i), (int)this.style.getMinimum().getAfterPackage())));
        return super.visitCompilationUnit(j, (Object)p);
    }

    @Override
    public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, P p) {
        J j = super.visitClassDeclaration(classDecl, (Object)p);
        List<JRightPadded<Statement>> statements = ((J.ClassDeclaration)j).getBody().getPadding().getStatements();
        j = ((J.ClassDeclaration)j).withBody(((J.ClassDeclaration)j).getBody().getPadding().withStatements(ListUtils.map(statements, (i, s) -> {
            if (i == 0) {
                s = this.minimumLines((J)((Object)s), (int)this.style.getMinimum().getAfterClassHeader());
            } else if (((JRightPadded)statements.get(i - 1)).getElement() instanceof J.Block) {
                s = this.minimumLines((J)((Object)s), (int)this.style.getMinimum().getAroundInitializer());
            }
            return s;
        })));
        j = ((J.ClassDeclaration)j).withBody(((J.ClassDeclaration)j).getBody().withEnd(this.minimumLines(((J.ClassDeclaration)j).getBody().getEnd(), (int)this.style.getMinimum().getBeforeClassEnd())));
        J.CompilationUnit cu = (J.CompilationUnit)this.getCursor().firstEnclosingOrThrow(J.CompilationUnit.class);
        boolean hasImports = !cu.getImports().isEmpty();
        boolean firstClass = ((J.ClassDeclaration)j).equals(cu.getClasses().get(0));
        J j2 = firstClass ? (hasImports ? (J.ClassDeclaration)this.minimumLines(j, (int)this.style.getMinimum().getAfterImports()) : j) : (j = (J.ClassDeclaration)this.minimumLines(j, (int)this.style.getMinimum().getAroundClass()));
        if (!hasImports && firstClass) {
            j = (J.ClassDeclaration)this.minimumLines(j, (int)this.style.getMinimum().getAfterPackage());
        }
        if (!hasImports && firstClass && cu.getPackageDeclaration() == null) {
            j = ((J.ClassDeclaration)j).withPrefix(((J.ClassDeclaration)j).getPrefix().withWhitespace(""));
        }
        return j;
    }

    @Override
    public J.Import visitImport(J.Import impoort, P p) {
        J.CompilationUnit cu;
        J i = super.visitImport(impoort, (Object)p);
        if (((J.Import)i).equals((cu = (J.CompilationUnit)this.getCursor().firstEnclosingOrThrow(J.CompilationUnit.class)).getImports().get(0)) && cu.getPackageDeclaration() == null && cu.getPrefix().equals(Space.EMPTY)) {
            i = ((J.Import)i).withPrefix(((J.Import)i).getPrefix().withWhitespace(""));
        }
        return i;
    }

    @Override
    public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, P p) {
        J j = super.visitMethodDeclaration(method, (Object)p);
        if (((J.MethodDeclaration)j).getBody() != null) {
            if (((J.MethodDeclaration)j).getBody().getStatements().isEmpty()) {
                Space end = this.minimumLines(((J.MethodDeclaration)j).getBody().getEnd(), (int)this.style.getMinimum().getBeforeMethodBody());
                if (end.getIndent().isEmpty() && this.style.getMinimum().getBeforeMethodBody() > 0) {
                    end = end.withWhitespace(end.getWhitespace() + method.getPrefix().getIndent());
                }
                j = ((J.MethodDeclaration)j).withBody(((J.MethodDeclaration)j).getBody().withEnd(end));
            } else {
                j = ((J.MethodDeclaration)j).withBody(((J.MethodDeclaration)j).getBody().withStatements(ListUtils.mapFirst(((J.MethodDeclaration)j).getBody().getStatements(), s -> this.minimumLines(s, (int)this.style.getMinimum().getBeforeMethodBody()))));
            }
        }
        return j;
    }

    @Override
    public J.NewClass visitNewClass(J.NewClass newClass, P p) {
        J j = super.visitNewClass(newClass, (Object)p);
        if (((J.NewClass)j).getBody() != null) {
            j = ((J.NewClass)j).withBody(((J.NewClass)j).getBody().withStatements(ListUtils.mapFirst(((J.NewClass)j).getBody().getStatements(), s -> this.minimumLines(s, (int)this.style.getMinimum().getAfterAnonymousClassHeader()))));
        }
        return j;
    }

    @Override
    public Statement visitStatement(Statement statement, P p) {
        J j = super.visitStatement(statement, (Object)p);
        Iterator cursorPath = this.getCursor().getParentOrThrow().getPath(J.class::isInstance);
        Object parentTree = cursorPath.next();
        if (cursorPath.hasNext()) {
            Object grandparentTree = cursorPath.next();
            if (grandparentTree instanceof J.ClassDeclaration && parentTree instanceof J.Block) {
                J.Block block = (J.Block)parentTree;
                J.ClassDeclaration classDecl = (J.ClassDeclaration)grandparentTree;
                j = (Statement)this.keepMaximumLines(j, (int)this.style.getKeepMaximum().getInDeclarations());
                if (!block.getStatements().isEmpty() && block.getStatements().iterator().next() != j) {
                    if (j instanceof J.VariableDeclarations) {
                        j = classDecl.getKind() == J.ClassDeclaration.Kind.Type.Interface ? (Statement)this.minimumLines(j, (int)this.style.getMinimum().getAroundFieldInInterface()) : (Statement)this.minimumLines(j, (int)this.style.getMinimum().getAroundField());
                    } else if (j instanceof J.MethodDeclaration) {
                        j = classDecl.getKind() == J.ClassDeclaration.Kind.Type.Interface ? (Statement)this.minimumLines(j, (int)this.style.getMinimum().getAroundMethodInInterface()) : (Statement)this.minimumLines(j, (int)this.style.getMinimum().getAroundMethod());
                    } else if (j instanceof J.Block) {
                        j = (Statement)this.minimumLines(j, (int)this.style.getMinimum().getAroundInitializer());
                    }
                }
            } else {
                return (Statement)this.keepMaximumLines(j, (int)this.style.getKeepMaximum().getInCode());
            }
        }
        return j;
    }

    @Override
    public J.Block visitBlock(J.Block block, P p) {
        J j = super.visitBlock(block, (Object)p);
        j = ((J.Block)j).withEnd(this.keepMaximumLines(((J.Block)j).getEnd(), (int)this.style.getKeepMaximum().getBeforeEndOfBlock()));
        return j;
    }

    private <J2 extends J> J2 keepMaximumLines(J2 tree, int max) {
        return tree.withPrefix(this.keepMaximumLines(tree.getPrefix(), max));
    }

    private Space keepMaximumLines(Space prefix, int max) {
        return prefix.withWhitespace(this.keepMaximumLines(prefix.getWhitespace(), max));
    }

    private String keepMaximumLines(String whitespace, int max) {
        long blankLines = whitespace.chars().filter(c -> c == 10).count() - 1L;
        if (blankLines > (long)max) {
            int startWhitespaceAtIndex = 0;
            int i = 0;
            while ((long)i < blankLines - (long)max + 1L) {
                startWhitespaceAtIndex = whitespace.indexOf(10, startWhitespaceAtIndex);
                ++i;
                ++startWhitespaceAtIndex;
            }
            return whitespace.substring(--startWhitespaceAtIndex);
        }
        return whitespace;
    }

    private <J2 extends J> JRightPadded<J2> minimumLines(JRightPadded<J2> tree, int min) {
        return tree.withElement(this.minimumLines((J)tree.getElement(), min));
    }

    private <J2 extends J> J2 minimumLines(J2 tree, int min) {
        return tree.withPrefix(this.minimumLines(tree.getPrefix(), min));
    }

    private Space minimumLines(Space prefix, int min) {
        return prefix.withWhitespace(this.minimumLines(prefix.getWhitespace(), min));
    }

    private String minimumLines(String whitespace, int min) {
        if (min == 0) {
            return whitespace;
        }
        String minWhitespace = whitespace;
        int i = 0;
        while ((long)i < (long)min - whitespace.chars().filter(c -> c == 10).count() + 1L) {
            minWhitespace = "\n" + minWhitespace;
            ++i;
        }
        return minWhitespace;
    }
}

