/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.HashSet;
import java.util.Set;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.TypeUtils;

public class FindReferencedTypes {
    private FindReferencedTypes() {
    }

    public static Set<JavaType.Class> find(J j) {
        HashSet<JavaType.Class> fields = new HashSet<JavaType.Class>();
        new FindReferencedTypesVisitor().visit(j, fields);
        return fields;
    }

    private static class FindReferencedTypesVisitor
    extends JavaIsoVisitor<Set<JavaType.Class>> {
        private FindReferencedTypesVisitor() {
        }

        @Override
        public <N extends NameTree> N visitTypeName(N name, Set<JavaType.Class> ctx) {
            JavaType.Class asClass = TypeUtils.asClass(name.getType());
            if (asClass != null) {
                ctx.add(asClass);
            }
            return super.visitTypeName(name, ctx);
        }
    }
}

