/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.openrewrite.Cursor;
import org.openrewrite.Incubating;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreePrinter;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaPrinter;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.internal.ClassDeclarationToString;
import org.openrewrite.java.internal.ImportToString;
import org.openrewrite.java.internal.LiteralToString;
import org.openrewrite.java.internal.MethodDeclarationToString;
import org.openrewrite.java.internal.MethodInvocationToString;
import org.openrewrite.java.internal.VariableDeclarationsToString;
import org.openrewrite.java.search.FindTypes;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.Coordinates;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaCoordinates;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;

@JsonIdentityInfo(generator=ObjectIdGenerators.IntSequenceGenerator.class, property="@ref")
public interface J
extends Serializable,
Tree {
    default public <R extends Tree, P> R accept(TreeVisitor<R, P> v, P p) {
        return (R)(v instanceof JavaVisitor ? this.acceptJava((JavaVisitor)v, p) : v.defaultValue((Tree)this, p));
    }

    @Nullable
    default public <P> J acceptJava(JavaVisitor<P> v, P p) {
        return (J)v.defaultValue(this, p);
    }

    default public <P> String print(TreePrinter<P> printer, P p) {
        return new JavaPrinter<P>(printer).print(this, p);
    }

    default public <P> String print(P p) {
        return this.print(TreePrinter.identity(), p);
    }

    public <J2 extends J> J2 withPrefix(Space var1);

    public Space getPrefix();

    default public List<Comment> getComments() {
        return this.getPrefix().getComments();
    }

    default public <J2 extends J> J2 withComments(List<Comment> comments) {
        return this.withPrefix(this.getPrefix().withComments(comments));
    }

    public Coordinates getCoordinates();

    @Incubating(since="7.0.0")
    default public <J2 extends J> J2 withTemplate(JavaTemplate template, JavaCoordinates coordinates, Object ... parameters) {
        return template.withTemplate(this, coordinates, parameters);
    }

    public static final class Wildcard
    implements J,
    Expression {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        @Nullable
        private final JLeftPadded<Bound> bound;
        @Nullable
        private final NameTree boundedType;

        @Nullable
        public Bound getBound() {
            return this.bound == null ? null : this.bound.getElement();
        }

        public Wildcard withBound(@Nullable Bound bound) {
            return this.getPadding().withBound(JLeftPadded.withElement(this.bound, bound));
        }

        @Override
        public JavaType getType() {
            return null;
        }

        public Wildcard withType(@Nullable JavaType type) {
            return this;
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitWildcard(this, p);
        }

        @Override
        public Coordinates.Wildcard getCoordinates() {
            return new Coordinates.Wildcard(this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @NonNull
        public String toString() {
            return "J.Wildcard(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", bound=" + (Object)((Object)this.getBound()) + ", boundedType=" + this.getBoundedType() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Wildcard)) {
                return false;
            }
            Wildcard other = (Wildcard)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Wildcard(UUID id, Space prefix, Markers markers, @Nullable JLeftPadded<Bound> bound, @Nullable NameTree boundedType) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.bound = bound;
            this.boundedType = boundedType;
        }

        private Wildcard(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, @Nullable JLeftPadded<Bound> bound, @Nullable NameTree boundedType) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.bound = bound;
            this.boundedType = boundedType;
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public Wildcard withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Wildcard(this.padding, this.id, prefix, this.markers, this.bound, this.boundedType);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public Wildcard withMarkers(Markers markers) {
            return this.markers == markers ? this : new Wildcard(this.padding, this.id, this.prefix, markers, this.bound, this.boundedType);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public Wildcard withBoundedType(@Nullable NameTree boundedType) {
            return this.boundedType == boundedType ? this : new Wildcard(this.padding, this.id, this.prefix, this.markers, this.bound, boundedType);
        }

        @Nullable
        public NameTree getBoundedType() {
            return this.boundedType;
        }

        public static class Padding {
            private final Wildcard t;

            @Nullable
            public JLeftPadded<Bound> getBound() {
                return this.t.bound;
            }

            public Wildcard withBound(@Nullable JLeftPadded<Bound> bound) {
                return this.t.bound == bound ? this.t : new Wildcard(this.t.id, this.t.prefix, this.t.markers, bound, this.t.boundedType);
            }

            public Padding(Wildcard t) {
                this.t = t;
            }
        }

        public static enum Bound {
            Extends,
            Super;

        }
    }

    public static final class WhileLoop
    implements J,
    Statement {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final ControlParentheses<Expression> condition;
        private final JRightPadded<Statement> body;

        public Statement getBody() {
            return this.body.getElement();
        }

        public WhileLoop withBody(Statement body) {
            return this.getPadding().withBody(this.body.withElement(body));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitWhileLoop(this, p);
        }

        @Override
        public Coordinates.WhileLoop getCoordinates() {
            return new Coordinates.WhileLoop(this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @NonNull
        public String toString() {
            return "J.WhileLoop(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", condition=" + this.getCondition() + ", body=" + this.getBody() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WhileLoop)) {
                return false;
            }
            WhileLoop other = (WhileLoop)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public WhileLoop(UUID id, Space prefix, Markers markers, ControlParentheses<Expression> condition, JRightPadded<Statement> body) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.condition = condition;
            this.body = body;
        }

        private WhileLoop(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, ControlParentheses<Expression> condition, JRightPadded<Statement> body) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.condition = condition;
            this.body = body;
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public WhileLoop withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new WhileLoop(this.padding, this.id, prefix, this.markers, this.condition, this.body);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public WhileLoop withMarkers(Markers markers) {
            return this.markers == markers ? this : new WhileLoop(this.padding, this.id, this.prefix, markers, this.condition, this.body);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public WhileLoop withCondition(ControlParentheses<Expression> condition) {
            return this.condition == condition ? this : new WhileLoop(this.padding, this.id, this.prefix, this.markers, condition, this.body);
        }

        public ControlParentheses<Expression> getCondition() {
            return this.condition;
        }

        public static class Padding {
            private final WhileLoop t;

            public JRightPadded<Statement> getBody() {
                return this.t.body;
            }

            public WhileLoop withBody(JRightPadded<Statement> body) {
                return this.t.body == body ? this.t : new WhileLoop(this.t.id, this.t.prefix, this.t.markers, this.t.condition, body);
            }

            public Padding(WhileLoop t) {
                this.t = t;
            }
        }
    }

    public static final class VariableDeclarations
    implements J,
    Statement {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final List<Annotation> annotations;
        private final List<Modifier> modifiers;
        @Nullable
        private final TypeTree typeExpression;
        @Nullable
        private final Space varargs;
        private final List<JLeftPadded<Space>> dimensionsBeforeName;
        private final List<JRightPadded<NamedVariable>> variables;

        public List<NamedVariable> getVariables() {
            return JRightPadded.getElements(this.variables);
        }

        public VariableDeclarations withVariables(List<NamedVariable> vars) {
            return this.getPadding().withVariables(JRightPadded.withElements(this.variables, vars));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitVariableDeclarations(this, p);
        }

        @Override
        public Coordinates.VariableDeclarations getCoordinates() {
            return new Coordinates.VariableDeclarations(this);
        }

        @Nullable
        public JavaType.Class getTypeAsClass() {
            return this.typeExpression == null ? null : TypeUtils.asClass(this.typeExpression.getType());
        }

        public boolean hasModifier(Modifier.Type modifier) {
            return Modifier.hasModifier(this.getModifiers(), modifier);
        }

        public String toString() {
            return "VariableDeclarations(" + VariableDeclarationsToString.toString(this) + ")";
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VariableDeclarations)) {
                return false;
            }
            VariableDeclarations other = (VariableDeclarations)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public VariableDeclarations(UUID id, Space prefix, Markers markers, List<Annotation> annotations, List<Modifier> modifiers, @Nullable TypeTree typeExpression, @Nullable Space varargs, List<JLeftPadded<Space>> dimensionsBeforeName, List<JRightPadded<NamedVariable>> variables) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.annotations = annotations;
            this.modifiers = modifiers;
            this.typeExpression = typeExpression;
            this.varargs = varargs;
            this.dimensionsBeforeName = dimensionsBeforeName;
            this.variables = variables;
        }

        private VariableDeclarations(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, List<Annotation> annotations, List<Modifier> modifiers, @Nullable TypeTree typeExpression, @Nullable Space varargs, List<JLeftPadded<Space>> dimensionsBeforeName, List<JRightPadded<NamedVariable>> variables) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.annotations = annotations;
            this.modifiers = modifiers;
            this.typeExpression = typeExpression;
            this.varargs = varargs;
            this.dimensionsBeforeName = dimensionsBeforeName;
            this.variables = variables;
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public VariableDeclarations withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new VariableDeclarations(this.padding, this.id, prefix, this.markers, this.annotations, this.modifiers, this.typeExpression, this.varargs, this.dimensionsBeforeName, this.variables);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public VariableDeclarations withMarkers(Markers markers) {
            return this.markers == markers ? this : new VariableDeclarations(this.padding, this.id, this.prefix, markers, this.annotations, this.modifiers, this.typeExpression, this.varargs, this.dimensionsBeforeName, this.variables);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public VariableDeclarations withAnnotations(List<Annotation> annotations) {
            return this.annotations == annotations ? this : new VariableDeclarations(this.padding, this.id, this.prefix, this.markers, annotations, this.modifiers, this.typeExpression, this.varargs, this.dimensionsBeforeName, this.variables);
        }

        public List<Annotation> getAnnotations() {
            return this.annotations;
        }

        @NonNull
        public VariableDeclarations withModifiers(List<Modifier> modifiers) {
            return this.modifiers == modifiers ? this : new VariableDeclarations(this.padding, this.id, this.prefix, this.markers, this.annotations, modifiers, this.typeExpression, this.varargs, this.dimensionsBeforeName, this.variables);
        }

        public List<Modifier> getModifiers() {
            return this.modifiers;
        }

        @NonNull
        public VariableDeclarations withTypeExpression(@Nullable TypeTree typeExpression) {
            return this.typeExpression == typeExpression ? this : new VariableDeclarations(this.padding, this.id, this.prefix, this.markers, this.annotations, this.modifiers, typeExpression, this.varargs, this.dimensionsBeforeName, this.variables);
        }

        @Nullable
        public TypeTree getTypeExpression() {
            return this.typeExpression;
        }

        @NonNull
        public VariableDeclarations withVarargs(@Nullable Space varargs) {
            return this.varargs == varargs ? this : new VariableDeclarations(this.padding, this.id, this.prefix, this.markers, this.annotations, this.modifiers, this.typeExpression, varargs, this.dimensionsBeforeName, this.variables);
        }

        @Nullable
        public Space getVarargs() {
            return this.varargs;
        }

        @NonNull
        public VariableDeclarations withDimensionsBeforeName(List<JLeftPadded<Space>> dimensionsBeforeName) {
            return this.dimensionsBeforeName == dimensionsBeforeName ? this : new VariableDeclarations(this.padding, this.id, this.prefix, this.markers, this.annotations, this.modifiers, this.typeExpression, this.varargs, dimensionsBeforeName, this.variables);
        }

        public List<JLeftPadded<Space>> getDimensionsBeforeName() {
            return this.dimensionsBeforeName;
        }

        public static class Padding {
            private final VariableDeclarations t;

            public List<JRightPadded<NamedVariable>> getVariables() {
                return this.t.variables;
            }

            public VariableDeclarations withVariables(List<JRightPadded<NamedVariable>> variables) {
                return this.t.variables == variables ? this.t : new VariableDeclarations(this.t.id, this.t.prefix, this.t.markers, this.t.annotations, this.t.modifiers, this.t.typeExpression, this.t.varargs, this.t.dimensionsBeforeName, variables);
            }

            public Padding(VariableDeclarations t) {
                this.t = t;
            }
        }

        public static final class NamedVariable
        implements J,
        NameTree {
            @Nullable
            private transient WeakReference<Padding> padding;
            private final UUID id;
            private final Space prefix;
            private final Markers markers;
            private final Identifier name;
            private final List<JLeftPadded<Space>> dimensionsAfterName;
            @Nullable
            private final JLeftPadded<Expression> initializer;
            @Nullable
            private final JavaType type;

            @Nullable
            public Expression getInitializer() {
                return this.initializer == null ? null : this.initializer.getElement();
            }

            public NamedVariable withInitializer(@Nullable Expression initializer) {
                return this.getPadding().withInitializer(JLeftPadded.withElement(this.initializer, initializer));
            }

            public String getSimpleName() {
                return this.name.getSimpleName();
            }

            @Override
            public <P> J acceptJava(JavaVisitor<P> v, P p) {
                return v.visitVariable(this, p);
            }

            @Override
            public Coordinates.VariableDeclarations.NamedVar getCoordinates() {
                return new Coordinates.VariableDeclarations.NamedVar(this);
            }

            public boolean isField(Cursor cursor) {
                return cursor.getParentOrThrow().getParentOrThrow().getParentOrThrow().getParentOrThrow().getParentOrThrow().getValue() instanceof ClassDeclaration;
            }

            public Padding getPadding() {
                Padding p;
                if (this.padding == null) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                } else {
                    p = (Padding)this.padding.get();
                    if (p == null || p.t != this) {
                        p = new Padding(this);
                        this.padding = new WeakReference<Padding>(p);
                    }
                }
                return p;
            }

            @NonNull
            public String toString() {
                return "J.VariableDeclarations.NamedVariable(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", name=" + this.getName() + ", dimensionsAfterName=" + this.getDimensionsAfterName() + ", initializer=" + this.getInitializer() + ", type=" + this.getType() + ")";
            }

            public boolean equals(@Nullable Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof NamedVariable)) {
                    return false;
                }
                NamedVariable other = (NamedVariable)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            public NamedVariable(UUID id, Space prefix, Markers markers, Identifier name, List<JLeftPadded<Space>> dimensionsAfterName, @Nullable JLeftPadded<Expression> initializer, @Nullable JavaType type) {
                this.id = id;
                this.prefix = prefix;
                this.markers = markers;
                this.name = name;
                this.dimensionsAfterName = dimensionsAfterName;
                this.initializer = initializer;
                this.type = type;
            }

            private NamedVariable(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Identifier name, List<JLeftPadded<Space>> dimensionsAfterName, @Nullable JLeftPadded<Expression> initializer, @Nullable JavaType type) {
                this.padding = padding;
                this.id = id;
                this.prefix = prefix;
                this.markers = markers;
                this.name = name;
                this.dimensionsAfterName = dimensionsAfterName;
                this.initializer = initializer;
                this.type = type;
            }

            public UUID getId() {
                return this.id;
            }

            @NonNull
            public NamedVariable withPrefix(Space prefix) {
                return this.prefix == prefix ? this : new NamedVariable(this.padding, this.id, prefix, this.markers, this.name, this.dimensionsAfterName, this.initializer, this.type);
            }

            @Override
            public Space getPrefix() {
                return this.prefix;
            }

            @NonNull
            public NamedVariable withMarkers(Markers markers) {
                return this.markers == markers ? this : new NamedVariable(this.padding, this.id, this.prefix, markers, this.name, this.dimensionsAfterName, this.initializer, this.type);
            }

            public Markers getMarkers() {
                return this.markers;
            }

            @NonNull
            public NamedVariable withName(Identifier name) {
                return this.name == name ? this : new NamedVariable(this.padding, this.id, this.prefix, this.markers, name, this.dimensionsAfterName, this.initializer, this.type);
            }

            public Identifier getName() {
                return this.name;
            }

            @NonNull
            public NamedVariable withDimensionsAfterName(List<JLeftPadded<Space>> dimensionsAfterName) {
                return this.dimensionsAfterName == dimensionsAfterName ? this : new NamedVariable(this.padding, this.id, this.prefix, this.markers, this.name, dimensionsAfterName, this.initializer, this.type);
            }

            public List<JLeftPadded<Space>> getDimensionsAfterName() {
                return this.dimensionsAfterName;
            }

            @NonNull
            public NamedVariable withType(@Nullable JavaType type) {
                return this.type == type ? this : new NamedVariable(this.padding, this.id, this.prefix, this.markers, this.name, this.dimensionsAfterName, this.initializer, type);
            }

            @Override
            @Nullable
            public JavaType getType() {
                return this.type;
            }

            public static class Padding {
                private final NamedVariable t;

                @Nullable
                public JLeftPadded<Expression> getInitializer() {
                    return this.t.initializer;
                }

                public NamedVariable withInitializer(@Nullable JLeftPadded<Expression> initializer) {
                    return this.t.initializer == initializer ? this.t : new NamedVariable(this.t.id, this.t.prefix, this.t.markers, this.t.name, this.t.dimensionsAfterName, initializer, this.t.type);
                }

                public Padding(NamedVariable t) {
                    this.t = t;
                }
            }
        }
    }

    public static final class Unary
    implements J,
    Statement,
    Expression {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JLeftPadded<Type> operator;
        private final Expression expression;
        @Nullable
        private final JavaType type;

        public Type getOperator() {
            return this.operator.getElement();
        }

        public Unary withOperator(Type operator) {
            return this.getPadding().withOperator(this.operator.withElement(operator));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitUnary(this, p);
        }

        @Override
        public Coordinates.Unary getCoordinates() {
            return new Coordinates.Unary(this);
        }

        @Override
        public List<Tree> getSideEffects() {
            return this.expression.getSideEffects();
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @NonNull
        public String toString() {
            return "J.Unary(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", operator=" + (Object)((Object)this.getOperator()) + ", expression=" + this.getExpression() + ", type=" + this.getType() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Unary)) {
                return false;
            }
            Unary other = (Unary)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Unary(UUID id, Space prefix, Markers markers, JLeftPadded<Type> operator, Expression expression, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.operator = operator;
            this.expression = expression;
            this.type = type;
        }

        private Unary(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, JLeftPadded<Type> operator, Expression expression, @Nullable JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.operator = operator;
            this.expression = expression;
            this.type = type;
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public Unary withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Unary(this.padding, this.id, prefix, this.markers, this.operator, this.expression, this.type);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public Unary withMarkers(Markers markers) {
            return this.markers == markers ? this : new Unary(this.padding, this.id, this.prefix, markers, this.operator, this.expression, this.type);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public Unary withExpression(Expression expression) {
            return this.expression == expression ? this : new Unary(this.padding, this.id, this.prefix, this.markers, this.operator, expression, this.type);
        }

        public Expression getExpression() {
            return this.expression;
        }

        @NonNull
        public Unary withType(@Nullable JavaType type) {
            return this.type == type ? this : new Unary(this.padding, this.id, this.prefix, this.markers, this.operator, this.expression, type);
        }

        @Override
        @Nullable
        public JavaType getType() {
            return this.type;
        }

        public static class Padding {
            private final Unary t;

            public JLeftPadded<Type> getOperator() {
                return this.t.operator;
            }

            public Unary withOperator(JLeftPadded<Type> operator) {
                return this.t.operator == operator ? this.t : new Unary(this.t.id, this.t.prefix, this.t.markers, operator, this.t.expression, this.t.type);
            }

            public Padding(Unary t) {
                this.t = t;
            }
        }

        public static enum Type {
            PreIncrement,
            PreDecrement,
            PostIncrement,
            PostDecrement,
            Positive,
            Negative,
            Complement,
            Not;

        }
    }

    public static final class TypeParameter
    implements J {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final List<Annotation> annotations;
        private final Expression name;
        @Nullable
        private final JContainer<TypeTree> bounds;

        @Nullable
        public List<TypeTree> getBounds() {
            return this.bounds == null ? null : this.bounds.getElements();
        }

        public TypeParameter withBounds(@Nullable List<TypeTree> bounds) {
            return this.getPadding().withBounds(JContainer.withElementsNullable(this.bounds, bounds));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitTypeParameter(this, p);
        }

        @Override
        public Coordinates.TypeParameter getCoordinates() {
            return new Coordinates.TypeParameter(this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @NonNull
        public String toString() {
            return "J.TypeParameter(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", annotations=" + this.getAnnotations() + ", name=" + this.getName() + ", bounds=" + this.getBounds() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TypeParameter)) {
                return false;
            }
            TypeParameter other = (TypeParameter)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public TypeParameter(UUID id, Space prefix, Markers markers, List<Annotation> annotations, Expression name, @Nullable JContainer<TypeTree> bounds) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.annotations = annotations;
            this.name = name;
            this.bounds = bounds;
        }

        private TypeParameter(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, List<Annotation> annotations, Expression name, @Nullable JContainer<TypeTree> bounds) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.annotations = annotations;
            this.name = name;
            this.bounds = bounds;
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public TypeParameter withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new TypeParameter(this.padding, this.id, prefix, this.markers, this.annotations, this.name, this.bounds);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public TypeParameter withMarkers(Markers markers) {
            return this.markers == markers ? this : new TypeParameter(this.padding, this.id, this.prefix, markers, this.annotations, this.name, this.bounds);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public TypeParameter withAnnotations(List<Annotation> annotations) {
            return this.annotations == annotations ? this : new TypeParameter(this.padding, this.id, this.prefix, this.markers, annotations, this.name, this.bounds);
        }

        public List<Annotation> getAnnotations() {
            return this.annotations;
        }

        @NonNull
        public TypeParameter withName(Expression name) {
            return this.name == name ? this : new TypeParameter(this.padding, this.id, this.prefix, this.markers, this.annotations, name, this.bounds);
        }

        public Expression getName() {
            return this.name;
        }

        public static class Padding {
            private final TypeParameter t;

            @Nullable
            public JContainer<TypeTree> getBounds() {
                return this.t.bounds;
            }

            public TypeParameter withBounds(@Nullable JContainer<TypeTree> bounds) {
                return this.t.bounds == bounds ? this.t : new TypeParameter(this.t.id, this.t.prefix, this.t.markers, this.t.annotations, this.t.name, bounds);
            }

            public Padding(TypeParameter t) {
                this.t = t;
            }
        }
    }

    public static final class TypeCast
    implements J,
    Expression {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final ControlParentheses<TypeTree> clazz;
        private final Expression expression;

        @Override
        public JavaType getType() {
            return this.clazz.getType();
        }

        public TypeCast withType(@Nullable JavaType type) {
            return this.withClazz((ControlParentheses<TypeTree>)this.clazz.withType(type));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitTypeCast(this, p);
        }

        @Override
        public Coordinates.TypeCast getCoordinates() {
            return new Coordinates.TypeCast(this);
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TypeCast)) {
                return false;
            }
            TypeCast other = (TypeCast)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public TypeCast(UUID id, Space prefix, Markers markers, ControlParentheses<TypeTree> clazz, Expression expression) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.clazz = clazz;
            this.expression = expression;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public ControlParentheses<TypeTree> getClazz() {
            return this.clazz;
        }

        public Expression getExpression() {
            return this.expression;
        }

        @NonNull
        public String toString() {
            return "J.TypeCast(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", clazz=" + this.getClazz() + ", expression=" + this.getExpression() + ")";
        }

        @NonNull
        public TypeCast withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new TypeCast(this.id, prefix, this.markers, this.clazz, this.expression);
        }

        @NonNull
        public TypeCast withMarkers(Markers markers) {
            return this.markers == markers ? this : new TypeCast(this.id, this.prefix, markers, this.clazz, this.expression);
        }

        @NonNull
        public TypeCast withClazz(ControlParentheses<TypeTree> clazz) {
            return this.clazz == clazz ? this : new TypeCast(this.id, this.prefix, this.markers, clazz, this.expression);
        }

        @NonNull
        public TypeCast withExpression(Expression expression) {
            return this.expression == expression ? this : new TypeCast(this.id, this.prefix, this.markers, this.clazz, expression);
        }
    }

    public static final class Try
    implements J,
    Statement {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        @Nullable
        private final JContainer<Resource> resources;
        private final Block body;
        private final List<Catch> catches;
        @Nullable
        private final JLeftPadded<Block> finallie;

        @Nullable
        public List<Resource> getResources() {
            return this.resources == null ? null : this.resources.getElements();
        }

        public Try withResources(@Nullable List<Resource> resources) {
            return this.getPadding().withResources(JContainer.withElementsNullable(this.resources, resources));
        }

        @Nullable
        public Block getFinally() {
            return this.finallie == null ? null : this.finallie.getElement();
        }

        public Try withFinally(Block finallie) {
            return this.getPadding().withFinally(JLeftPadded.withElement(this.finallie, finallie));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitTry(this, p);
        }

        @Override
        public Coordinates.Try getCoordinates() {
            return new Coordinates.Try(this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @NonNull
        public String toString() {
            return "J.Try(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", resources=" + this.getResources() + ", body=" + this.getBody() + ", catches=" + this.getCatches() + ", finallie=" + this.finallie + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Try)) {
                return false;
            }
            Try other = (Try)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Try(UUID id, Space prefix, Markers markers, @Nullable JContainer<Resource> resources, Block body, List<Catch> catches, @Nullable JLeftPadded<Block> finallie) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.resources = resources;
            this.body = body;
            this.catches = catches;
            this.finallie = finallie;
        }

        private Try(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, @Nullable JContainer<Resource> resources, Block body, List<Catch> catches, @Nullable JLeftPadded<Block> finallie) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.resources = resources;
            this.body = body;
            this.catches = catches;
            this.finallie = finallie;
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public Try withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Try(this.padding, this.id, prefix, this.markers, this.resources, this.body, this.catches, this.finallie);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public Try withMarkers(Markers markers) {
            return this.markers == markers ? this : new Try(this.padding, this.id, this.prefix, markers, this.resources, this.body, this.catches, this.finallie);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public Try withBody(Block body) {
            return this.body == body ? this : new Try(this.padding, this.id, this.prefix, this.markers, this.resources, body, this.catches, this.finallie);
        }

        public Block getBody() {
            return this.body;
        }

        @NonNull
        public Try withCatches(List<Catch> catches) {
            return this.catches == catches ? this : new Try(this.padding, this.id, this.prefix, this.markers, this.resources, this.body, catches, this.finallie);
        }

        public List<Catch> getCatches() {
            return this.catches;
        }

        public static class Padding {
            private final Try t;

            @Nullable
            public JContainer<Resource> getResources() {
                return this.t.resources;
            }

            public Try withResources(@Nullable JContainer<Resource> resources) {
                return this.t.resources == resources ? this.t : new Try(this.t.id, this.t.prefix, this.t.markers, resources, this.t.body, this.t.catches, this.t.finallie);
            }

            @Nullable
            public JLeftPadded<Block> getFinally() {
                return this.t.finallie;
            }

            public Try withFinally(@Nullable JLeftPadded<Block> finallie) {
                return this.t.finallie == finallie ? this.t : new Try(this.t.id, this.t.prefix, this.t.markers, this.t.resources, this.t.body, this.t.catches, finallie);
            }

            public Padding(Try t) {
                this.t = t;
            }
        }

        public static final class Catch
        implements J {
            private final UUID id;
            private final Space prefix;
            private final Markers markers;
            private final ControlParentheses<VariableDeclarations> parameter;
            private final Block body;

            @Override
            public <P> J acceptJava(JavaVisitor<P> v, P p) {
                return v.visitCatch(this, p);
            }

            @Override
            public Coordinates.Try.Catch getCoordinates() {
                return new Coordinates.Try.Catch(this);
            }

            public boolean equals(@Nullable Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Catch)) {
                    return false;
                }
                Catch other = (Catch)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            public Catch(UUID id, Space prefix, Markers markers, ControlParentheses<VariableDeclarations> parameter, Block body) {
                this.id = id;
                this.prefix = prefix;
                this.markers = markers;
                this.parameter = parameter;
                this.body = body;
            }

            public UUID getId() {
                return this.id;
            }

            @Override
            public Space getPrefix() {
                return this.prefix;
            }

            public Markers getMarkers() {
                return this.markers;
            }

            public ControlParentheses<VariableDeclarations> getParameter() {
                return this.parameter;
            }

            public Block getBody() {
                return this.body;
            }

            @NonNull
            public String toString() {
                return "J.Try.Catch(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", parameter=" + this.getParameter() + ", body=" + this.getBody() + ")";
            }

            @NonNull
            public Catch withPrefix(Space prefix) {
                return this.prefix == prefix ? this : new Catch(this.id, prefix, this.markers, this.parameter, this.body);
            }

            @NonNull
            public Catch withMarkers(Markers markers) {
                return this.markers == markers ? this : new Catch(this.id, this.prefix, markers, this.parameter, this.body);
            }

            @NonNull
            public Catch withParameter(ControlParentheses<VariableDeclarations> parameter) {
                return this.parameter == parameter ? this : new Catch(this.id, this.prefix, this.markers, parameter, this.body);
            }

            @NonNull
            public Catch withBody(Block body) {
                return this.body == body ? this : new Catch(this.id, this.prefix, this.markers, this.parameter, body);
            }
        }

        public static final class Resource
        implements J {
            private final UUID id;
            private final Space prefix;
            private final Markers markers;
            private final VariableDeclarations variableDeclarations;
            private final boolean terminatedWithSemicolon;

            @Override
            public Coordinates.Try.Resource getCoordinates() {
                return new Coordinates.Try.Resource(this);
            }

            public boolean equals(@Nullable Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Resource)) {
                    return false;
                }
                Resource other = (Resource)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            public Resource(UUID id, Space prefix, Markers markers, VariableDeclarations variableDeclarations, boolean terminatedWithSemicolon) {
                this.id = id;
                this.prefix = prefix;
                this.markers = markers;
                this.variableDeclarations = variableDeclarations;
                this.terminatedWithSemicolon = terminatedWithSemicolon;
            }

            public UUID getId() {
                return this.id;
            }

            @Override
            public Space getPrefix() {
                return this.prefix;
            }

            public Markers getMarkers() {
                return this.markers;
            }

            public VariableDeclarations getVariableDeclarations() {
                return this.variableDeclarations;
            }

            public boolean isTerminatedWithSemicolon() {
                return this.terminatedWithSemicolon;
            }

            @NonNull
            public String toString() {
                return "J.Try.Resource(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", variableDeclarations=" + this.getVariableDeclarations() + ", terminatedWithSemicolon=" + this.isTerminatedWithSemicolon() + ")";
            }

            @NonNull
            public Resource withPrefix(Space prefix) {
                return this.prefix == prefix ? this : new Resource(this.id, prefix, this.markers, this.variableDeclarations, this.terminatedWithSemicolon);
            }

            @NonNull
            public Resource withMarkers(Markers markers) {
                return this.markers == markers ? this : new Resource(this.id, this.prefix, markers, this.variableDeclarations, this.terminatedWithSemicolon);
            }

            @NonNull
            public Resource withVariableDeclarations(VariableDeclarations variableDeclarations) {
                return this.variableDeclarations == variableDeclarations ? this : new Resource(this.id, this.prefix, this.markers, variableDeclarations, this.terminatedWithSemicolon);
            }

            @NonNull
            public Resource withTerminatedWithSemicolon(boolean terminatedWithSemicolon) {
                return this.terminatedWithSemicolon == terminatedWithSemicolon ? this : new Resource(this.id, this.prefix, this.markers, this.variableDeclarations, terminatedWithSemicolon);
            }
        }
    }

    public static final class Throw
    implements J,
    Statement {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Expression exception;

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitThrow(this, p);
        }

        @Override
        public Coordinates.Throw getCoordinates() {
            return new Coordinates.Throw(this);
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Throw)) {
                return false;
            }
            Throw other = (Throw)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Throw(UUID id, Space prefix, Markers markers, Expression exception) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.exception = exception;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Expression getException() {
            return this.exception;
        }

        @NonNull
        public String toString() {
            return "J.Throw(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", exception=" + this.getException() + ")";
        }

        @NonNull
        public Throw withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Throw(this.id, prefix, this.markers, this.exception);
        }

        @NonNull
        public Throw withMarkers(Markers markers) {
            return this.markers == markers ? this : new Throw(this.id, this.prefix, markers, this.exception);
        }

        @NonNull
        public Throw withException(Expression exception) {
            return this.exception == exception ? this : new Throw(this.id, this.prefix, this.markers, exception);
        }
    }

    public static final class Ternary
    implements J,
    Expression {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Expression condition;
        private final JLeftPadded<Expression> truePart;
        private final JLeftPadded<Expression> falsePart;
        @Nullable
        private final JavaType type;

        public Expression getTruePart() {
            return this.truePart.getElement();
        }

        public Ternary withTruePart(Expression truePart) {
            return this.getPadding().withTruePart(this.truePart.withElement(truePart));
        }

        public Expression getFalsePart() {
            return this.falsePart.getElement();
        }

        public Ternary withFalsePart(Expression falsePart) {
            return this.getPadding().withFalsePart(this.falsePart.withElement(falsePart));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitTernary(this, p);
        }

        @Override
        public Coordinates.Ternary getCoordinates() {
            return new Coordinates.Ternary(this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @NonNull
        public String toString() {
            return "J.Ternary(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", condition=" + this.getCondition() + ", truePart=" + this.getTruePart() + ", falsePart=" + this.getFalsePart() + ", type=" + this.getType() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Ternary)) {
                return false;
            }
            Ternary other = (Ternary)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Ternary(UUID id, Space prefix, Markers markers, Expression condition, JLeftPadded<Expression> truePart, JLeftPadded<Expression> falsePart, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.condition = condition;
            this.truePart = truePart;
            this.falsePart = falsePart;
            this.type = type;
        }

        private Ternary(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Expression condition, JLeftPadded<Expression> truePart, JLeftPadded<Expression> falsePart, @Nullable JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.condition = condition;
            this.truePart = truePart;
            this.falsePart = falsePart;
            this.type = type;
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public Ternary withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Ternary(this.padding, this.id, prefix, this.markers, this.condition, this.truePart, this.falsePart, this.type);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public Ternary withMarkers(Markers markers) {
            return this.markers == markers ? this : new Ternary(this.padding, this.id, this.prefix, markers, this.condition, this.truePart, this.falsePart, this.type);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public Ternary withCondition(Expression condition) {
            return this.condition == condition ? this : new Ternary(this.padding, this.id, this.prefix, this.markers, condition, this.truePart, this.falsePart, this.type);
        }

        public Expression getCondition() {
            return this.condition;
        }

        @NonNull
        public Ternary withType(@Nullable JavaType type) {
            return this.type == type ? this : new Ternary(this.padding, this.id, this.prefix, this.markers, this.condition, this.truePart, this.falsePart, type);
        }

        @Override
        @Nullable
        public JavaType getType() {
            return this.type;
        }

        public static class Padding {
            private final Ternary t;

            public JLeftPadded<Expression> getTruePart() {
                return this.t.truePart;
            }

            public Ternary withTruePart(JLeftPadded<Expression> truePart) {
                return this.t.truePart == truePart ? this.t : new Ternary(this.t.id, this.t.prefix, this.t.markers, this.t.condition, truePart, this.t.falsePart, this.t.type);
            }

            public JLeftPadded<Expression> getFalsePart() {
                return this.t.falsePart;
            }

            public Ternary withFalsePart(JLeftPadded<Expression> falsePart) {
                return this.t.falsePart == falsePart ? this.t : new Ternary(this.t.id, this.t.prefix, this.t.markers, this.t.condition, this.t.truePart, falsePart, this.t.type);
            }

            public Padding(Ternary t) {
                this.t = t;
            }
        }
    }

    public static final class Synchronized
    implements J,
    Statement {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final ControlParentheses<Expression> lock;
        private final Block body;

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitSynchronized(this, p);
        }

        @Override
        public Coordinates.Synchronized getCoordinates() {
            return new Coordinates.Synchronized(this);
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Synchronized)) {
                return false;
            }
            Synchronized other = (Synchronized)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Synchronized(UUID id, Space prefix, Markers markers, ControlParentheses<Expression> lock, Block body) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.lock = lock;
            this.body = body;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public ControlParentheses<Expression> getLock() {
            return this.lock;
        }

        public Block getBody() {
            return this.body;
        }

        @NonNull
        public String toString() {
            return "J.Synchronized(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", lock=" + this.getLock() + ", body=" + this.getBody() + ")";
        }

        @NonNull
        public Synchronized withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Synchronized(this.id, prefix, this.markers, this.lock, this.body);
        }

        @NonNull
        public Synchronized withMarkers(Markers markers) {
            return this.markers == markers ? this : new Synchronized(this.id, this.prefix, markers, this.lock, this.body);
        }

        @NonNull
        public Synchronized withLock(ControlParentheses<Expression> lock) {
            return this.lock == lock ? this : new Synchronized(this.id, this.prefix, this.markers, lock, this.body);
        }

        @NonNull
        public Synchronized withBody(Block body) {
            return this.body == body ? this : new Synchronized(this.id, this.prefix, this.markers, this.lock, body);
        }
    }

    public static final class Switch
    implements J,
    Statement {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final ControlParentheses<Expression> selector;
        private final Block cases;

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitSwitch(this, p);
        }

        @Override
        public Coordinates.Switch getCoordinates() {
            return new Coordinates.Switch(this);
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Switch)) {
                return false;
            }
            Switch other = (Switch)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Switch(UUID id, Space prefix, Markers markers, ControlParentheses<Expression> selector, Block cases) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.selector = selector;
            this.cases = cases;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public ControlParentheses<Expression> getSelector() {
            return this.selector;
        }

        public Block getCases() {
            return this.cases;
        }

        @NonNull
        public String toString() {
            return "J.Switch(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", selector=" + this.getSelector() + ", cases=" + this.getCases() + ")";
        }

        @NonNull
        public Switch withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Switch(this.id, prefix, this.markers, this.selector, this.cases);
        }

        @NonNull
        public Switch withMarkers(Markers markers) {
            return this.markers == markers ? this : new Switch(this.id, this.prefix, markers, this.selector, this.cases);
        }

        @NonNull
        public Switch withSelector(ControlParentheses<Expression> selector) {
            return this.selector == selector ? this : new Switch(this.id, this.prefix, this.markers, selector, this.cases);
        }

        @NonNull
        public Switch withCases(Block cases) {
            return this.cases == cases ? this : new Switch(this.id, this.prefix, this.markers, this.selector, cases);
        }
    }

    public static final class Return
    implements J,
    Statement {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        @Nullable
        private final Expression expression;

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitReturn(this, p);
        }

        @Override
        public Coordinates.Return getCoordinates() {
            return new Coordinates.Return(this);
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Return)) {
                return false;
            }
            Return other = (Return)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Return(UUID id, Space prefix, Markers markers, @Nullable Expression expression) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.expression = expression;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @Nullable
        public Expression getExpression() {
            return this.expression;
        }

        @NonNull
        public String toString() {
            return "J.Return(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", expression=" + this.getExpression() + ")";
        }

        @NonNull
        public Return withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Return(this.id, prefix, this.markers, this.expression);
        }

        @NonNull
        public Return withMarkers(Markers markers) {
            return this.markers == markers ? this : new Return(this.id, this.prefix, markers, this.expression);
        }

        @NonNull
        public Return withExpression(@Nullable Expression expression) {
            return this.expression == expression ? this : new Return(this.id, this.prefix, this.markers, expression);
        }
    }

    public static final class Primitive
    implements J,
    TypeTree,
    Expression {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JavaType.Primitive type;

        public Primitive withType(@Nullable JavaType type) {
            if (type == this.type) {
                return this;
            }
            if (!(type instanceof JavaType.Primitive)) {
                throw new IllegalArgumentException("Cannot apply a non-primitive type to Primitive");
            }
            return new Primitive(this.id, this.prefix, this.markers, (JavaType.Primitive)type);
        }

        @Override
        @NonNull
        public JavaType.Primitive getType() {
            return this.type;
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitPrimitive(this, p);
        }

        @Override
        public Coordinates.Primitive getCoordinates() {
            return new Coordinates.Primitive(this);
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Primitive)) {
                return false;
            }
            Primitive other = (Primitive)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Primitive(UUID id, Space prefix, Markers markers, JavaType.Primitive type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.type = type;
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public Primitive withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Primitive(this.id, prefix, this.markers, this.type);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public Primitive withMarkers(Markers markers) {
            return this.markers == markers ? this : new Primitive(this.id, this.prefix, markers, this.type);
        }

        public Markers getMarkers() {
            return this.markers;
        }
    }

    public static final class ControlParentheses<J2 extends J>
    implements J,
    Expression {
        @Nullable
        private transient WeakReference<Padding<J2>> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JRightPadded<J2> tree;

        public J2 getTree() {
            return (J2)((J)this.tree.getElement());
        }

        public ControlParentheses<J2> withTree(J2 tree) {
            return this.getPadding().withTree(this.tree.withElement(tree));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitControlParentheses(this, p);
        }

        @Override
        public Coordinates.ControlParentheses getCoordinates() {
            return new Coordinates.ControlParentheses(this);
        }

        @Override
        public List<Tree> getSideEffects() {
            return this.tree instanceof Expression ? ((Expression)((Object)this.tree)).getSideEffects() : Collections.emptyList();
        }

        @Override
        public JavaType getType() {
            return this.tree instanceof Expression ? ((Expression)((Object)this.tree)).getType() : (this.tree instanceof NameTree ? ((NameTree)((Object)this.tree)).getType() : null);
        }

        public ControlParentheses<J2> withType(@Nullable JavaType type) {
            return this.tree instanceof Expression ? (ControlParentheses)((Expression)((Object)this.tree)).withType(type) : (this.tree instanceof NameTree ? (ControlParentheses)((NameTree)((Object)this.tree)).withType(type) : this);
        }

        public Padding<J2> getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference(p);
                }
            }
            return p;
        }

        @NonNull
        public String toString() {
            return "J.ControlParentheses(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", tree=" + this.getTree() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ControlParentheses)) {
                return false;
            }
            ControlParentheses other = (ControlParentheses)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public ControlParentheses(UUID id, Space prefix, Markers markers, JRightPadded<J2> tree) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.tree = tree;
        }

        private ControlParentheses(@Nullable WeakReference<Padding<J2>> padding, UUID id, Space prefix, Markers markers, JRightPadded<J2> tree) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.tree = tree;
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public ControlParentheses<J2> withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ControlParentheses<J2>(this.padding, this.id, prefix, this.markers, this.tree);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public ControlParentheses<J2> withMarkers(Markers markers) {
            return this.markers == markers ? this : new ControlParentheses<J2>(this.padding, this.id, this.prefix, markers, this.tree);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public static class Padding<J2 extends J> {
            private final ControlParentheses<J2> t;

            public JRightPadded<J2> getTree() {
                return ((ControlParentheses)this.t).tree;
            }

            public ControlParentheses<J2> withTree(JRightPadded<J2> tree) {
                return ((ControlParentheses)this.t).tree == tree ? this.t : new ControlParentheses<J2>(((ControlParentheses)this.t).id, ((ControlParentheses)this.t).prefix, ((ControlParentheses)this.t).markers, tree);
            }

            public Padding(ControlParentheses<J2> t) {
                this.t = t;
            }
        }
    }

    public static class Parentheses<J2 extends J>
    implements J,
    Expression {
        @Nullable
        private transient WeakReference<Padding<J2>> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JRightPadded<J2> tree;

        public J2 getTree() {
            return (J2)((J)this.tree.getElement());
        }

        public Parentheses<J2> withTree(J2 tree) {
            return this.getPadding().withTree(this.tree.withElement(tree));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitParentheses(this, p);
        }

        @Override
        public Coordinates.Parentheses getCoordinates() {
            return new Coordinates.Parentheses(this);
        }

        @Override
        public List<Tree> getSideEffects() {
            return this.tree instanceof Expression ? ((Expression)((Object)this.tree)).getSideEffects() : Collections.emptyList();
        }

        @Override
        public JavaType getType() {
            return this.tree instanceof Expression ? ((Expression)((Object)this.tree)).getType() : (this.tree instanceof NameTree ? ((NameTree)((Object)this.tree)).getType() : null);
        }

        public Parentheses<J2> withType(@Nullable JavaType type) {
            return this.tree instanceof Expression ? (Parentheses)((Expression)((Object)this.tree)).withType(type) : (this.tree instanceof NameTree ? (Parentheses)((NameTree)((Object)this.tree)).withType(type) : this);
        }

        public Padding<J2> getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference(p);
                }
            }
            return p;
        }

        @NonNull
        public String toString() {
            return "J.Parentheses(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", tree=" + this.getTree() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Parentheses)) {
                return false;
            }
            Parentheses other = (Parentheses)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Parentheses;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Parentheses(UUID id, Space prefix, Markers markers, JRightPadded<J2> tree) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.tree = tree;
        }

        private Parentheses(@Nullable WeakReference<Padding<J2>> padding, UUID id, Space prefix, Markers markers, JRightPadded<J2> tree) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.tree = tree;
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public Parentheses<J2> withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Parentheses<J2>(this.padding, this.id, prefix, this.markers, this.tree);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public Parentheses<J2> withMarkers(Markers markers) {
            return this.markers == markers ? this : new Parentheses<J2>(this.padding, this.id, this.prefix, markers, this.tree);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public static class Padding<J2 extends J> {
            private final Parentheses<J2> t;

            public JRightPadded<J2> getTree() {
                return ((Parentheses)this.t).tree;
            }

            public Parentheses<J2> withTree(JRightPadded<J2> tree) {
                return ((Parentheses)this.t).tree == tree ? this.t : new Parentheses<J2>(((Parentheses)this.t).id, ((Parentheses)this.t).prefix, ((Parentheses)this.t).markers, tree);
            }

            public Padding(Parentheses<J2> t) {
                this.t = t;
            }
        }
    }

    public static final class ParameterizedType
    implements J,
    TypeTree,
    Expression {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final NameTree clazz;
        @Nullable
        private final JContainer<Expression> typeParameters;

        @Nullable
        public List<Expression> getTypeParameters() {
            return this.typeParameters == null ? null : this.typeParameters.getElements();
        }

        public ParameterizedType withTypeParameters(@Nullable List<Expression> typeParameters) {
            return this.getPadding().withTypeParameters(JContainer.withElementsNullable(this.typeParameters, typeParameters));
        }

        @Override
        public JavaType getType() {
            return this.clazz.getType();
        }

        public ParameterizedType withType(@Nullable JavaType type) {
            if (type == this.clazz.getType()) {
                return this;
            }
            return this.withClazz((NameTree)this.clazz.withType(type));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitParameterizedType(this, p);
        }

        @Override
        public Coordinates.ParameterizedType getCoordinates() {
            return new Coordinates.ParameterizedType(this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @NonNull
        public String toString() {
            return "J.ParameterizedType(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", clazz=" + this.getClazz() + ", typeParameters=" + this.getTypeParameters() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParameterizedType)) {
                return false;
            }
            ParameterizedType other = (ParameterizedType)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public ParameterizedType(UUID id, Space prefix, Markers markers, NameTree clazz, @Nullable JContainer<Expression> typeParameters) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.clazz = clazz;
            this.typeParameters = typeParameters;
        }

        private ParameterizedType(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, NameTree clazz, @Nullable JContainer<Expression> typeParameters) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.clazz = clazz;
            this.typeParameters = typeParameters;
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public ParameterizedType withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ParameterizedType(this.padding, this.id, prefix, this.markers, this.clazz, this.typeParameters);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public ParameterizedType withMarkers(Markers markers) {
            return this.markers == markers ? this : new ParameterizedType(this.padding, this.id, this.prefix, markers, this.clazz, this.typeParameters);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public ParameterizedType withClazz(NameTree clazz) {
            return this.clazz == clazz ? this : new ParameterizedType(this.padding, this.id, this.prefix, this.markers, clazz, this.typeParameters);
        }

        public NameTree getClazz() {
            return this.clazz;
        }

        public static class Padding {
            private final ParameterizedType t;

            @Nullable
            public JContainer<Expression> getTypeParameters() {
                return this.t.typeParameters;
            }

            public ParameterizedType withTypeParameters(@Nullable JContainer<Expression> typeParameters) {
                return this.t.typeParameters == typeParameters ? this.t : new ParameterizedType(this.t.id, this.t.prefix, this.t.markers, this.t.clazz, typeParameters);
            }

            public Padding(ParameterizedType t) {
                this.t = t;
            }
        }
    }

    public static final class Package
    implements J {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Expression expression;

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitPackage(this, p);
        }

        @Override
        public Coordinates.Package getCoordinates() {
            return new Coordinates.Package(this);
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Package)) {
                return false;
            }
            Package other = (Package)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Package(UUID id, Space prefix, Markers markers, Expression expression) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.expression = expression;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Expression getExpression() {
            return this.expression;
        }

        @NonNull
        public String toString() {
            return "J.Package(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", expression=" + this.getExpression() + ")";
        }

        @NonNull
        public Package withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Package(this.id, prefix, this.markers, this.expression);
        }

        @NonNull
        public Package withMarkers(Markers markers) {
            return this.markers == markers ? this : new Package(this.id, this.prefix, markers, this.expression);
        }

        @NonNull
        public Package withExpression(Expression expression) {
            return this.expression == expression ? this : new Package(this.id, this.prefix, this.markers, expression);
        }
    }

    public static final class NewClass
    implements J,
    Statement,
    Expression {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        @Nullable
        private final JRightPadded<Expression> enclosing;
        private final Space nooh;
        @Nullable
        private final TypeTree clazz;
        @Nullable
        private final JContainer<Expression> arguments;
        @Nullable
        private final Block body;
        @Nullable
        private final JavaType type;

        @Nullable
        public Expression getEnclosing() {
            return this.enclosing == null ? null : this.enclosing.getElement();
        }

        public NewClass withEnclosing(Expression enclosing) {
            return this.getPadding().withEnclosing(JRightPadded.withElement(this.enclosing, enclosing));
        }

        public Space getNew() {
            return this.nooh;
        }

        public NewClass withNew(Space nooh) {
            if (nooh == this.nooh) {
                return this;
            }
            return new NewClass(this.id, this.prefix, this.markers, this.enclosing, nooh, this.clazz, this.arguments, this.body, this.type);
        }

        @Nullable
        public JContainer<Expression> getArguments() {
            return this.arguments;
        }

        public NewClass withArguments(@Nullable List<Expression> arguments) {
            return this.getPadding().withArguments(JContainer.withElementsNullable(this.arguments, arguments));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitNewClass(this, p);
        }

        @Override
        public Coordinates.NewClass getCoordinates() {
            return new Coordinates.NewClass(this);
        }

        @Override
        public List<Tree> getSideEffects() {
            return Collections.singletonList(this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @NonNull
        public String toString() {
            return "J.NewClass(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", enclosing=" + this.getEnclosing() + ", nooh=" + this.nooh + ", clazz=" + this.getClazz() + ", arguments=" + this.getArguments() + ", body=" + this.getBody() + ", type=" + this.getType() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NewClass)) {
                return false;
            }
            NewClass other = (NewClass)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public NewClass(UUID id, Space prefix, Markers markers, @Nullable JRightPadded<Expression> enclosing, Space nooh, @Nullable TypeTree clazz, @Nullable JContainer<Expression> arguments, @Nullable Block body, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.enclosing = enclosing;
            this.nooh = nooh;
            this.clazz = clazz;
            this.arguments = arguments;
            this.body = body;
            this.type = type;
        }

        private NewClass(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, @Nullable JRightPadded<Expression> enclosing, Space nooh, @Nullable TypeTree clazz, @Nullable JContainer<Expression> arguments, @Nullable Block body, @Nullable JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.enclosing = enclosing;
            this.nooh = nooh;
            this.clazz = clazz;
            this.arguments = arguments;
            this.body = body;
            this.type = type;
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public NewClass withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new NewClass(this.padding, this.id, prefix, this.markers, this.enclosing, this.nooh, this.clazz, this.arguments, this.body, this.type);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public NewClass withMarkers(Markers markers) {
            return this.markers == markers ? this : new NewClass(this.padding, this.id, this.prefix, markers, this.enclosing, this.nooh, this.clazz, this.arguments, this.body, this.type);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public NewClass withClazz(@Nullable TypeTree clazz) {
            return this.clazz == clazz ? this : new NewClass(this.padding, this.id, this.prefix, this.markers, this.enclosing, this.nooh, clazz, this.arguments, this.body, this.type);
        }

        @Nullable
        public TypeTree getClazz() {
            return this.clazz;
        }

        @NonNull
        public NewClass withBody(@Nullable Block body) {
            return this.body == body ? this : new NewClass(this.padding, this.id, this.prefix, this.markers, this.enclosing, this.nooh, this.clazz, this.arguments, body, this.type);
        }

        @Nullable
        public Block getBody() {
            return this.body;
        }

        @NonNull
        public NewClass withType(@Nullable JavaType type) {
            return this.type == type ? this : new NewClass(this.padding, this.id, this.prefix, this.markers, this.enclosing, this.nooh, this.clazz, this.arguments, this.body, type);
        }

        @Override
        @Nullable
        public JavaType getType() {
            return this.type;
        }

        public static class Padding {
            private final NewClass t;

            @Nullable
            public JRightPadded<Expression> getEnclosing() {
                return this.t.enclosing;
            }

            public NewClass withEnclosing(@Nullable JRightPadded<Expression> enclosing) {
                return this.t.enclosing == enclosing ? this.t : new NewClass(this.t.id, this.t.prefix, this.t.markers, enclosing, this.t.nooh, this.t.clazz, this.t.arguments, this.t.body, this.t.type);
            }

            @Nullable
            public JContainer<Expression> getArguments() {
                return this.t.arguments;
            }

            public NewClass withArguments(@Nullable JContainer<Expression> arguments) {
                return this.t.arguments == arguments ? this.t : new NewClass(this.t.id, this.t.prefix, this.t.markers, this.t.enclosing, this.t.nooh, this.t.clazz, arguments, this.t.body, this.t.type);
            }

            public Padding(NewClass t) {
                this.t = t;
            }
        }
    }

    public static final class ArrayDimension
    implements J {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JRightPadded<Expression> index;

        public Expression getIndex() {
            return this.index.getElement();
        }

        public ArrayDimension withIndex(Expression index) {
            return this.getPadding().withIndex(this.index.withElement(index));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitArrayDimension(this, p);
        }

        @Override
        public Coordinates.ArrayDimension getCoordinates() {
            return new Coordinates.ArrayDimension(this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @NonNull
        public String toString() {
            return "J.ArrayDimension(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", index=" + this.getIndex() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ArrayDimension)) {
                return false;
            }
            ArrayDimension other = (ArrayDimension)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public ArrayDimension(UUID id, Space prefix, Markers markers, JRightPadded<Expression> index) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.index = index;
        }

        private ArrayDimension(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, JRightPadded<Expression> index) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.index = index;
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public ArrayDimension withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ArrayDimension(this.padding, this.id, prefix, this.markers, this.index);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public ArrayDimension withMarkers(Markers markers) {
            return this.markers == markers ? this : new ArrayDimension(this.padding, this.id, this.prefix, markers, this.index);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public static class Padding {
            private final ArrayDimension t;

            public JRightPadded<Expression> getIndex() {
                return this.t.index;
            }

            public ArrayDimension withIndex(JRightPadded<Expression> index) {
                return this.t.index == index ? this.t : new ArrayDimension(this.t.id, this.t.prefix, this.t.markers, index);
            }

            public Padding(ArrayDimension t) {
                this.t = t;
            }
        }
    }

    public static final class NewArray
    implements J,
    Expression {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        @Nullable
        private final TypeTree typeExpression;
        private final List<ArrayDimension> dimensions;
        @Nullable
        private final JContainer<Expression> initializer;
        @Nullable
        private final JavaType type;

        @Nullable
        public List<Expression> getInitializer() {
            return this.initializer == null ? null : this.initializer.getElements();
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitNewArray(this, p);
        }

        @Override
        public Coordinates.NewArray getCoordinates() {
            return new Coordinates.NewArray(this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @NonNull
        public String toString() {
            return "J.NewArray(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", typeExpression=" + this.getTypeExpression() + ", dimensions=" + this.getDimensions() + ", initializer=" + this.getInitializer() + ", type=" + this.getType() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NewArray)) {
                return false;
            }
            NewArray other = (NewArray)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public NewArray(UUID id, Space prefix, Markers markers, @Nullable TypeTree typeExpression, List<ArrayDimension> dimensions, @Nullable JContainer<Expression> initializer, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.typeExpression = typeExpression;
            this.dimensions = dimensions;
            this.initializer = initializer;
            this.type = type;
        }

        private NewArray(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, @Nullable TypeTree typeExpression, List<ArrayDimension> dimensions, @Nullable JContainer<Expression> initializer, @Nullable JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.typeExpression = typeExpression;
            this.dimensions = dimensions;
            this.initializer = initializer;
            this.type = type;
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public NewArray withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new NewArray(this.padding, this.id, prefix, this.markers, this.typeExpression, this.dimensions, this.initializer, this.type);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public NewArray withMarkers(Markers markers) {
            return this.markers == markers ? this : new NewArray(this.padding, this.id, this.prefix, markers, this.typeExpression, this.dimensions, this.initializer, this.type);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public NewArray withTypeExpression(@Nullable TypeTree typeExpression) {
            return this.typeExpression == typeExpression ? this : new NewArray(this.padding, this.id, this.prefix, this.markers, typeExpression, this.dimensions, this.initializer, this.type);
        }

        @Nullable
        public TypeTree getTypeExpression() {
            return this.typeExpression;
        }

        @NonNull
        public NewArray withDimensions(List<ArrayDimension> dimensions) {
            return this.dimensions == dimensions ? this : new NewArray(this.padding, this.id, this.prefix, this.markers, this.typeExpression, dimensions, this.initializer, this.type);
        }

        public List<ArrayDimension> getDimensions() {
            return this.dimensions;
        }

        @NonNull
        public NewArray withType(@Nullable JavaType type) {
            return this.type == type ? this : new NewArray(this.padding, this.id, this.prefix, this.markers, this.typeExpression, this.dimensions, this.initializer, type);
        }

        @Override
        @Nullable
        public JavaType getType() {
            return this.type;
        }

        public static class Padding {
            private final NewArray t;

            @Nullable
            public JContainer<Expression> getInitializer() {
                return this.t.initializer;
            }

            public NewArray withInitializer(@Nullable JContainer<Expression> initializer) {
                return this.t.initializer == initializer ? this.t : new NewArray(this.t.id, this.t.prefix, this.t.markers, this.t.typeExpression, this.t.dimensions, initializer, this.t.type);
            }

            public Padding(NewArray t) {
                this.t = t;
            }
        }
    }

    public static final class MultiCatch
    implements J,
    TypeTree {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final List<JRightPadded<NameTree>> alternatives;

        public List<NameTree> getAlternatives() {
            return JRightPadded.getElements(this.alternatives);
        }

        public MultiCatch withAlternatives(List<NameTree> alternatives) {
            return this.getPadding().withAlternatives(JRightPadded.withElements(this.alternatives, alternatives));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitMultiCatch(this, p);
        }

        @Override
        public Coordinates.MultiCatch getCoordinates() {
            return new Coordinates.MultiCatch(this);
        }

        public MultiCatch withType(@Nullable JavaType type) {
            return this;
        }

        @Override
        public JavaType getType() {
            return new JavaType.MultiCatch(this.alternatives.stream().filter(Objects::nonNull).map(alt -> ((NameTree)alt.getElement()).getType()).collect(Collectors.toList()));
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @NonNull
        public String toString() {
            return "J.MultiCatch(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", alternatives=" + this.getAlternatives() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MultiCatch)) {
                return false;
            }
            MultiCatch other = (MultiCatch)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public MultiCatch(UUID id, Space prefix, Markers markers, List<JRightPadded<NameTree>> alternatives) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.alternatives = alternatives;
        }

        private MultiCatch(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, List<JRightPadded<NameTree>> alternatives) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.alternatives = alternatives;
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public MultiCatch withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new MultiCatch(this.padding, this.id, prefix, this.markers, this.alternatives);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public MultiCatch withMarkers(Markers markers) {
            return this.markers == markers ? this : new MultiCatch(this.padding, this.id, this.prefix, markers, this.alternatives);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public static class Padding {
            private final MultiCatch t;

            public List<JRightPadded<NameTree>> getAlternatives() {
                return this.t.alternatives;
            }

            public MultiCatch withAlternatives(List<JRightPadded<NameTree>> alternatives) {
                return this.t.alternatives == alternatives ? this.t : new MultiCatch(this.t.id, this.t.prefix, this.t.markers, alternatives);
            }

            public Padding(MultiCatch t) {
                this.t = t;
            }
        }
    }

    public static final class Modifier
    implements J {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Type type;

        public static boolean hasModifier(Collection<Modifier> modifiers, Type modifier) {
            return modifiers.stream().anyMatch(m -> m.getType() == modifier);
        }

        @Override
        public Coordinates.Modifier getCoordinates() {
            return new Coordinates.Modifier(this);
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Modifier)) {
                return false;
            }
            Modifier other = (Modifier)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Modifier(UUID id, Space prefix, Markers markers, Type type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.type = type;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Type getType() {
            return this.type;
        }

        @NonNull
        public String toString() {
            return "J.Modifier(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", type=" + (Object)((Object)this.getType()) + ")";
        }

        @NonNull
        public Modifier withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Modifier(this.id, prefix, this.markers, this.type);
        }

        @NonNull
        public Modifier withMarkers(Markers markers) {
            return this.markers == markers ? this : new Modifier(this.id, this.prefix, markers, this.type);
        }

        @NonNull
        public Modifier withType(Type type) {
            return this.type == type ? this : new Modifier(this.id, this.prefix, this.markers, type);
        }

        public static enum Type {
            Default,
            Public,
            Protected,
            Private,
            Abstract,
            Static,
            Final,
            Native,
            Strictfp,
            Synchronized,
            Transient,
            Volatile;

        }
    }

    public static final class MethodInvocation
    implements J,
    Statement,
    Expression {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        @Nullable
        private final JRightPadded<Expression> select;
        @Nullable
        private final JContainer<Expression> typeParameters;
        private final Identifier name;
        private final JContainer<Expression> arguments;
        @Nullable
        private final JavaType.Method type;

        @Nullable
        public Expression getSelect() {
            return this.select == null ? null : this.select.getElement();
        }

        public MethodInvocation withSelect(@Nullable Expression select) {
            return this.getPadding().withSelect(JRightPadded.withElement(this.select, select));
        }

        @Nullable
        public List<Expression> getTypeParameters() {
            return this.typeParameters == null ? null : this.typeParameters.getElements();
        }

        public List<Expression> getArguments() {
            return this.arguments.getElements();
        }

        public MethodInvocation withArguments(List<Expression> arguments) {
            return this.getPadding().withArguments(JContainer.withElements(this.arguments, arguments));
        }

        public MethodInvocation withType(@Nullable JavaType type) {
            if (type == this.type) {
                return this;
            }
            if (type instanceof JavaType.Method) {
                return new MethodInvocation(this.id, this.prefix, this.markers, this.select, this.typeParameters, this.name, this.arguments, (JavaType.Method)type);
            }
            return this;
        }

        public MethodInvocation withDeclaringType(JavaType.FullyQualified type) {
            if (this.type == null) {
                return this;
            }
            return this.withType(this.type.withDeclaringType(type));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitMethodInvocation(this, p);
        }

        @Override
        public Coordinates.MethodInvocation getCoordinates() {
            return new Coordinates.MethodInvocation(this);
        }

        @Nullable
        public JavaType getReturnType() {
            return this.type == null ? null : (this.type.getResolvedSignature() == null ? null : this.type.getResolvedSignature().getReturnType());
        }

        public String getSimpleName() {
            return this.name.getSimpleName();
        }

        @Override
        public List<Tree> getSideEffects() {
            return Collections.singletonList(this);
        }

        public String toString() {
            return "MethodInvocation(" + MethodInvocationToString.toString(this) + ")";
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MethodInvocation)) {
                return false;
            }
            MethodInvocation other = (MethodInvocation)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public MethodInvocation(UUID id, Space prefix, Markers markers, @Nullable JRightPadded<Expression> select, @Nullable JContainer<Expression> typeParameters, Identifier name, JContainer<Expression> arguments, @Nullable JavaType.Method type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.select = select;
            this.typeParameters = typeParameters;
            this.name = name;
            this.arguments = arguments;
            this.type = type;
        }

        private MethodInvocation(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, @Nullable JRightPadded<Expression> select, @Nullable JContainer<Expression> typeParameters, Identifier name, JContainer<Expression> arguments, @Nullable JavaType.Method type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.select = select;
            this.typeParameters = typeParameters;
            this.name = name;
            this.arguments = arguments;
            this.type = type;
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public MethodInvocation withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new MethodInvocation(this.padding, this.id, prefix, this.markers, this.select, this.typeParameters, this.name, this.arguments, this.type);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public MethodInvocation withMarkers(Markers markers) {
            return this.markers == markers ? this : new MethodInvocation(this.padding, this.id, this.prefix, markers, this.select, this.typeParameters, this.name, this.arguments, this.type);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public MethodInvocation withName(Identifier name) {
            return this.name == name ? this : new MethodInvocation(this.padding, this.id, this.prefix, this.markers, this.select, this.typeParameters, name, this.arguments, this.type);
        }

        public Identifier getName() {
            return this.name;
        }

        @Override
        @Nullable
        public JavaType.Method getType() {
            return this.type;
        }

        public static class Padding {
            private final MethodInvocation t;

            @Nullable
            public JRightPadded<Expression> getSelect() {
                return this.t.select;
            }

            public MethodInvocation withSelect(@Nullable JRightPadded<Expression> select) {
                return this.t.select == select ? this.t : new MethodInvocation(this.t.id, this.t.prefix, this.t.markers, select, this.t.typeParameters, this.t.name, this.t.arguments, this.t.type);
            }

            @Nullable
            public JContainer<Expression> getTypeParameters() {
                return this.t.typeParameters;
            }

            public MethodInvocation withTypeParameters(@Nullable JContainer<Expression> typeParameters) {
                return this.t.typeParameters == typeParameters ? this.t : new MethodInvocation(this.t.id, this.t.prefix, this.t.markers, this.t.select, typeParameters, this.t.name, this.t.arguments, this.t.type);
            }

            public JContainer<Expression> getArguments() {
                return this.t.arguments;
            }

            public MethodInvocation withArguments(JContainer<Expression> arguments) {
                return this.t.arguments == arguments ? this.t : new MethodInvocation(this.t.id, this.t.prefix, this.t.markers, this.t.select, this.t.typeParameters, this.t.name, arguments, this.t.type);
            }

            public Padding(MethodInvocation t) {
                this.t = t;
            }
        }
    }

    public static final class MethodDeclaration
    implements J,
    Statement {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final List<Annotation> annotations;
        private final List<Modifier> modifiers;
        @Nullable
        private final JContainer<TypeParameter> typeParameters;
        @Nullable
        private final TypeTree returnTypeExpression;
        private final Identifier name;
        private final JContainer<Statement> parameters;
        @Nullable
        private final JContainer<NameTree> throwz;
        @Nullable
        private final Block body;
        @Nullable
        private final JLeftPadded<Expression> defaultValue;
        @Nullable
        private final JavaType.Method type;

        @Nullable
        public List<TypeParameter> getTypeParameters() {
            return this.typeParameters == null ? null : this.typeParameters.getElements();
        }

        public MethodDeclaration withTypeParameters(@Nullable List<TypeParameter> typeParameters) {
            return this.getPadding().withTypeParameters(JContainer.withElementsNullable(this.typeParameters, typeParameters));
        }

        public List<Statement> getParameters() {
            return this.parameters.getElements();
        }

        public MethodDeclaration withParameters(List<Statement> parameters) {
            return this.getPadding().withParameters(JContainer.withElements(this.parameters, parameters));
        }

        @Nullable
        public List<NameTree> getThrows() {
            return this.throwz == null ? null : this.throwz.getElements();
        }

        public MethodDeclaration withThrows(@Nullable List<NameTree> throwz) {
            return this.getPadding().withThrows(JContainer.withElementsNullable(this.throwz, throwz));
        }

        @Nullable
        public Expression getDefaultValue() {
            return this.defaultValue == null ? null : this.defaultValue.getElement();
        }

        public MethodDeclaration withDefaultValue(@Nullable Expression defaultValue) {
            return this.getPadding().withDefaultValue(JLeftPadded.withElement(this.defaultValue, defaultValue));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitMethodDeclaration(this, p);
        }

        public boolean isAbstract() {
            return this.body == null;
        }

        public boolean isConstructor() {
            return this.getReturnTypeExpression() == null;
        }

        public String getSimpleName() {
            return this.name.getSimpleName();
        }

        public boolean hasModifier(Modifier.Type modifier) {
            return Modifier.hasModifier(this.getModifiers(), modifier);
        }

        public String toString() {
            return "MethodDeclaration(" + MethodDeclarationToString.toString(this) + ")";
        }

        @Override
        public Coordinates.MethodDeclaration getCoordinates() {
            return new Coordinates.MethodDeclaration(this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MethodDeclaration)) {
                return false;
            }
            MethodDeclaration other = (MethodDeclaration)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public MethodDeclaration(UUID id, Space prefix, Markers markers, List<Annotation> annotations, List<Modifier> modifiers, @Nullable JContainer<TypeParameter> typeParameters, @Nullable TypeTree returnTypeExpression, Identifier name, JContainer<Statement> parameters, @Nullable JContainer<NameTree> throwz, @Nullable Block body, @Nullable JLeftPadded<Expression> defaultValue, @Nullable JavaType.Method type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.annotations = annotations;
            this.modifiers = modifiers;
            this.typeParameters = typeParameters;
            this.returnTypeExpression = returnTypeExpression;
            this.name = name;
            this.parameters = parameters;
            this.throwz = throwz;
            this.body = body;
            this.defaultValue = defaultValue;
            this.type = type;
        }

        private MethodDeclaration(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, List<Annotation> annotations, List<Modifier> modifiers, @Nullable JContainer<TypeParameter> typeParameters, @Nullable TypeTree returnTypeExpression, Identifier name, JContainer<Statement> parameters, @Nullable JContainer<NameTree> throwz, @Nullable Block body, @Nullable JLeftPadded<Expression> defaultValue, @Nullable JavaType.Method type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.annotations = annotations;
            this.modifiers = modifiers;
            this.typeParameters = typeParameters;
            this.returnTypeExpression = returnTypeExpression;
            this.name = name;
            this.parameters = parameters;
            this.throwz = throwz;
            this.body = body;
            this.defaultValue = defaultValue;
            this.type = type;
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public MethodDeclaration withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new MethodDeclaration(this.padding, this.id, prefix, this.markers, this.annotations, this.modifiers, this.typeParameters, this.returnTypeExpression, this.name, this.parameters, this.throwz, this.body, this.defaultValue, this.type);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public MethodDeclaration withMarkers(Markers markers) {
            return this.markers == markers ? this : new MethodDeclaration(this.padding, this.id, this.prefix, markers, this.annotations, this.modifiers, this.typeParameters, this.returnTypeExpression, this.name, this.parameters, this.throwz, this.body, this.defaultValue, this.type);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public MethodDeclaration withAnnotations(List<Annotation> annotations) {
            return this.annotations == annotations ? this : new MethodDeclaration(this.padding, this.id, this.prefix, this.markers, annotations, this.modifiers, this.typeParameters, this.returnTypeExpression, this.name, this.parameters, this.throwz, this.body, this.defaultValue, this.type);
        }

        public List<Annotation> getAnnotations() {
            return this.annotations;
        }

        @NonNull
        public MethodDeclaration withModifiers(List<Modifier> modifiers) {
            return this.modifiers == modifiers ? this : new MethodDeclaration(this.padding, this.id, this.prefix, this.markers, this.annotations, modifiers, this.typeParameters, this.returnTypeExpression, this.name, this.parameters, this.throwz, this.body, this.defaultValue, this.type);
        }

        public List<Modifier> getModifiers() {
            return this.modifiers;
        }

        @NonNull
        public MethodDeclaration withReturnTypeExpression(@Nullable TypeTree returnTypeExpression) {
            return this.returnTypeExpression == returnTypeExpression ? this : new MethodDeclaration(this.padding, this.id, this.prefix, this.markers, this.annotations, this.modifiers, this.typeParameters, returnTypeExpression, this.name, this.parameters, this.throwz, this.body, this.defaultValue, this.type);
        }

        @Nullable
        public TypeTree getReturnTypeExpression() {
            return this.returnTypeExpression;
        }

        @NonNull
        public MethodDeclaration withName(Identifier name) {
            return this.name == name ? this : new MethodDeclaration(this.padding, this.id, this.prefix, this.markers, this.annotations, this.modifiers, this.typeParameters, this.returnTypeExpression, name, this.parameters, this.throwz, this.body, this.defaultValue, this.type);
        }

        public Identifier getName() {
            return this.name;
        }

        @NonNull
        public MethodDeclaration withBody(@Nullable Block body) {
            return this.body == body ? this : new MethodDeclaration(this.padding, this.id, this.prefix, this.markers, this.annotations, this.modifiers, this.typeParameters, this.returnTypeExpression, this.name, this.parameters, this.throwz, body, this.defaultValue, this.type);
        }

        @Nullable
        public Block getBody() {
            return this.body;
        }

        @NonNull
        public MethodDeclaration withType(@Nullable JavaType.Method type) {
            return this.type == type ? this : new MethodDeclaration(this.padding, this.id, this.prefix, this.markers, this.annotations, this.modifiers, this.typeParameters, this.returnTypeExpression, this.name, this.parameters, this.throwz, this.body, this.defaultValue, type);
        }

        @Nullable
        public JavaType.Method getType() {
            return this.type;
        }

        public static class Padding {
            private final MethodDeclaration t;

            @Nullable
            public JContainer<TypeParameter> getTypeParameters() {
                return this.t.typeParameters;
            }

            public MethodDeclaration withTypeParameters(@Nullable JContainer<TypeParameter> typeParameters) {
                return this.t.typeParameters == typeParameters ? this.t : new MethodDeclaration(this.t.id, this.t.prefix, this.t.markers, this.t.annotations, this.t.modifiers, typeParameters, this.t.returnTypeExpression, this.t.name, this.t.parameters, this.t.throwz, this.t.body, this.t.defaultValue, this.t.type);
            }

            public JContainer<Statement> getParameters() {
                return this.t.parameters;
            }

            public MethodDeclaration withParameters(JContainer<Statement> parameters) {
                return this.t.parameters == parameters ? this.t : new MethodDeclaration(this.t.id, this.t.prefix, this.t.markers, this.t.annotations, this.t.modifiers, this.t.typeParameters, this.t.returnTypeExpression, this.t.name, parameters, this.t.throwz, this.t.body, this.t.defaultValue, this.t.type);
            }

            @Nullable
            public JContainer<NameTree> getThrows() {
                return this.t.throwz;
            }

            public MethodDeclaration withThrows(@Nullable JContainer<NameTree> throwz) {
                return this.t.throwz == throwz ? this.t : new MethodDeclaration(this.t.id, this.t.prefix, this.t.markers, this.t.annotations, this.t.modifiers, this.t.typeParameters, this.t.returnTypeExpression, this.t.name, this.t.parameters, throwz, this.t.body, this.t.defaultValue, this.t.type);
            }

            @Nullable
            public JLeftPadded<Expression> getDefaultValue() {
                return this.t.defaultValue;
            }

            public MethodDeclaration withDefaultValue(@Nullable JLeftPadded<Expression> defaultValue) {
                return this.t.defaultValue == defaultValue ? this.t : new MethodDeclaration(this.t.id, this.t.prefix, this.t.markers, this.t.annotations, this.t.modifiers, this.t.typeParameters, this.t.returnTypeExpression, this.t.name, this.t.parameters, this.t.throwz, this.t.body, defaultValue, this.t.type);
            }

            public Padding(MethodDeclaration t) {
                this.t = t;
            }
        }
    }

    public static final class MemberReference
    implements J,
    Expression {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Expression containing;
        @Nullable
        private final JContainer<Expression> typeParameters;
        private final JLeftPadded<Identifier> reference;
        @Nullable
        private final JavaType type;
        @Nullable
        private final JavaType referenceType;

        @Nullable
        public List<Expression> getTypeParameters() {
            return this.typeParameters == null ? null : this.typeParameters.getElements();
        }

        public MemberReference withTypeParameters(@Nullable List<Expression> typeParameters) {
            return this.getPadding().withTypeParameters(JContainer.withElementsNullable(this.typeParameters, typeParameters));
        }

        public Identifier getReference() {
            return this.reference.getElement();
        }

        public MemberReference withReference(Identifier reference) {
            return this.getPadding().withReference(this.reference.withElement(reference));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitMemberReference(this, p);
        }

        @Override
        public Coordinates.MemberReference getCoordinates() {
            return new Coordinates.MemberReference(this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @NonNull
        public String toString() {
            return "J.MemberReference(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", containing=" + this.getContaining() + ", typeParameters=" + this.getTypeParameters() + ", reference=" + this.getReference() + ", type=" + this.getType() + ", referenceType=" + this.getReferenceType() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MemberReference)) {
                return false;
            }
            MemberReference other = (MemberReference)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public MemberReference(UUID id, Space prefix, Markers markers, Expression containing, @Nullable JContainer<Expression> typeParameters, JLeftPadded<Identifier> reference, @Nullable JavaType type, @Nullable JavaType referenceType) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.containing = containing;
            this.typeParameters = typeParameters;
            this.reference = reference;
            this.type = type;
            this.referenceType = referenceType;
        }

        private MemberReference(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Expression containing, @Nullable JContainer<Expression> typeParameters, JLeftPadded<Identifier> reference, @Nullable JavaType type, @Nullable JavaType referenceType) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.containing = containing;
            this.typeParameters = typeParameters;
            this.reference = reference;
            this.type = type;
            this.referenceType = referenceType;
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public MemberReference withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new MemberReference(this.padding, this.id, prefix, this.markers, this.containing, this.typeParameters, this.reference, this.type, this.referenceType);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public MemberReference withMarkers(Markers markers) {
            return this.markers == markers ? this : new MemberReference(this.padding, this.id, this.prefix, markers, this.containing, this.typeParameters, this.reference, this.type, this.referenceType);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public MemberReference withContaining(Expression containing) {
            return this.containing == containing ? this : new MemberReference(this.padding, this.id, this.prefix, this.markers, containing, this.typeParameters, this.reference, this.type, this.referenceType);
        }

        public Expression getContaining() {
            return this.containing;
        }

        @NonNull
        public MemberReference withType(@Nullable JavaType type) {
            return this.type == type ? this : new MemberReference(this.padding, this.id, this.prefix, this.markers, this.containing, this.typeParameters, this.reference, type, this.referenceType);
        }

        @Override
        @Nullable
        public JavaType getType() {
            return this.type;
        }

        @NonNull
        public MemberReference withReferenceType(@Nullable JavaType referenceType) {
            return this.referenceType == referenceType ? this : new MemberReference(this.padding, this.id, this.prefix, this.markers, this.containing, this.typeParameters, this.reference, this.type, referenceType);
        }

        @Nullable
        public JavaType getReferenceType() {
            return this.referenceType;
        }

        public static class Padding {
            private final MemberReference t;

            @Nullable
            public JContainer<Expression> getTypeParameters() {
                return this.t.typeParameters;
            }

            public MemberReference withTypeParameters(@Nullable JContainer<Expression> typeParameters) {
                return this.t.typeParameters == typeParameters ? this.t : new MemberReference(this.t.id, this.t.prefix, this.t.markers, this.t.containing, typeParameters, this.t.reference, this.t.type, this.t.referenceType);
            }

            public JLeftPadded<Identifier> getReference() {
                return this.t.reference;
            }

            public MemberReference withReference(JLeftPadded<Identifier> reference) {
                return this.t.reference == reference ? this.t : new MemberReference(this.t.id, this.t.prefix, this.t.markers, this.t.containing, this.t.typeParameters, reference, this.t.type, this.t.referenceType);
            }

            public Padding(MemberReference t) {
                this.t = t;
            }
        }
    }

    public static final class Literal
    implements J,
    Expression {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        @Nullable
        private final Object value;
        private final String valueSource;
        private final JavaType.Primitive type;

        public Literal withType(@Nullable JavaType type) {
            if (type == this.type) {
                return this;
            }
            if (type instanceof JavaType.Primitive) {
                return new Literal(this.id, this.prefix, this.markers, this.value, this.valueSource, (JavaType.Primitive)type);
            }
            return this;
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitLiteral(this, p);
        }

        @Override
        public Coordinates.Literal getCoordinates() {
            return new Coordinates.Literal(this);
        }

        public <T> String transformValue(Function<T, Object> transform) {
            Matcher valueMatcher = Pattern.compile("(.*)" + Pattern.quote(this.value == null ? "null" : this.value.toString()) + "(.*)").matcher(this.printTrimmed().replace("\\", ""));
            if (valueMatcher.find()) {
                String prefix = valueMatcher.group(1);
                String suffix = valueMatcher.group(2);
                return prefix + transform.apply(this.value) + suffix;
            }
            throw new IllegalStateException("Encountered a literal `" + this + "` that could not be transformed");
        }

        public String toString() {
            return "Literal(" + LiteralToString.toString(this) + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Literal)) {
                return false;
            }
            Literal other = (Literal)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Literal(UUID id, Space prefix, Markers markers, @Nullable Object value, String valueSource, JavaType.Primitive type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.value = value;
            this.valueSource = valueSource;
            this.type = type;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @Nullable
        public Object getValue() {
            return this.value;
        }

        public String getValueSource() {
            return this.valueSource;
        }

        @Override
        public JavaType.Primitive getType() {
            return this.type;
        }

        @NonNull
        public Literal withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Literal(this.id, prefix, this.markers, this.value, this.valueSource, this.type);
        }

        @NonNull
        public Literal withMarkers(Markers markers) {
            return this.markers == markers ? this : new Literal(this.id, this.prefix, markers, this.value, this.valueSource, this.type);
        }

        @NonNull
        public Literal withValue(@Nullable Object value) {
            return this.value == value ? this : new Literal(this.id, this.prefix, this.markers, value, this.valueSource, this.type);
        }

        @NonNull
        public Literal withValueSource(String valueSource) {
            return this.valueSource == valueSource ? this : new Literal(this.id, this.prefix, this.markers, this.value, valueSource, this.type);
        }
    }

    public static final class Lambda
    implements J,
    Expression {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Parameters parameters;
        private final Space arrow;
        private final J body;
        @Nullable
        private final JavaType type;

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitLambda(this, p);
        }

        @Override
        public Coordinates.Lambda getCoordinates() {
            return new Coordinates.Lambda(this);
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Lambda)) {
                return false;
            }
            Lambda other = (Lambda)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Lambda(UUID id, Space prefix, Markers markers, Parameters parameters, Space arrow, J body, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.parameters = parameters;
            this.arrow = arrow;
            this.body = body;
            this.type = type;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Parameters getParameters() {
            return this.parameters;
        }

        public Space getArrow() {
            return this.arrow;
        }

        public J getBody() {
            return this.body;
        }

        @Override
        @Nullable
        public JavaType getType() {
            return this.type;
        }

        @NonNull
        public String toString() {
            return "J.Lambda(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", parameters=" + this.getParameters() + ", arrow=" + this.getArrow() + ", body=" + this.getBody() + ", type=" + this.getType() + ")";
        }

        @NonNull
        public Lambda withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Lambda(this.id, prefix, this.markers, this.parameters, this.arrow, this.body, this.type);
        }

        @NonNull
        public Lambda withMarkers(Markers markers) {
            return this.markers == markers ? this : new Lambda(this.id, this.prefix, markers, this.parameters, this.arrow, this.body, this.type);
        }

        @NonNull
        public Lambda withParameters(Parameters parameters) {
            return this.parameters == parameters ? this : new Lambda(this.id, this.prefix, this.markers, parameters, this.arrow, this.body, this.type);
        }

        @NonNull
        public Lambda withArrow(Space arrow) {
            return this.arrow == arrow ? this : new Lambda(this.id, this.prefix, this.markers, this.parameters, arrow, this.body, this.type);
        }

        @NonNull
        public Lambda withBody(J body) {
            return this.body == body ? this : new Lambda(this.id, this.prefix, this.markers, this.parameters, this.arrow, body, this.type);
        }

        @NonNull
        public Lambda withType(@Nullable JavaType type) {
            return this.type == type ? this : new Lambda(this.id, this.prefix, this.markers, this.parameters, this.arrow, this.body, type);
        }

        public static final class Parameters
        implements J {
            @Nullable
            private transient WeakReference<Padding> padding;
            private final UUID id;
            private final Space prefix;
            private final Markers markers;
            private final boolean parenthesized;
            private final List<JRightPadded<J>> parameters;

            public List<J> getParameters() {
                return JRightPadded.getElements(this.parameters);
            }

            public Parameters withParameters(List<J> parameters) {
                return this.getPadding().withParams(JRightPadded.withElements(this.parameters, parameters));
            }

            @Override
            public Coordinates.Lambda.Parameters getCoordinates() {
                return new Coordinates.Lambda.Parameters(this);
            }

            public Padding getPadding() {
                Padding p;
                if (this.padding == null) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                } else {
                    p = (Padding)this.padding.get();
                    if (p == null || p.t != this) {
                        p = new Padding(this);
                        this.padding = new WeakReference<Padding>(p);
                    }
                }
                return p;
            }

            @NonNull
            public String toString() {
                return "J.Lambda.Parameters(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", parenthesized=" + this.isParenthesized() + ", parameters=" + this.getParameters() + ")";
            }

            public boolean equals(@Nullable Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Parameters)) {
                    return false;
                }
                Parameters other = (Parameters)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            public Parameters(UUID id, Space prefix, Markers markers, boolean parenthesized, List<JRightPadded<J>> parameters) {
                this.id = id;
                this.prefix = prefix;
                this.markers = markers;
                this.parenthesized = parenthesized;
                this.parameters = parameters;
            }

            private Parameters(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, boolean parenthesized, List<JRightPadded<J>> parameters) {
                this.padding = padding;
                this.id = id;
                this.prefix = prefix;
                this.markers = markers;
                this.parenthesized = parenthesized;
                this.parameters = parameters;
            }

            public UUID getId() {
                return this.id;
            }

            @NonNull
            public Parameters withPrefix(Space prefix) {
                return this.prefix == prefix ? this : new Parameters(this.padding, this.id, prefix, this.markers, this.parenthesized, this.parameters);
            }

            @Override
            public Space getPrefix() {
                return this.prefix;
            }

            @NonNull
            public Parameters withMarkers(Markers markers) {
                return this.markers == markers ? this : new Parameters(this.padding, this.id, this.prefix, markers, this.parenthesized, this.parameters);
            }

            public Markers getMarkers() {
                return this.markers;
            }

            @NonNull
            public Parameters withParenthesized(boolean parenthesized) {
                return this.parenthesized == parenthesized ? this : new Parameters(this.padding, this.id, this.prefix, this.markers, parenthesized, this.parameters);
            }

            public boolean isParenthesized() {
                return this.parenthesized;
            }

            public static class Padding {
                private final Parameters t;

                public List<JRightPadded<J>> getParams() {
                    return this.t.parameters;
                }

                public Parameters withParams(List<JRightPadded<J>> parameters) {
                    return this.t.parameters == parameters ? this.t : new Parameters(this.t.id, this.t.prefix, this.t.markers, this.t.parenthesized, parameters);
                }

                public Padding(Parameters t) {
                    this.t = t;
                }
            }
        }
    }

    public static final class Label
    implements J,
    Statement {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JRightPadded<Identifier> label;
        private final Statement statement;

        public Identifier getLabel() {
            return this.label.getElement();
        }

        public Label withLabel(Identifier label) {
            return this.getPadding().withLabel(this.label.withElement(label));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitLabel(this, p);
        }

        @Override
        public Coordinates.Label getCoordinates() {
            return new Coordinates.Label(this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @NonNull
        public String toString() {
            return "J.Label(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", label=" + this.getLabel() + ", statement=" + this.getStatement() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Label)) {
                return false;
            }
            Label other = (Label)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Label(UUID id, Space prefix, Markers markers, JRightPadded<Identifier> label, Statement statement) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.label = label;
            this.statement = statement;
        }

        private Label(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, JRightPadded<Identifier> label, Statement statement) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.label = label;
            this.statement = statement;
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public Label withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Label(this.padding, this.id, prefix, this.markers, this.label, this.statement);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public Label withMarkers(Markers markers) {
            return this.markers == markers ? this : new Label(this.padding, this.id, this.prefix, markers, this.label, this.statement);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public Label withStatement(Statement statement) {
            return this.statement == statement ? this : new Label(this.padding, this.id, this.prefix, this.markers, this.label, statement);
        }

        public Statement getStatement() {
            return this.statement;
        }

        public static class Padding {
            private final Label t;

            public JRightPadded<Identifier> getLabel() {
                return this.t.label;
            }

            public Label withLabel(JRightPadded<Identifier> label) {
                return this.t.label == label ? this.t : new Label(this.t.id, this.t.prefix, this.t.markers, label, this.t.statement);
            }

            public Padding(Label t) {
                this.t = t;
            }
        }
    }

    public static final class InstanceOf
    implements J,
    Expression {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JRightPadded<Expression> expression;
        private final J clazz;
        @Nullable
        private final JavaType type;

        public Expression getExpression() {
            return this.expression.getElement();
        }

        public InstanceOf withExpression(Expression expression) {
            return this.getPadding().withExpr(this.expression.withElement(expression));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitInstanceOf(this, p);
        }

        @Override
        public Coordinates.InstanceOf getCoordinates() {
            return new Coordinates.InstanceOf(this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @NonNull
        public String toString() {
            return "J.InstanceOf(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", expression=" + this.getExpression() + ", clazz=" + this.getClazz() + ", type=" + this.getType() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InstanceOf)) {
                return false;
            }
            InstanceOf other = (InstanceOf)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public InstanceOf(UUID id, Space prefix, Markers markers, JRightPadded<Expression> expression, J clazz, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.expression = expression;
            this.clazz = clazz;
            this.type = type;
        }

        private InstanceOf(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, JRightPadded<Expression> expression, J clazz, @Nullable JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.expression = expression;
            this.clazz = clazz;
            this.type = type;
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public InstanceOf withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new InstanceOf(this.padding, this.id, prefix, this.markers, this.expression, this.clazz, this.type);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public InstanceOf withMarkers(Markers markers) {
            return this.markers == markers ? this : new InstanceOf(this.padding, this.id, this.prefix, markers, this.expression, this.clazz, this.type);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public InstanceOf withClazz(J clazz) {
            return this.clazz == clazz ? this : new InstanceOf(this.padding, this.id, this.prefix, this.markers, this.expression, clazz, this.type);
        }

        public J getClazz() {
            return this.clazz;
        }

        @NonNull
        public InstanceOf withType(@Nullable JavaType type) {
            return this.type == type ? this : new InstanceOf(this.padding, this.id, this.prefix, this.markers, this.expression, this.clazz, type);
        }

        @Override
        @Nullable
        public JavaType getType() {
            return this.type;
        }

        public static class Padding {
            private final InstanceOf t;

            public JRightPadded<Expression> getExpr() {
                return this.t.expression;
            }

            public InstanceOf withExpr(JRightPadded<Expression> expression) {
                return this.t.expression == expression ? this.t : new InstanceOf(this.t.id, this.t.prefix, this.t.markers, expression, this.t.clazz, this.t.type);
            }

            public Padding(InstanceOf t) {
                this.t = t;
            }
        }
    }

    public static final class Import
    implements J,
    Comparable<Import> {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JLeftPadded<Boolean> statik;
        private final FieldAccess qualid;

        public boolean isStatic() {
            return this.statik.getElement();
        }

        public Import withStatic(boolean statik) {
            return this.getPadding().withStatic(this.statik.withElement(statik));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitImport(this, p);
        }

        @Override
        public Coordinates.Import getCoordinates() {
            return new Coordinates.Import(this);
        }

        public boolean isFromType(String clazz) {
            if ("*".equals(this.qualid.getSimpleName())) {
                return this.qualid.target.printTrimmed().equals(Arrays.stream(clazz.split("\\.")).filter(pkgOrNam -> Character.isLowerCase(pkgOrNam.charAt(0))).collect(Collectors.joining(".")));
            }
            return (this.isStatic() ? this.qualid.getTarget().printTrimmed() : this.qualid.printTrimmed()).equals(clazz);
        }

        public String getTypeName() {
            return this.isStatic() ? this.qualid.getTarget().printTrimmed() : this.qualid.printTrimmed();
        }

        public String getPackageName() {
            JavaType.Class importType = TypeUtils.asClass(this.qualid.getType());
            if (importType != null) {
                return importType.getPackageName();
            }
            AtomicBoolean takeWhile = new AtomicBoolean(true);
            return Arrays.stream(this.qualid.getTarget().printTrimmed().split("\\.")).filter(pkg -> {
                takeWhile.set(takeWhile.get() && !pkg.isEmpty() && Character.isLowerCase(pkg.charAt(0)));
                return takeWhile.get();
            }).collect(Collectors.joining("."));
        }

        @Override
        public int compareTo(Import o) {
            String p1 = this.getPackageName();
            String p2 = o.getPackageName();
            String[] p1s = p1.split("\\.");
            String[] p2s = p2.split("\\.");
            for (int i = 0; i < p1s.length; ++i) {
                String s = p1s[i];
                if (p2s.length < i + 1) {
                    return 1;
                }
                if (s.equals(p2s[i])) continue;
                return s.compareTo(p2s[i]);
            }
            return p1s.length < p2s.length ? -1 : this.getQualid().getSimpleName().compareTo(o.getQualid().getSimpleName());
        }

        public String toString() {
            return "Import(" + ImportToString.toString(this) + ")";
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Import)) {
                return false;
            }
            Import other = (Import)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Import(UUID id, Space prefix, Markers markers, JLeftPadded<Boolean> statik, FieldAccess qualid) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.statik = statik;
            this.qualid = qualid;
        }

        private Import(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, JLeftPadded<Boolean> statik, FieldAccess qualid) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.statik = statik;
            this.qualid = qualid;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public Import withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Import(this.padding, this.id, prefix, this.markers, this.statik, this.qualid);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public Import withMarkers(Markers markers) {
            return this.markers == markers ? this : new Import(this.padding, this.id, this.prefix, markers, this.statik, this.qualid);
        }

        @NonNull
        public Import withQualid(FieldAccess qualid) {
            return this.qualid == qualid ? this : new Import(this.padding, this.id, this.prefix, this.markers, this.statik, qualid);
        }

        public FieldAccess getQualid() {
            return this.qualid;
        }

        public static class Padding {
            private final Import t;

            public JLeftPadded<Boolean> getStatic() {
                return this.t.statik;
            }

            public Import withStatic(JLeftPadded<Boolean> statik) {
                return this.t.statik == statik ? this.t : new Import(this.t.id, this.t.prefix, this.t.markers, statik, this.t.qualid);
            }

            public Padding(Import t) {
                this.t = t;
            }
        }
    }

    public static final class If
    implements J,
    Statement {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final ControlParentheses<Expression> ifCondition;
        private final JRightPadded<Statement> thenPart;
        @Nullable
        private final Else elsePart;

        public Statement getThenPart() {
            return this.thenPart.getElement();
        }

        public If withThenPart(Statement thenPart) {
            return this.getPadding().withThenPart(this.thenPart.withElement(thenPart));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitIf(this, p);
        }

        @Override
        public Coordinates.If getCoordinates() {
            return new Coordinates.If(this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @NonNull
        public String toString() {
            return "J.If(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", ifCondition=" + this.getIfCondition() + ", thenPart=" + this.getThenPart() + ", elsePart=" + this.getElsePart() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof If)) {
                return false;
            }
            If other = (If)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public If(UUID id, Space prefix, Markers markers, ControlParentheses<Expression> ifCondition, JRightPadded<Statement> thenPart, @Nullable Else elsePart) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.ifCondition = ifCondition;
            this.thenPart = thenPart;
            this.elsePart = elsePart;
        }

        private If(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, ControlParentheses<Expression> ifCondition, JRightPadded<Statement> thenPart, @Nullable Else elsePart) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.ifCondition = ifCondition;
            this.thenPart = thenPart;
            this.elsePart = elsePart;
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public If withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new If(this.padding, this.id, prefix, this.markers, this.ifCondition, this.thenPart, this.elsePart);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public If withMarkers(Markers markers) {
            return this.markers == markers ? this : new If(this.padding, this.id, this.prefix, markers, this.ifCondition, this.thenPart, this.elsePart);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public If withIfCondition(ControlParentheses<Expression> ifCondition) {
            return this.ifCondition == ifCondition ? this : new If(this.padding, this.id, this.prefix, this.markers, ifCondition, this.thenPart, this.elsePart);
        }

        public ControlParentheses<Expression> getIfCondition() {
            return this.ifCondition;
        }

        @NonNull
        public If withElsePart(@Nullable Else elsePart) {
            return this.elsePart == elsePart ? this : new If(this.padding, this.id, this.prefix, this.markers, this.ifCondition, this.thenPart, elsePart);
        }

        @Nullable
        public Else getElsePart() {
            return this.elsePart;
        }

        public static class Padding {
            private final If t;

            public JRightPadded<Statement> getThenPart() {
                return this.t.thenPart;
            }

            public If withThenPart(JRightPadded<Statement> thenPart) {
                return this.t.thenPart == thenPart ? this.t : new If(this.t.id, this.t.prefix, this.t.markers, this.t.ifCondition, thenPart, this.t.elsePart);
            }

            public Padding(If t) {
                this.t = t;
            }
        }

        public static final class Else
        implements J {
            @Nullable
            private transient WeakReference<Padding> padding;
            private final UUID id;
            private final Space prefix;
            private final Markers markers;
            private final JRightPadded<Statement> body;

            public Statement getBody() {
                return this.body.getElement();
            }

            public Else withBody(Statement body) {
                return this.getPadding().withBody(this.body.withElement(body));
            }

            @Override
            public <P> J acceptJava(JavaVisitor<P> v, P p) {
                return v.visitElse(this, p);
            }

            @Override
            public Coordinates.If.Else getCoordinates() {
                return new Coordinates.If.Else(this);
            }

            public Padding getPadding() {
                Padding p;
                if (this.padding == null) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                } else {
                    p = (Padding)this.padding.get();
                    if (p == null || p.t != this) {
                        p = new Padding(this);
                        this.padding = new WeakReference<Padding>(p);
                    }
                }
                return p;
            }

            @NonNull
            public String toString() {
                return "J.If.Else(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", body=" + this.getBody() + ")";
            }

            public boolean equals(@Nullable Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Else)) {
                    return false;
                }
                Else other = (Else)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            public Else(UUID id, Space prefix, Markers markers, JRightPadded<Statement> body) {
                this.id = id;
                this.prefix = prefix;
                this.markers = markers;
                this.body = body;
            }

            private Else(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, JRightPadded<Statement> body) {
                this.padding = padding;
                this.id = id;
                this.prefix = prefix;
                this.markers = markers;
                this.body = body;
            }

            public UUID getId() {
                return this.id;
            }

            @NonNull
            public Else withPrefix(Space prefix) {
                return this.prefix == prefix ? this : new Else(this.padding, this.id, prefix, this.markers, this.body);
            }

            @Override
            public Space getPrefix() {
                return this.prefix;
            }

            @NonNull
            public Else withMarkers(Markers markers) {
                return this.markers == markers ? this : new Else(this.padding, this.id, this.prefix, markers, this.body);
            }

            public Markers getMarkers() {
                return this.markers;
            }

            public static class Padding {
                private final Else t;

                public JRightPadded<Statement> getBody() {
                    return this.t.body;
                }

                public Else withBody(JRightPadded<Statement> body) {
                    return this.t.body == body ? this.t : new Else(this.t.id, this.t.prefix, this.t.markers, body);
                }

                public Padding(Else t) {
                    this.t = t;
                }
            }
        }
    }

    public static final class Identifier
    implements J,
    TypeTree,
    Expression {
        private static final Map<String, Map<JavaType, IdentifierFlyweight>> flyweights = new WeakHashMap<String, Map<JavaType, IdentifierFlyweight>>();
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final IdentifierFlyweight identifier;

        private Identifier(UUID id, IdentifierFlyweight identifier, Space prefix, Markers markers) {
            this.id = id;
            this.identifier = identifier;
            this.prefix = prefix;
            this.markers = markers;
        }

        @Override
        public JavaType getType() {
            return this.identifier.getType();
        }

        public Identifier withType(@Nullable JavaType type) {
            if (type == this.getType()) {
                return this;
            }
            return Identifier.build(this.id, this.prefix, this.markers, this.getSimpleName(), type);
        }

        public String getSimpleName() {
            return this.identifier.getSimpleName();
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitIdentifier(this, p);
        }

        @Override
        public Coordinates.Identifier getCoordinates() {
            return new Coordinates.Identifier(this);
        }

        public Identifier withName(String name) {
            if (name.equals(this.identifier.getSimpleName())) {
                return this;
            }
            return Identifier.build(this.id, this.prefix, this.markers, name, this.getType());
        }

        public Identifier withMarkers(Markers markers) {
            if (markers == this.markers) {
                return this;
            }
            return Identifier.build(this.id, this.prefix, markers, this.identifier.getSimpleName(), this.getType());
        }

        public Identifier withPrefix(Space prefix) {
            if (prefix == this.prefix) {
                return this;
            }
            return Identifier.build(this.id, prefix, this.markers, this.identifier.getSimpleName(), this.getType());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JsonCreator
        public static Identifier build(UUID id, Space prefix, Markers markers, String simpleName, @Nullable JavaType type) {
            Map<String, Map<JavaType, IdentifierFlyweight>> map = flyweights;
            synchronized (map) {
                return new Identifier(id, flyweights.computeIfAbsent(simpleName, n -> new HashMap()).computeIfAbsent(type, t -> new IdentifierFlyweight(simpleName, (JavaType)t)), prefix, markers);
            }
        }

        public String toString() {
            return "Ident(" + this.printTrimmed() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Identifier)) {
                return false;
            }
            Identifier other = (Identifier)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public static final class IdentifierFlyweight
        implements Serializable {
            private final String simpleName;
            @Nullable
            private final JavaType type;

            public IdentifierFlyweight(String simpleName, @Nullable JavaType type) {
                this.simpleName = simpleName;
                this.type = type;
            }

            public String getSimpleName() {
                return this.simpleName;
            }

            @Nullable
            public JavaType getType() {
                return this.type;
            }

            public boolean equals(@Nullable Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof IdentifierFlyweight)) {
                    return false;
                }
                IdentifierFlyweight other = (IdentifierFlyweight)o;
                String this$simpleName = this.getSimpleName();
                String other$simpleName = other.getSimpleName();
                if (this$simpleName == null ? other$simpleName != null : !this$simpleName.equals(other$simpleName)) {
                    return false;
                }
                JavaType this$type = this.getType();
                JavaType other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $simpleName = this.getSimpleName();
                result = result * 59 + ($simpleName == null ? 43 : $simpleName.hashCode());
                JavaType $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            @NonNull
            public String toString() {
                return "J.Identifier.IdentifierFlyweight(simpleName=" + this.getSimpleName() + ", type=" + this.getType() + ")";
            }
        }
    }

    public static final class ForLoop
    implements J,
    Statement {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Control control;
        private final JRightPadded<Statement> body;

        public Statement getBody() {
            return this.body.getElement();
        }

        public ForLoop withBody(Statement body) {
            return this.getPadding().withBody(this.body.withElement(body));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitForLoop(this, p);
        }

        @Override
        public Coordinates.ForLoop getCoordinates() {
            return new Coordinates.ForLoop(this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @NonNull
        public String toString() {
            return "J.ForLoop(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", control=" + this.getControl() + ", body=" + this.getBody() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ForLoop)) {
                return false;
            }
            ForLoop other = (ForLoop)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public ForLoop(UUID id, Space prefix, Markers markers, Control control, JRightPadded<Statement> body) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.control = control;
            this.body = body;
        }

        private ForLoop(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Control control, JRightPadded<Statement> body) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.control = control;
            this.body = body;
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public ForLoop withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ForLoop(this.padding, this.id, prefix, this.markers, this.control, this.body);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public ForLoop withMarkers(Markers markers) {
            return this.markers == markers ? this : new ForLoop(this.padding, this.id, this.prefix, markers, this.control, this.body);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public ForLoop withControl(Control control) {
            return this.control == control ? this : new ForLoop(this.padding, this.id, this.prefix, this.markers, control, this.body);
        }

        public Control getControl() {
            return this.control;
        }

        public static class Padding {
            private final ForLoop t;

            public JRightPadded<Statement> getBody() {
                return this.t.body;
            }

            public ForLoop withBody(JRightPadded<Statement> body) {
                return this.t.body == body ? this.t : new ForLoop(this.t.id, this.t.prefix, this.t.markers, this.t.control, body);
            }

            public Padding(ForLoop t) {
                this.t = t;
            }
        }

        public static final class Control
        implements J {
            @Nullable
            private transient WeakReference<Padding> padding;
            private final UUID id;
            private final Space prefix;
            private final Markers markers;
            private final JRightPadded<Statement> init;
            private final JRightPadded<Expression> condition;
            private final List<JRightPadded<Statement>> update;

            public Statement getInit() {
                return this.init.getElement();
            }

            public Control withInit(Statement init) {
                return this.getPadding().withInit(this.init.withElement(init));
            }

            public Expression getCondition() {
                return this.condition.getElement();
            }

            public Control withCondition(Expression condition) {
                return this.getPadding().withCondition(this.condition.withElement(condition));
            }

            public List<Statement> getUpdate() {
                return JRightPadded.getElements(this.update);
            }

            public Control withUpdate(List<Statement> update) {
                return this.getPadding().withUpdate(JRightPadded.withElements(this.update, update));
            }

            @Override
            public <P> J acceptJava(JavaVisitor<P> v, P p) {
                return v.visitForControl(this, p);
            }

            @Override
            public Coordinates.ForLoop.Control getCoordinates() {
                return new Coordinates.ForLoop.Control(this);
            }

            public Padding getPadding() {
                Padding p;
                if (this.padding == null) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                } else {
                    p = (Padding)this.padding.get();
                    if (p == null || p.t != this) {
                        p = new Padding(this);
                        this.padding = new WeakReference<Padding>(p);
                    }
                }
                return p;
            }

            @NonNull
            public String toString() {
                return "J.ForLoop.Control(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", init=" + this.getInit() + ", condition=" + this.getCondition() + ", update=" + this.getUpdate() + ")";
            }

            public boolean equals(@Nullable Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Control)) {
                    return false;
                }
                Control other = (Control)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            public Control(UUID id, Space prefix, Markers markers, JRightPadded<Statement> init, JRightPadded<Expression> condition, List<JRightPadded<Statement>> update) {
                this.id = id;
                this.prefix = prefix;
                this.markers = markers;
                this.init = init;
                this.condition = condition;
                this.update = update;
            }

            private Control(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, JRightPadded<Statement> init, JRightPadded<Expression> condition, List<JRightPadded<Statement>> update) {
                this.padding = padding;
                this.id = id;
                this.prefix = prefix;
                this.markers = markers;
                this.init = init;
                this.condition = condition;
                this.update = update;
            }

            public UUID getId() {
                return this.id;
            }

            @NonNull
            public Control withPrefix(Space prefix) {
                return this.prefix == prefix ? this : new Control(this.padding, this.id, prefix, this.markers, this.init, this.condition, this.update);
            }

            @Override
            public Space getPrefix() {
                return this.prefix;
            }

            @NonNull
            public Control withMarkers(Markers markers) {
                return this.markers == markers ? this : new Control(this.padding, this.id, this.prefix, markers, this.init, this.condition, this.update);
            }

            public Markers getMarkers() {
                return this.markers;
            }

            public static class Padding {
                private final Control t;

                public JRightPadded<Statement> getInit() {
                    return this.t.init;
                }

                public Control withInit(JRightPadded<Statement> init) {
                    return this.t.init == init ? this.t : new Control(this.t.id, this.t.prefix, this.t.markers, init, this.t.condition, this.t.update);
                }

                public JRightPadded<Expression> getCondition() {
                    return this.t.condition;
                }

                public Control withCondition(JRightPadded<Expression> condition) {
                    return this.t.condition == condition ? this.t : new Control(this.t.id, this.t.prefix, this.t.markers, this.t.init, condition, this.t.update);
                }

                public List<JRightPadded<Statement>> getUpdate() {
                    return this.t.update;
                }

                public Control withUpdate(List<JRightPadded<Statement>> update) {
                    return this.t.update == update ? this.t : new Control(this.t.id, this.t.prefix, this.t.markers, this.t.init, this.t.condition, update);
                }

                public Padding(Control t) {
                    this.t = t;
                }
            }
        }
    }

    public static final class ForEachLoop
    implements J,
    Statement {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Control control;
        private final JRightPadded<Statement> body;

        public Statement getBody() {
            return this.body.getElement();
        }

        public ForEachLoop withBody(Statement body) {
            return this.getPadding().withBody(this.body.withElement(body));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitForEachLoop(this, p);
        }

        @Override
        public Coordinates.ForEachLoop getCoordinates() {
            return new Coordinates.ForEachLoop(this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @NonNull
        public String toString() {
            return "J.ForEachLoop(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", control=" + this.getControl() + ", body=" + this.getBody() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ForEachLoop)) {
                return false;
            }
            ForEachLoop other = (ForEachLoop)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public ForEachLoop(UUID id, Space prefix, Markers markers, Control control, JRightPadded<Statement> body) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.control = control;
            this.body = body;
        }

        private ForEachLoop(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Control control, JRightPadded<Statement> body) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.control = control;
            this.body = body;
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public ForEachLoop withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ForEachLoop(this.padding, this.id, prefix, this.markers, this.control, this.body);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public ForEachLoop withMarkers(Markers markers) {
            return this.markers == markers ? this : new ForEachLoop(this.padding, this.id, this.prefix, markers, this.control, this.body);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public ForEachLoop withControl(Control control) {
            return this.control == control ? this : new ForEachLoop(this.padding, this.id, this.prefix, this.markers, control, this.body);
        }

        public Control getControl() {
            return this.control;
        }

        public static class Padding {
            private final ForEachLoop t;

            public JRightPadded<Statement> getBody() {
                return this.t.body;
            }

            public ForEachLoop withBody(JRightPadded<Statement> body) {
                return this.t.body == body ? this.t : new ForEachLoop(this.t.id, this.t.prefix, this.t.markers, this.t.control, body);
            }

            public Padding(ForEachLoop t) {
                this.t = t;
            }
        }

        public static final class Control
        implements J {
            @Nullable
            private transient WeakReference<Padding> padding;
            private final UUID id;
            private final Space prefix;
            private final Markers markers;
            private final JRightPadded<VariableDeclarations> variable;
            private final JRightPadded<Expression> iterable;

            public VariableDeclarations getVariable() {
                return this.variable.getElement();
            }

            public Control withVariable(VariableDeclarations variable) {
                return this.getPadding().withVariable(this.variable.withElement(variable));
            }

            public Expression getIterable() {
                return this.iterable.getElement();
            }

            public Control withIterable(Expression iterable) {
                return this.getPadding().withIterable(this.iterable.withElement(iterable));
            }

            @Override
            public <P> J acceptJava(JavaVisitor<P> v, P p) {
                return v.visitForEachControl(this, p);
            }

            @Override
            public Coordinates.ForEachLoop.Control getCoordinates() {
                return new Coordinates.ForEachLoop.Control(this);
            }

            public Padding getPadding() {
                Padding p;
                if (this.padding == null) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                } else {
                    p = (Padding)this.padding.get();
                    if (p == null || p.t != this) {
                        p = new Padding(this);
                        this.padding = new WeakReference<Padding>(p);
                    }
                }
                return p;
            }

            @NonNull
            public String toString() {
                return "J.ForEachLoop.Control(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", variable=" + this.getVariable() + ", iterable=" + this.getIterable() + ")";
            }

            public boolean equals(@Nullable Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Control)) {
                    return false;
                }
                Control other = (Control)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            public Control(UUID id, Space prefix, Markers markers, JRightPadded<VariableDeclarations> variable, JRightPadded<Expression> iterable) {
                this.id = id;
                this.prefix = prefix;
                this.markers = markers;
                this.variable = variable;
                this.iterable = iterable;
            }

            private Control(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, JRightPadded<VariableDeclarations> variable, JRightPadded<Expression> iterable) {
                this.padding = padding;
                this.id = id;
                this.prefix = prefix;
                this.markers = markers;
                this.variable = variable;
                this.iterable = iterable;
            }

            public UUID getId() {
                return this.id;
            }

            @NonNull
            public Control withPrefix(Space prefix) {
                return this.prefix == prefix ? this : new Control(this.padding, this.id, prefix, this.markers, this.variable, this.iterable);
            }

            @Override
            public Space getPrefix() {
                return this.prefix;
            }

            @NonNull
            public Control withMarkers(Markers markers) {
                return this.markers == markers ? this : new Control(this.padding, this.id, this.prefix, markers, this.variable, this.iterable);
            }

            public Markers getMarkers() {
                return this.markers;
            }

            public static class Padding {
                private final Control t;

                public JRightPadded<VariableDeclarations> getVariable() {
                    return this.t.variable;
                }

                public Control withVariable(JRightPadded<VariableDeclarations> variable) {
                    return this.t.variable == variable ? this.t : new Control(this.t.id, this.t.prefix, this.t.markers, variable, this.t.iterable);
                }

                public JRightPadded<Expression> getIterable() {
                    return this.t.iterable;
                }

                public Control withIterable(JRightPadded<Expression> iterable) {
                    return this.t.iterable == iterable ? this.t : new Control(this.t.id, this.t.prefix, this.t.markers, this.t.variable, iterable);
                }

                public Padding(Control t) {
                    this.t = t;
                }
            }
        }
    }

    public static final class FieldAccess
    implements J,
    TypeTree,
    Expression {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Expression target;
        private final JLeftPadded<Identifier> name;
        @Nullable
        private final JavaType type;

        public Identifier getName() {
            return this.name.getElement();
        }

        public FieldAccess withName(Identifier name) {
            return this.getPadding().withName(this.name.withElement(name));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitFieldAccess(this, p);
        }

        @Override
        public Coordinates.FieldAccess getCoordinates() {
            return new Coordinates.FieldAccess(this);
        }

        public String getSimpleName() {
            return this.name.getElement().getSimpleName();
        }

        @Override
        public List<Tree> getSideEffects() {
            return this.target.getSideEffects();
        }

        public String toString() {
            return "FieldAccess(" + this.printTrimmed() + ")";
        }

        @Nullable
        public NameTree asClassReference() {
            if (this.target instanceof NameTree) {
                String fqn = null;
                if (this.type instanceof JavaType.Class) {
                    fqn = ((JavaType.Class)this.type).getFullyQualifiedName();
                } else if (this.type instanceof JavaType.ShallowClass) {
                    fqn = ((JavaType.ShallowClass)this.type).getFullyQualifiedName();
                }
                return "java.lang.Class".equals(fqn) ? (NameTree)((Object)this.target) : null;
            }
            return null;
        }

        public boolean isFullyQualifiedClassReference(String className) {
            return this.isFullyQualifiedClassReference(this, className);
        }

        public boolean isFullyQualifiedClassReference(MethodMatcher methodMatcher) {
            String hopefullyFullyQualifiedMethod = methodMatcher.getTargetTypePattern().pattern() + "." + methodMatcher.getMethodNamePattern().pattern();
            return this.isFullyQualifiedClassReference(this, hopefullyFullyQualifiedMethod);
        }

        private boolean isFullyQualifiedClassReference(FieldAccess fieldAccess, String className) {
            if (!className.contains(".")) {
                return false;
            }
            if (!fieldAccess.getName().getSimpleName().equals(className.substring(className.lastIndexOf(46) + 1))) {
                return false;
            }
            if (fieldAccess.getTarget() instanceof FieldAccess) {
                return this.isFullyQualifiedClassReference((FieldAccess)fieldAccess.getTarget(), className.substring(0, className.lastIndexOf(46)));
            }
            if (fieldAccess.getTarget() instanceof Identifier) {
                return ((Identifier)fieldAccess.getTarget()).getSimpleName().equals(className.substring(0, className.lastIndexOf(46)));
            }
            return false;
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FieldAccess)) {
                return false;
            }
            FieldAccess other = (FieldAccess)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public FieldAccess(UUID id, Space prefix, Markers markers, Expression target, JLeftPadded<Identifier> name, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.target = target;
            this.name = name;
            this.type = type;
        }

        private FieldAccess(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Expression target, JLeftPadded<Identifier> name, @Nullable JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.target = target;
            this.name = name;
            this.type = type;
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public FieldAccess withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new FieldAccess(this.padding, this.id, prefix, this.markers, this.target, this.name, this.type);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public FieldAccess withMarkers(Markers markers) {
            return this.markers == markers ? this : new FieldAccess(this.padding, this.id, this.prefix, markers, this.target, this.name, this.type);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public FieldAccess withTarget(Expression target) {
            return this.target == target ? this : new FieldAccess(this.padding, this.id, this.prefix, this.markers, target, this.name, this.type);
        }

        public Expression getTarget() {
            return this.target;
        }

        @NonNull
        public FieldAccess withType(@Nullable JavaType type) {
            return this.type == type ? this : new FieldAccess(this.padding, this.id, this.prefix, this.markers, this.target, this.name, type);
        }

        @Override
        @Nullable
        public JavaType getType() {
            return this.type;
        }

        public static class Padding {
            private final FieldAccess t;

            public JLeftPadded<Identifier> getName() {
                return this.t.name;
            }

            public FieldAccess withName(JLeftPadded<Identifier> name) {
                return this.t.name == name ? this.t : new FieldAccess(this.t.id, this.t.prefix, this.t.markers, this.t.target, name, this.t.type);
            }

            public Padding(FieldAccess t) {
                this.t = t;
            }
        }
    }

    public static final class EnumValueSet
    implements J,
    Statement {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final List<JRightPadded<EnumValue>> enums;
        private final boolean terminatedWithSemicolon;

        public List<EnumValue> getEnums() {
            return JRightPadded.getElements(this.enums);
        }

        public EnumValueSet withEnums(List<EnumValue> enums) {
            return this.getPadding().withEnums(JRightPadded.withElements(this.enums, enums));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitEnumValueSet(this, p);
        }

        @Override
        public Coordinates.EnumValueSet getCoordinates() {
            return new Coordinates.EnumValueSet(this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @NonNull
        public String toString() {
            return "J.EnumValueSet(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", enums=" + this.getEnums() + ", terminatedWithSemicolon=" + this.isTerminatedWithSemicolon() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EnumValueSet)) {
                return false;
            }
            EnumValueSet other = (EnumValueSet)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public EnumValueSet(UUID id, Space prefix, Markers markers, List<JRightPadded<EnumValue>> enums, boolean terminatedWithSemicolon) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.enums = enums;
            this.terminatedWithSemicolon = terminatedWithSemicolon;
        }

        private EnumValueSet(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, List<JRightPadded<EnumValue>> enums, boolean terminatedWithSemicolon) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.enums = enums;
            this.terminatedWithSemicolon = terminatedWithSemicolon;
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public EnumValueSet withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new EnumValueSet(this.padding, this.id, prefix, this.markers, this.enums, this.terminatedWithSemicolon);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public EnumValueSet withMarkers(Markers markers) {
            return this.markers == markers ? this : new EnumValueSet(this.padding, this.id, this.prefix, markers, this.enums, this.terminatedWithSemicolon);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public EnumValueSet withTerminatedWithSemicolon(boolean terminatedWithSemicolon) {
            return this.terminatedWithSemicolon == terminatedWithSemicolon ? this : new EnumValueSet(this.padding, this.id, this.prefix, this.markers, this.enums, terminatedWithSemicolon);
        }

        public boolean isTerminatedWithSemicolon() {
            return this.terminatedWithSemicolon;
        }

        public static class Padding {
            private final EnumValueSet t;

            public List<JRightPadded<EnumValue>> getEnums() {
                return this.t.enums;
            }

            public EnumValueSet withEnums(List<JRightPadded<EnumValue>> enums) {
                return this.t.enums == enums ? this.t : new EnumValueSet(this.t.id, this.t.prefix, this.t.markers, enums, this.t.terminatedWithSemicolon);
            }

            public Padding(EnumValueSet t) {
                this.t = t;
            }
        }
    }

    public static final class EnumValue
    implements J {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Identifier name;
        @Nullable
        private final NewClass initializer;

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitEnumValue(this, p);
        }

        @Override
        public Coordinates.EnumValue getCoordinates() {
            return new Coordinates.EnumValue(this);
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EnumValue)) {
                return false;
            }
            EnumValue other = (EnumValue)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public EnumValue(UUID id, Space prefix, Markers markers, Identifier name, @Nullable NewClass initializer) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.name = name;
            this.initializer = initializer;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Identifier getName() {
            return this.name;
        }

        @Nullable
        public NewClass getInitializer() {
            return this.initializer;
        }

        @NonNull
        public String toString() {
            return "J.EnumValue(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", name=" + this.getName() + ", initializer=" + this.getInitializer() + ")";
        }

        @NonNull
        public EnumValue withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new EnumValue(this.id, prefix, this.markers, this.name, this.initializer);
        }

        @NonNull
        public EnumValue withMarkers(Markers markers) {
            return this.markers == markers ? this : new EnumValue(this.id, this.prefix, markers, this.name, this.initializer);
        }

        @NonNull
        public EnumValue withName(Identifier name) {
            return this.name == name ? this : new EnumValue(this.id, this.prefix, this.markers, name, this.initializer);
        }

        @NonNull
        public EnumValue withInitializer(@Nullable NewClass initializer) {
            return this.initializer == initializer ? this : new EnumValue(this.id, this.prefix, this.markers, this.name, initializer);
        }
    }

    public static final class Empty
    implements J,
    Statement,
    Expression,
    TypeTree {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;

        @Override
        public JavaType getType() {
            return null;
        }

        public Empty withType(@Nullable JavaType type) {
            return this;
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitEmpty(this, p);
        }

        @Override
        public Coordinates.Empty getCoordinates() {
            return new Coordinates.Empty(this);
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Empty)) {
                return false;
            }
            Empty other = (Empty)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Empty(UUID id, Space prefix, Markers markers) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public String toString() {
            return "J.Empty(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ")";
        }

        @NonNull
        public Empty withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Empty(this.id, prefix, this.markers);
        }

        @NonNull
        public Empty withMarkers(Markers markers) {
            return this.markers == markers ? this : new Empty(this.id, this.prefix, markers);
        }
    }

    public static final class DoWhileLoop
    implements J,
    Statement {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JRightPadded<Statement> body;
        private final JLeftPadded<ControlParentheses<Expression>> whileCondition;

        public Statement getBody() {
            return this.body.getElement();
        }

        public DoWhileLoop withBody(Statement body) {
            return this.getPadding().withBody(this.body.withElement(body));
        }

        public ControlParentheses<Expression> getWhileCondition() {
            return this.whileCondition.getElement();
        }

        public DoWhileLoop withWhileCondition(ControlParentheses<Expression> whileCondition) {
            return this.getPadding().withWhileCondition(this.whileCondition.withElement(whileCondition));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitDoWhileLoop(this, p);
        }

        @Override
        public Coordinates.DoWhileLoop getCoordinates() {
            return new Coordinates.DoWhileLoop(this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @NonNull
        public String toString() {
            return "J.DoWhileLoop(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", body=" + this.getBody() + ", whileCondition=" + this.getWhileCondition() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DoWhileLoop)) {
                return false;
            }
            DoWhileLoop other = (DoWhileLoop)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public DoWhileLoop(UUID id, Space prefix, Markers markers, JRightPadded<Statement> body, JLeftPadded<ControlParentheses<Expression>> whileCondition) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.body = body;
            this.whileCondition = whileCondition;
        }

        private DoWhileLoop(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, JRightPadded<Statement> body, JLeftPadded<ControlParentheses<Expression>> whileCondition) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.body = body;
            this.whileCondition = whileCondition;
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public DoWhileLoop withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new DoWhileLoop(this.padding, this.id, prefix, this.markers, this.body, this.whileCondition);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public DoWhileLoop withMarkers(Markers markers) {
            return this.markers == markers ? this : new DoWhileLoop(this.padding, this.id, this.prefix, markers, this.body, this.whileCondition);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public static class Padding {
            private final DoWhileLoop t;

            public JRightPadded<Statement> getBody() {
                return this.t.body;
            }

            public DoWhileLoop withBody(JRightPadded<Statement> body) {
                return this.t.body == body ? this.t : new DoWhileLoop(this.t.id, this.t.prefix, this.t.markers, body, this.t.whileCondition);
            }

            public JLeftPadded<ControlParentheses<Expression>> getWhileCondition() {
                return this.t.whileCondition;
            }

            public DoWhileLoop withWhileCondition(JLeftPadded<ControlParentheses<Expression>> whileCondition) {
                return this.t.whileCondition == whileCondition ? this.t : new DoWhileLoop(this.t.id, this.t.prefix, this.t.markers, this.t.body, whileCondition);
            }

            public Padding(DoWhileLoop t) {
                this.t = t;
            }
        }
    }

    public static final class Continue
    implements J,
    Statement {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        @Nullable
        private final Identifier label;

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitContinue(this, p);
        }

        @Override
        public Coordinates.Continue getCoordinates() {
            return new Coordinates.Continue(this);
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Continue)) {
                return false;
            }
            Continue other = (Continue)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Continue(UUID id, Space prefix, Markers markers, @Nullable Identifier label) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.label = label;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @Nullable
        public Identifier getLabel() {
            return this.label;
        }

        @NonNull
        public String toString() {
            return "J.Continue(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", label=" + this.getLabel() + ")";
        }

        @NonNull
        public Continue withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Continue(this.id, prefix, this.markers, this.label);
        }

        @NonNull
        public Continue withMarkers(Markers markers) {
            return this.markers == markers ? this : new Continue(this.id, this.prefix, markers, this.label);
        }

        @NonNull
        public Continue withLabel(@Nullable Identifier label) {
            return this.label == label ? this : new Continue(this.id, this.prefix, this.markers, label);
        }
    }

    public static final class CompilationUnit
    implements J,
    SourceFile {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Path sourcePath;
        @Nullable
        private final JRightPadded<Package> packageDeclaration;
        private final List<JRightPadded<Import>> imports;
        private final List<ClassDeclaration> classes;
        private final Space eof;

        @Nullable
        public Package getPackageDeclaration() {
            return this.packageDeclaration == null ? null : this.packageDeclaration.getElement();
        }

        public CompilationUnit withPackageDeclaration(Package packageDeclaration) {
            return this.getPadding().withPackageDeclaration(JRightPadded.withElement(this.packageDeclaration, packageDeclaration));
        }

        public List<Import> getImports() {
            return JRightPadded.getElements(this.imports);
        }

        public CompilationUnit withImports(List<Import> imports) {
            return this.getPadding().withImports(JRightPadded.withElements(this.imports, imports));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitCompilationUnit(this, p);
        }

        @Override
        public Coordinates.CompilationUnit getCoordinates() {
            return new Coordinates.CompilationUnit(this);
        }

        public Set<NameTree> findType(String clazz) {
            return FindTypes.find(this, clazz);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @NonNull
        public String toString() {
            return "J.CompilationUnit(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", sourcePath=" + this.getSourcePath() + ", packageDeclaration=" + this.getPackageDeclaration() + ", imports=" + this.getImports() + ", classes=" + this.getClasses() + ", eof=" + this.getEof() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CompilationUnit)) {
                return false;
            }
            CompilationUnit other = (CompilationUnit)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public CompilationUnit(UUID id, Space prefix, Markers markers, Path sourcePath, @Nullable JRightPadded<Package> packageDeclaration, List<JRightPadded<Import>> imports, List<ClassDeclaration> classes, Space eof) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.sourcePath = sourcePath;
            this.packageDeclaration = packageDeclaration;
            this.imports = imports;
            this.classes = classes;
            this.eof = eof;
        }

        private CompilationUnit(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Path sourcePath, @Nullable JRightPadded<Package> packageDeclaration, List<JRightPadded<Import>> imports, List<ClassDeclaration> classes, Space eof) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.sourcePath = sourcePath;
            this.packageDeclaration = packageDeclaration;
            this.imports = imports;
            this.classes = classes;
            this.eof = eof;
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public CompilationUnit withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new CompilationUnit(this.padding, this.id, prefix, this.markers, this.sourcePath, this.packageDeclaration, this.imports, this.classes, this.eof);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public CompilationUnit withMarkers(Markers markers) {
            return this.markers == markers ? this : new CompilationUnit(this.padding, this.id, this.prefix, markers, this.sourcePath, this.packageDeclaration, this.imports, this.classes, this.eof);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public CompilationUnit withSourcePath(Path sourcePath) {
            return this.sourcePath == sourcePath ? this : new CompilationUnit(this.padding, this.id, this.prefix, this.markers, sourcePath, this.packageDeclaration, this.imports, this.classes, this.eof);
        }

        public Path getSourcePath() {
            return this.sourcePath;
        }

        @NonNull
        public CompilationUnit withClasses(List<ClassDeclaration> classes) {
            return this.classes == classes ? this : new CompilationUnit(this.padding, this.id, this.prefix, this.markers, this.sourcePath, this.packageDeclaration, this.imports, classes, this.eof);
        }

        public List<ClassDeclaration> getClasses() {
            return this.classes;
        }

        @NonNull
        public CompilationUnit withEof(Space eof) {
            return this.eof == eof ? this : new CompilationUnit(this.padding, this.id, this.prefix, this.markers, this.sourcePath, this.packageDeclaration, this.imports, this.classes, eof);
        }

        public Space getEof() {
            return this.eof;
        }

        public static class Padding {
            private final CompilationUnit t;

            @Nullable
            public JRightPadded<Package> getPackageDeclaration() {
                return this.t.packageDeclaration;
            }

            public CompilationUnit withPackageDeclaration(@Nullable JRightPadded<Package> packageDeclaration) {
                return this.t.packageDeclaration == packageDeclaration ? this.t : new CompilationUnit(this.t.id, this.t.prefix, this.t.markers, this.t.sourcePath, packageDeclaration, this.t.imports, this.t.classes, this.t.eof);
            }

            public List<JRightPadded<Import>> getImports() {
                return this.t.imports;
            }

            public CompilationUnit withImports(List<JRightPadded<Import>> imports) {
                return this.t.imports == imports ? this.t : new CompilationUnit(this.t.id, this.t.prefix, this.t.markers, this.t.sourcePath, this.t.packageDeclaration, imports, this.t.classes, this.t.eof);
            }

            public Padding(CompilationUnit t) {
                this.t = t;
            }
        }
    }

    public static final class ClassDeclaration
    implements J,
    Statement {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final List<Annotation> annotations;
        private final List<Modifier> modifiers;
        private final JLeftPadded<Kind> kind;
        private final Identifier name;
        @Nullable
        private final JContainer<TypeParameter> typeParameters;
        @Nullable
        private final JLeftPadded<TypeTree> extendings;
        @Nullable
        private final JContainer<TypeTree> implementings;
        private final Block body;
        @Nullable
        private final JavaType.Class type;

        public Kind getKind() {
            return this.kind.getElement();
        }

        public ClassDeclaration withKind(Kind kind) {
            return this.getPadding().withKind(this.kind.withElement(kind));
        }

        @Nullable
        public List<TypeParameter> getTypeParameters() {
            return this.typeParameters == null ? null : this.typeParameters.getElements();
        }

        public ClassDeclaration withTypeParameters(@Nullable List<TypeParameter> typeParameters) {
            return this.getPadding().withTypeParameters(JContainer.withElementsNullable(this.typeParameters, typeParameters));
        }

        @Nullable
        public TypeTree getExtends() {
            return this.extendings == null ? null : this.extendings.getElement();
        }

        public ClassDeclaration withExtends(@Nullable TypeTree extendings) {
            return this.getPadding().withExtends(JLeftPadded.withElement(this.extendings, extendings));
        }

        @Nullable
        public List<TypeTree> getImplements() {
            return this.implementings == null ? null : this.implementings.getElements();
        }

        public ClassDeclaration withImplements(@Nullable List<TypeTree> implementings) {
            return this.getPadding().withImplements(JContainer.withElementsNullable(this.implementings, implementings));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitClassDeclaration(this, p);
        }

        @Override
        public Coordinates.ClassDeclaration getCoordinates() {
            return new Coordinates.ClassDeclaration(this);
        }

        public String getSimpleName() {
            return this.name.getSimpleName();
        }

        public boolean hasModifier(Modifier.Type modifier) {
            return Modifier.hasModifier(this.getModifiers(), modifier);
        }

        public String toString() {
            return "ClassDeclaration(" + ClassDeclarationToString.toString(this) + ")";
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ClassDeclaration)) {
                return false;
            }
            ClassDeclaration other = (ClassDeclaration)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public ClassDeclaration(UUID id, Space prefix, Markers markers, List<Annotation> annotations, List<Modifier> modifiers, JLeftPadded<Kind> kind, Identifier name, @Nullable JContainer<TypeParameter> typeParameters, @Nullable JLeftPadded<TypeTree> extendings, @Nullable JContainer<TypeTree> implementings, Block body, @Nullable JavaType.Class type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.annotations = annotations;
            this.modifiers = modifiers;
            this.kind = kind;
            this.name = name;
            this.typeParameters = typeParameters;
            this.extendings = extendings;
            this.implementings = implementings;
            this.body = body;
            this.type = type;
        }

        private ClassDeclaration(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, List<Annotation> annotations, List<Modifier> modifiers, JLeftPadded<Kind> kind, Identifier name, @Nullable JContainer<TypeParameter> typeParameters, @Nullable JLeftPadded<TypeTree> extendings, @Nullable JContainer<TypeTree> implementings, Block body, @Nullable JavaType.Class type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.annotations = annotations;
            this.modifiers = modifiers;
            this.kind = kind;
            this.name = name;
            this.typeParameters = typeParameters;
            this.extendings = extendings;
            this.implementings = implementings;
            this.body = body;
            this.type = type;
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public ClassDeclaration withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ClassDeclaration(this.padding, this.id, prefix, this.markers, this.annotations, this.modifiers, this.kind, this.name, this.typeParameters, this.extendings, this.implementings, this.body, this.type);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public ClassDeclaration withMarkers(Markers markers) {
            return this.markers == markers ? this : new ClassDeclaration(this.padding, this.id, this.prefix, markers, this.annotations, this.modifiers, this.kind, this.name, this.typeParameters, this.extendings, this.implementings, this.body, this.type);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public ClassDeclaration withAnnotations(List<Annotation> annotations) {
            return this.annotations == annotations ? this : new ClassDeclaration(this.padding, this.id, this.prefix, this.markers, annotations, this.modifiers, this.kind, this.name, this.typeParameters, this.extendings, this.implementings, this.body, this.type);
        }

        public List<Annotation> getAnnotations() {
            return this.annotations;
        }

        @NonNull
        public ClassDeclaration withModifiers(List<Modifier> modifiers) {
            return this.modifiers == modifiers ? this : new ClassDeclaration(this.padding, this.id, this.prefix, this.markers, this.annotations, modifiers, this.kind, this.name, this.typeParameters, this.extendings, this.implementings, this.body, this.type);
        }

        public List<Modifier> getModifiers() {
            return this.modifiers;
        }

        @NonNull
        public ClassDeclaration withName(Identifier name) {
            return this.name == name ? this : new ClassDeclaration(this.padding, this.id, this.prefix, this.markers, this.annotations, this.modifiers, this.kind, name, this.typeParameters, this.extendings, this.implementings, this.body, this.type);
        }

        public Identifier getName() {
            return this.name;
        }

        @NonNull
        public ClassDeclaration withBody(Block body) {
            return this.body == body ? this : new ClassDeclaration(this.padding, this.id, this.prefix, this.markers, this.annotations, this.modifiers, this.kind, this.name, this.typeParameters, this.extendings, this.implementings, body, this.type);
        }

        public Block getBody() {
            return this.body;
        }

        @NonNull
        public ClassDeclaration withType(@Nullable JavaType.Class type) {
            return this.type == type ? this : new ClassDeclaration(this.padding, this.id, this.prefix, this.markers, this.annotations, this.modifiers, this.kind, this.name, this.typeParameters, this.extendings, this.implementings, this.body, type);
        }

        @Nullable
        public JavaType.Class getType() {
            return this.type;
        }

        public static class Padding {
            private final ClassDeclaration t;

            public JLeftPadded<Kind> getKind() {
                return this.t.kind;
            }

            public ClassDeclaration withKind(JLeftPadded<Kind> kind) {
                return this.t.kind == kind ? this.t : new ClassDeclaration(this.t.id, this.t.prefix, this.t.markers, this.t.annotations, this.t.modifiers, kind, this.t.name, this.t.typeParameters, this.t.extendings, this.t.implementings, this.t.body, this.t.type);
            }

            @Nullable
            public JLeftPadded<TypeTree> getExtends() {
                return this.t.extendings;
            }

            public ClassDeclaration withExtends(@Nullable JLeftPadded<TypeTree> extendings) {
                return this.t.extendings == extendings ? this.t : new ClassDeclaration(this.t.id, this.t.prefix, this.t.markers, this.t.annotations, this.t.modifiers, this.t.kind, this.t.name, this.t.typeParameters, extendings, this.t.implementings, this.t.body, this.t.type);
            }

            @Nullable
            public JContainer<TypeTree> getImplements() {
                return this.t.implementings;
            }

            public ClassDeclaration withImplements(@Nullable JContainer<TypeTree> implementings) {
                return this.t.implementings == implementings ? this.t : new ClassDeclaration(this.t.id, this.t.prefix, this.t.markers, this.t.annotations, this.t.modifiers, this.t.kind, this.t.name, this.t.typeParameters, this.t.extendings, implementings, this.t.body, this.t.type);
            }

            @Nullable
            public JContainer<TypeParameter> getTypeParameters() {
                return this.t.typeParameters;
            }

            public ClassDeclaration withTypeParameters(@Nullable JContainer<TypeParameter> typeParameters) {
                return this.t.typeParameters == typeParameters ? this.t : new ClassDeclaration(this.t.id, this.t.prefix, this.t.markers, this.t.annotations, this.t.modifiers, this.t.kind, this.t.name, typeParameters, this.t.extendings, this.t.implementings, this.t.body, this.t.type);
            }

            public Padding(ClassDeclaration t) {
                this.t = t;
            }
        }

        public static enum Kind {
            Class,
            Enum,
            Interface,
            Annotation;

        }
    }

    public static final class Case
    implements J,
    Statement {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Expression pattern;
        private final JContainer<Statement> statements;

        public List<Statement> getStatements() {
            return this.statements.getElements();
        }

        public Case withStatements(List<Statement> statements) {
            return this.getPadding().withStatements(this.statements.getPadding().withElements(JRightPadded.withElements(this.statements.getPadding().getElements(), statements)));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitCase(this, p);
        }

        @Override
        public Coordinates.Case getCoordinates() {
            return new Coordinates.Case(this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @NonNull
        public String toString() {
            return "J.Case(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", pattern=" + this.getPattern() + ", statements=" + this.getStatements() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Case)) {
                return false;
            }
            Case other = (Case)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Case(UUID id, Space prefix, Markers markers, Expression pattern, JContainer<Statement> statements) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.pattern = pattern;
            this.statements = statements;
        }

        private Case(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Expression pattern, JContainer<Statement> statements) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.pattern = pattern;
            this.statements = statements;
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public Case withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Case(this.padding, this.id, prefix, this.markers, this.pattern, this.statements);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public Case withMarkers(Markers markers) {
            return this.markers == markers ? this : new Case(this.padding, this.id, this.prefix, markers, this.pattern, this.statements);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public Case withPattern(Expression pattern) {
            return this.pattern == pattern ? this : new Case(this.padding, this.id, this.prefix, this.markers, pattern, this.statements);
        }

        public Expression getPattern() {
            return this.pattern;
        }

        public static class Padding {
            private final Case t;

            public JContainer<Statement> getStatements() {
                return this.t.statements;
            }

            public Case withStatements(JContainer<Statement> statements) {
                return this.t.statements == statements ? this.t : new Case(this.t.id, this.t.prefix, this.t.markers, this.t.pattern, statements);
            }

            public Padding(Case t) {
                this.t = t;
            }
        }
    }

    public static final class Break
    implements J,
    Statement {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        @Nullable
        private final Identifier label;

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitBreak(this, p);
        }

        @Override
        public Coordinates.Break getCoordinates() {
            return new Coordinates.Break(this);
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Break)) {
                return false;
            }
            Break other = (Break)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Break(UUID id, Space prefix, Markers markers, @Nullable Identifier label) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.label = label;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @Nullable
        public Identifier getLabel() {
            return this.label;
        }

        @NonNull
        public String toString() {
            return "J.Break(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", label=" + this.getLabel() + ")";
        }

        @NonNull
        public Break withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Break(this.id, prefix, this.markers, this.label);
        }

        @NonNull
        public Break withMarkers(Markers markers) {
            return this.markers == markers ? this : new Break(this.id, this.prefix, markers, this.label);
        }

        @NonNull
        public Break withLabel(@Nullable Identifier label) {
            return this.label == label ? this : new Break(this.id, this.prefix, this.markers, label);
        }
    }

    public static final class Block
    implements J,
    Statement {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JRightPadded<Boolean> statik;
        private final List<JRightPadded<Statement>> statements;
        private final Space end;

        public boolean isStatic() {
            return this.statik.getElement();
        }

        public Block withStatic(boolean statik) {
            return this.getPadding().withStatic(this.statik.withElement(statik));
        }

        public List<Statement> getStatements() {
            return JRightPadded.getElements(this.statements);
        }

        public Block withStatements(List<Statement> statements) {
            return this.getPadding().withStatements(JRightPadded.withElements(this.statements, statements));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitBlock(this, p);
        }

        @Override
        public Coordinates.Block getCoordinates() {
            return new Coordinates.Block(this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @NonNull
        public String toString() {
            return "J.Block(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", statik=" + this.statik + ", statements=" + this.getStatements() + ", end=" + this.getEnd() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Block)) {
                return false;
            }
            Block other = (Block)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Block(UUID id, Space prefix, Markers markers, JRightPadded<Boolean> statik, List<JRightPadded<Statement>> statements, Space end) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.statik = statik;
            this.statements = statements;
            this.end = end;
        }

        private Block(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, JRightPadded<Boolean> statik, List<JRightPadded<Statement>> statements, Space end) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.statik = statik;
            this.statements = statements;
            this.end = end;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public Block withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Block(this.padding, this.id, prefix, this.markers, this.statik, this.statements, this.end);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public Block withMarkers(Markers markers) {
            return this.markers == markers ? this : new Block(this.padding, this.id, this.prefix, markers, this.statik, this.statements, this.end);
        }

        public Space getEnd() {
            return this.end;
        }

        @NonNull
        public Block withEnd(Space end) {
            return this.end == end ? this : new Block(this.padding, this.id, this.prefix, this.markers, this.statik, this.statements, end);
        }

        public static class Padding {
            private final Block t;

            public JRightPadded<Boolean> getStatic() {
                return this.t.statik;
            }

            public Block withStatic(JRightPadded<Boolean> statik) {
                return this.t.statik == statik ? this.t : new Block(this.t.id, this.t.prefix, this.t.markers, statik, this.t.statements, this.t.end);
            }

            public List<JRightPadded<Statement>> getStatements() {
                return this.t.statements;
            }

            public Block withStatements(List<JRightPadded<Statement>> statements) {
                return this.t.statements == statements ? this.t : new Block(this.t.id, this.t.prefix, this.t.markers, this.t.statik, statements, this.t.end);
            }

            public Padding(Block t) {
                this.t = t;
            }
        }
    }

    public static final class Binary
    implements J,
    Expression {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Expression left;
        private final JLeftPadded<Type> operator;
        private final Expression right;
        @Nullable
        private final JavaType type;

        public Type getOperator() {
            return this.operator.getElement();
        }

        public Binary withOperator(Type operator) {
            return this.getPadding().withOperator(this.operator.withElement(operator));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitBinary(this, p);
        }

        @Override
        public Coordinates.Binary getCoordinates() {
            return new Coordinates.Binary(this);
        }

        @Override
        public List<Tree> getSideEffects() {
            ArrayList<Tree> sideEffects = new ArrayList<Tree>(2);
            sideEffects.addAll(this.left.getSideEffects());
            sideEffects.addAll(this.right.getSideEffects());
            return sideEffects;
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Binary)) {
                return false;
            }
            Binary other = (Binary)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Binary(UUID id, Space prefix, Markers markers, Expression left, JLeftPadded<Type> operator, Expression right, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.left = left;
            this.operator = operator;
            this.right = right;
            this.type = type;
        }

        private Binary(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Expression left, JLeftPadded<Type> operator, Expression right, @Nullable JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.left = left;
            this.operator = operator;
            this.right = right;
            this.type = type;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Expression getLeft() {
            return this.left;
        }

        public Expression getRight() {
            return this.right;
        }

        @Override
        @Nullable
        public JavaType getType() {
            return this.type;
        }

        public void setPadding(@Nullable WeakReference<Padding> padding) {
            this.padding = padding;
        }

        @NonNull
        public String toString() {
            return "J.Binary(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", left=" + this.getLeft() + ", operator=" + (Object)((Object)this.getOperator()) + ", right=" + this.getRight() + ", type=" + this.getType() + ")";
        }

        @NonNull
        public Binary withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Binary(this.padding, this.id, prefix, this.markers, this.left, this.operator, this.right, this.type);
        }

        @NonNull
        public Binary withMarkers(Markers markers) {
            return this.markers == markers ? this : new Binary(this.padding, this.id, this.prefix, markers, this.left, this.operator, this.right, this.type);
        }

        @NonNull
        public Binary withLeft(Expression left) {
            return this.left == left ? this : new Binary(this.padding, this.id, this.prefix, this.markers, left, this.operator, this.right, this.type);
        }

        @NonNull
        public Binary withRight(Expression right) {
            return this.right == right ? this : new Binary(this.padding, this.id, this.prefix, this.markers, this.left, this.operator, right, this.type);
        }

        @NonNull
        public Binary withType(@Nullable JavaType type) {
            return this.type == type ? this : new Binary(this.padding, this.id, this.prefix, this.markers, this.left, this.operator, this.right, type);
        }

        public static class Padding {
            private final Binary t;

            public JLeftPadded<Type> getOperator() {
                return this.t.operator;
            }

            public Binary withOperator(JLeftPadded<Type> operator) {
                return this.t.operator == operator ? this.t : new Binary(this.t.id, this.t.prefix, this.t.markers, this.t.left, operator, this.t.right, this.t.type);
            }

            public Padding(Binary t) {
                this.t = t;
            }
        }

        public static enum Type {
            Addition,
            Subtraction,
            Multiplication,
            Division,
            Modulo,
            LessThan,
            GreaterThan,
            LessThanOrEqual,
            GreaterThanOrEqual,
            Equal,
            NotEqual,
            BitAnd,
            BitOr,
            BitXor,
            LeftShift,
            RightShift,
            UnsignedRightShift,
            Or,
            And;

        }
    }

    public static final class AssignmentOperation
    implements J,
    Statement,
    Expression {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Expression variable;
        private final JLeftPadded<Type> operator;
        private final Expression assignment;
        @Nullable
        private final JavaType type;

        public Type getOperator() {
            return this.operator.getElement();
        }

        public AssignmentOperation withOperator(Type operator) {
            return this.getPadding().withOperator(this.operator.withElement(operator));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitAssignmentOperation(this, p);
        }

        @Override
        public Coordinates.AssignmentOperation getCoordinates() {
            return new Coordinates.AssignmentOperation(this);
        }

        @Override
        public List<Tree> getSideEffects() {
            return Collections.singletonList(this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @NonNull
        public String toString() {
            return "J.AssignmentOperation(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", variable=" + this.getVariable() + ", operator=" + (Object)((Object)this.getOperator()) + ", assignment=" + this.getAssignment() + ", type=" + this.getType() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AssignmentOperation)) {
                return false;
            }
            AssignmentOperation other = (AssignmentOperation)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public AssignmentOperation(UUID id, Space prefix, Markers markers, Expression variable, JLeftPadded<Type> operator, Expression assignment, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.variable = variable;
            this.operator = operator;
            this.assignment = assignment;
            this.type = type;
        }

        private AssignmentOperation(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Expression variable, JLeftPadded<Type> operator, Expression assignment, @Nullable JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.variable = variable;
            this.operator = operator;
            this.assignment = assignment;
            this.type = type;
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public AssignmentOperation withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new AssignmentOperation(this.padding, this.id, prefix, this.markers, this.variable, this.operator, this.assignment, this.type);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public AssignmentOperation withMarkers(Markers markers) {
            return this.markers == markers ? this : new AssignmentOperation(this.padding, this.id, this.prefix, markers, this.variable, this.operator, this.assignment, this.type);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public AssignmentOperation withVariable(Expression variable) {
            return this.variable == variable ? this : new AssignmentOperation(this.padding, this.id, this.prefix, this.markers, variable, this.operator, this.assignment, this.type);
        }

        public Expression getVariable() {
            return this.variable;
        }

        @NonNull
        public AssignmentOperation withAssignment(Expression assignment) {
            return this.assignment == assignment ? this : new AssignmentOperation(this.padding, this.id, this.prefix, this.markers, this.variable, this.operator, assignment, this.type);
        }

        public Expression getAssignment() {
            return this.assignment;
        }

        @NonNull
        public AssignmentOperation withType(@Nullable JavaType type) {
            return this.type == type ? this : new AssignmentOperation(this.padding, this.id, this.prefix, this.markers, this.variable, this.operator, this.assignment, type);
        }

        @Override
        @Nullable
        public JavaType getType() {
            return this.type;
        }

        public static class Padding {
            private final AssignmentOperation t;

            public JLeftPadded<Type> getOperator() {
                return this.t.operator;
            }

            public AssignmentOperation withOperator(JLeftPadded<Type> operator) {
                return this.t.operator == operator ? this.t : new AssignmentOperation(this.t.id, this.t.prefix, this.t.markers, this.t.variable, operator, this.t.assignment, this.t.type);
            }

            public Padding(AssignmentOperation t) {
                this.t = t;
            }
        }

        public static enum Type {
            Addition,
            Subtraction,
            Multiplication,
            Division,
            Modulo,
            BitAnd,
            BitOr,
            BitXor,
            LeftShift,
            RightShift,
            UnsignedRightShift;

        }
    }

    public static final class Assignment
    implements J,
    Statement,
    Expression {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Expression variable;
        private final JLeftPadded<Expression> assignment;
        @Nullable
        private final JavaType type;

        public Expression getAssignment() {
            return this.assignment.getElement();
        }

        public Assignment withAssignment(Expression assignment) {
            return this.getPadding().withAssignment(this.assignment.withElement(assignment));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitAssignment(this, p);
        }

        @Override
        public Coordinates.Assignment getCoordinates() {
            return new Coordinates.Assignment(this);
        }

        @Override
        public List<Tree> getSideEffects() {
            return Collections.singletonList(this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @NonNull
        public String toString() {
            return "J.Assignment(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", variable=" + this.getVariable() + ", assignment=" + this.getAssignment() + ", type=" + this.getType() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Assignment)) {
                return false;
            }
            Assignment other = (Assignment)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Assignment(UUID id, Space prefix, Markers markers, Expression variable, JLeftPadded<Expression> assignment, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.variable = variable;
            this.assignment = assignment;
            this.type = type;
        }

        private Assignment(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Expression variable, JLeftPadded<Expression> assignment, @Nullable JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.variable = variable;
            this.assignment = assignment;
            this.type = type;
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public Assignment withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Assignment(this.padding, this.id, prefix, this.markers, this.variable, this.assignment, this.type);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public Assignment withMarkers(Markers markers) {
            return this.markers == markers ? this : new Assignment(this.padding, this.id, this.prefix, markers, this.variable, this.assignment, this.type);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public Assignment withVariable(Expression variable) {
            return this.variable == variable ? this : new Assignment(this.padding, this.id, this.prefix, this.markers, variable, this.assignment, this.type);
        }

        public Expression getVariable() {
            return this.variable;
        }

        @NonNull
        public Assignment withType(@Nullable JavaType type) {
            return this.type == type ? this : new Assignment(this.padding, this.id, this.prefix, this.markers, this.variable, this.assignment, type);
        }

        @Override
        @Nullable
        public JavaType getType() {
            return this.type;
        }

        public static class Padding {
            private final Assignment t;

            public JLeftPadded<Expression> getAssignment() {
                return this.t.assignment;
            }

            public Assignment withAssignment(JLeftPadded<Expression> assignment) {
                return this.t.assignment == assignment ? this.t : new Assignment(this.t.id, this.t.prefix, this.t.markers, this.t.variable, assignment, this.t.type);
            }

            public Padding(Assignment t) {
                this.t = t;
            }
        }
    }

    public static final class Assert
    implements J,
    Statement {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Expression condition;

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitAssert(this, p);
        }

        @Override
        public Coordinates.Assert getCoordinates() {
            return new Coordinates.Assert(this);
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Assert)) {
                return false;
            }
            Assert other = (Assert)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Assert(UUID id, Space prefix, Markers markers, Expression condition) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.condition = condition;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Expression getCondition() {
            return this.condition;
        }

        @NonNull
        public String toString() {
            return "J.Assert(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", condition=" + this.getCondition() + ")";
        }

        @NonNull
        public Assert withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Assert(this.id, prefix, this.markers, this.condition);
        }

        @NonNull
        public Assert withMarkers(Markers markers) {
            return this.markers == markers ? this : new Assert(this.id, this.prefix, markers, this.condition);
        }

        @NonNull
        public Assert withCondition(Expression condition) {
            return this.condition == condition ? this : new Assert(this.id, this.prefix, this.markers, condition);
        }
    }

    public static final class ArrayType
    implements J,
    TypeTree,
    Expression {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final TypeTree elementType;
        private final List<JRightPadded<Space>> dimensions;

        @Override
        public JavaType getType() {
            return this.elementType.getType();
        }

        public ArrayType withType(@Nullable JavaType type) {
            return type == this.getType() ? this : this.withElementType((TypeTree)this.elementType.withType(type));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitArrayType(this, p);
        }

        @Override
        public Coordinates.ArrayType getCoordinates() {
            return new Coordinates.ArrayType(this);
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ArrayType)) {
                return false;
            }
            ArrayType other = (ArrayType)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public ArrayType(UUID id, Space prefix, Markers markers, TypeTree elementType, List<JRightPadded<Space>> dimensions) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.elementType = elementType;
            this.dimensions = dimensions;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public TypeTree getElementType() {
            return this.elementType;
        }

        public List<JRightPadded<Space>> getDimensions() {
            return this.dimensions;
        }

        @NonNull
        public String toString() {
            return "J.ArrayType(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", elementType=" + this.getElementType() + ", dimensions=" + this.getDimensions() + ")";
        }

        @NonNull
        public ArrayType withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ArrayType(this.id, prefix, this.markers, this.elementType, this.dimensions);
        }

        @NonNull
        public ArrayType withMarkers(Markers markers) {
            return this.markers == markers ? this : new ArrayType(this.id, this.prefix, markers, this.elementType, this.dimensions);
        }

        @NonNull
        public ArrayType withElementType(TypeTree elementType) {
            return this.elementType == elementType ? this : new ArrayType(this.id, this.prefix, this.markers, elementType, this.dimensions);
        }

        @NonNull
        public ArrayType withDimensions(List<JRightPadded<Space>> dimensions) {
            return this.dimensions == dimensions ? this : new ArrayType(this.id, this.prefix, this.markers, this.elementType, dimensions);
        }
    }

    public static final class ArrayAccess
    implements J,
    Expression {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Expression indexed;
        private final ArrayDimension dimension;
        @Nullable
        private final JavaType type;

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitArrayAccess(this, p);
        }

        @Override
        public Coordinates.ArrayAccess getCoordinates() {
            return new Coordinates.ArrayAccess(this);
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ArrayAccess)) {
                return false;
            }
            ArrayAccess other = (ArrayAccess)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public ArrayAccess(UUID id, Space prefix, Markers markers, Expression indexed, ArrayDimension dimension, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.indexed = indexed;
            this.dimension = dimension;
            this.type = type;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Expression getIndexed() {
            return this.indexed;
        }

        public ArrayDimension getDimension() {
            return this.dimension;
        }

        @Override
        @Nullable
        public JavaType getType() {
            return this.type;
        }

        @NonNull
        public String toString() {
            return "J.ArrayAccess(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", indexed=" + this.getIndexed() + ", dimension=" + this.getDimension() + ", type=" + this.getType() + ")";
        }

        @NonNull
        public ArrayAccess withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ArrayAccess(this.id, prefix, this.markers, this.indexed, this.dimension, this.type);
        }

        @NonNull
        public ArrayAccess withMarkers(Markers markers) {
            return this.markers == markers ? this : new ArrayAccess(this.id, this.prefix, markers, this.indexed, this.dimension, this.type);
        }

        @NonNull
        public ArrayAccess withIndexed(Expression indexed) {
            return this.indexed == indexed ? this : new ArrayAccess(this.id, this.prefix, this.markers, indexed, this.dimension, this.type);
        }

        @NonNull
        public ArrayAccess withDimension(ArrayDimension dimension) {
            return this.dimension == dimension ? this : new ArrayAccess(this.id, this.prefix, this.markers, this.indexed, dimension, this.type);
        }

        @NonNull
        public ArrayAccess withType(@Nullable JavaType type) {
            return this.type == type ? this : new ArrayAccess(this.id, this.prefix, this.markers, this.indexed, this.dimension, type);
        }
    }

    public static final class Annotation
    implements J,
    Expression {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final NameTree annotationType;
        @Nullable
        private final JContainer<Expression> arguments;

        public String getSimpleName() {
            return this.annotationType instanceof Identifier ? ((Identifier)this.annotationType).getSimpleName() : ((FieldAccess)this.annotationType).getSimpleName();
        }

        @Nullable
        public List<Expression> getArguments() {
            return this.arguments == null ? null : this.arguments.getElements();
        }

        public Annotation withArguments(@Nullable List<Expression> arguments) {
            return this.getPadding().withArguments(JContainer.withElementsNullable(this.arguments, arguments));
        }

        @Override
        public JavaType getType() {
            return this.annotationType.getType();
        }

        public Annotation withType(@Nullable JavaType type) {
            return this.withAnnotationType((NameTree)this.annotationType.withType(type));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitAnnotation(this, p);
        }

        @Override
        public Coordinates.Annotation getCoordinates() {
            return new Coordinates.Annotation(this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @NonNull
        public String toString() {
            return "J.Annotation(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", annotationType=" + this.getAnnotationType() + ", arguments=" + this.getArguments() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Annotation)) {
                return false;
            }
            Annotation other = (Annotation)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Annotation(UUID id, Space prefix, Markers markers, NameTree annotationType, @Nullable JContainer<Expression> arguments) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.annotationType = annotationType;
            this.arguments = arguments;
        }

        private Annotation(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, NameTree annotationType, @Nullable JContainer<Expression> arguments) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.annotationType = annotationType;
            this.arguments = arguments;
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public Annotation withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Annotation(this.padding, this.id, prefix, this.markers, this.annotationType, this.arguments);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public Annotation withMarkers(Markers markers) {
            return this.markers == markers ? this : new Annotation(this.padding, this.id, this.prefix, markers, this.annotationType, this.arguments);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public Annotation withAnnotationType(NameTree annotationType) {
            return this.annotationType == annotationType ? this : new Annotation(this.padding, this.id, this.prefix, this.markers, annotationType, this.arguments);
        }

        public NameTree getAnnotationType() {
            return this.annotationType;
        }

        public static class Padding {
            private final Annotation t;

            @Nullable
            public JContainer<Expression> getArguments() {
                return this.t.arguments;
            }

            public Annotation withArguments(@Nullable JContainer<Expression> arguments) {
                return this.t.arguments == arguments ? this.t : new Annotation(this.t.id, this.t.prefix, this.t.markers, this.t.annotationType, arguments);
            }

            public Padding(Annotation t) {
                this.t = t;
            }
        }
    }

    public static final class AnnotatedType
    implements J,
    Expression,
    TypeTree {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final List<Annotation> annotations;
        private final TypeTree typeExpression;

        @Override
        public JavaType getType() {
            return this.typeExpression.getType();
        }

        public AnnotatedType withType(@Nullable JavaType type) {
            return this.withTypeExpression((TypeTree)this.typeExpression.withType(type));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitAnnotatedType(this, p);
        }

        @Override
        public Coordinates.AnnotatedType getCoordinates() {
            return new Coordinates.AnnotatedType(this);
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AnnotatedType)) {
                return false;
            }
            AnnotatedType other = (AnnotatedType)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public AnnotatedType(UUID id, Space prefix, Markers markers, List<Annotation> annotations, TypeTree typeExpression) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.annotations = annotations;
            this.typeExpression = typeExpression;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Annotation> getAnnotations() {
            return this.annotations;
        }

        public TypeTree getTypeExpression() {
            return this.typeExpression;
        }

        @NonNull
        public String toString() {
            return "J.AnnotatedType(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", annotations=" + this.getAnnotations() + ", typeExpression=" + this.getTypeExpression() + ")";
        }

        @NonNull
        public AnnotatedType withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new AnnotatedType(this.id, prefix, this.markers, this.annotations, this.typeExpression);
        }

        @NonNull
        public AnnotatedType withMarkers(Markers markers) {
            return this.markers == markers ? this : new AnnotatedType(this.id, this.prefix, markers, this.annotations, this.typeExpression);
        }

        @NonNull
        public AnnotatedType withAnnotations(List<Annotation> annotations) {
            return this.annotations == annotations ? this : new AnnotatedType(this.id, this.prefix, this.markers, annotations, this.typeExpression);
        }

        @NonNull
        public AnnotatedType withTypeExpression(TypeTree typeExpression) {
            return this.typeExpression == typeExpression ? this : new AnnotatedType(this.id, this.prefix, this.markers, this.annotations, typeExpression);
        }
    }
}

