/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.util.Comparator;
import java.util.stream.Stream;
import org.openrewrite.Incubating;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

@Incubating(since="7.0.0")
public class CovariantEqualsVisitor<P>
extends JavaIsoVisitor<P> {
    private static final MethodMatcher OBJECT_EQUALS_SIGNATURE = new MethodMatcher("* equals(java.lang.Object)");

    @Override
    public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, P p) {
        J cd = super.visitClassDeclaration(classDecl, (Object)p);
        Stream<J.MethodDeclaration> mds = ((J.ClassDeclaration)cd).getBody().getStatements().stream().filter(J.MethodDeclaration.class::isInstance).map(J.MethodDeclaration.class::cast);
        if (mds.noneMatch(m -> OBJECT_EQUALS_SIGNATURE.matches((J.MethodDeclaration)m, classDecl))) {
            cd = (J.ClassDeclaration)new ChangeCovariantEqualsMethodVisitor((J.ClassDeclaration)cd).visit(cd, p, this.getCursor());
            assert (cd != null);
        }
        return cd;
    }

    private static class ChangeCovariantEqualsMethodVisitor<P>
    extends JavaIsoVisitor<P> {
        private static final AnnotationMatcher OVERRIDE_ANNOTATION_SIGNATURE = new AnnotationMatcher("@java.lang.Override");
        private static final String EQUALS_BODY_PREFIX_TEMPLATE = "if (#{} == this) return true;\nif (#{} == null || getClass() != #{}.getClass()) return false;\n#{} #{} = (#{}) #{};\n";
        private final J.ClassDeclaration enclosingClass;

        public ChangeCovariantEqualsMethodVisitor(J.ClassDeclaration enclosingClass) {
            this.enclosingClass = enclosingClass;
        }

        @Override
        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, P p) {
            J m = super.visitMethodDeclaration(method, (Object)p);
            JavaType.Class type = this.enclosingClass.getType();
            if (type == null) {
                return m;
            }
            String ecfqn = type.getFullyQualifiedName();
            if (new MethodMatcher(String.format("%s equals(%s)", ecfqn, ecfqn)).matches((J.MethodDeclaration)m, this.enclosingClass) && ((J.MethodDeclaration)m).hasModifier(J.Modifier.Type.Public) && ((J.MethodDeclaration)m).getReturnTypeExpression() != null && JavaType.Primitive.Boolean.equals(((J.MethodDeclaration)m).getReturnTypeExpression().getType())) {
                J.VariableDeclarations.NamedVariable oldParamName;
                if (((J.MethodDeclaration)m).getAnnotations().stream().noneMatch(OVERRIDE_ANNOTATION_SIGNATURE::matches)) {
                    m = this.maybeAutoFormat(m, (J.MethodDeclaration)m.withTemplate(this.template("@Override").build(), ((J.MethodDeclaration)m).getCoordinates().addAnnotation(Comparator.comparing(J.Annotation::getSimpleName)), new Object[0]), p, this.getCursor().getParentOrThrow());
                }
                String paramName = "obj".equals((oldParamName = ((J.VariableDeclarations)((J.MethodDeclaration)m).getParameters().iterator().next()).getVariables().iterator().next()).getSimpleName()) ? "other" : "obj";
                m = this.maybeAutoFormat(m, (J.MethodDeclaration)m.withTemplate(this.template("(Object #{})").build(), ((J.MethodDeclaration)m).getCoordinates().replaceParameters(), paramName), p, this.getCursor().getParentOrThrow());
                JavaTemplate equalsBodySnippet = this.template(EQUALS_BODY_PREFIX_TEMPLATE).build();
                assert (((J.MethodDeclaration)m).getBody() != null);
                Object[] params = new Object[]{paramName, paramName, paramName, this.enclosingClass.getSimpleName(), oldParamName.printTrimmed(), this.enclosingClass.getSimpleName(), paramName};
                m = this.maybeAutoFormat(m, (J.MethodDeclaration)m.withTemplate(equalsBodySnippet, ((J.MethodDeclaration)m).getBody().getStatements().get(0).getCoordinates().before(), params), p, this.getCursor().getParentOrThrow());
            }
            return m;
        }
    }
}

