/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.AddImport;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

public class UseStaticImport
extends Recipe {
    private final String methodPattern;

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new UseStaticImportVisitor(new MethodMatcher(this.methodPattern));
    }

    public UseStaticImport(String methodPattern) {
        this.methodPattern = methodPattern;
    }

    public String getMethodPattern() {
        return this.methodPattern;
    }

    @NonNull
    public String toString() {
        return "UseStaticImport(methodPattern=" + this.getMethodPattern() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UseStaticImport)) {
            return false;
        }
        UseStaticImport other = (UseStaticImport)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$methodPattern = this.getMethodPattern();
        String other$methodPattern = other.getMethodPattern();
        return !(this$methodPattern == null ? other$methodPattern != null : !this$methodPattern.equals(other$methodPattern));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof UseStaticImport;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $methodPattern = this.getMethodPattern();
        result = result * 59 + ($methodPattern == null ? 43 : $methodPattern.hashCode());
        return result;
    }

    private static class UseStaticImportVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private final MethodMatcher methodMatcher;

        private UseStaticImportVisitor(MethodMatcher methodMatcher) {
            this.methodMatcher = methodMatcher;
        }

        @Override
        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J m = super.visitMethodInvocation(method, ctx);
            if (this.methodMatcher.matches((J.MethodInvocation)m) && ((J.MethodInvocation)m).getSelect() != null) {
                if (((J.MethodInvocation)m).getType() != null) {
                    JavaType.FullyQualified receiverType = ((J.MethodInvocation)m).getType().getDeclaringType();
                    this.maybeRemoveImport(receiverType);
                    AddImport addStatic = new AddImport(receiverType.getFullyQualifiedName(), ((J.MethodInvocation)m).getSimpleName(), false);
                    if (!this.getAfterVisit().contains((Object)addStatic)) {
                        this.doAfterVisit(addStatic);
                    }
                }
                m = ((J.MethodInvocation)m).withSelect(null).withName(((J.MethodInvocation)m).getName().withPrefix(((J.MethodInvocation)m).getSelect().getPrefix()));
            }
            return m;
        }
    }
}

