/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.Space;

@JsonDeserialize(builder=Builder.class)
public class ReorderMethodArguments
extends Recipe {
    private final String methodPattern;
    private final String[] newParameterNames;
    @Nullable
    private String[] oldParameterNames;

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new ReorderMethodArgumentsVisitor(new MethodMatcher(this.methodPattern));
    }

    ReorderMethodArguments(String methodPattern, String[] newParameterNames, @Nullable String[] oldParameterNames) {
        this.methodPattern = methodPattern;
        this.newParameterNames = newParameterNames;
        this.oldParameterNames = oldParameterNames;
    }

    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    @NonNull
    public Builder toBuilder() {
        return new Builder().methodPattern(this.methodPattern).newParameterNames(this.newParameterNames).oldParameterNames(this.oldParameterNames);
    }

    public String getMethodPattern() {
        return this.methodPattern;
    }

    public String[] getNewParameterNames() {
        return this.newParameterNames;
    }

    @Nullable
    public String[] getOldParameterNames() {
        return this.oldParameterNames;
    }

    public void setOldParameterNames(@Nullable String[] oldParameterNames) {
        this.oldParameterNames = oldParameterNames;
    }

    @NonNull
    public String toString() {
        return "ReorderMethodArguments(methodPattern=" + this.getMethodPattern() + ", newParameterNames=" + Arrays.deepToString(this.getNewParameterNames()) + ", oldParameterNames=" + Arrays.deepToString(this.getOldParameterNames()) + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReorderMethodArguments)) {
            return false;
        }
        ReorderMethodArguments other = (ReorderMethodArguments)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$methodPattern = this.getMethodPattern();
        String other$methodPattern = other.getMethodPattern();
        if (this$methodPattern == null ? other$methodPattern != null : !this$methodPattern.equals(other$methodPattern)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getNewParameterNames(), other.getNewParameterNames())) {
            return false;
        }
        return Arrays.deepEquals(this.getOldParameterNames(), other.getOldParameterNames());
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ReorderMethodArguments;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $methodPattern = this.getMethodPattern();
        result = result * 59 + ($methodPattern == null ? 43 : $methodPattern.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getNewParameterNames());
        result = result * 59 + Arrays.deepHashCode(this.getOldParameterNames());
        return result;
    }

    private class ReorderMethodArgumentsVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private final MethodMatcher methodMatcher;

        private ReorderMethodArgumentsVisitor(MethodMatcher methodMatcher) {
            this.methodMatcher = methodMatcher;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J m = super.visitMethodInvocation(method, ctx);
            if (this.methodMatcher.matches((J.MethodInvocation)m) && ((J.MethodInvocation)m).getType() != null) {
                void var13_16;
                List<String> paramNames;
                List<String> list = paramNames = ReorderMethodArguments.this.oldParameterNames == null || ReorderMethodArguments.this.oldParameterNames.length == 0 ? ((J.MethodInvocation)m).getType().getParamNames() : Arrays.asList(ReorderMethodArguments.this.oldParameterNames);
                if (paramNames == null) {
                    throw new IllegalStateException("There is no source attachment for method " + ((J.MethodInvocation)m).getType().getDeclaringType().getFullyQualifiedName() + "." + ((J.MethodInvocation)m).getSimpleName() + "(..). Provide a reference for original parameter names by calling setOriginalParamNames(..)");
                }
                List<JRightPadded<Expression>> originalArgs = ((J.MethodInvocation)m).getPadding().getArguments().getPadding().getElements();
                int resolvedParamCount = ((J.MethodInvocation)m).getType().getResolvedSignature() == null ? originalArgs.size() : ((J.MethodInvocation)m).getType().getResolvedSignature().getParamTypes().size();
                int i = 0;
                ArrayList reordered = new ArrayList(originalArgs.size());
                ArrayList<Space> formattings = new ArrayList<Space>(originalArgs.size());
                ArrayList<Space> rightFormattings = new ArrayList<Space>(originalArgs.size());
                String[] stringArray = ReorderMethodArguments.this.newParameterNames;
                int n = stringArray.length;
                boolean bl = false;
                while (var13_16 < n) {
                    String name = stringArray[var13_16];
                    int fromPos = paramNames.indexOf(name);
                    if (originalArgs.size() > resolvedParamCount && fromPos == resolvedParamCount - 1) {
                        List<JRightPadded<Expression>> varargs = originalArgs.subList(fromPos, originalArgs.size());
                        reordered.addAll(varargs);
                        for (JRightPadded<Expression> exp : originalArgs.subList(i, i++ + varargs.size())) {
                            formattings.add(exp.getElement().getPrefix());
                            rightFormattings.add(exp.getAfter());
                        }
                    } else if (fromPos >= 0 && originalArgs.size() > fromPos) {
                        reordered.add(originalArgs.get(fromPos));
                        formattings.add(originalArgs.get(i).getElement().getPrefix());
                        rightFormattings.add(originalArgs.get(i++).getAfter());
                    }
                    ++var13_16;
                }
                boolean changed = false;
                i = 0;
                for (JRightPadded jRightPadded : reordered) {
                    int index = i;
                    reordered.set(i, jRightPadded.map(e -> (Expression)e.withPrefix((Space)formattings.get(index))).withAfter((Space)rightFormattings.get(index)));
                    if (reordered.get(i) != originalArgs.get(i)) {
                        changed = true;
                    }
                    ++i;
                }
                if (changed) {
                    m = ((J.MethodInvocation)m).getPadding().withArguments(((J.MethodInvocation)m).getPadding().getArguments().getPadding().withElements(reordered));
                }
            }
            return m;
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        private String methodPattern;
        private String[] newParameterNames;
        private String[] oldParameterNames;

        Builder() {
        }

        @NonNull
        public Builder methodPattern(String methodPattern) {
            this.methodPattern = methodPattern;
            return this;
        }

        @NonNull
        public Builder newParameterNames(String[] newParameterNames) {
            this.newParameterNames = newParameterNames;
            return this;
        }

        @NonNull
        public Builder oldParameterNames(@Nullable String[] oldParameterNames) {
            this.oldParameterNames = oldParameterNames;
            return this;
        }

        @NonNull
        public ReorderMethodArguments build() {
            return new ReorderMethodArguments(this.methodPattern, this.newParameterNames, this.oldParameterNames);
        }

        @NonNull
        public String toString() {
            return "ReorderMethodArguments.Builder(methodPattern=" + this.methodPattern + ", newParameterNames=" + Arrays.deepToString(this.newParameterNames) + ", oldParameterNames=" + Arrays.deepToString(this.oldParameterNames) + ")";
        }
    }
}

