/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.marker.Markable;
import org.openrewrite.marker.Markers;

@JsonIdentityInfo(generator=ObjectIdGenerators.IntSequenceGenerator.class, property="@ref")
public class Space
implements Markable {
    public static final Space EMPTY = new Space("", Collections.emptyList(), Markers.EMPTY);
    private static final Map<String, Space> flyweights = new WeakHashMap<String, Space>();
    private final List<Comment> comments;
    @Nullable
    private final String whitespace;
    private final Markers markers;
    private static final String[] spaces = new String[]{"\u00b7\u2081", "\u00b7\u2082", "\u00b7\u2083", "\u00b7\u2084", "\u00b7\u2085", "\u00b7\u2086", "\u00b7\u2087", "\u00b7\u2088", "\u00b7\u2089", "\u00b7\u208a"};
    private static final String[] tabs = new String[]{"-\u2081", "-\u2082", "-\u2083", "-\u2084", "-\u2085", "-\u2086", "-\u2087", "-\u2088", "-\u2089", "-\u208a"};

    private Space(@Nullable String whitespace, List<Comment> comments, Markers markers) {
        this.comments = comments;
        this.whitespace = whitespace == null || whitespace.isEmpty() ? null : whitespace;
        this.markers = markers;
    }

    @JsonCreator
    public static Space build(@Nullable String whitespace, List<Comment> comments, Markers markers) {
        if (comments.isEmpty() && (whitespace == null || whitespace.isEmpty())) {
            if (markers == Markers.EMPTY) {
                return EMPTY;
            }
            return flyweights.computeIfAbsent(whitespace == null ? "" : whitespace, ws -> new Space((String)ws, Collections.emptyList(), Markers.EMPTY));
        }
        return new Space(whitespace, comments, markers);
    }

    public String getIndent() {
        if (!this.comments.isEmpty()) {
            return this.getWhitespaceIndent(this.comments.get(this.comments.size() - 1).getSuffix());
        }
        return this.getWhitespaceIndent(this.whitespace);
    }

    public String getLastWhitespace() {
        if (!this.comments.isEmpty()) {
            return this.comments.get(this.comments.size() - 1).getSuffix();
        }
        return this.whitespace == null ? "" : this.whitespace;
    }

    private String getWhitespaceIndent(@Nullable String whitespace) {
        if (whitespace == null) {
            return "";
        }
        int lastNewline = whitespace.lastIndexOf(10);
        if (lastNewline >= 0) {
            return whitespace.substring(lastNewline + 1);
        }
        if (lastNewline == whitespace.length() - 1) {
            return "";
        }
        return whitespace;
    }

    public List<Comment> getComments() {
        return this.comments;
    }

    public String getWhitespace() {
        return this.whitespace == null ? "" : this.whitespace;
    }

    public Markers getMarkers() {
        return this.markers;
    }

    public Space withMarkers(Markers markers) {
        return Space.build(this.whitespace, this.comments, markers);
    }

    public Space withComments(List<Comment> comments) {
        if (comments.isEmpty() && (this.whitespace == null || this.whitespace.isEmpty())) {
            return EMPTY;
        }
        return Space.build(this.whitespace, comments, this.markers);
    }

    public Space withWhitespace(String whitespace) {
        if (this.comments.isEmpty() && whitespace.isEmpty()) {
            return EMPTY;
        }
        if (!whitespace.equals(this.whitespace)) {
            return Space.build(whitespace, this.comments, this.markers);
        }
        return this;
    }

    public boolean isEmpty() {
        return this == EMPTY;
    }

    public static Space firstPrefix(@Nullable List<? extends J> trees) {
        return trees == null || trees.isEmpty() ? EMPTY : trees.iterator().next().getPrefix();
    }

    public static Space format(String formatting) {
        char[] charArray;
        StringBuilder prefix = new StringBuilder();
        StringBuilder comment = new StringBuilder();
        ArrayList<Comment> comments = new ArrayList<Comment>();
        boolean inSingleLineComment = false;
        boolean inMultiLineComment = false;
        boolean inJavadoc = false;
        char last = '\u0000';
        for (char c : charArray = formatting.toCharArray()) {
            switch (c) {
                case '/': {
                    if (!(last != '/' || inSingleLineComment || inMultiLineComment || inJavadoc)) {
                        inSingleLineComment = true;
                        comment = new StringBuilder();
                        break;
                    }
                    if (last == '*' && inMultiLineComment) {
                        inMultiLineComment = false;
                        comment.setLength(comment.length() - 1);
                        comments.add(new Comment(Comment.Style.BLOCK, comment.toString(), prefix.toString()));
                        prefix = new StringBuilder();
                        comment = new StringBuilder();
                        break;
                    }
                    if (last == '*' && inJavadoc) {
                        inJavadoc = false;
                        comment.setLength(comment.length() - 1);
                        comments.add(new Comment(Comment.Style.JAVADOC, comment.toString(), prefix.toString()));
                        prefix = new StringBuilder();
                        comment = new StringBuilder();
                        break;
                    }
                    comment.append(c);
                    break;
                }
                case '\n': 
                case '\r': {
                    if (inSingleLineComment) {
                        inSingleLineComment = false;
                        comments.add(new Comment(Comment.Style.LINE, comment.toString(), prefix.toString()));
                        prefix = new StringBuilder();
                        comment = new StringBuilder();
                        prefix.append(c);
                        break;
                    }
                    if (!inMultiLineComment && !inJavadoc) {
                        prefix.append(c);
                        break;
                    }
                    comment.append(c);
                    break;
                }
                case '*': {
                    if (last == '/' && !inMultiLineComment && !inJavadoc) {
                        inMultiLineComment = true;
                        comment = new StringBuilder();
                        break;
                    }
                    if (last == '*' && inMultiLineComment && comment.toString().isEmpty()) {
                        inMultiLineComment = false;
                        inJavadoc = true;
                        comment = new StringBuilder();
                        break;
                    }
                    comment.append(c);
                    break;
                }
                default: {
                    if (inSingleLineComment || inMultiLineComment || inJavadoc) {
                        comment.append(c);
                        break;
                    }
                    prefix.append(c);
                }
            }
            last = c;
        }
        String whitespace = prefix.toString();
        if (!comments.isEmpty()) {
            for (int i = comments.size() - 1; i >= 0; --i) {
                Comment c = (Comment)comments.get(i);
                String next = c.getSuffix();
                comments.set(i, c.withSuffix(whitespace));
                whitespace = next;
            }
        }
        return Space.build(whitespace, comments, Markers.EMPTY);
    }

    public static <J2 extends J> List<JRightPadded<J2>> formatLastSuffix(@Nullable List<JRightPadded<J2>> trees, Space suffix) {
        if (trees == null) {
            return null;
        }
        if (!trees.isEmpty()) {
            ArrayList<JRightPadded<J2>> formattedTrees = new ArrayList<JRightPadded<J2>>(trees);
            formattedTrees.set(formattedTrees.size() - 1, ((JRightPadded)formattedTrees.get(formattedTrees.size() - 1)).withAfter(suffix));
            return formattedTrees;
        }
        return trees;
    }

    public static <J2 extends J> List<J2> formatFirstPrefix(List<J2> trees, Space prefix) {
        if (!trees.isEmpty()) {
            ArrayList<J2> formattedTrees = new ArrayList<J2>(trees);
            formattedTrees.set(0, ((J)formattedTrees.get(0)).withPrefix(prefix));
            return formattedTrees;
        }
        return trees;
    }

    public String toString() {
        StringBuilder printedWs = new StringBuilder();
        int lastNewline = 0;
        if (this.whitespace != null) {
            char[] charArray = this.whitespace.toCharArray();
            for (int i = 0; i < charArray.length; ++i) {
                char c = charArray[i];
                if (c == '\n') {
                    printedWs.append("\\n");
                    lastNewline = i + 1;
                    continue;
                }
                if (c == '\r') {
                    printedWs.append("\\r");
                    lastNewline = i + 1;
                    continue;
                }
                if (c == ' ') {
                    printedWs.append(spaces[(i - lastNewline) % 10]);
                    continue;
                }
                if (c != '\t') continue;
                printedWs.append(tabs[(i - lastNewline) % 10]);
            }
        }
        return "Space(comments=<" + (this.comments.size() == 1 ? "1 comment" : this.comments.size() + " comments") + ">, whitespace='" + printedWs + "')";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Space)) {
            return false;
        }
        Space other = (Space)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Comment> this$comments = this.getComments();
        List<Comment> other$comments = other.getComments();
        if (this$comments == null ? other$comments != null : !((Object)this$comments).equals(other$comments)) {
            return false;
        }
        String this$whitespace = this.getWhitespace();
        String other$whitespace = other.getWhitespace();
        if (this$whitespace == null ? other$whitespace != null : !this$whitespace.equals(other$whitespace)) {
            return false;
        }
        Markers this$markers = this.getMarkers();
        Markers other$markers = other.getMarkers();
        return !(this$markers == null ? other$markers != null : !this$markers.equals(other$markers));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Space;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Comment> $comments = this.getComments();
        result = result * 59 + ($comments == null ? 43 : ((Object)$comments).hashCode());
        String $whitespace = this.getWhitespace();
        result = result * 59 + ($whitespace == null ? 43 : $whitespace.hashCode());
        Markers $markers = this.getMarkers();
        result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
        return result;
    }

    public static enum Location {
        ANNOTATED_TYPE_PREFIX,
        ANNOTATION_ARGUMENTS,
        ANNOTATION_ARGUMENT_SUFFIX,
        ANNOTATIONS,
        ANNOTATION_PREFIX,
        ARRAY_ACCESS_PREFIX,
        ARRAY_INDEX_SUFFIX,
        ARRAY_TYPE_PREFIX,
        ASSERT_PREFIX,
        ASSIGNMENT,
        ASSIGNMENT_OPERATION_PREFIX,
        ASSIGNMENT_OPERATION_OPERATOR,
        ASSIGNMENT_PREFIX,
        BINARY_OPERATOR,
        BINARY_PREFIX,
        BLOCK_END,
        BLOCK_PREFIX,
        BLOCK_STATEMENT_SUFFIX,
        BREAK_PREFIX,
        CASE,
        CASE_PREFIX,
        CASE_SUFFIX,
        CATCH_ALTERNATIVE_SUFFIX,
        CATCH_PREFIX,
        CLASS_DECLARATION_PREFIX,
        CLASS_KIND,
        COMPILATION_UNIT_EOF,
        COMPILATION_UNIT_PREFIX,
        CONTINUE_PREFIX,
        CONTROL_PARENTHESES_PREFIX,
        DIMENSION_PREFIX,
        DIMENSION,
        DIMENSION_SUFFIX,
        DO_WHILE_PREFIX,
        ELSE_PREFIX,
        EMPTY_PREFIX,
        ENUM_VALUE_PREFIX,
        ENUM_VALUE_SET_PREFIX,
        ENUM_VALUE_SUFFIX,
        EXTENDS,
        FIELD_ACCESS_NAME,
        FIELD_ACCESS_PREFIX,
        FOREACH_ITERABLE_SUFFIX,
        FOREACH_VARIABLE_SUFFIX,
        FOR_BODY_SUFFIX,
        FOR_CONDITION_SUFFIX,
        FOR_CONTROL_PREFIX,
        FOR_EACH_CONTROL_PREFIX,
        FOR_EACH_LOOP_PREFIX,
        FOR_INIT_SUFFIX,
        FOR_PREFIX,
        FOR_UPDATE_SUFFIX,
        IDENTIFIER_PREFIX,
        IF_ELSE_SUFFIX,
        IF_PREFIX,
        IF_THEN_SUFFIX,
        IMPLEMENTS,
        IMPLEMENTS_SUFFIX,
        IMPORT_PREFIX,
        IMPORT_SUFFIX,
        INSTANCEOF_PREFIX,
        INSTANCEOF_SUFFIX,
        LABEL_PREFIX,
        LABEL_SUFFIX,
        LAMBDA_ARROW_PREFIX,
        LAMBDA_PARAMETER,
        LAMBDA_PARAMETERS_PREFIX,
        LAMBDA_PREFIX,
        LITERAL_PREFIX,
        MEMBER_REFERENCE_NAME,
        MEMBER_REFERENCE_PREFIX,
        METHOD_DECLARATION_PARAMETERS,
        METHOD_DECLARATION_PARAMETER_SUFFIX,
        METHOD_DECLARATION_DEFAULT_VALUE,
        METHOD_DECLARATION_PREFIX,
        METHOD_INVOCATION_ARGUMENTS,
        METHOD_INVOCATION_ARGUMENT_SUFFIX,
        METHOD_INVOCATION_PREFIX,
        METHOD_SELECT_SUFFIX,
        MODIFIER_PREFIX,
        MULTI_CATCH_PREFIX,
        VARIABLE_DECLARATIONS_PREFIX,
        NAMED_VARIABLE_SUFFIX,
        NEW_ARRAY_INITIALIZER,
        NEW_ARRAY_INITIALIZER_SUFFIX,
        NEW_ARRAY_PREFIX,
        NEW_CLASS_ARGUMENTS,
        NEW_CLASS_ARGUMENTS_SUFFIX,
        NEW_CLASS_ENCLOSING_SUFFIX,
        NEW_CLASS_PREFIX,
        NEW_PREFIX,
        PACKAGE_PREFIX,
        PACKAGE_SUFFIX,
        PARAMETERIZED_TYPE_PREFIX,
        PARENTHESES_PREFIX,
        PARENTHESES_SUFFIX,
        PRIMITIVE_PREFIX,
        RETURN_PREFIX,
        STATIC_IMPORT,
        STATIC_INIT_SUFFIX,
        SWITCH_PREFIX,
        SYNCHRONIZED_PREFIX,
        TERNARY_FALSE,
        TERNARY_PREFIX,
        TERNARY_TRUE,
        THROWS,
        THROWS_SUFFIX,
        THROW_PREFIX,
        TRY_FINALLY,
        TRY_PREFIX,
        TRY_RESOURCE,
        TRY_RESOURCES,
        TRY_RESOURCE_SUFFIX,
        TYPE_BOUNDS,
        TYPE_BOUND_SUFFIX,
        TYPE_CAST_PREFIX,
        TYPE_PARAMETERS,
        TYPE_PARAMETERS_PREFIX,
        TYPE_PARAMETER_SUFFIX,
        UNARY_OPERATOR,
        UNARY_PREFIX,
        VARARGS,
        VARIABLE_INITIALIZER,
        VARIABLE_PREFIX,
        WHILE_BODY_SUFFIX,
        WHILE_CONDITION,
        WHILE_PREFIX,
        WILDCARD_BOUND,
        WILDCARD_PREFIX;

    }
}

