/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.HashSet;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.RecipeSearchResult;

public final class FindTypes
extends Recipe {
    private final String fullyQualifiedTypeName;

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){
            {
                this.setCursoringOn();
            }

            @Override
            public <N extends NameTree> N visitTypeName(N name, ExecutionContext ctx) {
                N n = super.visitTypeName(name, ctx);
                JavaType.Class asClass = TypeUtils.asClass(n.getType());
                if (asClass != null && asClass.getFullyQualifiedName().equals(FindTypes.this.fullyQualifiedTypeName) && this.getCursor().firstEnclosing(J.Import.class) == null) {
                    return (N)((NameTree)n.withMarker(new Marker[]{new RecipeSearchResult((Recipe)FindTypes.this)}));
                }
                return n;
            }
        };
    }

    public static Set<NameTree> find(J j, final String fullyQualifiedClassName) {
        JavaIsoVisitor<Set<NameTree>> findVisitor = new JavaIsoVisitor<Set<NameTree>>(){
            {
                this.setCursoringOn();
            }

            @Override
            public <N extends NameTree> N visitTypeName(N name, Set<NameTree> ns) {
                N n = super.visitTypeName(name, ns);
                JavaType.Class asClass = TypeUtils.asClass(n.getType());
                if (asClass != null && asClass.getFullyQualifiedName().equals(fullyQualifiedClassName) && this.getCursor().firstEnclosing(J.Import.class) == null) {
                    ns.add(name);
                }
                return n;
            }
        };
        HashSet<NameTree> ts = new HashSet<NameTree>();
        findVisitor.visit(j, ts);
        return ts;
    }

    public FindTypes(String fullyQualifiedTypeName) {
        this.fullyQualifiedTypeName = fullyQualifiedTypeName;
    }

    public String getFullyQualifiedTypeName() {
        return this.fullyQualifiedTypeName;
    }

    public String toString() {
        return "FindTypes(fullyQualifiedTypeName=" + this.getFullyQualifiedTypeName() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindTypes)) {
            return false;
        }
        FindTypes other = (FindTypes)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$fullyQualifiedTypeName = this.getFullyQualifiedTypeName();
        String other$fullyQualifiedTypeName = other.getFullyQualifiedTypeName();
        return !(this$fullyQualifiedTypeName == null ? other$fullyQualifiedTypeName != null : !this$fullyQualifiedTypeName.equals(other$fullyQualifiedTypeName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FindTypes;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $fullyQualifiedTypeName = this.getFullyQualifiedTypeName();
        result = result * 59 + ($fullyQualifiedTypeName == null ? 43 : $fullyQualifiedTypeName.hashCode());
        return result;
    }
}

