/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class FindInheritedFields {
    private FindInheritedFields() {
    }

    public static Set<JavaType.Var> find(J j, String clazz) {
        HashSet<JavaType.Var> fields = new HashSet<JavaType.Var>();
        new FindInheritedFieldsVisitor(clazz).visit(j, fields);
        return fields;
    }

    private static class FindInheritedFieldsVisitor
    extends JavaIsoVisitor<Set<JavaType.Var>> {
        private final String fullyQualifiedName;

        public FindInheritedFieldsVisitor(String fullyQualifiedName) {
            this.fullyQualifiedName = fullyQualifiedName;
        }

        private Set<JavaType.Var> superFields(@Nullable JavaType.Class type) {
            if (type == null || type.getSupertype() == null) {
                return Collections.emptySet();
            }
            HashSet<JavaType.Var> types = new HashSet<JavaType.Var>();
            type.getMembers().stream().filter(m -> !m.hasFlags(Flag.Private) && TypeUtils.hasElementType(m.getType(), this.fullyQualifiedName)).forEach(types::add);
            types.addAll(this.superFields(type.getSupertype()));
            return types;
        }

        @Override
        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, Set<JavaType.Var> ctx) {
            JavaType.Class asClass = TypeUtils.asClass(classDecl.getType());
            ctx.addAll(this.superFields(asClass == null ? null : asClass.getSupertype()));
            return super.visitClassDeclaration(classDecl, ctx);
        }
    }
}

