/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.internal.template;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.format.AutoFormatVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaCoordinates;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.marker.Markers;

public class InsertAtCoordinates
extends JavaVisitor<List<? extends J>> {
    private static final J.Block EMPTY_BLOCK = new J.Block(Tree.randomId(), Space.EMPTY, Markers.EMPTY, new JRightPadded<Boolean>(false, Space.EMPTY, Markers.EMPTY), Collections.emptyList(), Space.EMPTY);
    private final UUID insertId;
    private final Space.Location location;
    private final JavaCoordinates coordinates;

    public InsertAtCoordinates(JavaCoordinates coordinates) {
        this.coordinates = coordinates;
        this.insertId = coordinates.getTree().getId();
        this.location = coordinates.getSpaceLocation();
        this.setCursoringOn();
    }

    @Nullable
    public J preVisit(@Nullable J tree, List<? extends J> generated) {
        if (tree == null || !this.coordinates.isReplaceWholeCursorValue() || !tree.getId().equals(this.insertId)) {
            return tree;
        }
        if (generated.size() == 1) {
            return new AutoFormatVisitor().visit((Tree)generated.get(0), (Object)0, this.getCursor()).withPrefix(tree.getPrefix());
        }
        throw new IllegalStateException("The template generated the incorrect number of elements.");
    }

    @Override
    public J visitBlock(J.Block block, List<? extends J> generated) {
        J.Block b = (J.Block)this.visitAndCast(block, generated, (x$0, x$1) -> super.visitBlock((J.Block)x$0, x$1));
        if (b.getId().equals(this.insertId) && this.location == Space.Location.BLOCK_END) {
            for (J j : generated) {
                if (j instanceof Statement) continue;
                throw new IllegalStateException("Attempted to insert a tree of type " + j.getClass().getSimpleName() + " as a block statement");
            }
            return b.withStatements(ListUtils.concatAll(b.getStatements(), generated));
        }
        b = b.withStatements(this.maybeMergeList(b.getStatements(), generated));
        return b;
    }

    @Override
    public J visitClassDeclaration(J.ClassDeclaration classDeclaration, List<? extends J> generated) {
        J.ClassDeclaration c = (J.ClassDeclaration)this.visitAndCast(classDeclaration, generated, (x$0, x$1) -> super.visitClassDeclaration((J.ClassDeclaration)x$0, x$1));
        if (this.insertId.equals(c.getId())) {
            AutoFormatVisitor autoFormat = new AutoFormatVisitor();
            switch (this.location) {
                case ANNOTATIONS: {
                    J.ClassDeclaration temp = JavaCoordinates.Mode.INSERTION.equals((Object)this.coordinates.getMode()) ? c.withAnnotations(ListUtils.insertInOrder(c.getAnnotations(), (Object)((J.Annotation)generated.get(0)), this.coordinates.getComparator())) : c.withAnnotations(generated);
                    temp = (J.ClassDeclaration)autoFormat.visit((Tree)temp.withBody(EMPTY_BLOCK), (Object)0, this.getCursor());
                    assert (temp != null);
                    c = temp.withBody(c.getBody());
                    break;
                }
                case TYPE_PARAMETERS: {
                    J.ClassDeclaration temp = c.withTypeParameters(generated);
                    temp = (J.ClassDeclaration)autoFormat.visit((Tree)temp.withBody(EMPTY_BLOCK), (Object)0, this.getCursor());
                    assert (temp != null);
                    c = c.getPadding().withTypeParameters(temp.getPadding().getTypeParameters());
                    break;
                }
                case EXTENDS: {
                    J.ClassDeclaration temp = c.withExtends((TypeTree)generated.get(0));
                    temp = (J.ClassDeclaration)autoFormat.visit((Tree)temp.withBody(EMPTY_BLOCK), (Object)0, this.getCursor());
                    assert (temp != null);
                    c = c.getPadding().withExtends(temp.getPadding().getExtends());
                    break;
                }
                case IMPLEMENTS: {
                    J.ClassDeclaration temp = c.withImplements(generated);
                    temp = (J.ClassDeclaration)autoFormat.visit((Tree)temp.withBody(EMPTY_BLOCK), (Object)0, this.getCursor());
                    assert (temp != null);
                    c = c.getPadding().withImplements(temp.getPadding().getImplements());
                    break;
                }
                case BLOCK_PREFIX: {
                    c = c.withBody((J.Block)generated.get(0));
                }
            }
        } else {
            c = c.withAnnotations(this.maybeMergeList(c.getAnnotations(), generated));
            c = c.withTypeParameters(this.maybeMergeList(c.getTypeParameters(), generated));
            c = c.withImplements(this.maybeMergeList(c.getImplements(), generated));
        }
        return c;
    }

    @Override
    public J visitMethodDeclaration(J.MethodDeclaration method, List<? extends J> generated) {
        J.MethodDeclaration m = (J.MethodDeclaration)this.visitAndCast(method, generated, (x$0, x$1) -> super.visitMethodDeclaration((J.MethodDeclaration)x$0, x$1));
        AutoFormatVisitor autoFormat = new AutoFormatVisitor();
        if (this.insertId.equals(m.getId())) {
            switch (this.location) {
                case ANNOTATIONS: {
                    J.MethodDeclaration temp = JavaCoordinates.Mode.INSERTION.equals((Object)this.coordinates.getMode()) ? m.withAnnotations(ListUtils.insertInOrder(m.getAnnotations(), (Object)((J.Annotation)generated.get(0)), this.coordinates.getComparator())) : m.withAnnotations(generated);
                    temp = (J.MethodDeclaration)autoFormat.visit((Tree)temp.withBody(EMPTY_BLOCK), (Object)0, this.getCursor());
                    assert (temp != null);
                    m = temp.withBody(m.getBody());
                    break;
                }
                case TYPE_PARAMETERS: {
                    J.MethodDeclaration temp = m.withTypeParameters(generated);
                    temp = (J.MethodDeclaration)autoFormat.visit((Tree)temp.withBody(EMPTY_BLOCK), (Object)0, this.getCursor());
                    assert (temp != null);
                    m = m.getPadding().withTypeParameters(temp.getPadding().getTypeParameters());
                    break;
                }
                case METHOD_DECLARATION_PARAMETERS: {
                    J.MethodDeclaration temp = m.withParameters(generated);
                    temp = (J.MethodDeclaration)autoFormat.visit((Tree)temp.withBody(EMPTY_BLOCK), (Object)0, this.getCursor());
                    assert (temp != null);
                    m = m.getPadding().withParameters(temp.getPadding().getParameters());
                    break;
                }
                case THROWS: {
                    J.MethodDeclaration temp = m.withThrows(generated);
                    temp = (J.MethodDeclaration)autoFormat.visit((Tree)temp.withBody(EMPTY_BLOCK), (Object)0, this.getCursor());
                    assert (temp != null);
                    m = m.getPadding().withThrows(temp.getPadding().getThrows());
                    break;
                }
                case BLOCK_PREFIX: {
                    m = m.withBody((J.Block)generated.get(0));
                }
            }
        } else {
            m = m.withAnnotations(this.maybeMergeList(m.getAnnotations(), generated));
            m = m.withTypeParameters(this.maybeMergeList(m.getTypeParameters(), generated));
            m = m.withThrows(this.maybeMergeList(m.getThrows(), generated));
        }
        return m;
    }

    @Override
    public J visitVariableDeclarations(J.VariableDeclarations multiVariable, List<? extends J> generated) {
        J.VariableDeclarations m = (J.VariableDeclarations)super.visitVariableDeclarations(multiVariable, generated);
        AutoFormatVisitor autoFormat = new AutoFormatVisitor();
        if (this.insertId.equals(m.getId())) {
            if (this.location == Space.Location.ANNOTATIONS) {
                m = JavaCoordinates.Mode.INSERTION.equals((Object)this.coordinates.getMode()) ? m.withAnnotations(ListUtils.insertInOrder(m.getAnnotations(), (Object)((J.Annotation)generated.get(0)), this.coordinates.getComparator())) : m.withAnnotations(generated);
                m = (J.VariableDeclarations)autoFormat.visit((Tree)m, (Object)0, this.getCursor());
                assert (m != null);
            }
        } else {
            m = m.withAnnotations(this.maybeMergeList(m.getAnnotations(), generated));
        }
        return m;
    }

    @Override
    public J visitMethodInvocation(J.MethodInvocation method, List<? extends J> generated) {
        J.MethodInvocation m = (J.MethodInvocation)this.visitAndCast(method, generated, (x$0, x$1) -> super.visitMethodInvocation((J.MethodInvocation)x$0, x$1));
        if (this.insertId.equals(m.getId()) && this.location == Space.Location.METHOD_INVOCATION_ARGUMENTS) {
            m = m.withArguments(generated);
        } else if (!this.coordinates.isReplacement()) {
            m = m.withArguments(this.maybeMergeList(m.getArguments(), generated));
        }
        return m;
    }

    @Nullable
    private <T extends J> List<T> maybeMergeList(@Nullable List<T> originalList, List<? extends J> generated) {
        if (originalList != null) {
            for (int index = 0; index < originalList.size(); ++index) {
                if (!this.insertId.equals(((J)originalList.get(index)).getId())) continue;
                ArrayList<Object> newList = new ArrayList<Object>();
                if (this.coordinates.isReplacement()) {
                    newList.addAll(originalList.subList(0, index + 1));
                    newList.addAll(generated);
                    newList.addAll(originalList.subList(index + 1, originalList.size()));
                } else {
                    newList.addAll(originalList.subList(0, index));
                    newList.addAll(generated);
                    newList.addAll(originalList.subList(index, originalList.size()));
                }
                return newList;
            }
        }
        return originalList;
    }
}

