/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.concurrent.atomic.AtomicReference;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class ChangeFieldName<P>
extends JavaIsoVisitor<P> {
    private final JavaType.Class classType;
    private final String hasName;
    private final String toName;

    public ChangeFieldName(JavaType.Class classType, String hasName, String toName) {
        this.classType = classType;
        this.hasName = hasName;
        this.toName = toName;
        this.setCursoringOn();
    }

    @Override
    public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, P p) {
        J.VariableDeclarations.NamedVariable v = variable;
        J.ClassDeclaration enclosingClass = (J.ClassDeclaration)this.getCursor().firstEnclosingOrThrow(J.ClassDeclaration.class);
        if (variable.isField(this.getCursor()) && this.matchesClass(enclosingClass.getType()) && variable.getSimpleName().equals(this.hasName)) {
            v = v.withName(v.getName().withName(this.toName));
        }
        if (variable.getPadding().getInitializer() != null) {
            v = v.getPadding().withInitializer(this.visitLeftPadded(variable.getPadding().getInitializer(), JLeftPadded.Location.VARIABLE_INITIALIZER, p));
        }
        return v;
    }

    @Override
    public J.FieldAccess visitFieldAccess(J.FieldAccess fieldAccess, P p) {
        J f = super.visitFieldAccess(fieldAccess, (Object)p);
        if (this.matchesClass(fieldAccess.getTarget().getType()) && fieldAccess.getSimpleName().equals(this.hasName)) {
            f = ((J.FieldAccess)f).getPadding().withName(((J.FieldAccess)f).getPadding().getName().withElement(((J.FieldAccess)f).getPadding().getName().getElement().withName(this.toName)));
        }
        return f;
    }

    @Override
    public J.Identifier visitIdentifier(J.Identifier ident, P p) {
        J i = super.visitIdentifier(ident, (Object)p);
        if (ident.getSimpleName().equals(this.hasName) && this.isFieldReference(ident) && this.isThisReferenceToClassType()) {
            i = ((J.Identifier)i).withName(this.toName);
        }
        return i;
    }

    private boolean matchesClass(@Nullable JavaType test) {
        JavaType.Class testClassType = TypeUtils.asClass(test);
        return testClassType != null && testClassType.getFullyQualifiedName().equals(this.classType.getFullyQualifiedName());
    }

    private boolean isThisReferenceToClassType() {
        J.FieldAccess fieldAccess = (J.FieldAccess)this.getCursor().firstEnclosing(J.FieldAccess.class);
        if (fieldAccess == null) {
            return true;
        }
        while (fieldAccess.getType() == null && fieldAccess.getTarget() instanceof J.FieldAccess) {
            fieldAccess = (J.FieldAccess)fieldAccess.getTarget();
        }
        return this.classType.equals(fieldAccess.getTarget().getType());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isFieldReference(J.Identifier ident) {
        AtomicReference nearest = new AtomicReference();
        new FindVariableDefinition(ident, this.getCursor()).visit((Tree)this.getCursor().firstEnclosing(J.CompilationUnit.class), nearest);
        if (nearest.get() == null) return false;
        if (!(((Cursor)nearest.get()).dropParentUntil(J.class::isInstance).dropParentUntil(J.class::isInstance).dropParentUntil(J.class::isInstance).getValue() instanceof J.ClassDeclaration)) return false;
        return true;
    }

    private static class FindVariableDefinition
    extends JavaIsoVisitor<AtomicReference<Cursor>> {
        private final J.Identifier ident;
        private final Cursor referenceScope;

        public FindVariableDefinition(J.Identifier ident, Cursor referenceScope) {
            this.ident = ident;
            this.referenceScope = referenceScope;
            this.setCursoringOn();
        }

        @Override
        public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, AtomicReference<Cursor> ctx) {
            if (variable.getSimpleName().equalsIgnoreCase(this.ident.getSimpleName()) && this.isInSameNameScope(this.referenceScope)) {
                ctx.accumulateAndGet(this.getCursor(), (r1, r2) -> {
                    if (r1 == null) {
                        return r2;
                    }
                    return r1.getPathAsStream().count() > r2.getPathAsStream().count() ? r1 : r2;
                });
            }
            return super.visitVariable(variable, ctx);
        }
    }
}

