/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.beans.ConstructorProperties;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.SearchResult;

public final class FindType
extends Recipe {
    private final String fullyQualifiedTypeName;

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new FindTypeVisitor();
    }

    public static Set<NameTree> find(J j, String fullyQualifiedClassName) {
        return ((J)((FindTypeVisitor)new FindType(fullyQualifiedClassName).getVisitor()).visit(j, ExecutionContext.builder().build())).findMarkedWith(SearchResult.class);
    }

    @ConstructorProperties(value={"fullyQualifiedTypeName"})
    public FindType(String fullyQualifiedTypeName) {
        this.fullyQualifiedTypeName = fullyQualifiedTypeName;
    }

    public String getFullyQualifiedTypeName() {
        return this.fullyQualifiedTypeName;
    }

    public String toString() {
        return "FindType(fullyQualifiedTypeName=" + this.getFullyQualifiedTypeName() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindType)) {
            return false;
        }
        FindType other = (FindType)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$fullyQualifiedTypeName = this.getFullyQualifiedTypeName();
        String other$fullyQualifiedTypeName = other.getFullyQualifiedTypeName();
        return !(this$fullyQualifiedTypeName == null ? other$fullyQualifiedTypeName != null : !this$fullyQualifiedTypeName.equals(other$fullyQualifiedTypeName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FindType;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $fullyQualifiedTypeName = this.getFullyQualifiedTypeName();
        result = result * 59 + ($fullyQualifiedTypeName == null ? 43 : $fullyQualifiedTypeName.hashCode());
        return result;
    }

    private class FindTypeVisitor
    extends JavaVisitor<ExecutionContext> {
        public FindTypeVisitor() {
            this.setCursoringOn();
        }

        @Override
        public <N extends NameTree> N visitTypeName(N name, ExecutionContext ctx) {
            N n = super.visitTypeName(name, ctx);
            JavaType.Class asClass = TypeUtils.asClass(n.getType());
            if (asClass != null && asClass.getFullyQualifiedName().equals(FindType.this.fullyQualifiedTypeName) && this.getCursor().firstEnclosing(J.Import.class) == null) {
                return (N)((NameTree)n.mark(new Marker[]{new SearchResult()}));
            }
            return n;
        }
    }
}

