/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.internal;

import org.openrewrite.TreePrinter;
import org.openrewrite.java.internal.JavaPrinter;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Space;

public class MethodDeclToString {
    private static final JavaPrinter<Void> METHOD_PRINTER = new JavaPrinter<Void>(TreePrinter.identity()){

        @Override
        public J visitMethod(J.MethodDecl method, Void unused) {
            this.visitModifiers(Space.formatFirstPrefix(method.getModifiers(), Space.EMPTY), unused);
            StringBuilder acc = this.getPrinterAcc();
            if (!method.getModifiers().isEmpty()) {
                acc.append(' ');
            }
            this.visit("<", method.getTypeParameters(), ",", ">", unused);
            if (method.getReturnTypeExpr() != null) {
                acc.append(method.getReturnTypeExpr().printTrimmed()).append(' ');
            }
            acc.append(method.getSimpleName());
            this.visit("(", method.getParams(), ",", ")", unused);
            this.visit("throws", method.getThrows(), ",", "", unused);
            return method;
        }
    };

    public static String toString(J.MethodDecl method) {
        return METHOD_PRINTER.print(method, null);
    }
}

