/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.internal;

import java.util.List;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.TreePrinter;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;

public class JavaPrinter<P>
extends JavaVisitor<P> {
    private static final String PRINTER_ACC_KEY = "printed";
    private final TreePrinter<P> treePrinter;

    public JavaPrinter(TreePrinter<P> treePrinter) {
        this.treePrinter = treePrinter;
        this.setCursoringOn();
    }

    @NonNull
    protected StringBuilder getPrinterAcc() {
        StringBuilder acc = (StringBuilder)this.getCursor().getRoot().peekNearestMessage(PRINTER_ACC_KEY);
        if (acc == null) {
            acc = new StringBuilder();
            this.getCursor().getRoot().putMessage(PRINTER_ACC_KEY, (Object)acc);
        }
        return acc;
    }

    public String print(J j, P p) {
        this.setCursor(new Cursor(null, (Object)"EPSILON"));
        this.visit((Tree)j, (Object)p);
        return this.getPrinterAcc().toString();
    }

    @Nullable
    public J visit(@Nullable Tree tree, P p) {
        if (tree == null) {
            return (J)this.defaultValue(null, p);
        }
        StringBuilder printerAcc = this.getPrinterAcc();
        this.treePrinter.doBefore(tree, printerAcc, p);
        tree = super.visit(tree, p);
        if (tree != null) {
            this.treePrinter.doAfter(tree, printerAcc, p);
        }
        return (J)tree;
    }

    protected void visit(@Nullable List<? extends J> nodes, P p) {
        if (nodes != null) {
            for (J j : nodes) {
                this.visit((Tree)j, (Object)p);
            }
        }
    }

    protected void visit(List<? extends JRightPadded<? extends J>> nodes, String suffixBetween, P p) {
        StringBuilder acc = this.getPrinterAcc();
        for (int i = 0; i < nodes.size(); ++i) {
            JRightPadded<? extends J> node = nodes.get(i);
            this.visit((Tree)node.getElem(), (Object)p);
            this.visitSpace(node.getAfter(), p);
            if (i >= nodes.size() - 1) continue;
            acc.append(suffixBetween);
        }
    }

    protected void visit(String before, @Nullable JContainer<? extends J> container, String suffixBetween, @Nullable String after, P p) {
        if (container == null) {
            return;
        }
        StringBuilder acc = this.getPrinterAcc();
        this.visitSpace(container.getBefore(), p);
        acc.append(before);
        this.visit(container.getElem(), suffixBetween, p);
        acc.append(after == null ? "" : after);
    }

    @Override
    public Space visitSpace(Space space, P p) {
        StringBuilder acc = this.getPrinterAcc();
        acc.append(space.getWhitespace());
        for (Comment comment : space.getComments()) {
            switch (comment.getStyle()) {
                case LINE: {
                    acc.append("//").append(comment.getText());
                    break;
                }
                case BLOCK: {
                    acc.append("/*").append(comment.getText()).append("*/");
                    break;
                }
                case JAVADOC: {
                    acc.append("/**").append(comment.getText()).append("*/");
                }
            }
            acc.append(comment.getSuffix());
        }
        return space;
    }

    protected void visit(@Nullable String prefix, @Nullable JLeftPadded<? extends J> leftPadded, P p) {
        if (leftPadded != null) {
            StringBuilder acc = this.getPrinterAcc();
            this.visitSpace(leftPadded.getBefore(), p);
            if (prefix != null) {
                acc.append(prefix);
            }
            this.visit((Tree)leftPadded.getElem(), (Object)p);
        }
    }

    protected void visit(@Nullable JRightPadded<? extends J> rightPadded, @Nullable String suffix, P p) {
        if (rightPadded != null) {
            StringBuilder acc = this.getPrinterAcc();
            this.visit((Tree)rightPadded.getElem(), (Object)p);
            this.visitSpace(rightPadded.getAfter(), p);
            if (suffix != null) {
                acc.append(suffix);
            }
        }
    }

    protected void visitModifiers(Iterable<J.Modifier> modifiers, P p) {
        StringBuilder acc = this.getPrinterAcc();
        for (J.Modifier mod : modifiers) {
            String keyword = "";
            switch (mod.getType()) {
                case Default: {
                    keyword = "default";
                    break;
                }
                case Public: {
                    keyword = "public";
                    break;
                }
                case Protected: {
                    keyword = "protected";
                    break;
                }
                case Private: {
                    keyword = "private";
                    break;
                }
                case Abstract: {
                    keyword = "abstract";
                    break;
                }
                case Static: {
                    keyword = "static";
                    break;
                }
                case Final: {
                    keyword = "final";
                    break;
                }
                case Native: {
                    keyword = "native";
                    break;
                }
                case Strictfp: {
                    keyword = "strictfp";
                    break;
                }
                case Synchronized: {
                    keyword = "synchronized";
                    break;
                }
                case Transient: {
                    keyword = "transient";
                    break;
                }
                case Volatile: {
                    keyword = "volatile";
                }
            }
            this.visitSpace(mod.getPrefix(), p);
            acc.append(keyword);
        }
    }

    @Override
    public J visitAnnotation(J.Annotation annotation, P p) {
        this.visitSpace(annotation.getPrefix(), p);
        StringBuilder acc = this.getPrinterAcc();
        acc.append("@");
        this.visit((Tree)annotation.getAnnotationType(), (Object)p);
        this.visit("(", annotation.getArgs(), ",", ")", p);
        return annotation;
    }

    @Override
    public J visitArrayDimension(J.ArrayDimension arrayDimension, P p) {
        this.visitSpace(arrayDimension.getPrefix(), p);
        StringBuilder acc = this.getPrinterAcc();
        acc.append("[");
        this.visit(arrayDimension.getIndex(), "]", p);
        return arrayDimension;
    }

    @Override
    public J visitArrayType(J.ArrayType arrayType, P p) {
        this.visitSpace(arrayType.getPrefix(), p);
        this.visit((Tree)arrayType.getElementType(), (Object)p);
        StringBuilder acc = this.getPrinterAcc();
        for (JRightPadded<Space> d : arrayType.getDimensions()) {
            this.visitSpace(d.getElem(), p);
            acc.append('[');
            this.visitSpace(d.getAfter(), p);
            acc.append(']');
        }
        return arrayType;
    }

    @Override
    public J visitAssert(J.Assert azzert, P p) {
        this.visitSpace(azzert.getPrefix(), p);
        StringBuilder acc = this.getPrinterAcc();
        acc.append("assert");
        this.visit((Tree)azzert.getCondition(), (Object)p);
        return azzert;
    }

    @Override
    public J visitAssign(J.Assign assign, P p) {
        this.visitSpace(assign.getPrefix(), p);
        this.visit((Tree)assign.getVariable(), (Object)p);
        this.visit("=", assign.getAssignment(), p);
        return assign;
    }

    @Override
    public J visitAssignOp(J.AssignOp assignOp, P p) {
        String keyword = "";
        switch (assignOp.getOperator().getElem()) {
            case Addition: {
                keyword = "+=";
                break;
            }
            case Subtraction: {
                keyword = "-=";
                break;
            }
            case Multiplication: {
                keyword = "*=";
                break;
            }
            case Division: {
                keyword = "/=";
                break;
            }
            case Modulo: {
                keyword = "%=";
                break;
            }
            case BitAnd: {
                keyword = "&=";
                break;
            }
            case BitOr: {
                keyword = "|=";
                break;
            }
            case BitXor: {
                keyword = "^=";
                break;
            }
            case LeftShift: {
                keyword = "<<=";
                break;
            }
            case RightShift: {
                keyword = ">>=";
                break;
            }
            case UnsignedRightShift: {
                keyword = ">>>=";
            }
        }
        this.visitSpace(assignOp.getPrefix(), p);
        this.visit((Tree)assignOp.getVariable(), (Object)p);
        this.visitSpace(assignOp.getOperator().getBefore(), p);
        StringBuilder acc = this.getPrinterAcc();
        acc.append(keyword);
        this.visit((Tree)assignOp.getAssignment(), (Object)p);
        return assignOp;
    }

    @Override
    public J visitBinary(J.Binary binary, P p) {
        String keyword = "";
        switch (binary.getOperator().getElem()) {
            case Addition: {
                keyword = "+";
                break;
            }
            case Subtraction: {
                keyword = "-";
                break;
            }
            case Multiplication: {
                keyword = "*";
                break;
            }
            case Division: {
                keyword = "/";
                break;
            }
            case Modulo: {
                keyword = "%";
                break;
            }
            case LessThan: {
                keyword = "<";
                break;
            }
            case GreaterThan: {
                keyword = ">";
                break;
            }
            case LessThanOrEqual: {
                keyword = "<=";
                break;
            }
            case GreaterThanOrEqual: {
                keyword = ">=";
                break;
            }
            case Equal: {
                keyword = "==";
                break;
            }
            case NotEqual: {
                keyword = "!=";
                break;
            }
            case BitAnd: {
                keyword = "&";
                break;
            }
            case BitOr: {
                keyword = "|";
                break;
            }
            case BitXor: {
                keyword = "^";
                break;
            }
            case LeftShift: {
                keyword = "<<";
                break;
            }
            case RightShift: {
                keyword = ">>";
                break;
            }
            case UnsignedRightShift: {
                keyword = ">>>";
                break;
            }
            case Or: {
                keyword = "||";
                break;
            }
            case And: {
                keyword = "&&";
            }
        }
        this.visitSpace(binary.getPrefix(), p);
        this.visit((Tree)binary.getLeft(), (Object)p);
        this.visitSpace(binary.getOperator().getBefore(), p);
        StringBuilder acc = this.getPrinterAcc();
        acc.append(keyword);
        this.visit((Tree)binary.getRight(), (Object)p);
        return binary;
    }

    @Override
    public J visitBlock(J.Block block, P p) {
        this.visitSpace(block.getPrefix(), p);
        StringBuilder acc = this.getPrinterAcc();
        if (block.getStatic() != null) {
            acc.append("static");
            this.visitSpace(block.getStatic(), p);
        }
        acc.append('{');
        this.visitStatements(block.getStatements(), p);
        this.visitSpace(block.getEnd(), p);
        acc.append('}');
        return block;
    }

    private void visitStatements(List<JRightPadded<Statement>> statements, P p) {
        for (JRightPadded<Statement> paddedStat : statements) {
            this.visitStatement(paddedStat, p);
        }
    }

    private void visitStatement(@Nullable JRightPadded<Statement> paddedStat, P p) {
        if (paddedStat == null) {
            return;
        }
        this.visit((Tree)paddedStat.getElem(), (Object)p);
        this.visitSpace(paddedStat.getAfter(), p);
        StringBuilder acc = this.getPrinterAcc();
        Statement s = paddedStat.getElem();
        while (true) {
            if (s instanceof J.Assert || s instanceof J.Assign || s instanceof J.AssignOp || s instanceof J.Break || s instanceof J.Continue || s instanceof J.DoWhileLoop || s instanceof J.Empty || s instanceof J.MethodInvocation || s instanceof J.NewClass || s instanceof J.Return || s instanceof J.Throw || s instanceof J.Unary || s instanceof J.VariableDecls) {
                acc.append(';');
                return;
            }
            if (s instanceof J.MethodDecl && ((J.MethodDecl)s).getBody() == null) {
                acc.append(';');
                return;
            }
            if (!(s instanceof J.Label)) break;
            s = ((J.Label)s).getStatement();
        }
    }

    @Override
    public J visitBreak(J.Break breakStatement, P p) {
        this.visitSpace(breakStatement.getPrefix(), p);
        StringBuilder acc = this.getPrinterAcc();
        acc.append("break");
        this.visit((Tree)breakStatement.getLabel(), (Object)p);
        return breakStatement;
    }

    @Override
    public J visitCase(J.Case caze, P p) {
        this.visitSpace(caze.getPrefix(), p);
        StringBuilder acc = this.getPrinterAcc();
        Expression elem = caze.getPattern();
        if (elem instanceof J.Ident && ((J.Ident)elem).getSimpleName().equals("default")) {
            acc.append("default");
        } else {
            acc.append("case");
            this.visit((Tree)elem, (Object)p);
        }
        this.visitSpace(caze.getStatements().getBefore(), p);
        acc.append(':');
        this.visitStatements(caze.getStatements().getElem(), p);
        return caze;
    }

    @Override
    public J visitCatch(J.Try.Catch catzh, P p) {
        this.visitSpace(catzh.getPrefix(), p);
        StringBuilder acc = this.getPrinterAcc();
        acc.append("catch");
        this.visit((Tree)catzh.getParam(), (Object)p);
        this.visit((Tree)catzh.getBody(), (Object)p);
        return catzh;
    }

    @Override
    public J visitClassDecl(J.ClassDecl classDecl, P p) {
        String kind = "";
        switch (classDecl.getKind().getElem()) {
            case Class: {
                kind = "class";
                break;
            }
            case Enum: {
                kind = "enum";
                break;
            }
            case Interface: {
                kind = "interface";
                break;
            }
            case Annotation: {
                kind = "@interface";
            }
        }
        this.visitSpace(classDecl.getPrefix(), p);
        this.visit(classDecl.getAnnotations(), p);
        this.visitModifiers(classDecl.getModifiers(), p);
        this.visitSpace(classDecl.getKind().getBefore(), p);
        StringBuilder acc = this.getPrinterAcc();
        acc.append(kind);
        this.visit((Tree)classDecl.getName(), (Object)p);
        this.visit("<", classDecl.getTypeParameters(), ",", ">", p);
        this.visit("extends", classDecl.getExtends(), p);
        this.visit(classDecl.getKind().getElem().equals((Object)J.ClassDecl.Kind.Interface) ? "extends" : "implements", classDecl.getImplements(), ",", null, p);
        this.visit((Tree)classDecl.getBody(), (Object)p);
        return classDecl;
    }

    @Override
    public J visitCompilationUnit(J.CompilationUnit cu, P p) {
        this.visitSpace(cu.getPrefix(), p);
        this.visit(cu.getPackageDecl(), ";", p);
        this.visit(cu.getImports(), ";", p);
        StringBuilder acc = this.getPrinterAcc();
        if (!cu.getImports().isEmpty()) {
            acc.append(";");
        }
        this.visit(cu.getClasses(), p);
        this.visitSpace(cu.getEof(), p);
        return cu;
    }

    @Override
    public J visitContinue(J.Continue continueStatement, P p) {
        this.visitSpace(continueStatement.getPrefix(), p);
        StringBuilder acc = this.getPrinterAcc();
        acc.append("continue");
        this.visit((Tree)continueStatement.getLabel(), (Object)p);
        return continueStatement;
    }

    @Override
    public <T extends J> J visitControlParentheses(J.ControlParentheses<T> controlParens, P p) {
        this.visitSpace(controlParens.getPrefix(), p);
        StringBuilder acc = this.getPrinterAcc();
        acc.append('(');
        this.visit(controlParens.getTree(), ")", p);
        return controlParens;
    }

    @Override
    public J visitDoWhileLoop(J.DoWhileLoop doWhileLoop, P p) {
        this.visitSpace(doWhileLoop.getPrefix(), p);
        StringBuilder acc = this.getPrinterAcc();
        acc.append("do");
        this.visitStatement(doWhileLoop.getBody(), p);
        this.visit("while", doWhileLoop.getWhileCondition(), p);
        return doWhileLoop;
    }

    @Override
    public J visitElse(J.If.Else elze, P p) {
        this.visitSpace(elze.getPrefix(), p);
        StringBuilder acc = this.getPrinterAcc();
        acc.append("else");
        this.visitStatement(elze.getBody(), p);
        return elze;
    }

    @Override
    public J visitEnumValue(J.EnumValue enoom, P p) {
        this.visitSpace(enoom.getPrefix(), p);
        this.visit((Tree)enoom.getName(), (Object)p);
        J.NewClass initializer = enoom.getInitializer();
        if (enoom.getInitializer() != null) {
            this.visitSpace(initializer.getPrefix(), p);
            this.visit("(", initializer.getArgs(), ",", ")", p);
            this.visit((Tree)initializer.getBody(), (Object)p);
        }
        return enoom;
    }

    @Override
    public J visitEnumValueSet(J.EnumValueSet enums, P p) {
        this.visitSpace(enums.getPrefix(), p);
        this.visit(enums.getEnums(), ",", p);
        StringBuilder acc = this.getPrinterAcc();
        if (enums.isTerminatedWithSemicolon()) {
            acc.append(';');
        }
        return enums;
    }

    @Override
    public J visitFieldAccess(J.FieldAccess fieldAccess, P p) {
        this.visitSpace(fieldAccess.getPrefix(), p);
        this.visit((Tree)fieldAccess.getTarget(), (Object)p);
        this.visit(".", fieldAccess.getName(), p);
        return fieldAccess;
    }

    @Override
    public J visitForLoop(J.ForLoop forLoop, P p) {
        this.visitSpace(forLoop.getPrefix(), p);
        StringBuilder acc = this.getPrinterAcc();
        acc.append("for");
        J.ForLoop.Control ctrl = forLoop.getControl();
        this.visitSpace(ctrl.getPrefix(), p);
        acc.append('(');
        this.visit(ctrl.getInit(), ";", p);
        this.visit(ctrl.getCondition(), ";", p);
        this.visit(ctrl.getUpdate(), ",", p);
        acc.append(')');
        this.visitStatement(forLoop.getBody(), p);
        return forLoop;
    }

    @Override
    public J visitForEachLoop(J.ForEachLoop forEachLoop, P p) {
        this.visitSpace(forEachLoop.getPrefix(), p);
        StringBuilder acc = this.getPrinterAcc();
        acc.append("for");
        J.ForEachLoop.Control ctrl = forEachLoop.getControl();
        this.visitSpace(ctrl.getPrefix(), p);
        acc.append('(');
        this.visit(ctrl.getVariable(), ":", p);
        this.visit(ctrl.getIterable(), "", p);
        acc.append(')');
        this.visitStatement(forEachLoop.getBody(), p);
        return forEachLoop;
    }

    @Override
    public J visitIdentifier(J.Ident ident, P p) {
        this.visitSpace(ident.getPrefix(), p);
        StringBuilder acc = this.getPrinterAcc();
        acc.append(ident.getSimpleName());
        return ident;
    }

    @Override
    public J visitIf(J.If iff, P p) {
        this.visitSpace(iff.getPrefix(), p);
        StringBuilder acc = this.getPrinterAcc();
        acc.append("if");
        this.visit((Tree)iff.getIfCondition(), (Object)p);
        this.visitStatement(iff.getThenPart(), p);
        this.visit((Tree)iff.getElsePart(), (Object)p);
        return iff;
    }

    @Override
    public J visitImport(J.Import impoort, P p) {
        StringBuilder acc = this.getPrinterAcc();
        this.visitSpace(impoort.getPrefix(), p);
        acc.append("import");
        if (impoort.isStatic()) {
            if (impoort.getStatic() != null) {
                this.visitSpace(impoort.getStatic(), p);
            }
            acc.append("static");
        }
        this.visit((Tree)impoort.getQualid(), (Object)p);
        return impoort;
    }

    @Override
    public J visitInstanceOf(J.InstanceOf instanceOf, P p) {
        this.visitSpace(instanceOf.getPrefix(), p);
        this.visit(instanceOf.getExpr(), "instanceof", p);
        this.visit((Tree)instanceOf.getClazz(), (Object)p);
        return instanceOf;
    }

    @Override
    public J visitLabel(J.Label label, P p) {
        this.visitSpace(label.getPrefix(), p);
        this.visit(label.getLabel(), ":", p);
        this.visit((Tree)label.getStatement(), (Object)p);
        return label;
    }

    @Override
    public J visitLambda(J.Lambda lambda, P p) {
        StringBuilder acc = this.getPrinterAcc();
        this.visitSpace(lambda.getPrefix(), p);
        this.visitSpace(lambda.getParameters().getPrefix(), p);
        if (lambda.getParameters().isParenthesized()) {
            acc.append('(');
            this.visit(lambda.getParameters().getParams(), ",", p);
            acc.append(')');
        } else {
            this.visit(lambda.getParameters().getParams(), ",", p);
        }
        this.visitSpace(lambda.getArrow(), p);
        acc.append("->");
        this.visit((Tree)lambda.getBody(), (Object)p);
        return lambda;
    }

    @Override
    public J visitLiteral(J.Literal literal, P p) {
        this.visitSpace(literal.getPrefix(), p);
        StringBuilder acc = this.getPrinterAcc();
        acc.append(literal.getValueSource());
        return literal;
    }

    @Override
    public J visitMemberReference(J.MemberReference memberRef, P p) {
        this.visitSpace(memberRef.getPrefix(), p);
        this.visit((Tree)memberRef.getContaining(), (Object)p);
        this.visit("<", memberRef.getTypeParameters(), ",", ">", p);
        this.visit("::", memberRef.getReference(), p);
        return memberRef;
    }

    @Override
    public J visitMethod(J.MethodDecl method, P p) {
        this.visitSpace(method.getPrefix(), p);
        this.visit(method.getAnnotations(), p);
        this.visitModifiers(method.getModifiers(), p);
        this.visit("<", method.getTypeParameters(), ",", ">", p);
        this.visit((Tree)method.getReturnTypeExpr(), (Object)p);
        this.visit((Tree)method.getName(), (Object)p);
        this.visit("(", method.getParams(), ",", ")", p);
        this.visit("throws", method.getThrows(), ",", null, p);
        this.visit((Tree)method.getBody(), (Object)p);
        this.visit("default", method.getDefaultValue(), p);
        return method;
    }

    @Override
    public J visitMethodInvocation(J.MethodInvocation method, P p) {
        this.visitSpace(method.getPrefix(), p);
        this.visit(method.getSelect(), ".", p);
        this.visit("<", method.getTypeParameters(), ",", ">", p);
        this.visit((Tree)method.getName(), (Object)p);
        this.visit("(", method.getArgs(), ",", ")", p);
        return method;
    }

    @Override
    public J visitMultiCatch(J.MultiCatch multiCatch, P p) {
        this.visitSpace(multiCatch.getPrefix(), p);
        this.visit(multiCatch.getAlternatives(), "|", p);
        return multiCatch;
    }

    @Override
    public J visitMultiVariable(J.VariableDecls multiVariable, P p) {
        StringBuilder acc = this.getPrinterAcc();
        this.visitSpace(multiVariable.getPrefix(), p);
        this.visit(multiVariable.getAnnotations(), p);
        this.visitModifiers(multiVariable.getModifiers(), p);
        this.visit((Tree)multiVariable.getTypeExpr(), (Object)p);
        for (JLeftPadded<Space> dim : multiVariable.getDimensionsBeforeName()) {
            this.visitSpace(dim.getBefore(), p);
            acc.append('[');
            this.visitSpace(dim.getElem(), p);
            acc.append(']');
        }
        if (multiVariable.getVarargs() != null) {
            this.visitSpace(multiVariable.getVarargs(), p);
            acc.append("...");
        }
        this.visit(multiVariable.getVars(), ",", p);
        return multiVariable;
    }

    @Override
    public J visitNewArray(J.NewArray newArray, P p) {
        StringBuilder acc = this.getPrinterAcc();
        this.visitSpace(newArray.getPrefix(), p);
        if (newArray.getTypeExpr() != null) {
            acc.append("new");
        }
        this.visit((Tree)newArray.getTypeExpr(), (Object)p);
        this.visit(newArray.getDimensions(), p);
        this.visit("{", newArray.getInitializer(), ",", "}", p);
        return newArray;
    }

    @Override
    public J visitNewClass(J.NewClass newClass, P p) {
        StringBuilder acc = this.getPrinterAcc();
        this.visitSpace(newClass.getPrefix(), p);
        this.visit(newClass.getEncl(), ".", p);
        this.visitSpace(newClass.getNew(), p);
        acc.append("new");
        this.visit((Tree)newClass.getClazz(), (Object)p);
        this.visit("(", newClass.getArgs(), ",", ")", p);
        this.visit((Tree)newClass.getBody(), (Object)p);
        return newClass;
    }

    @Override
    public J visitPackage(J.Package pkg, P p) {
        StringBuilder acc = this.getPrinterAcc();
        this.visitSpace(pkg.getPrefix(), p);
        acc.append("package");
        this.visit((Tree)pkg.getExpr(), (Object)p);
        return pkg;
    }

    @Override
    public J visitParameterizedType(J.ParameterizedType type, P p) {
        this.visitSpace(type.getPrefix(), p);
        this.visit((Tree)type.getClazz(), (Object)p);
        this.visit("<", type.getTypeParameters(), ",", ">", p);
        return type;
    }

    @Override
    public J visitPrimitive(J.Primitive primitive, P p) {
        String keyword;
        switch (primitive.getType()) {
            case Boolean: {
                keyword = "boolean";
                break;
            }
            case Byte: {
                keyword = "byte";
                break;
            }
            case Char: {
                keyword = "char";
                break;
            }
            case Double: {
                keyword = "double";
                break;
            }
            case Float: {
                keyword = "float";
                break;
            }
            case Int: {
                keyword = "int";
                break;
            }
            case Long: {
                keyword = "long";
                break;
            }
            case Short: {
                keyword = "short";
                break;
            }
            case Void: {
                keyword = "void";
                break;
            }
            case String: {
                keyword = "String";
                break;
            }
            case Wildcard: {
                keyword = "*";
                break;
            }
            case None: {
                throw new IllegalStateException("Unable to print None primitive");
            }
            case Null: {
                throw new IllegalStateException("Unable to print Null primitive");
            }
            default: {
                throw new IllegalStateException("Unable to print non-primitive type");
            }
        }
        StringBuilder acc = this.getPrinterAcc();
        this.visitSpace(primitive.getPrefix(), p);
        acc.append(keyword);
        return primitive;
    }

    @Override
    public <T extends J> J visitParentheses(J.Parentheses<T> parens, P p) {
        StringBuilder acc = this.getPrinterAcc();
        this.visitSpace(parens.getPrefix(), p);
        acc.append("(");
        this.visit(parens.getTree(), ")", p);
        return parens;
    }

    @Override
    public J visitReturn(J.Return retrn, P p) {
        StringBuilder acc = this.getPrinterAcc();
        this.visitSpace(retrn.getPrefix(), p);
        acc.append("return");
        this.visit((Tree)retrn.getExpr(), (Object)p);
        return retrn;
    }

    @Override
    public J visitSwitch(J.Switch switzh, P p) {
        StringBuilder acc = this.getPrinterAcc();
        this.visitSpace(switzh.getPrefix(), p);
        acc.append("switch");
        this.visit((Tree)switzh.getSelector(), (Object)p);
        this.visit((Tree)switzh.getCases(), (Object)p);
        return switzh;
    }

    @Override
    public J visitSynchronized(J.Synchronized synch, P p) {
        StringBuilder acc = this.getPrinterAcc();
        this.visitSpace(synch.getPrefix(), p);
        acc.append("synchronized");
        this.visit((Tree)synch.getLock(), (Object)p);
        this.visit((Tree)synch.getBody(), (Object)p);
        return synch;
    }

    @Override
    public J visitTernary(J.Ternary ternary, P p) {
        this.visitSpace(ternary.getPrefix(), p);
        this.visit((Tree)ternary.getCondition(), (Object)p);
        this.visit("?", ternary.getTruePart(), p);
        this.visit(":", ternary.getFalsePart(), p);
        return ternary;
    }

    @Override
    public J visitThrow(J.Throw thrown, P p) {
        StringBuilder acc = this.getPrinterAcc();
        this.visitSpace(thrown.getPrefix(), p);
        acc.append("throw");
        this.visit((Tree)thrown.getException(), (Object)p);
        return thrown;
    }

    @Override
    public J visitTry(J.Try tryable, P p) {
        StringBuilder acc = this.getPrinterAcc();
        this.visitSpace(tryable.getPrefix(), p);
        acc.append("try");
        if (tryable.getResources() != null) {
            this.visitSpace(tryable.getResources().getBefore(), p);
            acc.append('(');
            List<JRightPadded<J.Try.Resource>> resources = tryable.getResources().getElem();
            for (int i = 0; i < resources.size(); ++i) {
                JRightPadded<J.Try.Resource> resource = resources.get(i);
                this.visitSpace(resource.getElem().getPrefix(), p);
                this.visit((Tree)resource.getElem().getVariableDecls(), (Object)p);
                if (i < resources.size() - 1 || resource.getElem().isTerminatedWithSemicolon()) {
                    acc.append(';');
                }
                this.visitSpace(resource.getAfter(), p);
            }
            acc.append(')');
        }
        this.visit((Tree)tryable.getBody(), (Object)p);
        this.visit(tryable.getCatches(), p);
        this.visit("finally", tryable.getFinally(), p);
        return tryable;
    }

    @Override
    public J visitTypeParameter(J.TypeParameter typeParam, P p) {
        this.visitSpace(typeParam.getPrefix(), p);
        this.visit(typeParam.getAnnotations(), p);
        this.visit((Tree)typeParam.getName(), (Object)p);
        this.visit("extends", typeParam.getBounds(), "&", "", p);
        return typeParam;
    }

    @Override
    public J visitUnary(J.Unary unary, P p) {
        StringBuilder acc = this.getPrinterAcc();
        this.visitSpace(unary.getPrefix(), p);
        switch (unary.getOperator().getElem()) {
            case PreIncrement: {
                acc.append("++");
                this.visit((Tree)unary.getExpr(), (Object)p);
                break;
            }
            case PreDecrement: {
                acc.append("--");
                this.visit((Tree)unary.getExpr(), (Object)p);
                break;
            }
            case PostIncrement: {
                this.visit((Tree)unary.getExpr(), (Object)p);
                this.visitSpace(unary.getOperator().getBefore(), p);
                acc.append("++");
                break;
            }
            case PostDecrement: {
                this.visit((Tree)unary.getExpr(), (Object)p);
                this.visitSpace(unary.getOperator().getBefore(), p);
                acc.append("--");
                break;
            }
            case Positive: {
                acc.append("+");
                this.visit((Tree)unary.getExpr(), (Object)p);
                break;
            }
            case Negative: {
                acc.append("-");
                this.visit((Tree)unary.getExpr(), (Object)p);
                break;
            }
            case Complement: {
                acc.append("~");
                this.visit((Tree)unary.getExpr(), (Object)p);
                break;
            }
            default: {
                acc.append("!");
                this.visit((Tree)unary.getExpr(), (Object)p);
            }
        }
        return unary;
    }

    @Override
    public J visitVariable(J.VariableDecls.NamedVar variable, P p) {
        StringBuilder acc = this.getPrinterAcc();
        this.visitSpace(variable.getPrefix(), p);
        this.visit((Tree)variable.getName(), (Object)p);
        for (JLeftPadded<Space> dimension : variable.getDimensionsAfterName()) {
            this.visitSpace(dimension.getBefore(), p);
            acc.append('[');
            this.visitSpace(dimension.getElem(), p);
            acc.append(']');
        }
        this.visit("=", variable.getInitializer(), p);
        return variable;
    }

    @Override
    public J visitWhileLoop(J.WhileLoop whileLoop, P p) {
        StringBuilder acc = this.getPrinterAcc();
        this.visitSpace(whileLoop.getPrefix(), p);
        acc.append("while");
        this.visit((Tree)whileLoop.getCondition(), (Object)p);
        this.visitStatement(whileLoop.getBody(), p);
        return whileLoop;
    }

    @Override
    public J visitWildcard(J.Wildcard wildcard, P p) {
        StringBuilder acc = this.getPrinterAcc();
        this.visitSpace(wildcard.getPrefix(), p);
        acc.append('?');
        if (wildcard.getBound() != null) {
            switch (wildcard.getBound().getElem()) {
                case Extends: {
                    this.visitSpace(wildcard.getBound().getBefore(), p);
                    acc.append("extends");
                    break;
                }
                case Super: {
                    this.visitSpace(wildcard.getBound().getBefore(), p);
                    acc.append("super");
                }
            }
        }
        this.visit((Tree)wildcard.getBoundedType(), (Object)p);
        return wildcard;
    }
}

