/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.internal;

import org.openrewrite.TreePrinter;
import org.openrewrite.java.internal.JavaPrinter;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Space;

public class ClassDeclToString {
    private static final JavaPrinter<Void> CLASS_DECL_PRINTER = new JavaPrinter<Void>(TreePrinter.identity()){

        @Override
        public J visitClassDecl(J.ClassDecl classDecl, Void unused) {
            this.visitModifiers(Space.formatFirstPrefix(classDecl.getModifiers(), Space.EMPTY), unused);
            StringBuilder acc = this.getPrinterAcc();
            if (!classDecl.getModifiers().isEmpty()) {
                acc.append(' ');
            }
            switch (classDecl.getKind().getElem()) {
                case Class: {
                    acc.append("class ");
                    break;
                }
                case Enum: {
                    acc.append("enum ");
                    break;
                }
                case Interface: {
                    acc.append("interface ");
                    break;
                }
                case Annotation: {
                    acc.append("@interface ");
                }
            }
            acc.append(classDecl.getName().printTrimmed());
            if (classDecl.getTypeParameters() != null) {
                this.visit("<", classDecl.getTypeParameters(), ",", ">", unused);
                acc.append(' ');
            }
            this.visit("extends", classDecl.getExtends(), unused);
            if (classDecl.getImplements() != null) {
                if (J.ClassDecl.Kind.Interface.equals((Object)classDecl.getKind().getElem())) {
                    acc.append("extends");
                } else {
                    acc.append("implements");
                }
            }
            this.visit("", classDecl.getImplements(), ",", "", unused);
            return classDecl;
        }
    };

    public static String toString(J.ClassDecl clazz) {
        return CLASS_DECL_PRINTER.print(clazz, null);
    }
}

