/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.format;

import java.util.List;
import org.openrewrite.Cursor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.style.BlankLinesStyle;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;

class BlankLinesVisitor<P>
extends JavaIsoVisitor<P> {
    private final BlankLinesStyle style;

    public BlankLinesVisitor(BlankLinesStyle style) {
        this.style = style;
        this.setCursoringOn();
    }

    @Override
    public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, P p) {
        J j = super.visitCompilationUnit(cu, (Object)p);
        if (((J.CompilationUnit)j).getPackageDecl() != null) {
            j = !((J.CompilationUnit)j).getPrefix().getComments().isEmpty() ? (J.CompilationUnit)j.withComments(ListUtils.mapLast(j.getComments(), c -> {
                String suffix = this.keepMaximumLines(c.getSuffix(), this.style.getKeepMaximum().getBetweenHeaderAndPackage());
                suffix = this.minimumLines(suffix, this.style.getMinimum().getBeforePackage());
                return c.withSuffix(suffix);
            })) : ((J.CompilationUnit)j).withPrefix(Space.EMPTY);
        }
        if (((J.CompilationUnit)j).getPackageDecl() == null) {
            j = j.getComments().isEmpty() ? ((J.CompilationUnit)j).withPrefix(Space.EMPTY) : (J.CompilationUnit)j.withComments(ListUtils.mapLast(j.getComments(), c -> c.withSuffix(this.minimumLines(c.getSuffix(), this.style.getMinimum().getBeforeImports()))));
        } else if (((J.CompilationUnit)(j = ((J.CompilationUnit)j).withImports(ListUtils.mapFirst(((J.CompilationUnit)j).getImports(), i -> this.minimumLines((J)((Object)i), this.style.getMinimum().getAfterPackage()))))).getImports().isEmpty()) {
            j = ((J.CompilationUnit)j).withClasses(ListUtils.mapFirst(((J.CompilationUnit)j).getClasses(), c -> this.minimumLines(c, this.style.getMinimum().getAfterPackage())));
        }
        boolean hasImports = !((J.CompilationUnit)j).getImports().isEmpty();
        j = ((J.CompilationUnit)j).withClasses(ListUtils.map(((J.CompilationUnit)j).getClasses(), (i, c) -> i == 0 ? (hasImports ? this.minimumLines(c, this.style.getMinimum().getAfterImports()) : c) : this.minimumLines(c, this.style.getMinimum().getAroundClass())));
        return j;
    }

    @Override
    public J.ClassDecl visitClassDecl(J.ClassDecl classDecl, P p) {
        J j = super.visitClassDecl(classDecl, (Object)p);
        List<JRightPadded<Statement>> statements = ((J.ClassDecl)j).getBody().getStatements();
        j = ((J.ClassDecl)j).withBody(((J.ClassDecl)j).getBody().withStatements(ListUtils.map(statements, (i, s) -> {
            if (i == 0) {
                s = this.minimumLines((J)((Object)s), this.style.getMinimum().getAfterClassHeader());
            } else if (((JRightPadded)statements.get(i - 1)).getElem() instanceof J.Block) {
                s = this.minimumLines((J)((Object)s), this.style.getMinimum().getAroundInitializer());
            }
            return s;
        })));
        j = ((J.ClassDecl)j).withBody(((J.ClassDecl)j).getBody().withEnd(this.minimumLines(((J.ClassDecl)j).getBody().getEnd(), this.style.getMinimum().getBeforeClassEnd())));
        return j;
    }

    @Override
    public J.MethodDecl visitMethod(J.MethodDecl method, P p) {
        J j = super.visitMethod(method, (Object)p);
        if (((J.MethodDecl)j).getBody() != null) {
            if (((J.MethodDecl)j).getBody().getStatements().isEmpty()) {
                Space end = this.minimumLines(((J.MethodDecl)j).getBody().getEnd(), this.style.getMinimum().getBeforeMethodBody());
                if (end.getIndent().isEmpty() && this.style.getMinimum().getBeforeMethodBody() > 0) {
                    end = end.withWhitespace(end.getWhitespace() + method.getPrefix().getIndent());
                }
                j = ((J.MethodDecl)j).withBody(((J.MethodDecl)j).getBody().withEnd(end));
            } else {
                j = ((J.MethodDecl)j).withBody(((J.MethodDecl)j).getBody().withStatements(ListUtils.mapFirst(((J.MethodDecl)j).getBody().getStatements(), s -> this.minimumLines((J)((Object)s), this.style.getMinimum().getBeforeMethodBody()))));
            }
        }
        return j;
    }

    @Override
    public J.NewClass visitNewClass(J.NewClass newClass, P p) {
        J j = super.visitNewClass(newClass, (Object)p);
        if (((J.NewClass)j).getBody() != null) {
            j = ((J.NewClass)j).withBody(((J.NewClass)j).getBody().withStatements(ListUtils.mapFirst(((J.NewClass)j).getBody().getStatements(), s -> this.minimumLines((J)((Object)s), this.style.getMinimum().getAfterAnonymousClassHeader()))));
        }
        return j;
    }

    @Override
    public Statement visitStatement(Statement statement, P p) {
        J j = super.visitStatement(statement, (Object)p);
        Cursor parent = this.getCursor().dropParentUntil(J.class::isInstance);
        if (parent.getParent() != null) {
            Object parentTree = parent.getValue();
            Object grandparentTree = parent.dropParentUntil(J.class::isInstance).getValue();
            if (grandparentTree instanceof J.ClassDecl && parentTree instanceof J.Block) {
                J.Block block = (J.Block)parentTree;
                J.ClassDecl classDecl = (J.ClassDecl)grandparentTree;
                j = (Statement)this.keepMaximumLines(j, this.style.getKeepMaximum().getInDeclarations());
                if (block.getStatements().iterator().next().getElem() != j) {
                    if (j instanceof J.VariableDecls) {
                        j = classDecl.getKind().getElem() == J.ClassDecl.Kind.Interface ? (Statement)this.minimumLines(j, this.style.getMinimum().getAroundFieldInInterface()) : (Statement)this.minimumLines(j, this.style.getMinimum().getAroundField());
                    } else if (j instanceof J.MethodDecl) {
                        j = classDecl.getKind().getElem() == J.ClassDecl.Kind.Interface ? (Statement)this.minimumLines(j, this.style.getMinimum().getAroundMethodInInterface()) : (Statement)this.minimumLines(j, this.style.getMinimum().getAroundMethod());
                    } else if (j instanceof J.Block) {
                        j = (Statement)this.minimumLines(j, this.style.getMinimum().getAroundInitializer());
                    }
                }
            } else {
                return (Statement)this.keepMaximumLines(j, this.style.getKeepMaximum().getInCode());
            }
        }
        return j;
    }

    @Override
    public J.Block visitBlock(J.Block block, P p) {
        J j = super.visitBlock(block, (Object)p);
        j = ((J.Block)j).withEnd(this.keepMaximumLines(((J.Block)j).getEnd(), this.style.getKeepMaximum().getBeforeEndOfBlock()));
        return j;
    }

    private <J2 extends J> J2 keepMaximumLines(J2 tree, int max) {
        return tree.withPrefix(this.keepMaximumLines(tree.getPrefix(), max));
    }

    private Space keepMaximumLines(Space prefix, int max) {
        return prefix.withWhitespace(this.keepMaximumLines(prefix.getWhitespace(), max));
    }

    private String keepMaximumLines(String whitespace, int max) {
        long blankLines = whitespace.chars().filter(c -> c == 10).count() - 1L;
        if (blankLines > (long)max) {
            int startWhitespaceAtIndex = 0;
            int i = 0;
            while ((long)i < blankLines - (long)max + 1L) {
                startWhitespaceAtIndex = whitespace.indexOf(10, startWhitespaceAtIndex);
                ++i;
                ++startWhitespaceAtIndex;
            }
            return whitespace.substring(--startWhitespaceAtIndex);
        }
        return whitespace;
    }

    private <J2 extends J> JRightPadded<J2> minimumLines(JRightPadded<J2> tree, int min) {
        return tree.withElem(this.minimumLines((J)tree.getElem(), min));
    }

    private <J2 extends J> J2 minimumLines(J2 tree, int min) {
        return tree.withPrefix(this.minimumLines(tree.getPrefix(), min));
    }

    private Space minimumLines(Space prefix, int min) {
        return prefix.withWhitespace(this.minimumLines(prefix.getWhitespace(), min));
    }

    private String minimumLines(String whitespace, int min) {
        if (min == 0) {
            return whitespace;
        }
        String minWhitespace = whitespace;
        int i = 0;
        while ((long)i < (long)min - whitespace.chars().filter(c -> c == 10).count() + 1L) {
            minWhitespace = "\n" + minWhitespace;
            ++i;
        }
        return minWhitespace;
    }
}

