/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.example;

import java.beans.ConstructorProperties;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;

public class GenerateGetter
extends Recipe {
    private static final JavaTemplate GETTER = JavaTemplate.builder("public #{} get#{}() {\n    return #{};\n}").build();
    private final String fieldName;

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new GenerateGetterVisitor<ExecutionContext>();
    }

    @ConstructorProperties(value={"fieldName"})
    public GenerateGetter(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String toString() {
        return "GenerateGetter(fieldName=" + this.getFieldName() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GenerateGetter)) {
            return false;
        }
        GenerateGetter other = (GenerateGetter)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$fieldName = this.getFieldName();
        String other$fieldName = other.getFieldName();
        return !(this$fieldName == null ? other$fieldName != null : !this$fieldName.equals(other$fieldName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GenerateGetter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $fieldName = this.getFieldName();
        result = result * 59 + ($fieldName == null ? 43 : $fieldName.hashCode());
        return result;
    }

    private class GenerateGetterVisitor<P>
    extends JavaIsoVisitor<P> {
        public GenerateGetterVisitor() {
            this.setCursoringOn();
        }

        @Override
        public J.VariableDecls.NamedVar visitVariable(J.VariableDecls.NamedVar variable, P p) {
            if (variable.isField(this.getCursor()) && variable.getSimpleName().equals(GenerateGetter.this.fieldName)) {
                this.getCursor().putMessageOnFirstEnclosing(J.ClassDecl.class, "varCursor", (Object)this.getCursor());
            }
            return super.visitVariable(variable, (Object)p);
        }

        @Override
        public J.ClassDecl visitClassDecl(J.ClassDecl classDecl, P p) {
            J c = super.visitClassDecl(classDecl, (Object)p);
            Cursor varCursor = (Cursor)this.getCursor().pollNearestMessage("varCursor");
            if (varCursor != null) {
                J.VariableDecls.NamedVar var = (J.VariableDecls.NamedVar)varCursor.getValue();
                J.Block body = ((J.ClassDecl)c).getBody();
                J.MethodDecl generatedMethodDecl = (J.MethodDecl)GETTER.generateAfter(varCursor, TypeUtils.asClass(var.getType()).getClassName(), StringUtils.capitalize((String)var.getSimpleName()), var.getSimpleName()).iterator().next();
                c = ((J.ClassDecl)c).withBody(body.withStatements(ListUtils.concat(body.getStatements(), new JRightPadded<J.MethodDecl>(generatedMethodDecl, Space.EMPTY, Markers.EMPTY))));
            }
            return c;
        }
    }
}

