/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.beans.ConstructorProperties;
import java.util.LinkedHashSet;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Markers;

public class ChangeMethodTargetToStatic
extends Recipe {
    private final String methodPattern;
    private final String targetType;

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new ChangeMethodTargetToStaticVisitor(new MethodMatcher(this.methodPattern));
    }

    @ConstructorProperties(value={"methodPattern", "targetType"})
    public ChangeMethodTargetToStatic(String methodPattern, String targetType) {
        this.methodPattern = methodPattern;
        this.targetType = targetType;
    }

    public String getMethodPattern() {
        return this.methodPattern;
    }

    public String getTargetType() {
        return this.targetType;
    }

    public String toString() {
        return "ChangeMethodTargetToStatic(methodPattern=" + this.getMethodPattern() + ", targetType=" + this.getTargetType() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeMethodTargetToStatic)) {
            return false;
        }
        ChangeMethodTargetToStatic other = (ChangeMethodTargetToStatic)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$methodPattern = this.getMethodPattern();
        String other$methodPattern = other.getMethodPattern();
        if (this$methodPattern == null ? other$methodPattern != null : !this$methodPattern.equals(other$methodPattern)) {
            return false;
        }
        String this$targetType = this.getTargetType();
        String other$targetType = other.getTargetType();
        return !(this$targetType == null ? other$targetType != null : !this$targetType.equals(other$targetType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChangeMethodTargetToStatic;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $methodPattern = this.getMethodPattern();
        result = result * 59 + ($methodPattern == null ? 43 : $methodPattern.hashCode());
        String $targetType = this.getTargetType();
        result = result * 59 + ($targetType == null ? 43 : $targetType.hashCode());
        return result;
    }

    private class ChangeMethodTargetToStaticVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private final MethodMatcher methodMatcher;

        public ChangeMethodTargetToStaticVisitor(MethodMatcher methodMatcher) {
            this.methodMatcher = methodMatcher;
        }

        @Override
        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J m = super.visitMethodInvocation(method, ctx);
            if (this.methodMatcher.matches(method)) {
                JavaType.Class classType = JavaType.Class.build(ChangeMethodTargetToStatic.this.targetType);
                m = method.withSelect(new JRightPadded<Expression>(J.Ident.build(Tree.randomId(), method.getSelect() == null ? Space.EMPTY : method.getSelect().getElem().getPrefix(), Markers.EMPTY, classType.getClassName(), classType), Space.EMPTY, Markers.EMPTY));
                this.maybeAddImport(ChangeMethodTargetToStatic.this.targetType);
                JavaType.Method transformedType = null;
                if (method.getType() != null) {
                    this.maybeRemoveImport(method.getType().getDeclaringType());
                    transformedType = method.getType().withDeclaringType(classType);
                    if (!method.getType().hasFlags(Flag.Static)) {
                        LinkedHashSet<Flag> flags = new LinkedHashSet<Flag>(method.getType().getFlags());
                        flags.add(Flag.Static);
                        transformedType = transformedType.withFlags(flags);
                    }
                }
                m = ((J.MethodInvocation)m).withType(transformedType);
            }
            return m;
        }
    }
}

