/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.openrewrite.Incubating;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.JavaType;

@Incubating(since="6.1.0")
public class MethodTypeBuilder {
    JavaType.FullyQualified declaringType = null;
    Set<Flag> flags = new HashSet<Flag>();
    JavaType returnType;
    String name;
    List<Parameter> parameters = new ArrayList<Parameter>();

    public static MethodTypeBuilder newMethodType() {
        return new MethodTypeBuilder();
    }

    public MethodTypeBuilder declaringClass(String fullyQualifiedClassName) {
        this.declaringType = JavaType.Class.build(fullyQualifiedClassName);
        return this;
    }

    public MethodTypeBuilder flags(Flag ... flags) {
        this.flags.addAll(Arrays.asList(flags));
        return this;
    }

    public MethodTypeBuilder name(String name) {
        this.name = name;
        return this;
    }

    public MethodTypeBuilder returnType(String type) {
        this.returnType = JavaType.buildType(type);
        return this;
    }

    public MethodTypeBuilder returnType(JavaType type) {
        this.returnType = type;
        return this;
    }

    public MethodTypeBuilder parameter(String type, String name) {
        this.parameters.add(new Parameter(JavaType.buildType(type), name));
        return this;
    }

    public MethodTypeBuilder parameter(JavaType type, String name) {
        this.parameters.add(new Parameter(type, name));
        return this;
    }

    public JavaType.Method build() {
        if (StringUtils.isBlank((String)this.name)) {
            throw new IllegalArgumentException("The method name is required.");
        }
        if (this.declaringType == null) {
            throw new IllegalArgumentException("The declaring type is required.");
        }
        if (this.returnType == null) {
            this.returnType = JavaType.Primitive.Void;
        }
        JavaType.Method.Signature signature = new JavaType.Method.Signature(this.returnType, this.parameters.stream().map(Parameter::getType).collect(Collectors.toList()));
        return JavaType.Method.build(this.declaringType, this.name, signature, signature, this.parameters.stream().map(Parameter::getName).collect(Collectors.toList()), this.flags);
    }

    private static class Parameter {
        JavaType type;
        String name;

        public JavaType getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        @ConstructorProperties(value={"type", "name"})
        public Parameter(JavaType type, String name) {
            this.type = type;
            this.name = name;
        }
    }
}

