/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.Iterator;
import org.openrewrite.Cursor;
import org.openrewrite.SourceVisitor;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Statement;

public interface JavaSourceVisitor<R>
extends SourceVisitor<R> {
    default public J.CompilationUnit enclosingCompilationUnit() {
        J.CompilationUnit cu = (J.CompilationUnit)this.getCursor().firstEnclosing(J.CompilationUnit.class);
        if (cu == null) {
            throw new IllegalStateException("Expected to find a J.CompilationUnit in " + this);
        }
        return cu;
    }

    default public J.Block<?> enclosingBlock() {
        return (J.Block)this.getCursor().firstEnclosing(J.Block.class);
    }

    @Nullable
    default public J.MethodDecl enclosingMethod() {
        return (J.MethodDecl)this.getCursor().firstEnclosing(J.MethodDecl.class);
    }

    default public J.ClassDecl enclosingClass() {
        return (J.ClassDecl)this.getCursor().firstEnclosing(J.ClassDecl.class);
    }

    default public boolean isInSameNameScope(Cursor base, Cursor child) {
        J.ClassDecl childClass;
        Tree childScope;
        Tree baseScope = base.getPathAsStream().filter(t -> t instanceof J.Block || t instanceof J.MethodDecl || t instanceof J.Try || t instanceof J.ForLoop || t instanceof J.ForEachLoop).findFirst().orElseThrow(() -> new IllegalArgumentException("The base cursor does not have an scoped context."));
        Iterator it = child.getPath();
        while (it.hasNext() && (!((childScope = (Tree)it.next()) instanceof J.ClassDecl) || (childClass = (J.ClassDecl)childScope).getKind() instanceof J.ClassDecl.Kind.Class && !childClass.hasModifier("static"))) {
            if (!baseScope.isScope(childScope)) continue;
            return true;
        }
        return false;
    }

    default public boolean isInSameNameScope(Cursor child) {
        return this.isInSameNameScope(this.getCursor(), child);
    }

    default public R visitExpression(Expression expr) {
        if (expr.getType() instanceof JavaType.FullyQualified) {
            JavaType.FullyQualified exprType = (JavaType.FullyQualified)expr.getType();
            if (expr instanceof J.FieldAccess ? ((J.FieldAccess)expr).getSimpleName().equals(exprType.getClassName()) : expr instanceof J.Ident && ((J.Ident)expr).getSimpleName().equals(exprType.getClassName())) {
                return (R)this.reduce(this.defaultTo(expr), this.visitTypeName((NameTree)((Object)expr)));
            }
        }
        return (R)this.defaultTo(expr);
    }

    public R visitStatement(Statement var1);

    public R visitTypeName(NameTree var1);

    public R visitAnnotatedType(J.AnnotatedType var1);

    public R visitAnnotation(J.Annotation var1);

    public R visitArrayAccess(J.ArrayAccess var1);

    public R visitArrayType(J.ArrayType var1);

    public R visitAssert(J.Assert var1);

    public R visitAssign(J.Assign var1);

    public R visitAssignOp(J.AssignOp var1);

    public R visitBinary(J.Binary var1);

    public R visitBlock(J.Block<J> var1);

    public R visitBreak(J.Break var1);

    public R visitCase(J.Case var1);

    public R visitCatch(J.Try.Catch var1);

    public R visitClassDecl(J.ClassDecl var1);

    public R visitCompilationUnit(J.CompilationUnit var1);

    public R visitContinue(J.Continue var1);

    public R visitDoWhileLoop(J.DoWhileLoop var1);

    public R visitEmpty(J.Empty var1);

    public R visitEnumValue(J.EnumValue var1);

    public R visitEnumValueSet(J.EnumValueSet var1);

    public R visitFinally(J.Try.Finally var1);

    public R visitFieldAccess(J.FieldAccess var1);

    public R visitForEachLoop(J.ForEachLoop var1);

    public R visitForLoop(J.ForLoop var1);

    public R visitIdentifier(J.Ident var1);

    public R visitIf(J.If var1);

    public R visitElse(J.If.Else var1);

    public R visitImport(J.Import var1);

    public R visitInstanceOf(J.InstanceOf var1);

    public R visitLabel(J.Label var1);

    public R visitLambda(J.Lambda var1);

    public R visitLiteral(J.Literal var1);

    public R visitMemberReference(J.MemberReference var1);

    public R visitMethod(J.MethodDecl var1);

    public R visitMethodInvocation(J.MethodInvocation var1);

    public R visitMultiCatch(J.MultiCatch var1);

    public R visitMultiVariable(J.VariableDecls var1);

    public R visitNewArray(J.NewArray var1);

    public R visitNewClass(J.NewClass var1);

    public R visitPackage(J.Package var1);

    public R visitParameterizedType(J.ParameterizedType var1);

    public <T extends J> R visitParentheses(J.Parentheses<T> var1);

    public R visitPrimitive(J.Primitive var1);

    public R visitReturn(J.Return var1);

    public R visitSwitch(J.Switch var1);

    public R visitSynchronized(J.Synchronized var1);

    public R visitTernary(J.Ternary var1);

    public R visitThrow(J.Throw var1);

    public R visitTry(J.Try var1);

    public R visitTypeCast(J.TypeCast var1);

    public R visitTypeParameter(J.TypeParameter var1);

    public R visitTypeParameters(J.TypeParameters var1);

    public R visitUnary(J.Unary var1);

    public R visitUnparsedSource(J.UnparsedSource var1);

    public R visitVariable(J.VariableDecls.NamedVar var1);

    public R visitWhileLoop(J.WhileLoop var1);

    public R visitWildcard(J.Wildcard var1);
}

