/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.openrewrite.Formatting;
import org.openrewrite.Tree;
import org.openrewrite.java.JavaIsoRefactorVisitor;
import org.openrewrite.java.search.FindReferencedTypes;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.marker.Markers;

public class DeleteStatement {

    public static class Scoped
    extends JavaIsoRefactorVisitor {
        private final Statement statement;

        public Scoped(Statement statement) {
            this.statement = statement;
        }

        @Override
        public J.If visitIf(J.If iff) {
            J.If i = super.visitIf(iff);
            if (this.statement.isScope(i.getThenPart())) {
                i = i.withThenPart(this.emptyBlock());
            } else if (i.getElsePart() != null && this.statement.isScope(i.getElsePart())) {
                i = i.withElsePart(i.getElsePart().withStatement(this.emptyBlock()));
            }
            return i;
        }

        @Override
        public J.ForLoop visitForLoop(J.ForLoop forLoop) {
            return this.statement.isScope(forLoop.getBody()) ? forLoop.withBody(this.emptyBlock()) : super.visitForLoop(forLoop);
        }

        @Override
        public J.ForEachLoop visitForEachLoop(J.ForEachLoop forEachLoop) {
            return this.statement.isScope(forEachLoop.getBody()) ? forEachLoop.withBody(this.emptyBlock()) : super.visitForEachLoop(forEachLoop);
        }

        @Override
        public J.WhileLoop visitWhileLoop(J.WhileLoop whileLoop) {
            return this.statement.isScope(whileLoop.getBody()) ? whileLoop.withBody(this.emptyBlock()) : super.visitWhileLoop(whileLoop);
        }

        @Override
        public J.DoWhileLoop visitDoWhileLoop(J.DoWhileLoop doWhileLoop) {
            return this.statement.isScope(doWhileLoop.getBody()) ? doWhileLoop.withBody(this.emptyBlock()) : super.visitDoWhileLoop(doWhileLoop);
        }

        @Override
        public J.Block<J> visitBlock(J.Block<J> block) {
            J.Block b = super.visitBlock((J.Block)block);
            if (block.getStatements().stream().anyMatch(arg_0 -> ((Statement)this.statement).isScope(arg_0))) {
                b = b.withStatements(b.getStatements().stream().filter(s -> !this.statement.isScope((Tree)s)).collect(Collectors.toList()));
            }
            return b;
        }

        public J visitTree(Tree tree) {
            if (this.statement.isScope(tree)) {
                ((Set)new FindReferencedTypes().visit(tree)).forEach(this::maybeRemoveImport);
            }
            return (J)super.visitTree(tree);
        }

        private J.Block<J> emptyBlock() {
            return new J.Block<J>(Tree.randomId(), null, Collections.emptyList(), Collections.emptyList(), Formatting.EMPTY, Markers.EMPTY, new J.Block.End(Tree.randomId(), Collections.emptyList(), Formatting.format((String)""), Markers.EMPTY));
        }
    }
}

