/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.regex.Pattern;
import org.openrewrite.Formatting;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.Tree;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoRefactorVisitor;
import org.openrewrite.java.OrderImports;
import org.openrewrite.java.search.FindType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TreeBuilder;
import org.openrewrite.marker.Markers;

public class AddImport
extends JavaIsoRefactorVisitor {
    private String type;
    @Nullable
    private String statik;
    private boolean onlyIfReferenced = true;
    private JavaType.Class classType;
    private static final Pattern prefixedByTwoNewlines = Pattern.compile("[ \t\r]*\n[ \t\r]*\n[ \t\n]*.*", 32);

    public void setType(String type) {
        this.type = type;
        this.classType = JavaType.Class.build(type);
    }

    public void setStatic(@Nullable String statik) {
        this.statik = statik;
    }

    public void setOnlyIfReferenced(boolean onlyIfReferenced) {
        this.onlyIfReferenced = onlyIfReferenced;
    }

    public Iterable<Tag> getTags() {
        return Tags.of((String[])new String[]{"class", this.type, "static.method", this.statik == null ? "none" : this.statik});
    }

    public Validated validate() {
        return Validated.required((String)"type", (Object)this.type);
    }

    @Override
    public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu) {
        if (JavaType.Primitive.fromKeyword(this.classType.getFullyQualifiedName()) != null) {
            return cu;
        }
        if (this.onlyIfReferenced && !this.hasReference(cu)) {
            return cu;
        }
        if (this.classType.getPackageName().isEmpty()) {
            return cu;
        }
        if (cu.getImports().stream().anyMatch(i -> {
            String ending = i.getQualid().getSimpleName();
            if (this.statik == null) {
                return !i.isStatic() && i.getPackageName().equals(this.classType.getPackageName()) && (ending.equals(this.classType.getClassName()) || ending.equals("*"));
            }
            return i.isStatic() && i.getTypeName().equals(this.classType.getFullyQualifiedName()) && (ending.equals(this.statik) || ending.equals("*"));
        })) {
            return cu;
        }
        J.Import importToAdd = new J.Import(Tree.randomId(), (J.FieldAccess)TreeBuilder.buildName(this.classType.getFullyQualifiedName() + (this.statik == null ? "" : "." + this.statik)).withFormatting(Formatting.format((String)" ")), this.statik != null, Collections.emptyList(), Formatting.EMPTY, Markers.EMPTY);
        ArrayList<J.Import> imports = new ArrayList<J.Import>(cu.getImports());
        if (imports.isEmpty()) {
            J.Import import_ = importToAdd = cu.getPackageDecl() == null ? (J.Import)importToAdd.withPrefix(cu.getClasses().get(0).getPrefix() + "\n\n") : (J.Import)importToAdd.withPrefix("\n\n");
        }
        if (cu.getClasses().iterator().hasNext()) {
            while (!prefixedByTwoNewlines.matcher(Formatting.firstPrefix(cu.getClasses())).matches()) {
                cu = cu.withClasses(Formatting.formatFirstPrefix(cu.getClasses(), (String)("\n" + Formatting.firstPrefix(cu.getClasses()))));
            }
        }
        imports.add(importToAdd);
        cu = cu.withImports(imports);
        OrderImports orderImports = new OrderImports();
        orderImports.setRemoveUnused(false);
        this.andThen((RefactorVisitor)orderImports);
        return cu;
    }

    private boolean hasReference(J.CompilationUnit compilationUnit) {
        if (this.statik == null) {
            return ((Set)new FindType(this.type).visit(compilationUnit)).stream().filter(t -> !(t instanceof J.FieldAccess) || !((J.FieldAccess)t).isFullyQualifiedClassReference(this.type)).findAny().isPresent();
        }
        return compilationUnit.findMethodCalls(this.type + " *(..)").stream().filter(invocation -> invocation.getSelect() == null && (this.statik.equals("*") || invocation.getName().getSimpleName().equals(this.statik))).findAny().isPresent();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddImport)) {
            return false;
        }
        AddImport other = (AddImport)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.onlyIfReferenced != other.onlyIfReferenced) {
            return false;
        }
        String this$type = this.type;
        String other$type = other.type;
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$statik = this.statik;
        String other$statik = other.statik;
        return !(this$statik == null ? other$statik != null : !this$statik.equals(other$statik));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AddImport;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.onlyIfReferenced ? 79 : 97);
        String $type = this.type;
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $statik = this.statik;
        result = result * 59 + ($statik == null ? 43 : $statik.hashCode());
        return result;
    }
}

