/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openrewrite.Formatting;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoRefactorVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.marker.Markers;

public final class AddField {
    private AddField() {
    }

    public static class Scoped
    extends JavaIsoRefactorVisitor {
        private final J.ClassDecl scope;
        private final List<J.Modifier> modifiers;
        private final String type;
        private final String name;
        @Nullable
        private final String init;

        public Scoped(J.ClassDecl scope, List<J.Modifier> modifiers, String type, String name, @Nullable String init) {
            this.scope = scope;
            this.modifiers = modifiers;
            this.type = type;
            this.name = name;
            this.init = init;
        }

        public Iterable<Tag> getTags() {
            return Tags.of((String[])new String[]{"field.class", this.type, "field.name", this.name});
        }

        @Override
        public J.ClassDecl visitClassDecl(J.ClassDecl classDecl) {
            J.ClassDecl c = super.visitClassDecl(classDecl);
            if (this.scope.isScope(classDecl)) {
                if (classDecl.getBody().getStatements().stream().filter(s -> s instanceof J.VariableDecls).map(J.VariableDecls.class::cast).noneMatch(mv -> mv.getVars().stream().anyMatch(var -> var.getSimpleName().equals(this.name)))) {
                    String fieldTypeString;
                    J.Block<J> body = c.getBody();
                    JavaType javaType = JavaType.buildType(this.type);
                    if (javaType instanceof JavaType.FullyQualified) {
                        JavaType.FullyQualified classType = (JavaType.FullyQualified)javaType;
                        this.maybeAddImport(classType);
                        fieldTypeString = classType.getClassName();
                    } else {
                        fieldTypeString = javaType.toTypeTree().print();
                    }
                    J.VariableDecls newField = new J.VariableDecls(Tree.randomId(), Collections.emptyList(), this.modifiers, J.Ident.build(Tree.randomId(), fieldTypeString, javaType, Collections.emptyList(), this.modifiers.isEmpty() ? Formatting.EMPTY : Formatting.format((String)" "), Markers.EMPTY), null, Collections.emptyList(), Collections.singletonList(new J.VariableDecls.NamedVar(Tree.randomId(), J.Ident.build(Tree.randomId(), this.name, null, Collections.emptyList(), Formatting.format((String)"", (String)(this.init == null ? "" : " ")), Markers.EMPTY), Collections.emptyList(), this.init == null ? null : new J.UnparsedSource(Tree.randomId(), this.init, Collections.emptyList(), Formatting.format((String)" "), Markers.EMPTY), javaType, Collections.emptyList(), Formatting.format((String)" "), Markers.EMPTY)), Collections.emptyList(), this.formatter.format(body), Markers.EMPTY);
                    ArrayList<J> statements = new ArrayList<J>(body.getStatements().size() + 1);
                    statements.add(newField);
                    statements.addAll(body.getStatements());
                    c = c.withBody(body.withStatements(statements));
                }
            }
            return c;
        }
    }
}

