/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import java.util.ArrayList;
import java.util.List;
import org.openrewrite.Tree;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoRefactorVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.TreeBuilder;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;

public class ChangeType
extends JavaIsoRefactorVisitor {
    private String type;
    private JavaType.Class targetType;

    public void setType(String type) {
        this.type = type;
    }

    public void setTargetType(String targetType) {
        this.targetType = JavaType.Class.build(targetType);
    }

    public void setTargetType(JavaType.Class targetType) {
        this.targetType = targetType;
    }

    public Validated validate() {
        return Validated.required((String)"type", (Object)this.type).and(Validated.required((String)"target.type", (Object)this.targetType.getFullyQualifiedName()));
    }

    public Iterable<Tag> getTags() {
        return Tags.of((String[])new String[]{"type", this.type, "target.type", this.targetType.getFullyQualifiedName()});
    }

    @Override
    public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu) {
        this.maybeAddImport(this.targetType);
        this.maybeRemoveImport(this.type);
        return super.visitCompilationUnit(cu);
    }

    @Override
    public NameTree visitTypeName(NameTree name) {
        JavaType.Class oldTypeAsClass = TypeUtils.asClass(name.getType());
        NameTree n = super.visitTypeName(name);
        if (!(name instanceof TypeTree) && oldTypeAsClass != null && oldTypeAsClass.getFullyQualifiedName().equals(this.type)) {
            n = (NameTree)n.withType(this.targetType);
        }
        return n;
    }

    @Override
    public J.Annotation visitAnnotation(J.Annotation annotation) {
        J.Annotation a = super.visitAnnotation(annotation);
        return a.withAnnotationType(this.transformName(a.getAnnotationType()));
    }

    @Override
    public J.ArrayType visitArrayType(J.ArrayType arrayType) {
        J.ArrayType a = super.visitArrayType(arrayType);
        return a.withElementType(this.transformName(a.getElementType()));
    }

    @Override
    public J.ClassDecl visitClassDecl(J.ClassDecl classDecl) {
        J.ClassDecl c = super.visitClassDecl(classDecl);
        if (c.getExtends() != null) {
            c = c.withExtends(c.getExtends().withFrom(this.transformName(c.getExtends().getFrom())));
        }
        if (c.getImplements() != null) {
            c = c.withImplements(c.getImplements().withFrom(this.transformNames(c.getImplements().getFrom())));
        }
        return c;
    }

    @Override
    public J.FieldAccess visitFieldAccess(J.FieldAccess fieldAccess) {
        J.FieldAccess f = super.visitFieldAccess(fieldAccess);
        if (f.isFullyQualifiedClassReference(this.type)) {
            return (J.FieldAccess)TreeBuilder.buildName(this.targetType.getFullyQualifiedName(), f.getFormatting(), f.getId());
        }
        return f;
    }

    @Override
    public J.Ident visitIdentifier(J.Ident ident) {
        J.Ident i = super.visitIdentifier(ident);
        JavaType.Class originalType = JavaType.Class.build(this.type);
        if (TypeUtils.isOfClassType(i.getType(), this.type) && i.getSimpleName().equals(originalType.getClassName())) {
            i = i.withName(this.targetType.getClassName());
            i = i.withType(this.targetType);
        }
        return i;
    }

    @Override
    public J.MethodDecl visitMethod(J.MethodDecl method) {
        J.MethodDecl m = super.visitMethod(method);
        return m.withThrows((m = m.withReturnTypeExpr(this.transformName(m.getReturnTypeExpr()))).getThrows() == null ? null : m.getThrows().withExceptions(this.transformNames(m.getThrows().getExceptions())));
    }

    @Override
    public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method) {
        JavaType.Class selectType;
        J.MethodInvocation m = super.visitMethodInvocation(method);
        if (m.getSelect() instanceof NameTree && m.getType() != null && m.getType().hasFlags(Flag.Static)) {
            m = m.withSelect(this.transformName(m.getSelect()));
        }
        if (m.getSelect() != null && (selectType = TypeUtils.asClass(m.getSelect().getType())) != null && selectType.getFullyQualifiedName().equals(this.type)) {
            m = m.withSelect((Expression)m.getSelect().withType(this.targetType));
        }
        if (m.getType() != null && m.getType().getDeclaringType().getFullyQualifiedName().equals(this.type)) {
            m = m.withDeclaringType(this.targetType);
        }
        return m;
    }

    @Override
    public J.MultiCatch visitMultiCatch(J.MultiCatch multiCatch) {
        J.MultiCatch m = super.visitMultiCatch(multiCatch);
        return m.withAlternatives(this.transformNames(m.getAlternatives()));
    }

    @Override
    public J.VariableDecls visitMultiVariable(J.VariableDecls multiVariable) {
        if (multiVariable.getTypeExpr() instanceof J.MultiCatch) {
            return super.visitMultiVariable(multiVariable);
        }
        J.VariableDecls m = super.visitMultiVariable(multiVariable);
        return m.withTypeExpr(this.transformName(m.getTypeExpr()));
    }

    @Override
    public J.VariableDecls.NamedVar visitVariable(J.VariableDecls.NamedVar variable) {
        J.VariableDecls.NamedVar v = super.visitVariable(variable);
        JavaType.Class varType = TypeUtils.asClass(variable.getType());
        if (varType != null && varType.getFullyQualifiedName().equals(this.type)) {
            v = v.withType(this.targetType).withName(v.getName().withType(this.targetType));
        }
        return v;
    }

    @Override
    public J.NewArray visitNewArray(J.NewArray newArray) {
        J.NewArray n = super.visitNewArray(newArray);
        return n.withTypeExpr(this.transformName(n.getTypeExpr()));
    }

    @Override
    public J.NewClass visitNewClass(J.NewClass newClass) {
        J.NewClass n = super.visitNewClass(newClass);
        return n.withClazz(this.transformName(n.getClazz()));
    }

    @Override
    public J.TypeCast visitTypeCast(J.TypeCast typeCast) {
        J.TypeCast t = super.visitTypeCast(typeCast);
        return t.withClazz(t.getClazz().withTree(this.transformName(t.getClazz().getTree())));
    }

    @Override
    public J.TypeParameter visitTypeParameter(J.TypeParameter typeParam) {
        J.TypeParameter t;
        t = t.withBounds((t = super.visitTypeParameter(typeParam)).getBounds() == null ? null : t.getBounds().withTypes(this.transformNames(t.getBounds().getTypes())));
        return t.withName(this.transformName(t.getName()));
    }

    @Override
    public J.Wildcard visitWildcard(J.Wildcard wildcard) {
        J.Wildcard w = super.visitWildcard(wildcard);
        return w.withBoundedType(this.transformName(w.getBoundedType()));
    }

    private <T extends Tree> T transformName(@Nullable T nameField) {
        JavaType.Class nameTreeClass;
        if (nameField instanceof NameTree && (nameTreeClass = TypeUtils.asClass(((NameTree)nameField).getType())) != null && nameTreeClass.getFullyQualifiedName().equals(this.type)) {
            return (T)J.Ident.build(Tree.randomId(), this.targetType.getClassName(), this.targetType, nameField.getFormatting());
        }
        return nameField;
    }

    private <T extends Tree> List<T> transformNames(@Nullable List<T> trees) {
        if (trees == null) {
            return null;
        }
        boolean atLeastOneChanged = false;
        ArrayList<Tree> transformed = new ArrayList<Tree>();
        for (Tree tree : trees) {
            JavaType.Class nodeTypeAsClass;
            if (tree instanceof NameTree && (nodeTypeAsClass = TypeUtils.asClass(((NameTree)tree).getType())) != null && nodeTypeAsClass.getFullyQualifiedName().equals(this.type)) {
                atLeastOneChanged = true;
                transformed.add(J.Ident.build(Tree.randomId(), this.targetType.getClassName(), this.targetType, tree.getFormatting()));
                continue;
            }
            transformed.add(tree);
        }
        return atLeastOneChanged ? transformed : trees;
    }
}

