/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openrewrite.Formatting;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.Tree;
import org.openrewrite.Validated;
import org.openrewrite.java.JavaIsoRefactorVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

public class ReorderMethodArguments
extends JavaIsoRefactorVisitor {
    private MethodMatcher methodMatcher;
    private String[] order;
    private String[] originalOrder = new String[0];

    public boolean isIdempotent() {
        return false;
    }

    public void setMethod(String method) {
        this.methodMatcher = new MethodMatcher(method);
    }

    public void setOrder(String ... order) {
        this.order = order;
    }

    public void setOriginalOrder(String ... originalOrder) {
        this.originalOrder = originalOrder;
    }

    public Validated validate() {
        return Validated.required((String)"method", (Object)this.methodMatcher).and(Validated.required((String)"order", (Object)this.order));
    }

    @Override
    public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method) {
        if (this.methodMatcher.matches(method)) {
            this.andThen((RefactorVisitor)new Scoped(method, this.order, this.originalOrder));
        }
        return super.visitMethodInvocation(method);
    }

    public static class Scoped
    extends JavaIsoRefactorVisitor {
        private final J.MethodInvocation scope;
        private final String[] order;
        private final String[] originalOrder;

        public Scoped(J.MethodInvocation scope, String[] order, String[] originalOrder) {
            this.scope = scope;
            this.order = order;
            this.originalOrder = originalOrder;
            this.setCursoringOn();
        }

        public boolean isIdempotent() {
            return false;
        }

        @Override
        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method) {
            if (this.scope.isScope(method) && method.getType() != null) {
                List<String> paramNames;
                List<String> list = paramNames = this.originalOrder.length == 0 ? method.getType().getParamNames() : Arrays.asList(this.originalOrder);
                if (paramNames == null) {
                    throw new IllegalStateException("There is no source attachment for method " + method.getType().getDeclaringType().getFullyQualifiedName() + "." + method.getSimpleName() + "(..). Provide a reference for original parameter names by calling setOriginalParamNames(..)");
                }
                List<Expression> originalArgs = method.getArgs().getArgs();
                int resolvedParamCount = method.getType().getResolvedSignature() == null ? originalArgs.size() : method.getType().getResolvedSignature().getParamTypes().size();
                int i = 0;
                ArrayList<Expression> reordered = new ArrayList<Expression>(originalArgs.size());
                ArrayList<Formatting> formattings = new ArrayList<Formatting>(originalArgs.size());
                for (String name : this.order) {
                    int fromPos = paramNames.indexOf(name);
                    if (originalArgs.size() > resolvedParamCount && fromPos == resolvedParamCount - 1) {
                        List<Expression> varargs = originalArgs.subList(fromPos, originalArgs.size());
                        reordered.addAll(varargs);
                        int n = i;
                        int n2 = i++;
                        originalArgs.subList(n, n2 + varargs.size()).stream().map(Tree::getFormatting).forEach(formattings::add);
                        continue;
                    }
                    if (fromPos < 0 || originalArgs.size() <= fromPos) continue;
                    reordered.add(originalArgs.get(fromPos));
                    formattings.add(originalArgs.get(i++).getFormatting());
                }
                i = 0;
                for (Expression expression : reordered) {
                    reordered.set(i, (Expression)expression.withFormatting((Formatting)formattings.get(i++)));
                }
                if (!method.getArgs().getArgs().equals(reordered)) {
                    return method.withArgs(method.getArgs().withArgs(reordered));
                }
            }
            return super.visitMethodInvocation(method);
        }
    }
}

